/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoVetAtomicInspection
extends GoInspectionBase {
    private static final String[] ATOMIC_ADD_FUNCTIONS = new String[]{"AddInt32", "AddInt64", "AddUint32", "AddUint64", "AddUintptr"};

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoVetAtomicInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoVetAtomicInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitAssignmentStatement(@NotNull GoAssignmentStatement assignmentStatement) {
                if (assignmentStatement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitAssignmentStatement(assignmentStatement);
                this.processAssignments(assignmentStatement.getLeftHandExprList().getExpressionList(), assignmentStatement.getExpressionList());
            }

            @Override
            public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration shortVarDeclaration) {
                if (shortVarDeclaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitShortVarDeclaration(shortVarDeclaration);
                this.processAssignments(shortVarDeclaration.getVarDefinitionList(), shortVarDeclaration.getExpressionList());
            }

            private <T extends PsiElement> void processAssignments(@NotNull List<T> left, @NotNull List<GoExpression> right) {
                if (left == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (right == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (left.size() != right.size()) {
                    return;
                }
                for (Pair pair : ContainerUtil.zip(left, right)) {
                    GoCallExpr call;
                    if (pair.first instanceof GoVarDefinition && GoInspectionUtil.isPrimaryDefinition((GoNamedElement)pair.first) || !GoStdlibUtil.isStdLibCall(call = (GoCallExpr)ObjectUtils.tryCast((Object)pair.second, GoCallExpr.class), "sync/atomic", ATOMIC_ADD_FUNCTIONS)) continue;
                    this.checkAtomicAddAssignment((PsiElement)pair.first, call);
                }
            }

            private <T extends PsiElement> void checkAtomicAddAssignment(@NotNull T left, @NotNull GoCallExpr right) {
                List<GoExpression> args;
                if (left == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (right == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((args = right.getArgumentList().getExpressionList()).size() != 2) {
                    return;
                }
                GoExpression firstArg = args.get(0);
                if (firstArg instanceof GoUnaryExpr && ((GoUnaryExpr)firstArg).getBitAnd() != null && 1.identical(left, ((GoUnaryExpr)firstArg).getExpression()) || left instanceof GoUnaryExpr && ((GoUnaryExpr)left).getMul() != null && GoExpressionUtil.identical(((GoUnaryExpr)left).getExpression(), firstArg)) {
                    holder.registerProblem(left, GoVetAtomicInspection.message("go.inspection.problem.direct.assignment.to.atomic.value"), new LocalQuickFix[0]);
                }
            }

            private static <T extends PsiElement> boolean identical(@NotNull T left, @Nullable GoExpression right) {
                if (left == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (left instanceof GoExpression) {
                    return GoExpressionUtil.identical((GoExpression)left, right);
                }
                if (left instanceof GoVarDefinition) {
                    PsiElement leftResolve;
                    PsiReference leftReference = left.getReference();
                    PsiElement psiElement = leftResolve = leftReference != null ? leftReference.resolve() : null;
                    if (leftResolve == null) {
                        return false;
                    }
                    PsiElement rightResolve = (PsiElement)ObjectUtils.doIfCast((Object)right, GoReferenceExpression.class, GoResolvable::resolve);
                    return leftResolve.isEquivalentTo(rightResolve);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignmentStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "shortVarDeclaration";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "left";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "right";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/vet/GoVetAtomicInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAssignmentStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitShortVarDeclaration";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processAssignments";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkAtomicAddAssignment";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "identical";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoVetAtomicInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

