/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.vet;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.quickfix.GoReplaceExpressionQuickFix;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class GoErrorsAsInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoErrorsAsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoErrorsAsInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr call) {
                GoType type2;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitCallExpr(call);
                if (!GoStdlibUtil.isStdLibCall(call, "errors", "As")) {
                    return;
                }
                GoExpression secondArg = (GoExpression)ContainerUtil.getOrElse(call.getArgumentList().getExpressionList(), (int)1, null);
                GoType goType = type2 = secondArg != null ? secondArg.getGoType(null) : null;
                if (type2 != null && !this.pointerToInterfaceOrError(type2, secondArg)) {
                    GoInspectionMessage message = GoErrorsAsInspection.message("go.inspection.problem.invalid.second.argument.to.errors.as", new Object[]{GoErrorsAsInspection.code("errors.As")});
                    LocalQuickFix[] fixes = 1.interfaceOrError(type2, secondArg) && GoExpressionUtil.canTakeAddressOf(secondArg) ? GoErrorsAsInspection.fixes(new LocalQuickFix[]{GoReplaceExpressionQuickFix.prependAmpersandQuickFix(secondArg)}) : null;
                    holder.registerProblem((PsiElement)secondArg, message, fixes);
                }
            }

            private boolean pointerToInterfaceOrError(@NotNull GoType type2, @NotNull GoExpression context) {
                GoType underlyingType;
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!((underlyingType = type2.getUnderlyingType(context)) instanceof GoPointerType)) {
                    return false;
                }
                GoType elementType = ((GoPointerType)underlyingType).getType();
                return elementType == null || 1.interfaceOrError(elementType, context);
            }

            private static boolean interfaceOrError(@NotNull GoType type2, @NotNull GoExpression context) {
                if (type2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(4);
                }
                return type2.getUnderlyingType(context) instanceof GoInterfaceType || GoStdlibUtil.implementsError(type2, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/vet/GoErrorsAsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpr";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pointerToInterfaceOrError";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "interfaceOrError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/vet/GoErrorsAsInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

