/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.tag;

import com.goide.GoTypes;
import com.goide.inspections.tag.GoTagEntry;
import com.goide.inspections.tag.GoTagFile;
import com.goide.inspections.tag.GoTagLanguage;
import com.goide.inspections.tag.GoTagLexer;
import com.goide.inspections.tag.GoTagToken;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoTag;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTagUtil {
    public static final PsiElementPattern.Capture<PsiElement> RAW_STRING_IN_STRUCT_TAG = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(GoTypes.RAW_STRING)).withParent(GoStringLiteral.class)).withSuperParent(2, GoTag.class);

    @NotNull
    public static List<String> getKeys(@NotNull GoTag tag) {
        GoStringLiteral literal;
        PsiElement rawString;
        if (tag == null) {
            GoTagUtil.$$$reportNull$$$0(0);
        }
        if ((rawString = (literal = tag.getStringLiteral()).getRawString()) != null) {
            IElementType token;
            ArrayList<String> result = new ArrayList<String>();
            GoTagLexer lexer = new GoTagLexer();
            TextRange range = ElementManipulators.getManipulator((PsiElement)literal).getRangeInElement((PsiElement)literal);
            String text = rawString.getText();
            lexer.start(text, range.getStartOffset(), range.getEndOffset());
            while ((token = lexer.getTokenType()) != null) {
                if (token == GoTagToken.KEY) {
                    result.add(text.substring(lexer.getTokenStart(), lexer.getTokenEnd()));
                }
                lexer.advance();
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                GoTagUtil.$$$reportNull$$$0(1);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            GoTagUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static int getTagStartOffset(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoTagUtil.$$$reportNull$$$0(3);
        }
        TextRange literalContentRange = ElementManipulators.getManipulator((PsiElement)literal).getRangeInElement((PsiElement)literal);
        return literal.getTextRange().getStartOffset() + literalContentRange.getStartOffset();
    }

    @Nullable
    static GoTagEntry getTagEntry(@Nullable PsiElement element, int offsetInEditor) {
        GoStringLiteral stringLiteral = (GoStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, GoStringLiteral.class, (boolean)false);
        if (stringLiteral == null) {
            return null;
        }
        int relativeOffset = offsetInEditor - GoTagUtil.getTagStartOffset(stringLiteral);
        GoTagFile file = GoTagUtil.parseTagLiteral(stringLiteral);
        PsiElement elementInTag = file != null ? file.findElementAt(relativeOffset) : null;
        return (GoTagEntry)PsiTreeUtil.getParentOfType((PsiElement)elementInTag, GoTagEntry.class, (boolean)false);
    }

    @Nullable
    static GoTagFile parseTagLiteral(@Nullable GoStringLiteral literal) {
        if (literal == null) {
            return null;
        }
        PsiElement tagString = literal.getRawString();
        if (tagString == null) {
            return null;
        }
        TextRange range = ElementManipulators.getManipulator((PsiElement)literal).getRangeInElement((PsiElement)literal);
        return GoTagUtil.createGoTagFile(literal.getProject(), range.substring(literal.getText()));
    }

    @Nullable
    static GoTagFile createGoTagFile(@NotNull Project project, @NotNull String tagText) {
        if (project == null) {
            GoTagUtil.$$$reportNull$$$0(4);
        }
        if (tagText == null) {
            GoTagUtil.$$$reportNull$$$0(5);
        }
        return (GoTagFile)PsiFileFactory.getInstance((Project)project).createFileFromText("elementFactory.gotag", (Language)GoTagLanguage.INSTANCE, (CharSequence)tagText, false, true);
    }

    @Nullable
    static PsiElement createValue(@NotNull Project project, @NotNull String valueText) {
        GoTagFile file;
        if (project == null) {
            GoTagUtil.$$$reportNull$$$0(6);
        }
        if (valueText == null) {
            GoTagUtil.$$$reportNull$$$0(7);
        }
        GoTagEntry entry = (file = GoTagUtil.createGoTagFile(project, "k:" + valueText)) != null ? (GoTagEntry)((Object)ContainerUtil.getOnlyItem(file.getEntries())) : null;
        return entry != null ? entry.getValue() : null;
    }

    @Nullable
    static String getFieldNameForTag(@Nullable PsiElement at) {
        GoFieldDeclaration field = (GoFieldDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, GoFieldDeclaration.class);
        if (field == null) {
            return null;
        }
        GoFieldDefinition onlyDefinition = (GoFieldDefinition)ContainerUtil.getOnlyItem(field.getFieldDefinitionList());
        if (onlyDefinition != null) {
            return onlyDefinition.getName();
        }
        GoAnonymousFieldDefinition anonymous = field.getAnonymousFieldDefinition();
        return anonymous != null ? anonymous.getType().getText() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/tag/GoTagUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/tag/GoTagUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTagStartOffset";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGoTagFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

