/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections.buildTag;

import com.goide.sdk.GoSdkVersion;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoBuildDirectiveOptions {
    public static final GoBuildDirectiveOptions NO_SUPPORT = new GoBuildDirectiveOptions(null, false, false, false, false, false, false);
    public static final GoBuildDirectiveOptions MINIMAL_SUPPORT = new GoBuildDirectiveOptions(GoSdkVersion.GO_1_16, true, true, false, false, false, false);
    public static final GoBuildDirectiveOptions TRANSITION_SUPPORT = new GoBuildDirectiveOptions(GoSdkVersion.GO_1_17, true, false, true, true, true, false);
    public static final GoBuildDirectiveOptions FULL_SUPPORT = new GoBuildDirectiveOptions(GoSdkVersion.GO_1_18, true, false, true, true, true, true);
    private final GoSdkVersion myGoVersion;
    private final boolean myReportMisplacedDirective;
    private final boolean myReportMissingPlusBuildTags;
    private final boolean myReportSemanticErrors;
    private final boolean myFormatGoBuildDirectives;
    private final boolean myUseForFileMatching;
    private final boolean myRemovePlusBuildComments;

    private GoBuildDirectiveOptions(@Nullable GoSdkVersion goVersion, boolean reportMisplacedDirective, boolean reportMissingPlusBuildTags, boolean reportSemanticErrors, boolean formatGoBuildDirectives, boolean useForFileMatching, boolean removePlusBuildComments) {
        this.myGoVersion = goVersion;
        this.myReportMisplacedDirective = reportMisplacedDirective;
        this.myReportMissingPlusBuildTags = reportMissingPlusBuildTags;
        this.myReportSemanticErrors = reportSemanticErrors;
        this.myFormatGoBuildDirectives = formatGoBuildDirectives;
        this.myUseForFileMatching = useForFileMatching;
        this.myRemovePlusBuildComments = removePlusBuildComments;
    }

    public boolean isReportMisplacedDirective() {
        return this.myReportMisplacedDirective;
    }

    public boolean isReportMissingPlusBuildTags() {
        return this.myReportMissingPlusBuildTags;
    }

    public boolean isReportMissingPlusBuildTags(@Nullable GoSdkVersion targetGoVersion) {
        return targetGoVersion != null && targetGoVersion.isLessThan(Objects.requireNonNull(GoBuildDirectiveOptions.TRANSITION_SUPPORT.myGoVersion));
    }

    public boolean isReportSemanticErrors() {
        return this.myReportSemanticErrors;
    }

    public boolean isFormatGoBuildDirectives() {
        return this.myFormatGoBuildDirectives;
    }

    public boolean isUseForFileMatching() {
        return this.myUseForFileMatching;
    }

    public boolean isRemovePlusBuildComments(@Nullable GoSdkVersion targetGoVersion) {
        return this.myRemovePlusBuildComments && targetGoVersion != null && targetGoVersion.isAtLeast(Objects.requireNonNull(GoBuildDirectiveOptions.TRANSITION_SUPPORT.myGoVersion));
    }

    @NotNull
    public static GoBuildDirectiveOptions getGoBuildDirectiveOptions(@NotNull GoSdkVersion version2) {
        if (version2 == null) {
            GoBuildDirectiveOptions.$$$reportNull$$$0(0);
        }
        if (version2.isAtLeast(GoBuildDirectiveOptions.FULL_SUPPORT.myGoVersion)) {
            GoBuildDirectiveOptions goBuildDirectiveOptions = FULL_SUPPORT;
            if (goBuildDirectiveOptions == null) {
                GoBuildDirectiveOptions.$$$reportNull$$$0(1);
            }
            return goBuildDirectiveOptions;
        }
        if (version2.isAtLeast(GoBuildDirectiveOptions.TRANSITION_SUPPORT.myGoVersion)) {
            GoBuildDirectiveOptions goBuildDirectiveOptions = TRANSITION_SUPPORT;
            if (goBuildDirectiveOptions == null) {
                GoBuildDirectiveOptions.$$$reportNull$$$0(2);
            }
            return goBuildDirectiveOptions;
        }
        if (version2.isAtLeast(GoBuildDirectiveOptions.MINIMAL_SUPPORT.myGoVersion)) {
            GoBuildDirectiveOptions goBuildDirectiveOptions = MINIMAL_SUPPORT;
            if (goBuildDirectiveOptions == null) {
                GoBuildDirectiveOptions.$$$reportNull$$$0(3);
            }
            return goBuildDirectiveOptions;
        }
        GoBuildDirectiveOptions goBuildDirectiveOptions = NO_SUPPORT;
        if (goBuildDirectiveOptions == null) {
            GoBuildDirectiveOptions.$$$reportNull$$$0(4);
        }
        return goBuildDirectiveOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/buildTag/GoBuildDirectiveOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/buildTag/GoBuildDirectiveOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoBuildDirectiveOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGoBuildDirectiveOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

