/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.execution.testing.GoTestFinder;
import com.goide.go.GoGotoSuperHandler;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoReferencesSearch;
import com.goide.psi.GoSignature;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.util.GoUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class GoUnnecessarilyExportedIdentifiersInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoUnnecessarilyExportedIdentifiersInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoUnnecessarilyExportedIdentifiersInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitTypeSpec(@NotNull GoTypeSpec o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeSpec(o);
                if (this.isCheapEnoughToSearch(o) && o.isPublic() && !1.isUsedOutsidePackage(o) && !this.isPartOfPublicAPI(o)) {
                    this.registerProblem(o);
                }
            }

            @Override
            public void visitFunctionOrMethodDeclaration(@NotNull GoFunctionOrMethodDeclaration o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFunctionOrMethodDeclaration(o);
                if (!(!this.isCheapEnoughToSearch(o) || !o.isPublic() || o instanceof GoMethodDeclaration && GoGotoSuperHandler.GoSuperMarkerProvider.hasSuperMethod(o) || 1.isUsedOutsidePackage(o))) {
                    this.registerProblem(o);
                }
            }

            @Override
            public void visitVarOrConstDefinition(@NotNull GoVarOrConstDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitVarOrConstDefinition(o);
                if (this.isCheapEnoughToSearch(o) && o.isPublic() && GoPsiUtil.isTopLevelDeclaration(o) && !1.isUsedOutsidePackage(o)) {
                    this.registerProblem(o);
                }
            }

            private boolean isCheapEnoughToSearch(@NotNull GoNamedElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                return !holder.isOnTheFly() || GoInspectionUtil.isCheapEnoughToSearch(o);
            }

            private static boolean isUsedOutsidePackage(@NotNull GoNamedElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                GoFile file = o.getContainingFile();
                return !GoReferencesSearch.search(o, o.getUseScope()).forEach(arg_0 -> 1.lambda$isUsedOutsidePackage$0((PsiFile)file, arg_0));
            }

            private boolean isPartOfPublicAPI(@NotNull GoTypeSpec typeSpec) {
                GoPackage pkg;
                if (typeSpec == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((pkg = GoPackage.of(typeSpec.getContainingFile())) == null) {
                    return false;
                }
                return !pkg.processFiles((Processor<? super PsiFile>)((Processor)psiFile -> {
                    ProgressManager.checkCanceled();
                    GoFile file = (GoFile)((Object)((Object)ObjectUtils.tryCast((Object)psiFile, GoFile.class)));
                    boolean found = file != null && !GoTestFinder.isTestFile((PsiFile)file) && ContainerUtil.exists(file.getFunctions(), f -> f.isPublic() && 1.isUsedInSignature(typeSpec, f));
                    return !found;
                }));
            }

            private static boolean isUsedInSignature(@NotNull GoTypeSpec typeSpec, @NotNull GoFunctionDeclaration declaration) {
                GoSignature signature;
                if (typeSpec == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (declaration == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((signature = declaration.getSignature()) == null) {
                    return false;
                }
                return GoTypeUtil.findTypeSpec(signature.getResultType(), typeSpec, true) == typeSpec || ContainerUtil.exists(signature.getParameters().getParameterDeclarationList(), p -> GoTypeUtil.findTypeSpec(p.getType(), typeSpec, true) == typeSpec);
            }

            private void registerProblem(@NotNull GoNamedElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(8);
                }
                o.getName();
                PsiElement identifier = o.getIdentifier();
                if (identifier == null) {
                    return;
                }
                String name = o.getName();
                if (StringUtil.isEmpty((String)name)) {
                    return;
                }
                String description = UsageViewUtil.getType((PsiElement)o);
                holder.registerProblem(identifier, GoUnnecessarilyExportedIdentifiersInspection.message("go.inspection.problem.unnecessarily.exported.element", new Object[]{description, REF}), new LocalQuickFix[]{new GoRenameQuickFix(o), new RenameElementFix((PsiNamedElement)o, StringUtil.decapitalize((String)o.getName()))});
            }

            private static /* synthetic */ boolean lambda$isUsedOutsidePackage$0(PsiFile file, PsiReference reference) {
                ProgressManager.checkCanceled();
                PsiElement element = reference.getElement();
                return GoUtil.isDirectlyAccessible(file, element.getContainingFile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeSpec";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "declaration";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoUnnecessarilyExportedIdentifiersInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeSpec";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionOrMethodDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVarOrConstDefinition";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCheapEnoughToSearch";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUsedOutsidePackage";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isPartOfPublicAPI";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isUsedInSignature";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    protected boolean isEnabledOnFile(@NotNull GoFile file) {
        if (file == null) {
            GoUnnecessarilyExportedIdentifiersInspection.$$$reportNull$$$0(2);
        }
        return super.isEnabledOnFile(file) && !GoTestFinder.isTestFile((PsiFile)file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoUnnecessarilyExportedIdentifiersInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

