/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoType;
import com.goide.psi.GoVarOrConstDefinition;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoUnitSpecificDurationSuffixInspection
extends GoInspectionBase {
    private static final String[] timeSuffixes = new String[]{"Sec", "Secs", "Seconds", "Msec", "Msecs", "Milli", "Millis", "Milliseconds", "Usec", "Usecs", "Microseconds", "MS", "Ms"};

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoUnitSpecificDurationSuffixInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoUnitSpecificDurationSuffixInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitVarOrConstDefinition(@NotNull GoVarOrConstDefinition o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitVarOrConstDefinition(o);
                String name = o.getName();
                String suffix = GoUnitSpecificDurationSuffixInspection.getUnitSpecificSuffix(name);
                if (suffix == null || !GoUnitSpecificDurationSuffixInspection.isBuiltinDuration(o.getGoType(null), o)) {
                    return;
                }
                LocalQuickFixOnPsiElement quickFix = name.equals(suffix) ? new GoRenameQuickFix(o) : new DropSuffixQuickFix(o, suffix);
                holder.registerProblem((PsiElement)o, GoUnitSpecificDurationSuffixInspection.message("go.inspection.problem.unit.specific.suffix", new Object[]{GoUnitSpecificDurationSuffixInspection.code(suffix)}), new LocalQuickFix[]{quickFix});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoUnitSpecificDurationSuffixInspection$1", "visitVarOrConstDefinition"));
            }
        };
    }

    private static boolean isBuiltinDuration(@Nullable GoType type2, @NotNull PsiElement context) {
        if (context == null) {
            GoUnitSpecificDurationSuffixInspection.$$$reportNull$$$0(2);
        }
        return GoStdlibUtil.isStdLibType(type2, context, "time", "Duration");
    }

    @Nullable
    private static String getUnitSpecificSuffix(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return (String)ContainerUtil.find((Object[])timeSuffixes, name::endsWith);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoUnitSpecificDurationSuffixInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isBuiltinDuration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class DropSuffixQuickFix
    extends LocalQuickFixOnPsiElement {
        private final String mySuffix;

        private DropSuffixQuickFix(@NotNull PsiElement element, @NotNull String suffix) {
            if (element == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(0);
            }
            if (suffix == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(1);
            }
            super(element);
            this.mySuffix = suffix;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(5);
            }
            if (startElement.isValid() && startElement instanceof GoVarOrConstDefinition) {
                GoVarOrConstDefinition element = (GoVarOrConstDefinition)startElement;
                String originalName = element.getName();
                if (originalName == null || !originalName.endsWith(this.mySuffix)) {
                    return;
                }
                GoRefactoringUtil.renameInPsiTree(element, StringUtil.substringBeforeLast((String)originalName, (String)this.mySuffix));
            }
        }

        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.fix.drop.suffix.text", (Object[])new Object[]{this.mySuffix});
            if (string == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.drop.suffix.name", (Object[])new Object[0]);
            if (string == null) {
                DropSuffixQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoUnitSpecificDurationSuffixInspection$DropSuffixQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoUnitSpecificDurationSuffixInspection$DropSuffixQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

