/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoRenameQuickFix;
import com.goide.quickfix.GoUppercaseTypeParameterQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/goide/inspections/GoTypeParameterInLowerCaseInspection;", "Lcom/goide/inspections/core/GoInspectionBase;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/goide/inspections/core/GoProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "intellij.go.impl"})
public final class GoTypeParameterInLowerCaseInspection
extends GoInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(@NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new GoVisitor(holder){
            final /* synthetic */ GoProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitTypeParameters(@NotNull GoTypeParameters o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitTypeParameters(o);
                List<GoTypeParamDefinition> typeParametersInLowerCase = this.findParameterInLowerCase(o);
                if (typeParametersInLowerCase.isEmpty()) {
                    return;
                }
                List<String> typeParameterNamesList = GoTypeParameterInLowerCaseInspection.Companion.getTypeParametersNamesList(o);
                for (GoTypeParamDefinition parameter : typeParametersInLowerCase) {
                    String parameterName;
                    if (parameter.getName() == null) continue;
                    String string = parameterName.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                    LocalQuickFixOnPsiElement quickFix = !typeParameterNamesList.contains(string) ? (LocalQuickFixOnPsiElement)new GoUppercaseTypeParameterQuickFix(parameter, parameterName) : (LocalQuickFixOnPsiElement)new GoRenameQuickFix(parameter);
                    Object[] objectArray = new Object[]{parameterName};
                    GoInspectionMessage goInspectionMessage = GoTypeParameterInLowerCaseInspection.access$message$s1115493773("go.inspection.type.parameter.declared.in.lower.case.message", objectArray);
                    objectArray = new LocalQuickFix[]{quickFix};
                    this.$holder.registerProblem((PsiElement)parameter, goInspectionMessage, (LocalQuickFix[])objectArray);
                }
            }

            private final List<GoTypeParamDefinition> findParameterInLowerCase(GoTypeParameters parameters) {
                List typeParametersInLowerCase = new ArrayList<E>();
                for (GoTypeParameterDeclaration parameterDeclaration : parameters.getTypeParameterDeclarationList()) {
                    block1: for (GoTypeParamDefinition parameter : parameterDeclaration.getTypeParamDefinitionList()) {
                        String parameterName;
                        if (parameter.getName() == null) continue;
                        int n = parameterName.length();
                        for (int i = 0; i < n; ++i) {
                            char c = parameterName.charAt(i);
                            if (!Character.isLowerCase(c)) continue;
                            Intrinsics.checkNotNull((Object)parameter);
                            typeParametersInLowerCase.add(parameter);
                            continue block1;
                        }
                    }
                }
                return typeParametersInLowerCase;
            }
        };
    }

    public static final /* synthetic */ GoInspectionMessage access$message$s1115493773(String key, Object ... parameters) {
        return GoInspectionBase.message(key, parameters);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/goide/inspections/GoTypeParameterInLowerCaseInspection$Companion;", "", "()V", "getTypeParametersNamesList", "", "", "typeParametersDeclaration", "Lcom/goide/psi/GoTypeParameters;", "intellij.go.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getTypeParametersNamesList(@Nullable GoTypeParameters typeParametersDeclaration) {
            if (typeParametersDeclaration == null) {
                return CollectionsKt.emptyList();
            }
            List typeParameterNamesList = new ArrayList();
            for (GoTypeParameterDeclaration goTypeParameterDeclaration : typeParametersDeclaration.getTypeParameterDeclarationList()) {
                for (GoTypeParamDefinition goTypeParameterDefinition : goTypeParameterDeclaration.getTypeParamDefinitionList()) {
                    String goTypeParameterDefinitionName = goTypeParameterDefinition.getName();
                    if (goTypeParameterDefinitionName == null) continue;
                    typeParameterNamesList.add(goTypeParameterDefinitionName);
                }
            }
            return typeParameterNamesList;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

