/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.intentions.expressions.structLiteral.GoFillStructInfo;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoVisitor;
import com.goide.quickfix.GoAddKeysToStructLiteralValueQuickFix;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStructInitializationWithoutFieldNamesInspection
extends GoInspectionBase {
    private static final GoInspectionMessage PROBLEM_MESSAGE = GoStructInitializationWithoutFieldNamesInspection.message("go.inspection.problem.fields.are.assigned.without.explicit.names");
    public boolean reportLocalStructs;
    public boolean reportStructLiteralsWithoutType;

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoStructInitializationWithoutFieldNamesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoStructInitializationWithoutFieldNamesInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCompositeLit(@NotNull GoCompositeLit o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.process(o.getLiteralValue(), o);
            }

            @Override
            public void visitLiteralValue(@NotNull GoLiteralValue o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ObjectUtils.tryCast((Object)o.getParent(), GoCompositeLit.class) == null) {
                    this.process(o, null);
                }
            }

            private void process(@Nullable GoLiteralValue literalValue, @Nullable GoCompositeLit compositeLit) {
                GoStructType type2 = GoInspectionUtil.findStructTypeForLiteralValue(literalValue);
                if (literalValue != null && type2 != null && GoStructInitializationWithoutFieldNamesInspection.canAddKeys(literalValue, type2)) {
                    boolean shouldReportProblem;
                    GoCompositeElement targetElement = compositeLit != null ? compositeLit : literalValue;
                    boolean bl = shouldReportProblem = !(!GoStructInitializationWithoutFieldNamesInspection.this.reportLocalStructs && GoUtil.isDirectlyAccessible(type2.getContainingFile(), literalValue.getContainingFile()) || !GoStructInitializationWithoutFieldNamesInspection.this.reportStructLiteralsWithoutType && compositeLit == null);
                    if (shouldReportProblem) {
                        if (!GoStructInitializationWithoutFieldNamesInspection.this.isInformationLevel(targetElement)) {
                            holder.registerProblem((PsiElement)targetElement, PROBLEM_MESSAGE, new GoAddKeysToStructLiteralValueQuickFix());
                            if (targetElement != literalValue && holder.isOnTheFly()) {
                                holder.registerProblem((PsiElement)literalValue, PROBLEM_MESSAGE, ProblemHighlightType.INFORMATION, new GoAddKeysToStructLiteralValueQuickFix());
                            }
                        } else {
                            holder.registerProblem((PsiElement)targetElement, PROBLEM_MESSAGE, ProblemHighlightType.INFORMATION, (TextRange)null, new GoAddKeysToStructLiteralValueQuickFix());
                        }
                    } else if (holder.isOnTheFly()) {
                        holder.registerProblem((PsiElement)targetElement, PROBLEM_MESSAGE, ProblemHighlightType.INFORMATION, (TextRange)null, new GoAddKeysToStructLiteralValueQuickFix());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/inspections/GoStructInitializationWithoutFieldNamesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCompositeLit";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLiteralValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"reportLocalStructs", (String)GoBundle.message((String)"go.inspection.struct.initialization.settings.report.for.local.type.checkbox", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"reportStructLiteralsWithoutType", (String)GoBundle.message((String)"go.inspection.struct.initialization.settings.report.for.literals.without.type.checkbox", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            GoStructInitializationWithoutFieldNamesInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static boolean canAddKeys(@NotNull GoLiteralValue literalValue, @NotNull GoStructType structType) {
        List<GoElement> elements;
        if (literalValue == null) {
            GoStructInitializationWithoutFieldNamesInspection.$$$reportNull$$$0(3);
        }
        if (structType == null) {
            GoStructInitializationWithoutFieldNamesInspection.$$$reportNull$$$0(4);
        }
        if ((elements = literalValue.getElementList()).isEmpty() || !ContainerUtil.and(elements, e -> e.getKey() == null)) {
            return false;
        }
        List<GoNamedElement> fields = structType.getFieldDefinitions();
        if (fields.size() < elements.size()) {
            return false;
        }
        List<GoNamedElement> filledFields = fields.subList(0, elements.size());
        return GoFillStructInfo.getAccessibleFieldsCount(structType, filledFields, literalValue) == elements.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoStructInitializationWithoutFieldNamesInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalValue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoStructInitializationWithoutFieldNamesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canAddKeys";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

