/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoRenameQuickFix;
import com.intellij.DynamicBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameElementFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GoReceiverNamesInspection
extends GoInspectionBase {
    public static final Set<String> GENERIC_NAMES_SET = ContainerUtil.newHashSet((Object[])new String[]{"me", "this", "self"});

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoReceiverNamesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoReceiverNamesInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitReceiver(@NotNull GoReceiver o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GENERIC_NAMES_SET.contains(o.getName())) {
                    PsiElement identifier = o.getIdentifier();
                    if (identifier == null) {
                        return;
                    }
                    holder.registerProblem(identifier, GoReceiverNamesInspection.message("go.inspection.problem.receiver.has.generic.name"), new LocalQuickFix[]{new GoRenameQuickFix(o)});
                }
            }

            @Override
            public void visitMethodDeclaration(@NotNull GoMethodDeclaration o) {
                GoTypeSpec typeSpec;
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((typeSpec = GoPsiImplUtil.getTypeSpecFromReceiver(o.getReceiver())) == null || ((Object)((Object)typeSpec.getContainingFile())).equals((Object)o.getContainingFile())) {
                    return;
                }
                if (GoReceiverNamesInspection.hasMultipleReceiverNames(typeSpec)) {
                    this.registerProblem(o);
                }
            }

            @Override
            public void visitTypeSpec(@NotNull GoTypeSpec o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.checkTypeSpec(o, (PsiFile)o.getContainingFile());
            }

            private void checkTypeSpec(@NotNull GoTypeSpec o, @NotNull PsiFile file) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (GoReceiverNamesInspection.hasMultipleReceiverNames(o)) {
                    for (GoMethodDeclaration method : o.getMethods()) {
                        if (!method.isValid() || !file.isEquivalentTo((PsiElement)method.getContainingFile())) continue;
                        this.registerProblem(method);
                    }
                }
            }

            private void registerProblem(@NotNull GoMethodDeclaration method) {
                GoReceiver receiver;
                PsiElement identifier;
                if (method == null) {
                    1.$$$reportNull$$$0(5);
                }
                PsiElement psiElement = identifier = (receiver = method.getReceiver()) != null ? receiver.getIdentifier() : null;
                if (identifier == null) {
                    return;
                }
                holder.registerProblem(identifier, GoReceiverNamesInspection.message("go.inspection.problem.receiver.names.are.different"), new LocalQuickFix[]{new RenameAllReceiversFix(receiver, identifier.getText()), new GoRenameQuickFix(receiver)});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoReceiverNamesInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReceiver";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeSpec";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypeSpec";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean hasMultipleReceiverNames(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoReceiverNamesInspection.$$$reportNull$$$0(2);
        }
        return GoPsiImplUtil.getReceiversNames(typeSpec, true).size() > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoReceiverNamesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMultipleReceiverNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RenameAllReceiversFix
    extends RenameElementFix {
        private static final Map<Locale, Map<String, @Nls String>> TEXTS = ContainerUtil.createWeakKeyWeakValueMap();

        private RenameAllReceiversFix(@NotNull GoReceiver receiver, @NotNull String newName) {
            if (receiver == null) {
                RenameAllReceiversFix.$$$reportNull$$$0(0);
            }
            if (newName == null) {
                RenameAllReceiversFix.$$$reportNull$$$0(1);
            }
            super((PsiNamedElement)receiver, newName, RenameAllReceiversFix.fromCache(newName, name -> GoBundle.message((String)"go.fix.rename.all.receivers.text", (Object[])new Object[]{name})));
        }

        @NotNull
        @IntentionName
        private static String fromCache(@NotNull String newName, @NotNull Function<String, @Nls String> textProducer) {
            if (newName == null) {
                RenameAllReceiversFix.$$$reportNull$$$0(2);
            }
            if (textProducer == null) {
                RenameAllReceiversFix.$$$reportNull$$$0(3);
            }
            String string = TEXTS.computeIfAbsent(DynamicBundle.getLocale(), __ -> ContainerUtil.createWeakKeyWeakValueMap()).computeIfAbsent(newName, textProducer);
            if (string == null) {
                RenameAllReceiversFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.rename.all.receivers.name", (Object[])new Object[0]);
            if (string == null) {
                RenameAllReceiversFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiver";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textProducer";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoReceiverNamesInspection$RenameAllReceiversFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoReceiverNamesInspection$RenameAllReceiversFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromCache";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fromCache";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

