/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoCallableDescriptor;
import com.goide.inspections.core.GoCallableDescriptorSet;
import com.goide.inspections.core.GoFunctionDescriptor;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoMethodDescriptor;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.inspections.fmtstring.parser.GoFmtStringParser;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringBadPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionType;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoChangeToFormattingCallQuickFix;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoStdlibUtil;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoPrintFunctionsInspection
extends GoInspectionBase {
    private static final GoCallableDescriptorSet DESCRIPTORS = new GoCallableDescriptorSet(ContainerUtil.newHashSet((Object[])new GoCallableDescriptor[]{GoFunctionDescriptor.of("fmt.Fprint"), GoFunctionDescriptor.of("fmt.Fprintln"), GoFunctionDescriptor.of("fmt.Print"), GoFunctionDescriptor.of("fmt.Println"), GoFunctionDescriptor.of("fmt.Sprint"), GoFunctionDescriptor.of("fmt.Sprintln"), GoFunctionDescriptor.of("log.Fatal"), GoFunctionDescriptor.of("log.Fatalln"), GoFunctionDescriptor.of("log.Panic"), GoFunctionDescriptor.of("log.Panicln"), GoFunctionDescriptor.of("log.Print"), GoFunctionDescriptor.of("log.Println"), GoMethodDescriptor.of("(*testing.common).Error"), GoMethodDescriptor.of("(*testing.common).Fatal"), GoMethodDescriptor.of("(*testing.common).Log"), GoMethodDescriptor.of("(*testing.common).Skip")}));
    private static final String FLAGS_RE = "[+\\-#]*";
    private static final String INDEX_OPT_RE = "(\\[[0-9]+])?";
    private static final String NUM_OPT_RE = "([0-9]+|(\\[[0-9]+])?\\*)?";
    private static final String VERB_RE = "[bcdefgopqstvxEFGUXO]";
    private static final String PRINT_FORMAT_REGEXP = "%[+\\-#]*([0-9]+|(\\[[0-9]+])?\\*)?\\.?([0-9]+|(\\[[0-9]+])?\\*)?(\\[[0-9]+])?[bcdefgopqstvxEFGUXO]";
    private static final Pattern PRINT_FORMAT_PATTERN = Pattern.compile("%[+\\-#]*([0-9]+|(\\[[0-9]+])?\\*)?\\.?([0-9]+|(\\[[0-9]+])?\\*)?(\\[[0-9]+])?[bcdefgopqstvxEFGUXO]");
    private static final GoSdkVersion ANY_SDK_VERSION = GoSdkVersion.GO_1_1;
    private static final Map<Character, GoSdkVersion> VERBS = GoPrintFunctionsInspection.verbSdkMap(Pair.pair((Object)"vTtbcdoqxXUeEfFgGsp", (Object)((Object)ANY_SDK_VERSION)), Pair.pair((Object)"w", (Object)((Object)GoSdk.ERROR_WRAPPERS_VERSION)), Pair.pair((Object)"O", (Object)((Object)GoSdk.OCTAL_PREFIX_VERSION)));
    private static final Map<Character, GoSdkVersion> FLOAT_AND_COMPLEX_VERBS = GoPrintFunctionsInspection.verbSdkMap(Pair.pair((Object)"beEfFgG", (Object)((Object)ANY_SDK_VERSION)), Pair.pair((Object)"xX", (Object)((Object)GoSdk.HEX_FLOATS_VERSION)));
    private static final Set<Character> FLAGS_FOR_ANY_VERB = Set.of(Character.valueOf('-'), Character.valueOf('0'));
    private static final Map<Character, Map<Character, GoSdkVersion>> VERBS_FOR_FLAG = Map.of(Character.valueOf('+'), GoPrintFunctionsInspection.verbSdkMap(Pair.pair((Object)"vbdoxXeEfFgGq", (Object)((Object)ANY_SDK_VERSION))), Character.valueOf('#'), GoPrintFunctionsInspection.verbSdkMap(Pair.pair((Object)"voxXpqeEfFgGU", (Object)((Object)ANY_SDK_VERSION)), Pair.pair((Object)"b", (Object)((Object)GoSdk.BINARY_DIGITS_VERSION))), Character.valueOf(' '), GoPrintFunctionsInspection.verbSdkMap(Pair.pair((Object)"dxX", (Object)((Object)ANY_SDK_VERSION))));

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitCallExpr(@NotNull GoCallExpr o) {
                GoFmtStringUtil.FmtFunctionInfo fmtFunction;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((fmtFunction = GoFmtStringUtil.findFormattingFunction(o)) != null) {
                    GoPrintFunctionsInspection.this.checkPrintf(holder, fmtFunction);
                }
                if (DESCRIPTORS.contains(o, true)) {
                    GoPrintFunctionsInspection.checkPrint(holder, o, Objects.requireNonNull(GoInspectionUtil.resolveCall(o)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/goide/inspections/GoPrintFunctionsInspection$1", "visitCallExpr"));
            }
        };
    }

    private static void checkPrint(@NotNull GoProblemsHolder holder, @NotNull GoCallExpr callExpr, @NotNull GoNamedSignatureOwner declaration) {
        String declarationName;
        String trimmed;
        String firstArgText;
        GoSignature signature;
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(2);
        }
        if (callExpr == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(3);
        }
        if (declaration == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(4);
        }
        if ((signature = declaration.getSignature()) == null) {
            return;
        }
        GoParameters parameters = signature.getParameters();
        if (!parameters.isVariadic()) {
            return;
        }
        int firstArgIndex = parameters.getParameterDeclarationList().size() - 1;
        List<GoExpression> allArguments = callExpr.getArgumentList().getExpressionList();
        if (allArguments.size() <= firstArgIndex) {
            return;
        }
        List<GoExpression> arguments = allArguments.subList(firstArgIndex, allArguments.size());
        GoExpression firstArg = (GoExpression)ContainerUtil.getFirstItem(arguments);
        if (firstArg == null) {
            return;
        }
        if (firstArgIndex == 0 && GoPrintFunctionsInspection.isStdIOWriter(firstArg)) {
            String argText = firstArg.getText();
            GoInspectionMessage message = GoPrintFunctionsInspection.message("go.inspection.problem.function.does.not.take.writer", GoPrintFunctionsInspection.code("io.Writer"), GoPrintFunctionsInspection.code(argText));
            holder.registerProblem((PsiElement)firstArg, message, new LocalQuickFix[0]);
        }
        if ((firstArgText = GoFmtStringUtil.getStringValue(firstArg)) != null && StringUtil.containsChar((String)(trimmed = StringUtil.trimEnd((String)firstArgText, (char)'%')), (char)'%') && PRINT_FORMAT_PATTERN.matcher(trimmed).find()) {
            holder.registerProblem((PsiElement)firstArg, GoPrintFunctionsInspection.message("go.inspection.problem.possible.formatting.directive", REF), new LocalQuickFix[]{firstArg instanceof GoStringLiteral ? new GoChangeToFormattingCallQuickFix(callExpr) : null});
        }
        if ((declarationName = declaration.getName()) != null && declarationName.endsWith("ln")) {
            String argText;
            GoExpression lastArg = (GoExpression)ContainerUtil.getLastItem(arguments);
            String string = argText = lastArg != null ? GoFmtStringUtil.getStringValue(lastArg) : null;
            if (argText != null && argText.endsWith("\n")) {
                holder.registerProblem((PsiElement)lastArg, GoPrintFunctionsInspection.message("go.inspection.problem.last.argument.ends.with.redundant.newline", GoPrintFunctionsInspection.code(declarationName)), new LocalQuickFix[0]);
            }
        }
        for (GoExpression argument : arguments) {
            GoType goType = argument.getGoType(null);
            if (GoTypeUtil.isFunction(goType, argument)) {
                GoInspectionMessage message = argument instanceof GoCallExpr ? GoPrintFunctionsInspection.message("go.inspection.problem.return.value.has.a.function.type", REF) : GoPrintFunctionsInspection.message("go.inspection.problem.argument.is.not.a.function.call", REF);
                holder.registerProblem((PsiElement)argument, message, new LocalQuickFix[0]);
            }
            if (!GoPrintFunctionsInspection.isStringer(argument)) continue;
            holder.registerProblem((PsiElement)argument, GoPrintFunctionsInspection.message("go.inspection.problem.argument.causes.recursive.call.to.string.method", REF, GoPrintFunctionsInspection.code("String")), new LocalQuickFix[0]);
        }
    }

    private static boolean isStdIOWriter(@NotNull GoExpression expression) {
        GoReferenceExpression ref;
        if (expression == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(5);
        }
        return (ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)expression, GoReferenceExpression.class)) != null && (ref.textMatches("os.Stdout") || ref.textMatches("os.Stderr") || ref.textMatches("os.Stdin")) && GoInspectionUtil.isInSdkPackage(ref.resolve(), "os", expression);
    }

    private static boolean isStringer(@NotNull GoExpression expression) {
        boolean isUnaryMul;
        GoExpression unwrapped;
        GoReferenceExpression ref;
        if (expression == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(6);
        }
        if ((ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)(unwrapped = (isUnaryMul = expression instanceof GoUnaryExpr && ((GoUnaryExpr)expression).getBitAnd() != null) ? ((GoUnaryExpr)expression).getExpression() : expression), GoReferenceExpression.class)) == null) {
            return false;
        }
        PsiElement resolve2 = ref.resolve();
        GoReceiver receiver = (GoReceiver)ObjectUtils.tryCast((Object)resolve2, GoReceiver.class);
        if (receiver == null) {
            return false;
        }
        if (receiver.getType() instanceof GoPointerType && isUnaryMul) {
            return false;
        }
        return GoStdlibUtil.isStringMethod((GoNamedSignatureOwner)ObjectUtils.tryCast((Object)receiver.getParent(), GoMethodDeclaration.class), expression);
    }

    private void checkPrintf(@NotNull GoProblemsHolder holder, @NotNull GoFmtStringUtil.FmtFunctionInfo fmtFunctionInfo) {
        boolean canCheckOperands;
        GoFmtStringUtil.FmtCallArguments args;
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(7);
        }
        if (fmtFunctionInfo == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(8);
        }
        if ((args = fmtFunctionInfo.getFmtStringAndRestArguments()) == null) {
            return;
        }
        GoFmtStringUtil.FmtStringProblemsHolder holderWrapper = new GoFmtStringUtil.FmtStringProblemsHolder(holder, args.getFmtString());
        String fmtStringValue = GoFmtStringUtil.getStringValue(args.getFmtString());
        if (fmtStringValue == null) {
            return;
        }
        if (!StringUtil.containsChar((String)fmtStringValue, (char)'%')) {
            if (args.getRestArguments().isEmpty()) {
                return;
            }
            holderWrapper.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.no.placeholders.in.format.string"));
            return;
        }
        List<GoFmtStringToken> tokens = GoFmtStringParser.parse(fmtStringValue);
        List badPlaceholders = ContainerUtil.filter(tokens, t -> t instanceof GoFmtStringBadPlaceholder);
        if (!badPlaceholders.isEmpty()) {
            badPlaceholders.forEach(bad -> holderWrapper.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.placeholder.syntax.error", GoPrintFunctionsInspection.getText(bad)), (GoFmtStringToken)bad));
            return;
        }
        if (fmtFunctionInfo.isScanFunction()) {
            return;
        }
        if (ContainerUtil.or(tokens, t -> t instanceof GoFmtStringEscapedPercent && !"%%".equals(t.getText()))) {
            return;
        }
        List<GoFmtStringPlaceholder> placeholders = GoFmtStringUtil.filterPlaceholders(tokens);
        if (placeholders.isEmpty() && !args.getRestArguments().isEmpty()) {
            holderWrapper.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.too.many.arguments.for.format.string", 0, args.getRestArguments().size()));
            return;
        }
        boolean isIndicesOk = GoPrintFunctionsInspection.checkIndices(holderWrapper, placeholders);
        boolean bl = canCheckOperands = isIndicesOk && !fmtFunctionInfo.getCallExpression().getArgumentList().isVariadic();
        if (!canCheckOperands) {
            return;
        }
        List<GoFmtStringUtil.Indices> indicesList = GoFmtStringUtil.operandsIndices(placeholders);
        int requiredOperandsCount = GoFmtStringUtil.maxIndex(indicesList) + 1;
        if (args.getRestArguments().size() > requiredOperandsCount && !GoFmtStringUtil.hasExplicitIndices(placeholders)) {
            holderWrapper.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.too.many.arguments.for.format.string", requiredOperandsCount, args.getRestArguments().size()));
            return;
        }
        boolean wPlaceholderAlreadySeen = false;
        for (int i = 0; i < placeholders.size(); ++i) {
            GoFmtStringPlaceholder placeholder = placeholders.get(i);
            GoCallExpr callExpr = fmtFunctionInfo.getCallExpression();
            if (placeholder.getVerb() == 'w' && GoPrintFunctionsInspection.isKnownVerb(callExpr, 'w')) {
                if (!fmtFunctionInfo.isFmtErrorfFunction()) {
                    holderWrapper.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.this.verb.can.be.used.only.in.fmt.errorf", GoPrintFunctionsInspection.code("fmt.Errorf"), GoPrintFunctionsInspection.getText(placeholder)), placeholder);
                    continue;
                }
                if (wPlaceholderAlreadySeen && !GoPrintFunctionsInspection.isSupportedBySdk(callExpr, GoSdk.MULTI_ERRORS_VERSION)) {
                    holderWrapper.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.this.verb.can.be.used.only.once.in.a.format.string", GoPrintFunctionsInspection.getText(placeholder)), placeholder);
                    continue;
                }
                wPlaceholderAlreadySeen = true;
            }
            this.checkOperands(holderWrapper, placeholder, indicesList.get(i), args.getRestArguments());
        }
    }

    @NlsSafe
    @NotNull
    private static String getText(@NotNull GoFmtStringToken token) {
        String tokenText;
        if (token == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(9);
        }
        return !(tokenText = token.getText()).isEmpty() ? String.format(" (%s)", tokenText) : "";
    }

    private void checkOperands(@NotNull GoFmtStringUtil.FmtStringProblemsHolder holder, @NotNull GoFmtStringPlaceholder placeholder, @NotNull GoFmtStringUtil.Indices operandsIndices, @NotNull List<GoExpression> allOperands) {
        Integer precisionIndex;
        Integer widthIndex;
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(10);
        }
        if (placeholder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(11);
        }
        if (operandsIndices == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(12);
        }
        if (allOperands == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(13);
        }
        if ((widthIndex = operandsIndices.getWidthIndex()) != null) {
            GoPrintFunctionsInspection.checkParameter(holder, placeholder, PlaceholderPart.WIDTH, widthIndex, allOperands);
        }
        if ((precisionIndex = operandsIndices.getPrecisionIndex()) != null) {
            GoPrintFunctionsInspection.checkParameter(holder, placeholder, PlaceholderPart.PRECISION, precisionIndex, allOperands);
        }
        GoPrintFunctionsInspection.checkOperand(holder, placeholder, PlaceholderPart.VERB, operandsIndices.getVerbIndex(), allOperands, (Consumer<GoExpression>)((Consumer)operand -> {
            char verb = placeholder.getVerb();
            GoType type2 = operand.getGoType(null);
            TypeInfo operandTypeInfo = new TypeInfo(type2, (PsiElement)operand);
            if (!GoPrintFunctionsInspection.isKnownVerb(operand, verb)) {
                GoPrintFunctionsInspection.registerWarning(holder, GoPrintFunctionsInspection.message("go.inspection.problem.unknown.verb", GoPrintFunctionsInspection.code(String.valueOf(verb)), GoPrintFunctionsInspection.getText(placeholder)), placeholder, operandTypeInfo);
                return;
            }
            this.checkFlags(holder, (PsiElement)operand, placeholder, operandTypeInfo);
            if (verb != 'p' && verb != 'T' && GoTypeUtil.isFunction(type2, operand)) {
                if (operand instanceof GoCallExpr) {
                    GoPrintFunctionsInspection.registerWarning(holder, GoPrintFunctionsInspection.message("go.inspection.problem.return.value.of.placeholder.argument.has.a.function.type", GoPrintFunctionsInspection.getText(placeholder)), placeholder, operandTypeInfo);
                } else {
                    GoPrintFunctionsInspection.registerWarning(holder, GoPrintFunctionsInspection.message("go.inspection.problem.placeholder.argument.is.not.a.function.call", GoPrintFunctionsInspection.getText(placeholder)), placeholder, operandTypeInfo);
                }
                return;
            }
            ResolveState resolveState = GoPsiImplUtil.createContextOnElement(operand);
            if (!(GoPrintFunctionsInspection.typeMatches(verb, type2, new HashSet<GoType>(), resolveState) || verb == 'p' && GoExpressionUtil.isNil(operand))) {
                GoPrintFunctionsInspection.registerWarning(holder, GoPrintFunctionsInspection.message("go.inspection.problem.placeholder.argument.has.wrong.type", GoPrintFunctionsInspection.code(operand), GoPrintFunctionsInspection.code(type2), GoPrintFunctionsInspection.getText(placeholder)), placeholder, operandTypeInfo);
                return;
            }
            if ((GoPrintFunctionsInspection.isForString(verb) || verb == 'v') && !placeholder.getFlags().contains(Character.valueOf('#')) && GoPrintFunctionsInspection.isStringer(operand)) {
                GoPrintFunctionsInspection.registerWarning(holder, GoPrintFunctionsInspection.message("go.inspection.problem.placeholder.argument.causes.recursive.call.to.string", GoPrintFunctionsInspection.code("String"), GoPrintFunctionsInspection.getText(placeholder)), placeholder, operandTypeInfo);
            }
        }));
    }

    private static void checkParameter(@NotNull GoFmtStringUtil.FmtStringProblemsHolder holder, @NotNull GoFmtStringPlaceholder placeholder, @NotNull PlaceholderPart placeholderPart, int operandIndex, @NotNull List<GoExpression> allOperands) {
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(14);
        }
        if (placeholder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(15);
        }
        if (placeholderPart == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(16);
        }
        if (allOperands == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(17);
        }
        GoPrintFunctionsInspection.checkOperand(holder, placeholder, placeholderPart, operandIndex, allOperands, (Consumer<GoExpression>)((Consumer)operand -> {
            if (!GoTypeUtil.isIntegerType(operand.getGoType(null), operand)) {
                holder.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.fmt.parameter.with.non.integer.expression", placeholderPart.index, GoPrintFunctionsInspection.code(operand), GoPrintFunctionsInspection.getText(placeholder)), placeholder);
            }
        }));
    }

    private static void checkOperand(@NotNull GoFmtStringUtil.FmtStringProblemsHolder holder, @NotNull GoFmtStringPlaceholder placeholder, @NotNull PlaceholderPart placeholderPart, int operandIndex, @NotNull List<GoExpression> allOperands, @NotNull Consumer<GoExpression> operandChecker) {
        GoExpression operand;
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(18);
        }
        if (placeholder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(19);
        }
        if (placeholderPart == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(20);
        }
        if (allOperands == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(21);
        }
        if (operandChecker == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(22);
        }
        if ((operand = (GoExpression)ContainerUtil.getOrElse(allOperands, (int)operandIndex, null)) == null) {
            holder.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.no.argument.for.placeholder.part", placeholderPart.index, operandIndex + 1, allOperands.size(), GoPrintFunctionsInspection.getText(placeholder)), placeholder);
        } else {
            operandChecker.consume((Object)operand);
        }
    }

    private void checkFlags(@NotNull GoFmtStringUtil.FmtStringProblemsHolder holder, @NotNull PsiElement context, @NotNull GoFmtStringPlaceholder placeholder, @NotNull TypeInfo operandTypeInfo) {
        List<Character> flags;
        List ignoredFlags;
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(23);
        }
        if (context == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(24);
        }
        if (placeholder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(25);
        }
        if (operandTypeInfo == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(26);
        }
        if (!(ignoredFlags = ContainerUtil.filter(flags = placeholder.getFlags(), flag -> !GoPrintFunctionsInspection.applicableToVerb(context, flag, placeholder.getVerb()))).isEmpty() && !operandTypeInfo.implementsFormatter()) {
            String flagsText = StringUtil.join((Collection)ContainerUtil.map((Collection)ignoredFlags, f -> "'" + f + "'"), (String)", ");
            GoInspectionMessage message = ignoredFlags.size() == 1 ? GoPrintFunctionsInspection.message("go.inspection.problem.verb.will.ignore.flag", flagsText, GoPrintFunctionsInspection.getText(placeholder)) : GoPrintFunctionsInspection.message("go.inspection.problem.verb.will.ignore.flags", flagsText, GoPrintFunctionsInspection.getText(placeholder));
            holder.reportToken(message, this.nonDefaultHighlightingType(ProblemHighlightType.WEAK_WARNING, holder.getFmtStringExpr()), placeholder);
        }
    }

    public static boolean checkIndices(@NotNull GoFmtStringUtil.FmtStringProblemsHolder holder, @NotNull List<GoFmtStringPlaceholder> placeholders) {
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(27);
        }
        if (placeholders == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(28);
        }
        boolean indicesNotOk = false;
        for (GoFmtStringPlaceholder p : placeholders) {
            boolean hasZeroIndices = GoFmtStringUtil.hasZeroIndices(p);
            if (hasZeroIndices) {
                holder.registerWarning(GoPrintFunctionsInspection.message("go.inspection.problem.index.zero.is.illegal", GoPrintFunctionsInspection.getText(p)), p);
            }
            indicesNotOk |= hasZeroIndices;
        }
        return !indicesNotOk;
    }

    private static void registerWarning(@NotNull GoFmtStringUtil.FmtStringProblemsHolder holder, @NotNull GoInspectionMessage message, @NotNull GoFmtStringPlaceholder placeholder, @NotNull TypeInfo operandTypeInfo) {
        if (holder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(29);
        }
        if (message == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(30);
        }
        if (placeholder == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(31);
        }
        if (operandTypeInfo == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(32);
        }
        if (!operandTypeInfo.implementsFormatter()) {
            holder.registerWarning(message, placeholder);
        }
    }

    private static boolean applicableToVerb(@NotNull PsiElement context, @NotNull Character flag, char verb) {
        if (context == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(33);
        }
        if (flag == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(34);
        }
        return FLAGS_FOR_ANY_VERB.contains(flag) || GoPrintFunctionsInspection.isSupportedBySdk(context, (GoSdkVersion)((Object)VERBS_FOR_FLAG.getOrDefault(flag, Collections.emptyMap()).get(Character.valueOf(verb))));
    }

    @Contract(value="_, null, _, _ -> true")
    private static boolean typeMatches(char verb, @Nullable GoType type2, @NotNull Set<GoType> visitedTypes, @Nullable ResolveState resolveState) {
        if (visitedTypes == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(35);
        }
        if (type2 == null || !visitedTypes.add(type2)) {
            return true;
        }
        if (verb == 'v' || verb == 'T') {
            return true;
        }
        PsiElement context = GoPsiImplUtil.getContextElement(resolveState);
        if (GoPrintFunctionsInspection.isForString(verb) && GoStdlibUtil.implementsStringerOrError(type2, context)) {
            return true;
        }
        if (verb == 'w') {
            return GoStdlibUtil.implementsError(type2, context);
        }
        GoType underlyingType = type2.getUnderlyingType(resolveState);
        if (GoTypeUtil.isUnresolvedType(underlyingType, resolveState)) {
            return true;
        }
        Boolean match = (Boolean)RecursionManager.doPreventingRecursion((Object)underlyingType, (boolean)true, () -> {
            if (underlyingType instanceof GoFunctionType || underlyingType instanceof GoChannelType) {
                return verb == 'p';
            }
            if (underlyingType instanceof GoMapType) {
                return verb == 'p' || GoPrintFunctionsInspection.typeMatches(verb, ((GoMapType)underlyingType).getKeyType(), visitedTypes, resolveState) && GoPrintFunctionsInspection.typeMatches(verb, ((GoMapType)underlyingType).getValueType(), visitedTypes, resolveState);
            }
            if (underlyingType instanceof GoArrayOrSliceType) {
                GoType elementType = ((GoArrayOrSliceType)underlyingType).getType();
                return verb == 'p' || GoPrintFunctionsInspection.isForString(verb) && GoTypeUtil.isByteType(elementType, context) || GoPrintFunctionsInspection.typeMatches(verb, elementType, visitedTypes, resolveState);
            }
            if (underlyingType instanceof GoPointerType) {
                GoType elementUnderlyingType;
                if (verb == 'p') {
                    return true;
                }
                GoType elementType = ((GoPointerType)underlyingType).getType();
                GoType goType = elementUnderlyingType = elementType != null ? elementType.getUnderlyingType(resolveState) : null;
                if (elementUnderlyingType == null) {
                    return true;
                }
                if (elementUnderlyingType instanceof GoStructType) {
                    return GoPrintFunctionsInspection.structTypeMatches(verb, (GoStructType)elementUnderlyingType, visitedTypes, resolveState);
                }
                return GoPrintFunctionsInspection.isForInteger(verb);
            }
            if (underlyingType instanceof GoStructType) {
                return GoPrintFunctionsInspection.structTypeMatches(verb, (GoStructType)underlyingType, visitedTypes, resolveState);
            }
            if (underlyingType instanceof GoInterfaceType) {
                return true;
            }
            if (GoTypeUtil.isBoolean(underlyingType, context)) {
                return verb == 't';
            }
            if (GoTypeUtil.isIntegerType(underlyingType, context)) {
                return GoPrintFunctionsInspection.isForInteger(verb);
            }
            if (GoTypeUtil.isFloatType(underlyingType, context) || GoTypeUtil.isComplexType(underlyingType, context)) {
                return GoPrintFunctionsInspection.isForFloatOrComplex(context, verb);
            }
            if (GoTypeUtil.isString(underlyingType, context)) {
                return GoPrintFunctionsInspection.isForString(verb);
            }
            if (GoTypeUtil.isUnsafePointerType(underlyingType, context)) {
                return verb == 'p' || GoPrintFunctionsInspection.isForInteger(verb);
            }
            return false;
        });
        return match != null ? match : true;
    }

    private static boolean structTypeMatches(char verb, @NotNull GoStructType type2, @NotNull Set<GoType> visitedTypes, @Nullable ResolveState resolveState) {
        if (type2 == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(36);
        }
        if (visitedTypes == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(37);
        }
        for (GoNamedElement field : type2.getFieldDefinitions()) {
            GoType fieldType = field.getGoType(resolveState);
            if (fieldType == null) {
                return true;
            }
            if (GoPrintFunctionsInspection.typeMatches(verb, fieldType, visitedTypes, resolveState)) continue;
            return false;
        }
        return true;
    }

    private static boolean isForString(char verb) {
        return verb == 'q' || verb == 's' || verb == 'x' || verb == 'X';
    }

    private static boolean isForInteger(char verb) {
        return verb == 'b' || verb == 'c' || verb == 'd' || verb == 'o' || verb == 'O' || verb == 'q' || verb == 'U' || verb == 'x' || verb == 'X';
    }

    private static boolean isForFloatOrComplex(@Nullable PsiElement context, char verb) {
        return GoPrintFunctionsInspection.isSupportedBySdk(context, FLOAT_AND_COMPLEX_VERBS.get(Character.valueOf(verb)));
    }

    private static boolean isKnownVerb(@NotNull PsiElement context, char verb) {
        if (context == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(38);
        }
        return GoPrintFunctionsInspection.isSupportedBySdk(context, VERBS.get(Character.valueOf(verb)));
    }

    private static boolean isSupportedBySdk(@Nullable PsiElement context, @Nullable GoSdkVersion minSdkVersion) {
        if (minSdkVersion == null) {
            return false;
        }
        GoSdk sdk = context != null ? GoSdkService.getInstance(context.getProject()).getSdk(GoUtil.module(context)) : null;
        return sdk != null && sdk.getMajorVersion().isAtLeast(minSdkVersion);
    }

    @NotNull
    private static Map<Character, GoSdkVersion> verbSdkMap(Pair<String, GoSdkVersion> ... verbVersions) {
        HashMap<Character, GoSdkVersion> result = new HashMap<Character, GoSdkVersion>();
        for (Pair<String, GoSdkVersion> verbsAndSdk : verbVersions) {
            String verbs = (String)verbsAndSdk.first;
            GoSdkVersion sdkVersion = (GoSdkVersion)((Object)verbsAndSdk.second);
            for (int i = 0; i < verbs.length(); ++i) {
                result.put(Character.valueOf(verbs.charAt(i)), sdkVersion);
            }
        }
        HashMap<Character, GoSdkVersion> hashMap = result;
        if (hashMap == null) {
            GoPrintFunctionsInspection.$$$reportNull$$$0(39);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fmtFunctionInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandsIndices";
                break;
            }
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allOperands";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderPart";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandChecker";
                break;
            }
            case 24: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandTypeInfo";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTypes";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoPrintFunctionsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoPrintFunctionsInspection";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "verbSdkMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkPrint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStdIOWriter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStringer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkPrintf";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkOperands";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkParameter";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkOperand";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkFlags";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkIndices";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerWarning";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "applicableToVerb";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "typeMatches";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "structTypeMatches";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isKnownVerb";
                break;
            }
            case 39: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 39 -> new IllegalStateException(string);
        };
    }

    private static enum PlaceholderPart {
        WIDTH(0),
        PRECISION(1),
        VERB(2);

        final int index;

        private PlaceholderPart(int index) {
            this.index = index;
        }
    }

    private static class TypeInfo {
        private final GoType myType;
        @Nullable
        private final PsiElement myContext;
        private Boolean myImplementsFormatter;

        TypeInfo(@Nullable GoType type2, @Nullable PsiElement context) {
            this.myType = type2;
            this.myContext = context;
        }

        boolean implementsFormatter() {
            if (this.myImplementsFormatter == null) {
                this.myImplementsFormatter = GoStdlibUtil.implementsFormatter(this.myType, this.myContext);
            }
            return this.myImplementsFormatter == Boolean.TRUE;
        }
    }
}

