/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForClause;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVarSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.quickfix.GoExtractEmptySliceToVarDeclarationQuickFix;
import com.goide.quickfix.GoReplaceExpressionQuickFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPreferNilSliceInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoPreferNilSliceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoPreferNilSliceInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            @Override
            public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration shortVarDeclaration) {
                PsiElement grand;
                if (shortVarDeclaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitShortVarDeclaration(shortVarDeclaration);
                PsiElement parent = shortVarDeclaration.getParent();
                PsiElement psiElement = grand = parent != null ? parent.getParent() : null;
                if (parent instanceof GoSimpleStatement && (grand instanceof GoIfStatement || grand instanceof GoForClause || grand instanceof GoExprSwitchStatement || grand instanceof GoTypeSwitchStatement)) {
                    return;
                }
                this.checkVarDeclaration(shortVarDeclaration.getVarDefinitionList(), shortVarDeclaration.getRightExpressionsList(), GoInspectionUtil::isPrimaryDefinition, false);
            }

            @Override
            public void visitVarDeclaration(@NotNull GoVarDeclaration varDeclaration) {
                if (varDeclaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitVarDeclaration(varDeclaration);
                List<GoVarSpec> specs = varDeclaration.getVarSpecList();
                for (GoVarSpec spec : specs) {
                    this.checkVarDeclaration(spec.getVarDefinitionList(), spec.getExpressionList(), def -> true, spec.getType() != null);
                }
            }

            private void checkVarDeclaration(@NotNull List<GoVarDefinition> definitions, @NotNull List<GoExpression> assignedExprs, @NotNull Predicate<GoVarDefinition> additionalCheck, boolean hasExplicitType) {
                if (definitions == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (assignedExprs == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (additionalCheck == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (definitions.size() != assignedExprs.size()) {
                    return;
                }
                for (Pair pair : ContainerUtil.zip(definitions, assignedExprs)) {
                    if (((GoVarDefinition)pair.first).isBlank() || !GoPreferNilSliceInspection.isEmptySliceLiteral(GoPsiImplUtil.unwrapParentheses((GoExpression)pair.second)) || !additionalCheck.test((GoVarDefinition)pair.first)) continue;
                    GoInspectionMessage message = GoPreferNilSliceInspection.message("go.inspection.problem.empty.slice.declaration.via.literal");
                    GoExtractEmptySliceToVarDeclarationQuickFix extract = new GoExtractEmptySliceToVarDeclarationQuickFix((PsiElement)pair.second);
                    if (!hasExplicitType) {
                        holder.registerProblem((PsiElement)pair.second, message, new LocalQuickFix[]{extract});
                        continue;
                    }
                    holder.registerProblem((PsiElement)pair.second, message, new LocalQuickFix[]{extract, GoPreferNilSliceInspection.replaceWithNilFix()});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "shortVarDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "varDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "definitions";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "assignedExprs";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalCheck";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoPreferNilSliceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitShortVarDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVarDeclaration";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkVarDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static GoReplaceExpressionQuickFix replaceWithNilFix() {
        return new GoReplaceExpressionQuickFix("nil"){

            @Override
            @Nls(capitalization=Nls.Capitalization.Sentence)
            @NotNull
            public String getFamilyName() {
                String string = GoBundle.message((String)"go.fix.replace.with.nil.with.side.effects.name", (Object[])new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/inspections/GoPreferNilSliceInspection$2", "getFamilyName"));
            }
        };
    }

    @Contract(value="null -> false")
    private static boolean isEmptySliceLiteral(@Nullable GoExpression expr) {
        GoCompositeLit compositeLit = (GoCompositeLit)ObjectUtils.tryCast((Object)expr, GoCompositeLit.class);
        if (compositeLit == null) {
            return false;
        }
        GoLiteralValue literalValue = compositeLit.getLiteralValue();
        if (literalValue == null || !literalValue.getElementList().isEmpty()) {
            return false;
        }
        GoType type2 = compositeLit.getType();
        return type2 instanceof GoArrayOrSliceType && !((GoArrayOrSliceType)type2).isArray();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/goide/inspections/GoPreferNilSliceInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

