/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoFile;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoIncDecStatement;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoStatement;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoLoopClosureInspection
extends GoInspectionBase {
    @Override
    protected boolean isEnabledOnFile(@NotNull GoFile file) {
        if (file == null) {
            GoLoopClosureInspection.$$$reportNull$$$0(0);
        }
        return super.isEnabledOnFile(file) && GoSdkUtil.featureSupported((PsiElement)file, false, GoSdkVersion::hasPerIterationScopeLoopVar) != GoSdkUtil.FeatureSupported.YES;
    }

    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoLoopClosureInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            GoLoopClosureInspection.$$$reportNull$$$0(2);
        }
        return new GoVisitor(){

            @Override
            public void visitFieldName(@NotNull GoFieldName o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitFieldName(o);
                this.checkReferenceElement(o);
            }

            @Override
            public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitReferenceExpression(o);
                this.checkReferenceElement(o);
            }

            private void checkReferenceElement(@NotNull GoResolvable o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                GoFunctionLit functionLit = (GoFunctionLit)PsiTreeUtil.getParentOfType((PsiElement)o, GoFunctionLit.class);
                while (functionLit != null) {
                    this.checkFunctionLiteral(o, functionLit);
                    functionLit = (GoFunctionLit)PsiTreeUtil.getParentOfType((PsiElement)functionLit, GoFunctionLit.class);
                }
            }

            private void checkFunctionLiteral(@NotNull GoResolvable o, @NotNull GoFunctionLit functionLit) {
                PsiElement call;
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (functionLit == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!((call = functionLit.getParent()) instanceof GoCallExpr)) {
                    return;
                }
                PsiElement statement = call.getParent();
                if (!(statement instanceof GoGoStatement) && !(statement instanceof GoDeferStatement)) {
                    return;
                }
                GoBlock block = (GoBlock)ObjectUtils.tryCast((Object)statement.getParent(), GoBlock.class);
                if (block == null || ContainerUtil.getLastItem(block.getStatementList()) != statement) {
                    return;
                }
                GoForStatement forStatement = (GoForStatement)ObjectUtils.tryCast((Object)block.getParent(), GoForStatement.class);
                if (forStatement == null) {
                    return;
                }
                GoNamedElement resolve2 = (GoNamedElement)ObjectUtils.tryCast((Object)o.resolve(), GoNamedElement.class);
                if (resolve2 == null) {
                    return;
                }
                String name = resolve2.getName();
                if (name == null) {
                    return;
                }
                if (this.checkRangeClause(forStatement.getRangeClause(), resolve2) || this.checkForClause(forStatement.getForClause(), resolve2)) {
                    @NlsSafe String statementName = statement instanceof GoGoStatement ? "go" : "defer";
                    holder.registerProblem((PsiElement)o, GoLoopClosureInspection.message("go.inspection.loop.closure.message", new Object[]{statementName}), new LocalQuickFix[]{new GoCreateVariableDeclarationFix(statement, name)});
                }
            }

            private boolean checkForClause(@Nullable GoForClause forClause, @NotNull GoNamedElement resolve2) {
                if (resolve2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (forClause == null) {
                    return false;
                }
                GoStatement postStatement = forClause.getPostStatement();
                if (postStatement instanceof GoAssignmentStatement) {
                    for (GoExpression expression : ((GoAssignmentStatement)postStatement).getLeftHandExprList().getExpressionList()) {
                        if (!1.checkExpression(expression, resolve2)) continue;
                        return true;
                    }
                }
                if (postStatement instanceof GoIncDecStatement) {
                    return 1.checkExpression(((GoIncDecStatement)postStatement).getExpression(), resolve2);
                }
                return false;
            }

            private static boolean checkExpression(@Nullable GoExpression expression, @NotNull GoNamedElement resolve2) {
                if (resolve2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (expression == null) {
                    return false;
                }
                return expression instanceof GoReferenceExpression && resolve2.equals(((GoReferenceExpression)expression).resolve());
            }

            private boolean checkRangeClause(@Nullable GoRangeClause rangeClause, @NotNull GoNamedElement resolve2) {
                if (resolve2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (rangeClause == null) {
                    return false;
                }
                PsiElement varAssign = rangeClause.getVarAssign();
                if (varAssign != null) {
                    if (resolve2 instanceof GoVarDefinition && rangeClause.getVarDefinitionList().contains(resolve2)) {
                        return true;
                    }
                } else {
                    for (GoExpression expression : rangeClause.getLeftExpressionsList()) {
                        if (!1.checkExpression(expression, resolve2)) continue;
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "functionLit";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resolve";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoLoopClosureInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFieldName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkReferenceElement";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkFunctionLiteral";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkForClause";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkExpression";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkRangeClause";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/goide/inspections/GoLoopClosureInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class GoCreateVariableDeclarationFix
    extends LocalQuickFixOnPsiElement {
        private final String myVariableName;

        private GoCreateVariableDeclarationFix(@NotNull PsiElement statement, @NotNull String name) {
            if (statement == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(0);
            }
            if (name == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(1);
            }
            super(statement);
            this.myVariableName = name;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(5);
            }
            if (startElement instanceof GoStatement) {
                GoStatement declaration = GoElementFactory.createShortVarDeclarationStatement(project, this.myVariableName, this.myVariableName);
                startElement.getParent().addBefore((PsiElement)declaration, startElement);
            }
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.create.intermediate.variable.declaration.fix.name", (Object[])new Object[0]);
            if (string == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.create.intermediate.variable.declaration.fix.name", (Object[])new Object[0]);
            if (string == null) {
                GoCreateVariableDeclarationFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoLoopClosureInspection$GoCreateVariableDeclarationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoLoopClosureInspection$GoCreateVariableDeclarationFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

