/*
 * Decompiled with CFR 0.152.
 */
package com.goide.inspections;

import com.goide.GoParserDefinition;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.GoBuildDirectivePostFormatProcessor;
import com.goide.highlighting.errors.GoBuildDirectiveSpecChecker;
import com.goide.i18n.GoBundle;
import com.goide.inspections.buildTag.GoBuildDirectiveOptions;
import com.goide.inspections.buildTag.GoBuildElement;
import com.goide.inspections.buildTag.GoBuildTagUtil;
import com.goide.inspections.buildTag.plusBuild.GoPlusBuildElement;
import com.goide.inspections.core.GoInspectionBase;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.sdk.GoTargetSdkVersionProvider;
import com.goide.util.GoUtil;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoBuildTagInspection
extends GoInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor buildVisitor(final @NotNull GoProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            GoBuildTagInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            GoBuildTagInspection.$$$reportNull$$$0(1);
        }
        return new GoVisitor(){

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitComment(comment);
                GoPackageClause pkg = GoBuildTagInspection.getPackage(comment);
                if (pkg == null) {
                    return;
                }
                if (GoBuildTagInspection.isBuildTagComment((PsiElement)comment)) {
                    if (GoBuildTagInspection.startsAfter(pkg, (PsiElement)comment)) {
                        GoBuildTagInspection.reportWrongLocation(comment, holder, new PlaceBeforePackageQuickFix());
                    }
                } else if (comment.getTokenType() == GoParserDefinition.Lazy.LINE_COMMENT) {
                    String commentText = StringUtil.trimLeading((String)StringUtil.trimStart((String)comment.getText(), (String)"//"));
                    int buildTagIndex = commentText.indexOf("+build");
                    if (buildTagIndex == 0) {
                        holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.inspection.problem.possible.malformed.build.comment"), new LocalQuickFix[0]);
                    } else if (buildTagIndex > 0 && GoBuildTagInspection.startsAfter((PsiElement)comment, pkg) && !GoDocumentationProvider.getUpperComments(pkg).contains(comment)) {
                        holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.inspection.problem.possible.malformed.build.comment"), new LocalQuickFix[0]);
                    }
                }
            }

            @Override
            public void visitGoFile(@NotNull GoFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitGoFile(file);
                ArrayList<PsiComment> plusBuildComments = new ArrayList<PsiComment>();
                ArrayList<PsiComment> goBuildComments = new ArrayList<PsiComment>();
                GoBuildDirectivePostFormatProcessor.collectBuildComments(file, plusBuildComments, goBuildComments);
                if (plusBuildComments.isEmpty()) {
                    return;
                }
                if (GoBuildTagInspection.reportPlusBuildCommentProblems(file, holder, plusBuildComments)) {
                    return;
                }
                GoBuildTagInspection.crossCheckBuildConstraints(file, holder, plusBuildComments, goBuildComments);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/inspections/GoBuildTagInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitGoFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void crossCheckBuildConstraints(@NotNull GoFile file, @NotNull GoProblemsHolder holder, @NotNull List<PsiComment> plusBuildComments, @NotNull List<PsiComment> goBuildComments) {
        block10: {
            block8: {
                PsiComment goBuildComment;
                block9: {
                    GoBuildElement goBuildConstraint;
                    if (file == null) {
                        GoBuildTagInspection.$$$reportNull$$$0(2);
                    }
                    if (holder == null) {
                        GoBuildTagInspection.$$$reportNull$$$0(3);
                    }
                    if (plusBuildComments == null) {
                        GoBuildTagInspection.$$$reportNull$$$0(4);
                    }
                    if (goBuildComments == null) {
                        GoBuildTagInspection.$$$reportNull$$$0(5);
                    }
                    GoBuildElement goBuildElement = goBuildConstraint = (goBuildComment = (PsiComment)ContainerUtil.getOnlyItem(goBuildComments)) != null ? GoBuildTagUtil.parseGoBuildElement((PsiElement)goBuildComment) : null;
                    if (goBuildConstraint == null) break block8;
                    if (!GoBuildDirectiveSpecChecker.areEquivalent(goBuildConstraint, plusBuildComments)) break block9;
                    if (!GoBuildTagInspection.isRemovePlusBuildComments(file)) break block10;
                    for (PsiComment comment : plusBuildComments) {
                        holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.error.go.plus.build.can.be.removed"), ProblemHighlightType.WEAK_WARNING, new RemovePlusBuildCommentsQuickFix());
                    }
                    break block10;
                }
                GoSdk sdk = GoSdkService.getInstance(file.getProject()).getSdk(GoUtil.module((PsiElement)file));
                GoBuildDirectiveOptions options = sdk.getGoBuildDirectiveOptions();
                if (!options.isReportSemanticErrors()) break block10;
                GoBuildDirectiveSpecChecker.UpdatePlusBuildCommentsFix fix = new GoBuildDirectiveSpecChecker.UpdatePlusBuildCommentsFix(goBuildComment);
                for (PsiComment comment : plusBuildComments) {
                    holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.error.go.build.and.plus.build.lines.dont.match"), ProblemHighlightType.WARNING, new LocalQuickFix[]{fix});
                }
                break block10;
            }
            if (goBuildComments.isEmpty() && GoBuildTagInspection.isRemovePlusBuildComments(file)) {
                for (PsiComment comment : plusBuildComments) {
                    holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.error.go.plus.build.can.be.converted.to.go.build"), ProblemHighlightType.WEAK_WARNING, new ConvertPlusBuildCommentToGoBuildDirective());
                }
            }
        }
    }

    @Override
    protected boolean isEnabledOnFile(@NotNull GoFile file) {
        if (file == null) {
            GoBuildTagInspection.$$$reportNull$$$0(6);
        }
        return ApplicationManager.getApplication().isUnitTestMode() || super.isEnabledOnFile(file);
    }

    public static boolean isBuildTagComment(@NotNull PsiElement o) {
        if (o == null) {
            GoBuildTagInspection.$$$reportNull$$$0(7);
        }
        return o instanceof PsiComment && GoPsiUtil.isBuildTagComment(StringUtil.trimStart((String)o.getText(), (String)"//"));
    }

    @Nullable
    private static GoPackageClause getPackage(@NotNull PsiComment comment) {
        PsiFile file;
        if (comment == null) {
            GoBuildTagInspection.$$$reportNull$$$0(8);
        }
        return (file = comment.getContainingFile()) instanceof GoFile ? ((GoFile)file).getPackage() : null;
    }

    private static boolean startsAfter(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            GoBuildTagInspection.$$$reportNull$$$0(9);
        }
        if (element2 == null) {
            GoBuildTagInspection.$$$reportNull$$$0(10);
        }
        return element2.getTextRange().getStartOffset() > element1.getTextRange().getStartOffset();
    }

    private static boolean reportPlusBuildCommentProblems(@NotNull GoFile file, @NotNull GoProblemsHolder holder, @NotNull List<PsiComment> plusBuildComments) {
        if (file == null) {
            GoBuildTagInspection.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            GoBuildTagInspection.$$$reportNull$$$0(12);
        }
        if (plusBuildComments == null) {
            GoBuildTagInspection.$$$reportNull$$$0(13);
        }
        boolean result = false;
        List<PsiComment> buildFlagElements = file.getBuildFlagElements();
        for (PsiComment comment : plusBuildComments) {
            if (!buildFlagElements.contains(comment)) {
                GoBuildTagInspection.reportWrongLocation(comment, holder, new GoAddNewLineQuickFix());
                result = true;
                continue;
            }
            GoPlusBuildElement plusBuildRoot = GoBuildTagUtil.parsePlusBuildElement((PsiElement)comment);
            if (plusBuildRoot != null && !GoBuildTagInspection.reportEmptyTags(plusBuildRoot, comment, holder)) continue;
            result = true;
        }
        return result;
    }

    private static void reportWrongLocation(@NotNull PsiComment comment, @NotNull GoProblemsHolder holder, @NotNull LocalQuickFix quickFix) {
        if (comment == null) {
            GoBuildTagInspection.$$$reportNull$$$0(14);
        }
        if (holder == null) {
            GoBuildTagInspection.$$$reportNull$$$0(15);
        }
        if (quickFix == null) {
            GoBuildTagInspection.$$$reportNull$$$0(16);
        }
        holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.inspection.problem.wrong.location.of.build.comment"), quickFix);
    }

    private static boolean reportEmptyTags(@NotNull GoPlusBuildElement root, PsiComment comment, @NotNull GoProblemsHolder holder) {
        if (root == null) {
            GoBuildTagInspection.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            GoBuildTagInspection.$$$reportNull$$$0(18);
        }
        if (GoBuildTagUtil.hasEmptyTags(root)) {
            holder.registerProblem((PsiElement)comment, GoBuildTagInspection.message("go.inspection.problem.go.plus.build.empty.tag"), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
            return true;
        }
        return false;
    }

    public static void deleteCommentAndNextWhitespace(@NotNull PsiElement comment) {
        PsiElement next;
        if (comment == null) {
            GoBuildTagInspection.$$$reportNull$$$0(19);
        }
        if ((next = comment.getNextSibling()) instanceof PsiWhiteSpace) {
            String whiteSpaceText = next.getText();
            if ("\n".equals(whiteSpaceText)) {
                next.delete();
            } else if (whiteSpaceText.startsWith("\n")) {
                PsiElement whitespace = PsiParserFacade.getInstance((Project)comment.getProject()).createWhiteSpaceFromText(StringUtil.trimStart((String)next.getText(), (String)"\n"));
                next.replace(whitespace);
            }
        }
        comment.delete();
    }

    @NotNull
    private static List<PsiComment> collectPlusBuildComments(@NotNull ProblemDescriptor descriptor) {
        if (descriptor == null) {
            GoBuildTagInspection.$$$reportNull$$$0(20);
        }
        ArrayList<PsiComment> result = new ArrayList<PsiComment>();
        GoFile file = GoBuildTagInspection.getGoFile(descriptor);
        if (file != null) {
            GoBuildDirectivePostFormatProcessor.collectBuildComments(file, result, new ArrayList<PsiComment>());
        }
        ArrayList<PsiComment> arrayList = result;
        if (arrayList == null) {
            GoBuildTagInspection.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    @Nullable
    private static GoFile getGoFile(@NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (descriptor == null) {
            GoBuildTagInspection.$$$reportNull$$$0(22);
        }
        if ((element = descriptor.getPsiElement()) == null || !element.isValid()) {
            return null;
        }
        return (GoFile)((Object)ObjectUtils.tryCast((Object)element.getContainingFile(), GoFile.class));
    }

    private static boolean isRemovePlusBuildComments(@NotNull GoFile file) {
        if (file == null) {
            GoBuildTagInspection.$$$reportNull$$$0(23);
        }
        GoSdk sdk = GoSdkService.getInstance(file.getProject()).getSdk(GoUtil.module((PsiElement)file));
        GoBuildDirectiveOptions options = sdk.getGoBuildDirectiveOptions();
        GoSdkVersion targetVersion = GoTargetSdkVersionProvider.getTargetGoSdkVersion((PsiFile)file);
        return options.isRemovePlusBuildComments(targetVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plusBuildComments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goBuildComments";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/inspections/GoBuildTagInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/inspections/GoBuildTagInspection";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPlusBuildComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "crossCheckBuildConstraints";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBuildTagComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPackage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startsAfter";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportPlusBuildCommentProblems";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportWrongLocation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportEmptyTags";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteCommentAndNextWhitespace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectPlusBuildComments";
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getGoFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRemovePlusBuildComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 21 -> new IllegalStateException(string);
        };
    }

    private static class RemovePlusBuildCommentsQuickFix
    implements LocalQuickFix {
        private RemovePlusBuildCommentsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.remove.plus.build.comments", (Object[])new Object[0]);
            if (string == null) {
                RemovePlusBuildCommentsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                RemovePlusBuildCommentsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemovePlusBuildCommentsQuickFix.$$$reportNull$$$0(2);
            }
            List<PsiComment> plusBuildComments = GoBuildTagInspection.collectPlusBuildComments(descriptor);
            for (PsiComment comment : plusBuildComments) {
                comment.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoBuildTagInspection$RemovePlusBuildCommentsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoBuildTagInspection$RemovePlusBuildCommentsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ConvertPlusBuildCommentToGoBuildDirective
    implements LocalQuickFix {
        private ConvertPlusBuildCommentToGoBuildDirective() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.convert.plus.build.comments.to.go.build.directive", (Object[])new Object[0]);
            if (string == null) {
                ConvertPlusBuildCommentToGoBuildDirective.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            List<PsiComment> plusBuildComments;
            if (project == null) {
                ConvertPlusBuildCommentToGoBuildDirective.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                ConvertPlusBuildCommentToGoBuildDirective.$$$reportNull$$$0(2);
            }
            if (GoBuildDirectivePostFormatProcessor.generateGoBuildDirective(plusBuildComments = GoBuildTagInspection.collectPlusBuildComments(descriptor))) {
                for (PsiComment comment : plusBuildComments) {
                    comment.delete();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoBuildTagInspection$ConvertPlusBuildCommentToGoBuildDirective";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoBuildTagInspection$ConvertPlusBuildCommentToGoBuildDirective";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class GoAddNewLineQuickFix
    implements LocalQuickFix {
        private GoAddNewLineQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.missing.new.line.name", (Object[])new Object[0]);
            if (string == null) {
                GoAddNewLineQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement anchor;
            PsiElement element;
            if (project == null) {
                GoAddNewLineQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                GoAddNewLineQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid() || !(element instanceof PsiComment)) {
                return;
            }
            for (anchor = element.getNextSibling(); anchor != null; anchor = anchor.getNextSibling()) {
                if (anchor instanceof PsiWhiteSpace && anchor.getText().contains("\n\n")) {
                    return;
                }
                if (anchor instanceof PsiComment && !GoBuildTagInspection.isBuildTagComment(anchor) || anchor instanceof GoPackageClause) break;
            }
            if (anchor != null) {
                anchor.getParent().addBefore(GoElementFactory.createNewLine(project, 2), anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoBuildTagInspection$GoAddNewLineQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoBuildTagInspection$GoAddNewLineQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PlaceBeforePackageQuickFix
    implements LocalQuickFix {
        private PlaceBeforePackageQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.place.build.tag.before.package.name", (Object[])new Object[0]);
            if (string == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) == null || !element.isValid() || !(element instanceof PsiComment)) {
                return;
            }
            PsiFile psiFile = element.getContainingFile();
            if (!(psiFile instanceof GoFile)) {
                return;
            }
            GoFile file = (GoFile)psiFile;
            GoPackageClause pkg = file.getPackage();
            if (pkg != null) {
                PsiElement anchor = PlaceBeforePackageQuickFix.findBuildTagAnchor(pkg);
                String text = StringUtil.trimStart((String)element.getText(), (String)"//").trim();
                PsiComment comment = GoElementFactory.createLineCommentFromText(project, text);
                PsiElement added = anchor.getParent().addBefore((PsiElement)comment, anchor);
                if (!PlaceBeforePackageQuickFix.hasNewLineBetween(anchor, pkg)) {
                    added.getParent().addAfter(GoElementFactory.createNewLine(project, 2), added);
                }
                GoBuildTagInspection.deleteCommentAndNextWhitespace(element);
            }
        }

        @NotNull
        private static PsiElement findBuildTagAnchor(@NotNull GoPackageClause pkg) {
            if (pkg == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(3);
            }
            GoPackageClause result = pkg;
            for (GoPackageClause prev = pkg; !(prev == null || prev instanceof PsiComment && GoBuildTagInspection.isBuildTagComment(prev)); prev = prev.getPrevSibling()) {
                result = prev;
            }
            GoPackageClause goPackageClause = result;
            if (goPackageClause == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(4);
            }
            return goPackageClause;
        }

        private static boolean hasNewLineBetween(@NotNull PsiElement begin, @NotNull PsiElement end) {
            if (begin == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(5);
            }
            if (end == null) {
                PlaceBeforePackageQuickFix.$$$reportNull$$$0(6);
            }
            for (PsiElement next = begin; next != null; next = next.getNextSibling()) {
                if (next instanceof PsiWhiteSpace && next.getText().contains("\n\n")) {
                    return true;
                }
                if (!next.equals(end)) continue;
                return false;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/inspections/GoBuildTagInspection$PlaceBeforePackageQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pkg";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "begin";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "end";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/inspections/GoBuildTagInspection$PlaceBeforePackageQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findBuildTagAnchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findBuildTagAnchor";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNewLineBetween";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

