/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoParameters;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeArguments;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeParameter;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.expectedTypes.GoExpectedTypes;
import com.goide.psi.impl.expectedTypes.GoExpectedTypesCheckResult;
import com.goide.psi.impl.generics.GoTypeArgument;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedElement;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedFunctionType;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedSignature;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedType;
import com.goide.psi.impl.generics.instantiated.GoInstantiatedTypeFactory;
import com.goide.psi.impl.typesCompatibility.GoCannotBeNil;
import com.goide.psi.impl.typesCompatibility.GoInvalidUseOfTripleDot;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.quickfix.GoAddMissingReturnValuesQuickFix;
import com.goide.quickfix.GoChangeParametersQuickFix;
import com.goide.quickfix.GoChangeResultParametersInReturnQuickFix;
import com.goide.quickfix.GoChangeResultParametersQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTypesCompatibilityInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoTypesCompatibilityInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr o) {
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(1);
        }
        super.visitCallExpr(o);
        if (GoPsiUtil.isConversionExpression(o)) {
            return;
        }
        this.checkTypeArguments(o);
        GoArgumentList argumentList = o.getArgumentList();
        List<GoExpression> expressionList = argumentList.getExpressionList();
        boolean variadic = argumentList.isVariadic();
        int size = expressionList.size();
        for (int i = 0; i < size; ++i) {
            GoExpectedTypesCheckResult result;
            GoTypeCheckResult firstProblem;
            if (i == 1 && GoTypesCompatibilityInspection.isAppendVariadicStringToByteSlice(o)) continue;
            boolean last = i + 1 == size;
            boolean argIsVariadic = variadic && last;
            GoExpression expression = expressionList.get(i);
            GoExpectedTypes expectedTypes = GoTypeUtil.getExpectedTypes(expression);
            if (expectedTypes.areEmpty() || (firstProblem = (GoTypeCheckResult)ContainerUtil.getFirstItem((result = expectedTypes.checkCompatibleWith(expression, false, argIsVariadic, null)).getProblems())) == null) continue;
            if (firstProblem instanceof GoInvalidUseOfTripleDot) {
                SmartList fixes = new SmartList();
                new GoChangeParametersQuickFix(o).addIfAvailable((List)fixes);
                this.myHolder.registerProblem((PsiElement)expression, GoInspectionProblemUtil.message("go.inspection.problem.invalid.use.of.triple.dot"), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (firstProblem instanceof GoCannotBeNil) {
                this.myHolder.registerProblem((PsiElement)expression, GoInspectionProblemUtil.message("go.inspection.problem.nil.is.not.allowed", GoInspectionProblemUtil.code("nil"), GoTypesCompatibilityInspection.getPresentationText(expectedTypes, false, argIsVariadic)), new LocalQuickFix[0]);
                continue;
            }
            GoInspectionMessage message = GoTypesCompatibilityInspection.callArgumentErrorMessage(expression, argIsVariadic, expectedTypes);
            GoTypesCompatibilityInspection.registerProblem(this.myHolder, expression, message, result.getProblems(), !argIsVariadic);
        }
    }

    private void checkTypeArguments(@NotNull GoCallExpr call) {
        GoSignature signature;
        if (call == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(2);
        }
        if ((signature = call.resolveSignature()) == null) {
            return;
        }
        GoInstantiatedSignature instantiated2 = signature.toInstantiated();
        this.checkTypeArguments(instantiated2, (Function<GoTypeArgument, PsiElement>)((Function)arg -> GoTypesCompatibilityInspection.getInstantiationProblemTargetElement(arg, call)));
    }

    @NotNull
    private static PsiElement getInstantiationProblemTargetElement(@NotNull GoTypeArgument typeArgument, @NotNull GoCallExpr call) {
        if (typeArgument == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(3);
        }
        if (call == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(4);
        }
        PsiElement argElement = typeArgument.getOriginalElement();
        List<GoTypeArgument> explicitArguments = GoTypeInstantiationKt.getExplicitTypeArgumentElements(call);
        for (GoTypeArgument typeArg : explicitArguments) {
            if (!typeArg.getOriginalElement().equals(argElement)) continue;
            PsiElement psiElement = argElement;
            if (psiElement == null) {
                GoTypesCompatibilityInspection.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        GoExpression goExpression = call.getExpression();
        if (goExpression == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(6);
        }
        return goExpression;
    }

    private void checkTypeArguments(@Nullable GoType underlyingType, @NotNull GoTypeArguments typeArguments) {
        if (typeArguments == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(7);
        }
        if (underlyingType instanceof GoInstantiatedType) {
            GoInstantiatedType instantiatedType = (GoInstantiatedType)underlyingType;
            this.checkTypeArguments(instantiatedType, (Function<GoTypeArgument, PsiElement>)((Function)arg -> GoTypesCompatibilityInspection.getInstantiationProblemTargetElement(arg, typeArguments)));
        }
    }

    @NotNull
    private static PsiElement getInstantiationProblemTargetElement(@NotNull GoTypeArgument substitutionArg, @NotNull GoTypeArguments explicitTypeArguments) {
        if (substitutionArg == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(8);
        }
        if (explicitTypeArguments == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(9);
        }
        return GoTypesCompatibilityInspection.getInstantiationProblemTargetElement(substitutionArg, explicitTypeArguments, explicitTypeArguments.getTypes());
    }

    @NotNull
    private static PsiElement getInstantiationProblemTargetElement(@NotNull GoTypeArgument substitutionArg, @NotNull PsiElement explicitTypeArguments, @NotNull List<GoType> explicitArgs) {
        GoType typeList;
        int index;
        PsiElement argElement;
        if (substitutionArg == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(10);
        }
        if (explicitTypeArguments == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(11);
        }
        if (explicitArgs == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(12);
        }
        if (explicitArgs.contains(argElement = substitutionArg.getOriginalElement())) {
            PsiElement psiElement = argElement;
            if (psiElement == null) {
                GoTypesCompatibilityInspection.$$$reportNull$$$0(13);
            }
            return psiElement;
        }
        PsiElement parent = argElement.getParent();
        if ((parent instanceof GoTypeList || parent instanceof GoTypeArguments) && (index = GoTypeUtil.getListOfTypesFromTypeList(typeList = parent instanceof GoTypeArguments ? ((GoTypeArguments)parent).getTypeList() : (GoTypeList)parent).indexOf(argElement)) >= 0 && index < explicitArgs.size()) {
            PsiElement psiElement = explicitArgs.get(index);
            if (psiElement == null) {
                GoTypesCompatibilityInspection.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        PsiElement psiElement = explicitTypeArguments;
        if (psiElement == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    private void checkTypeArguments(@NotNull GoInstantiatedElement<?> instantiated2, @NotNull @NotNull Function<@NotNull GoTypeArgument, @NotNull PsiElement> getTargetElement) {
        if (instantiated2 == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(16);
        }
        if (getTargetElement == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(17);
        }
        instantiated2.getSubstitution().getParams().forEach((typeParamDefinition, typeArgument) -> {
            GoTypeParameter typeParameter = typeParamDefinition.getTypeParameter();
            GoType constraintType = GoPsiImplUtil.getInstantiatedConstraintType(typeParameter, instantiated2);
            if (constraintType == null) {
                return;
            }
            PsiElement instantiationContext = instantiated2.getInstantiationContext();
            GoType argumentType = GoInstantiatedTypeFactory.create(typeArgument.getType(), instantiated2.getSubstitution().getParams(), instantiationContext);
            GoTypeCheckResult result = GoTypeUtil.checkImplementsConstraint(constraintType, argumentType, instantiationContext, false);
            if (result instanceof GoTypesNotCompatible) {
                GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(argumentType, constraintType);
                PsiElement targetElement = (PsiElement)getTargetElement.fun(typeArgument);
                GoExpression expression = (GoExpression)ObjectUtils.tryCast((Object)targetElement, GoExpression.class);
                GoTypeCheckingUtil.registerProblem(this.myHolder, targetElement, expression, message, constraintType, result);
            }
        });
    }

    @Override
    public void visitForStatement(@NotNull GoForStatement o) {
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(18);
        }
        super.visitForStatement(o);
        GoExpression expression = o.getExpression();
        if (expression != null) {
            this.checkCondition(expression);
        } else {
            GoForClause clause = o.getForClause();
            if (clause != null) {
                this.checkCondition(clause.getExpression());
            }
        }
    }

    @Override
    public void visitIfStatement(@NotNull GoIfStatement o) {
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(19);
        }
        super.visitIfStatement(o);
        GoExpression expression = o.getExpression();
        if (expression != null) {
            this.checkCondition(expression);
        } else {
            GoSimpleStatement statement = (GoSimpleStatement)ObjectUtils.tryCast((Object)o.getStatement(), GoSimpleStatement.class);
            if (statement != null) {
                List<Object> expressions;
                GoLeftHandExprList leftHandExprList = statement.getLeftHandExprList();
                List<Object> list = expressions = leftHandExprList != null ? leftHandExprList.getExpressionList() : Collections.emptyList();
                if (expressions.size() == 1 && statement.getExpression() == null && statement.getStatement() == null) {
                    this.checkCondition((GoExpression)ContainerUtil.getFirstItem(expressions));
                }
            }
        }
    }

    @Override
    public void visitRangeClause(@NotNull GoRangeClause o) {
        GoType type2;
        GoType underlyingType;
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(20);
        }
        super.visitRangeClause(o);
        GoExpression expression = o.getRangeExpression();
        if (expression == null) {
            return;
        }
        PsiElement context = GoReferenceBase.getSubstitutionContextOrSelf(expression);
        GoExpectedTypes expectedTypes = GoTypeUtil.getExpectedTypes(expression);
        GoExpectedTypesCheckResult typeCheckResult = expectedTypes.checkCompatibleWith(expression, false, false, GoPsiImplUtil.createContextOnElement(context));
        if (!typeCheckResult.getProblems().isEmpty()) {
            String presentationText = GoTypeCheckingUtil.getPresentationText(expression);
            GoInspectionMessage message = GoInspectionProblemUtil.message("go.inspection.problem.cannot.range", presentationText);
            GoTypesCompatibilityInspection.registerProblem(this.myHolder, expression, message, typeCheckResult.getProblems(), false);
        }
        GoType goType = underlyingType = (type2 = expression.getGoType(null)) != null ? type2.getUnderlyingType(expression) : null;
        if (underlyingType instanceof GoChannelType && ((GoChannelType)underlyingType).getDirection() == GoPsiImplUtil.ChannelDirection.SEND) {
            String presentationText = type2.getPresentationText();
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.from.send.only.type", o.getText(), presentationText), new LocalQuickFix[0]);
        }
    }

    @Override
    public void visitExprSwitchStatement(@NotNull GoExprSwitchStatement switchStatement) {
        if (switchStatement == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(21);
        }
        super.visitExprSwitchStatement(switchStatement);
        GoExpression switchExpr = switchStatement.getCondition();
        String switchExprText = switchExpr != null ? switchExpr.getText() : "true";
        List<GoExprCaseClause> clauses = switchStatement.getExprCaseClauseList();
        GoExpression firstCaseExpression = Optional.of(clauses).map(ContainerUtil::getFirstItem).map(GoExprCaseClause::getExpressionList).map(ContainerUtil::getFirstItem).orElse(null);
        if (firstCaseExpression == null) {
            return;
        }
        GoExpectedTypes expectedTypes = GoTypeUtil.getExpectedTypes(firstCaseExpression);
        if (expectedTypes.areEmpty()) {
            return;
        }
        GoType type2 = firstCaseExpression.getGoType(null);
        boolean needFullPath = ContainerUtil.or(expectedTypes.asList(), expected -> GoTypeCheckingUtil.haveSamePresentation(type2, expected.getType()));
        String expectedTypesText = GoTypesCompatibilityInspection.getPresentationText(expectedTypes, needFullPath, false);
        for (GoExprCaseClause caseClause : clauses) {
            for (GoExpression expr : caseClause.getExpressionList()) {
                GoExpectedTypesCheckResult result = expectedTypes.checkCompatibleWith(expr, false, false, null);
                if (result.getProblems().isEmpty()) continue;
                GoInspectionMessage message = GoTypesCompatibilityInspection.expressionSwitchErrorMessage(switchExprText, expr, expectedTypesText, needFullPath);
                GoTypesCompatibilityInspection.registerProblem(this.myHolder, expr, message, result.getProblems(), true);
            }
        }
    }

    @Override
    public void visitReturnStatement(@NotNull GoReturnStatement o) {
        boolean fromTypeList;
        GoSignatureOwner signatureOwner;
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(22);
        }
        if ((signatureOwner = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)o, GoSignatureOwner.class)) == null) {
            return;
        }
        GoType resultType = signatureOwner.getResultType();
        List<GoType> resultTypes = GoTypeUtil.getListOfTypesFromTypeList(resultType);
        int resultTypesCount = resultTypes.size();
        List<GoExpression> expressions = o.getExpressionList();
        List<GoType> expressionTypes = GoTypeUtil.getTypesOfExpressions(expressions);
        int expressionTypesCount = expressionTypes.size();
        boolean bl = fromTypeList = expressionTypesCount != expressions.size();
        if (!(expressionTypesCount == resultTypesCount || GoTypesCompatibilityInspection.hasNamedParametersInResult(signatureOwner) && expressionTypesCount == 0)) {
            boolean tooMany = expressionTypesCount > resultTypesCount;
            SmartList fixes = new SmartList();
            if (!tooMany) {
                if (expressionTypesCount == 1 && expressionTypes.get(0) == null && expressions.get(0) instanceof GoCallExpr) {
                    return;
                }
                fixes.add(new GoAddMissingReturnValuesQuickFix());
            }
            new GoChangeResultParametersQuickFix(o).addIfAvailable((List)fixes);
            new GoChangeResultParametersInReturnQuickFix(o).addIfAvailable((List)fixes);
            this.myHolder.registerProblem((PsiElement)o, tooMany ? GoInspectionProblemUtil.message("go.inspection.problem.too.many.arguments.to.return") : GoInspectionProblemUtil.message("go.inspection.problem.not.enough.arguments.to.return"), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            return;
        }
        for (int i = 0; i < expressionTypesCount; ++i) {
            GoTypeCheckResult result;
            GoExpression expression = expressions.get(fromTypeList ? 0 : i);
            GoType expressionType = expressionTypes.get(i);
            GoType resType = resultTypes.get(i);
            GoTypeCheckResult goTypeCheckResult = result = expressionType != null ? GoTypeUtil.checkAssignable(resType, expression, expressionType, false) : null;
            if (!(result instanceof GoTypesNotCompatible)) continue;
            GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(expression, expressionType, resType, result);
            GoTypeCheckingUtil.registerProblem(this.myHolder, expression, message, resType, result);
        }
    }

    @Override
    public void visitExpression(@NotNull GoExpression expression) {
        GoType expectedType;
        if (expression == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(23);
        }
        if ((expectedType = (GoType)ObjectUtils.doIfCast((Object)expression.getParent(), GoCodeFragment.class, GoCodeFragment::getExpectedType)) == null) {
            return;
        }
        GoType expressionType = expression.getGoType(null);
        if (expressionType == null) {
            return;
        }
        if (GoTypesCompatibilityInspection.isCompatibleWithExpectedTypes(expression)) {
            return;
        }
        this.myHolder.registerProblem((PsiElement)expression, GoTypeCheckingUtil.commonErrorDescription(expression, expressionType, expectedType, null), new LocalQuickFix[0]);
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(24);
        }
        super.visitIndexOrSliceExpr(o);
        PsiElement typeArgument = GoPsiUtil.getTypeArgument(o);
        if (typeArgument instanceof GoType) {
            GoType type2 = (GoType)typeArgument;
            this.checkTypeArguments(o, (Function<GoTypeArgument, PsiElement>)((Function)arg -> GoTypesCompatibilityInspection.getInstantiationProblemTargetElement(arg, typeArgument, GoTypeUtil.getListOfTypesFromTypeList(type2))));
        } else if (typeArgument != null) {
            this.checkTypeArguments(o, (Function<GoTypeArgument, PsiElement>)((Function)arg -> typeArgument));
        }
    }

    @Override
    public void visitTypeArguments(@NotNull GoTypeArguments typeArguments) {
        if (typeArguments == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(25);
        }
        super.visitTypeArguments(typeArguments);
        if (PsiTreeUtil.getParentOfType((PsiElement)typeArguments, GoReceiver.class) != null) {
            return;
        }
        PsiElement parent = typeArguments.getParent();
        if (parent instanceof GoType) {
            GoType type2 = (GoType)parent;
            this.checkTypeArguments(type2.getUnderlyingType(parent), typeArguments);
        } else if (parent instanceof GoCompositeLit) {
            GoCompositeLit compositeLit = (GoCompositeLit)parent;
            this.checkTypeArguments(compositeLit, (Function<GoTypeArgument, PsiElement>)((Function)arg -> GoTypesCompatibilityInspection.getInstantiationProblemTargetElement(arg, typeArguments)));
        }
    }

    private void checkTypeArguments(@NotNull GoExpression expression, @NotNull @NotNull Function<@NotNull GoTypeArgument, @NotNull PsiElement> getTargetElement) {
        PsiElement resolved;
        ResolveState state;
        GoType goType;
        if (expression == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(26);
        }
        if (getTargetElement == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(27);
        }
        if ((goType = expression.getGoType(state = GoPsiImplUtil.createContextOnElement(expression))) == null) {
            return;
        }
        if (goType instanceof GoInstantiatedFunctionType) {
            GoInstantiatedFunctionType funcType = (GoInstantiatedFunctionType)goType;
            if (!(expression.getParent() instanceof GoCallExpr)) {
                this.checkTypeArguments(funcType, getTargetElement);
            }
        }
        if ((resolved = goType.resolve(state)) instanceof GoTypeSpec) {
            GoTypeSpec typeSpec = (GoTypeSpec)resolved;
            if (goType.getTypeArguments() == null) {
                return;
            }
            GoSpecType specType = typeSpec.getSpecType();
            GoType instantiatedSpecType = GoTypeInstantiationKt.getInstantiatedSpecType(specType, goType.toInstantiated());
            if (instantiatedSpecType instanceof GoInstantiatedType) {
                GoInstantiatedType instantiatedType = (GoInstantiatedType)instantiatedSpecType;
                this.checkTypeArguments(instantiatedType, getTargetElement);
            }
        }
    }

    private static boolean isAppendVariadicStringToByteSlice(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(28);
        }
        if (!GoPsiUtil.isBuiltinFunctionCall(callExpr, "append")) {
            return false;
        }
        GoArgumentList argumentList = callExpr.getArgumentList();
        if (argumentList.getTripleDot() == null) {
            return false;
        }
        List<GoExpression> expressionList = argumentList.getExpressionList();
        if (expressionList.size() <= 1) {
            return false;
        }
        GoExpression byteSlice = expressionList.get(0);
        GoExpression string = expressionList.get(1);
        GoType stringType = string.getGoType(null);
        if (stringType == null) {
            return true;
        }
        if (!GoTypeUtil.underlyingTypeIs(stringType, string, u -> GoTypeUtil.isString(u, string) || GoTypeUtil.isByteSliceStrict(u, string))) {
            return false;
        }
        GoType byteSliceType = (GoType)GoPsiImplUtil.withContextOnElement(byteSlice, state -> byteSlice.getGoType((ResolveState)state));
        return GoTypeUtil.isByteSliceStrict(byteSliceType, byteSlice);
    }

    private void checkCondition(@Nullable GoExpression o) {
        if (o == null) {
            return;
        }
        if (GoTypesCompatibilityInspection.isCompatibleWithExpectedTypes(o)) {
            return;
        }
        this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.non.bool.used.as.condition", GoTypeCheckingUtil.getPresentationText(o)), new LocalQuickFix[0]);
    }

    private static boolean isCompatibleWithExpectedTypes(@Nullable GoExpression expression) {
        if (expression != null && GoTypeUtil.isCType(expression.getGoType(null), expression)) {
            return true;
        }
        GoExpectedTypes expectedTypes = expression != null ? GoTypeUtil.getExpectedTypes(expression) : null;
        return expectedTypes == null || expectedTypes.areEmpty() || expectedTypes.areCompatibleWith(expression, false, false, null);
    }

    private static boolean hasNamedParametersInResult(@NotNull GoSignatureOwner o) {
        GoSignature signature;
        GoResult result;
        if (o == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(29);
        }
        GoResult goResult = result = (signature = o.getSignature()) != null ? signature.getResult() : null;
        if (result == null) {
            return false;
        }
        GoType type2 = result.getType();
        if (type2 != null) {
            return false;
        }
        GoParameters parameters = result.getParameters();
        if (parameters == null) {
            return false;
        }
        return StreamEx.of(parameters.getDefinitionList()).map(NavigationItem::getName).anyMatch(StringUtil::isNotEmpty);
    }

    @NonNls
    @NotNull
    private static String getPresentationText(@NotNull GoExpectedTypes expectedTypes, boolean needFullPath, boolean isVariadic) {
        if (expectedTypes == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(30);
        }
        assert (!expectedTypes.asList().isEmpty());
        List expectedTypeTexts = ContainerUtil.map(expectedTypes.asList(), expected -> {
            GoType innerType = expected.getType();
            String presentation = innerType != null ? GoTypeCheckingUtil.getPresentationText(innerType, needFullPath) : expected.getPresentationText();
            return isVariadic && expected.isVariadic() ? "[]" + presentation : presentation;
        });
        if (expectedTypeTexts.size() == 1) {
            String string = (String)expectedTypeTexts.get(0);
            if (string == null) {
                GoTypesCompatibilityInspection.$$$reportNull$$$0(31);
            }
            return string;
        }
        List first = ContainerUtil.getFirstItems((List)expectedTypeTexts, (int)(expectedTypeTexts.size() - 1));
        String last = (String)ContainerUtil.getLastItem((List)expectedTypeTexts);
        String string = GoBundle.message((String)"go.inspection.problem.type.or.type", (Object[])new Object[]{StringUtil.join((Collection)first, (String)", "), last});
        if (string == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static GoInspectionMessage callArgumentErrorMessage(@NotNull GoExpression e, boolean isVariadic, @NotNull GoExpectedTypes expectedTypes) {
        if (e == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(33);
        }
        if (expectedTypes == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(34);
        }
        GoType type2 = e.getGoType(null);
        boolean needFullPath = ContainerUtil.or(expectedTypes.asList(), expected -> GoTypeCheckingUtil.haveSamePresentation(type2, expected.getType()));
        GoInspectionMessage goInspectionMessage = GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types", GoTypeCheckingUtil.getPresentationText(e, needFullPath), GoTypesCompatibilityInspection.getPresentationText(expectedTypes, needFullPath, isVariadic));
        if (goInspectionMessage == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(35);
        }
        return goInspectionMessage;
    }

    @NotNull
    private static GoInspectionMessage expressionSwitchErrorMessage(@NotNull String switchExprText, @NotNull GoExpression caseExpr, @NotNull String expectedTypesText, boolean needFullPath) {
        if (switchExprText == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(36);
        }
        if (caseExpr == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(37);
        }
        if (expectedTypesText == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(38);
        }
        String actualTypeText = GoExpressionUtil.isNil(caseExpr) ? "" : Optional.of(caseExpr).map(e -> e.getGoType(null)).map(t -> GoTypeCheckingUtil.getPresentationText(t, needFullPath)).orElse("");
        String details = !StringUtil.isEmpty((String)actualTypeText) && !StringUtil.isEmpty((String)expectedTypesText) ? GoBundle.message((String)"go.inspection.problem.mismatched.types", (Object[])new Object[]{GoInspectionProblemUtil.code(actualTypeText), GoInspectionProblemUtil.code(expectedTypesText)}) : "";
        GoInspectionMessage goInspectionMessage = StringUtil.isEmpty((String)switchExprText) ? GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types.in.switch", GoInspectionProblemUtil.code(caseExpr), details) : GoInspectionProblemUtil.message("go.inspection.problem.incompatible.types.in.switch.on.expression", GoInspectionProblemUtil.code(caseExpr), GoInspectionProblemUtil.code(switchExprText), details);
        if (goInspectionMessage == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(39);
        }
        return goInspectionMessage;
    }

    private static void registerProblem(@NotNull GoProblemsHolder holder, @NotNull GoExpression expression, @NotNull GoInspectionMessage message, @NotNull List<? extends GoTypeCheckResult> problems, boolean suggestConversion) {
        if (holder == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(40);
        }
        if (expression == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(41);
        }
        if (message == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(42);
        }
        if (problems == null) {
            GoTypesCompatibilityInspection.$$$reportNull$$$0(43);
        }
        GoInspectionMessage fullMessage = GoTypeCheckingUtil.getMessageWithAdditionalInfo(message, problems);
        List<@NotNull LocalQuickFix> fixes = GoTypeCheckingUtil.additionalFixes(expression, problems, suggestConversion);
        holder.registerProblem((PsiElement)expression, fullMessage, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 13, 14, 15, 31, 32, 35, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgument";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 31: 
            case 32: 
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoTypesCompatibilityInspection";
                break;
            }
            case 7: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutionArg";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitTypeArguments";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitArgs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiated";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getTargetElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 23: 
            case 26: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchExprText";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseExpr";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypesText";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoTypesCompatibilityInspection";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstantiationProblemTargetElement";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationText";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "callArgumentErrorMessage";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "expressionSwitchErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitCallExpr";
                break;
            }
            case 2: 
            case 7: 
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeArguments";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInstantiationProblemTargetElement";
                break;
            }
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 31: 
            case 32: 
            case 35: 
            case 39: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitRangeClause";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitExprSwitchStatement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitIndexOrSliceExpr";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeArguments";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isAppendVariadicStringToByteSlice";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasNamedParametersInResult";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "callArgumentErrorMessage";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "expressionSwitchErrorMessage";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 13, 14, 15, 31, 32, 35, 39 -> new IllegalStateException(string);
        };
    }
}

