/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoType;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoConvertStringToByteQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoStringAndByteTypeMismatchInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoStringAndByteTypeMismatchInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoStringAndByteTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitConditionalExpr(@NotNull GoConditionalExpr o) {
        if (o == null) {
            GoStringAndByteTypeMismatchInspection.$$$reportNull$$$0(1);
        }
        List<GoExpression> list = o.getExpressionList();
        GoIndexOrSliceExpr indexExpr = (GoIndexOrSliceExpr)ContainerUtil.findInstance(list, GoIndexOrSliceExpr.class);
        GoStringLiteral stringLiteral = (GoStringLiteral)ContainerUtil.findInstance(list, GoStringLiteral.class);
        if (indexExpr == null || stringLiteral == null) {
            return;
        }
        if (GoStringAndByteTypeMismatchInspection.isStringIndexExpression(indexExpr)) {
            LocalQuickFix[] fixes = GoPsiImplUtil.isSingleCharLiteral(stringLiteral) ? GoInspectionProblemUtil.fixes(new GoConvertStringToByteQuickFix()) : null;
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.mismatched.types.byte.and.string"), fixes);
        }
    }

    private static boolean isStringIndexExpression(@NotNull GoIndexOrSliceExpr indexOrSliceExpr) {
        GoExpression expression;
        if (indexOrSliceExpr == null) {
            GoStringAndByteTypeMismatchInspection.$$$reportNull$$$0(2);
        }
        GoType type2 = (expression = indexOrSliceExpr.getExpression()) != null ? expression.getGoType(null) : null;
        return GoTypeUtil.isString(type2, expression) && indexOrSliceExpr.isIndexExpression();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexOrSliceExpr";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoStringAndByteTypeMismatchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringIndexExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

