/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoQualifierOwner;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoReplaceExpressionQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoExplicitDereferenceRequiredInspection
extends GoVisitor {
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoExplicitDereferenceRequiredInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoExplicitDereferenceRequiredInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoExplicitDereferenceRequiredInspection.$$$reportNull$$$0(1);
        }
        super.visitCallExpr(callExpr);
        GoReferenceExpression ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)callExpr.getExpression(), GoReferenceExpression.class);
        if (ref == null || ref.resolve() == null) {
            return;
        }
        GoQualifier qualifier = ref.getQualifier();
        if (qualifier == null) {
            return;
        }
        this.checkQualifierIsDoublePointer(callExpr, ref, qualifier);
    }

    @Override
    public void visitReferenceExpression(@NotNull GoReferenceExpression ref) {
        if (ref == null) {
            GoExplicitDereferenceRequiredInspection.$$$reportNull$$$0(2);
        }
        super.visitReferenceExpression(ref);
        if (ref.getParent() instanceof GoCallExpr || ref.resolve() == null) {
            return;
        }
        GoQualifier qualifier = ref.getQualifier();
        if (qualifier == null || GoPsiUtil.isMethodExpressionQualifier(qualifier)) {
            return;
        }
        this.checkQualifierIsDoublePointer(ref, ref, qualifier);
    }

    private void checkQualifierIsDoublePointer(@NotNull PsiElement reportElement, @NotNull GoReferenceExpression ref, @NotNull GoQualifier qualifier) {
        GoType goType;
        if (reportElement == null) {
            GoExplicitDereferenceRequiredInspection.$$$reportNull$$$0(3);
        }
        if (ref == null) {
            GoExplicitDereferenceRequiredInspection.$$$reportNull$$$0(4);
        }
        if (qualifier == null) {
            GoExplicitDereferenceRequiredInspection.$$$reportNull$$$0(5);
        }
        if (qualifier instanceof GoTypeOwner) {
            GoTypeOwner e = (GoTypeOwner)((Object)qualifier);
            goType = e.getGoType(null);
        } else {
            goType = null;
        }
        GoType type2 = goType;
        GoType unwrapped = GoExplicitDereferenceRequiredInspection.unwrapPointer(GoExplicitDereferenceRequiredInspection.unwrapPointer(type2, qualifier), qualifier);
        if (unwrapped != null && GoExplicitDereferenceRequiredInspection.unwrapPointer(unwrapped, qualifier) == null) {
            GoInspectionMessage message = reportElement instanceof GoCallExpr ? GoInspectionProblemUtil.message("go.inspection.explicit.dereference.calling.method.with.receiver.message", GoInspectionProblemUtil.code(ref.getIdentifier()), GoInspectionProblemUtil.code(qualifier), GoInspectionProblemUtil.code("**" + unwrapped.getText())) : GoInspectionProblemUtil.message("go.inspection.explicit.dereference.accessing.field.message", GoInspectionProblemUtil.code(ref.getIdentifier()), GoInspectionProblemUtil.code(qualifier), GoInspectionProblemUtil.code("**" + unwrapped.getText()));
            this.myHolder.registerProblem(reportElement, message, new GoDereferenceQualifierQuickFix(qualifier));
        }
    }

    @Nullable
    private static GoType unwrapPointer(@Nullable GoType type2, @Nullable PsiElement context) {
        GoType underlyingType = type2 != null ? type2.getUnderlyingType(context) : null;
        return underlyingType instanceof GoPointerType ? ((GoPointerType)underlyingType).getType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoExplicitDereferenceRequiredInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkQualifierIsDoublePointer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class GoDereferenceQualifierQuickFix
    extends GoReplaceExpressionQuickFix {
        public GoDereferenceQualifierQuickFix(@NotNull GoQualifier qualifier) {
            if (qualifier == null) {
                GoDereferenceQualifierQuickFix.$$$reportNull$$$0(0);
            }
            super("(*" + qualifier.getText() + ")");
        }

        @Override
        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = GoBundle.message((String)"go.fix.add.explicit.dereference.name", (Object[])new Object[0]);
            if (string == null) {
                GoDereferenceQualifierQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        protected PsiElement getElementToReplace(@Nullable PsiElement sourceElement) {
            GoCallExpr callExpr;
            GoExpression goExpression;
            if (sourceElement instanceof GoReferenceExpression) {
                GoReferenceExpression ref = (GoReferenceExpression)sourceElement;
                return ref.getQualifier();
            }
            if (sourceElement instanceof GoCallExpr && (goExpression = (callExpr = (GoCallExpr)sourceElement).getExpression()) instanceof GoQualifierOwner) {
                GoQualifierOwner owner = (GoQualifierOwner)((Object)goExpression);
                return owner.getQualifier();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/legacyErrorInspections/GoExplicitDereferenceRequiredInspection$GoDereferenceQualifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoExplicitDereferenceRequiredInspection$GoDereferenceQualifierQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

