/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.legacyErrorInspections;

import com.goide.GoTypes;
import com.goide.highlighting.legacyErrorInspections.GoInvalidExpressionConversionInspection;
import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionProblemUtil;
import com.goide.inspections.core.GoProblemsHolder;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIncDecStatement;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoCType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.typesCompatibility.GoTypeCheckResult;
import com.goide.psi.impl.typesCompatibility.GoTypesCompatible;
import com.goide.psi.impl.typesCompatibility.GoTypesNotCompatible;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.Complex;
import com.goide.util.Value;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoBinaryAndUnaryExpressionTypesCompatibilityInspection
extends GoVisitor {
    private static final TokenSet MUL_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.MUL, GoTypes.MUL_ASSIGN, GoTypes.QUOTIENT, GoTypes.QUOTIENT_ASSIGN});
    private static final TokenSet SHIFT_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.SHIFT_LEFT, GoTypes.SHIFT_LEFT_ASSIGN, GoTypes.SHIFT_RIGHT, GoTypes.SHIFT_RIGHT_ASSIGN});
    private static final TokenSet BOOL_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.COND_OR, GoTypes.COND_AND});
    private static final TokenSet PLUS_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.PLUS, GoTypes.PLUS_ASSIGN});
    private static final TokenSet MINUS_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.MINUS, GoTypes.MINUS_ASSIGN});
    private static final TokenSet COMPARE_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.EQ, GoTypes.NOT_EQ});
    private static final TokenSet ORDERED_COMPARE_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.LESS, GoTypes.LESS_OR_EQUAL, GoTypes.GREATER, GoTypes.GREATER_OR_EQUAL});
    private static final TokenSet INTEGER_OP = TokenSet.create((IElementType[])new IElementType[]{GoTypes.BIT_OR, GoTypes.BIT_OR_ASSIGN, GoTypes.BIT_XOR, GoTypes.BIT_XOR_ASSIGN, GoTypes.BIT_CLEAR, GoTypes.BIT_CLEAR_ASSIGN, GoTypes.REMAINDER, GoTypes.REMAINDER_ASSIGN, GoTypes.BIT_AND, GoTypes.BIT_AND_ASSIGN});
    @NotNull
    private final GoProblemsHolder myHolder;

    public GoBinaryAndUnaryExpressionTypesCompatibilityInspection(@NotNull GoProblemsHolder holder) {
        if (holder == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitUnaryExpr(@NotNull GoUnaryExpr o) {
        GoType coreType;
        PsiElement operator;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(1);
        }
        if ((operator = o.getOperator()) == null) {
            return;
        }
        GoExpression expression = o.getExpression();
        GoType type2 = expression != null ? expression.getGoType(null) : null;
        GoType goType = coreType = type2 != null ? GoTypeUtil.getCoreType(type2, expression) : null;
        if (type2 == null || coreType instanceof GoCType) {
            return;
        }
        IElementType operatorType = operator.getNode().getElementType();
        if (coreType != null && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToUnaryExpressionType(operatorType, coreType, o)) {
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.invalid.unary.operation", operator.getText() + " " + type2.getPresentationText()), new LocalQuickFix[0]);
        } else if (operatorType == GoTypes.ARROW) {
            if (coreType instanceof GoChannelType) {
                GoChannelType channelType = (GoChannelType)coreType;
                if (channelType.getDirection() == GoPsiImplUtil.ChannelDirection.SEND) {
                    this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.from.send.only.type", o.getText(), type2.getPresentationText()), new LocalQuickFix[0]);
                }
            } else if (coreType != null) {
                this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.from.non.chan.type", o.getText(), type2.getPresentationText()), new LocalQuickFix[0]);
            } else {
                this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.receive.no.core.type", o.getText(), expression.getText(), type2.getText()), new LocalQuickFix[0]);
            }
        }
    }

    @Override
    public void visitBinaryExpr(@NotNull GoBinaryExpr o) {
        PsiElement operator;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(2);
        }
        if ((operator = o.getOperator()) != null) {
            this.checkTypesCompatibility(o.getLeft(), o.getRight(), operator, o);
        }
    }

    @Override
    public void visitVarOrConstSpec(@NotNull GoVarOrConstSpec o) {
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(3);
        }
        if (o.getType() == null) {
            return;
        }
        GoVarOrConstSpec spec = o;
        this.checkTypesCompatibility(spec.getDefinitionList(), spec.getExpressionList(), true);
    }

    @Override
    public void visitShortVarDeclaration(@NotNull GoShortVarDeclaration o) {
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(4);
        }
        this.checkTypesCompatibility(o.getVarDefinitionList(), o.getExpressionList(), false);
    }

    @Override
    public void visitAssignmentStatement(@NotNull GoAssignmentStatement o) {
        PsiElement operator;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(5);
        }
        if ((operator = o.getAssignOp().getOperator()) == null) {
            return;
        }
        if (operator.getNode().getElementType() == GoTypes.ASSIGN) {
            this.checkTypesCompatibility(o.getLeftHandExprList().getExpressionList(), o.getExpressionList(), false);
        } else {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.processAssignments(o.getLeftHandExprList().getExpressionList(), o.getExpressionList(), (Consumer<? super AssignmentInfo>)((Consumer)assignmentInfo -> this.checkTypesCompatibility(assignmentInfo.left, assignmentInfo.right, operator, o)), false);
        }
    }

    @Override
    public void visitSendStatement(@NotNull GoSendStatement o) {
        GoExpression channelExpression;
        GoType type2;
        GoType underlyingType;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(6);
        }
        GoType goType = underlyingType = (type2 = (channelExpression = o.getChannelExpression()).getGoType(null)) != null ? GoTypeUtil.getCoreType(type2, channelExpression) : null;
        if (underlyingType instanceof GoChannelType) {
            this.checkSendExpressionType(o, (GoChannelType)underlyingType);
        } else if (type2 != null) {
            this.myHolder.registerProblem((PsiElement)o, GoInspectionProblemUtil.message("go.inspection.problem.send.to.non.chan.type", o.getText(), type2.getPresentationText()), new LocalQuickFix[0]);
        }
    }

    private void checkSendExpressionType(@NotNull GoSendStatement sendStatement, @NotNull GoChannelType channelType) {
        GoTypeCheckResult result;
        if (sendStatement == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(7);
        }
        if (channelType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(8);
        }
        if (channelType.getDirection() == GoPsiImplUtil.ChannelDirection.RECEIVE) {
            this.myHolder.registerProblem((PsiElement)sendStatement, GoInspectionProblemUtil.message("go.inspection.problem.send.to.receive.only.type", sendStatement.getText(), channelType.getPresentationText()), new LocalQuickFix[0]);
            return;
        }
        GoType expectedType = channelType.getType();
        GoExpression sendExpression = sendStatement.getSendExpression();
        if (sendExpression == null) {
            return;
        }
        GoTypeCheckResult goTypeCheckResult = result = expectedType != null ? GoTypeUtil.checkAssignable(expectedType, sendExpression, false) : null;
        if (result instanceof GoTypesNotCompatible) {
            GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(sendExpression, expectedType, result);
            GoTypeCheckingUtil.registerProblem(this.myHolder, sendExpression, message, expectedType, result);
        }
    }

    @Override
    public void visitIncDecStatement(@NotNull GoIncDecStatement o) {
        GoExpression expression;
        GoType type2;
        GoType underlyingType;
        if (o == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(9);
        }
        GoType goType = underlyingType = (type2 = (expression = o.getExpression()).getGoType(null)) != null ? type2.getUnderlyingType(expression) : null;
        if (underlyingType != null && !(underlyingType instanceof GoCType) && !GoTypeUtil.isNumericType(underlyingType, expression)) {
            this.myHolder.registerProblem((PsiElement)expression, GoInspectionProblemUtil.message("go.inspection.problem.invalid.inc.dec.operation", o.getText(), type2.getPresentationText()), new LocalQuickFix[0]);
        }
    }

    private void checkTypesCompatibility(@NotNull List<? extends GoTypeOwner> leftElements, @NotNull List<GoExpression> rightElements, boolean skipBlank) {
        if (leftElements == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(10);
        }
        if (rightElements == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(11);
        }
        GoBinaryAndUnaryExpressionTypesCompatibilityInspection.processAssignments(leftElements, rightElements, (Consumer<? super AssignmentInfo>)((Consumer)assignmentInfo -> {
            GoType leftType = assignmentInfo.left.getGoType(null);
            GoType rightType = assignmentInfo.rightType;
            if (leftType == null || rightType == null) {
                return;
            }
            GoTypeCheckResult result = GoTypeUtil.checkAssignable(leftType, assignmentInfo.right, rightType, false);
            if (result instanceof GoTypesCompatible) {
                return;
            }
            if (assignmentInfo.multipleAssignment) {
                String leftText = GoBundle.message((String)"go.inspection.problem.expression.with.type", (Object[])new Object[]{assignmentInfo.left.getText(), leftType.getPresentationText()});
                GoInspectionMessage message = GoInspectionProblemUtil.message("go.inspection.problem.cannot.assign.in.multiple.assignment", rightType.getPresentationText(), leftText);
                GoTypeCheckingUtil.registerProblem(this.myHolder, assignmentInfo.right, message, leftType, result);
            } else {
                GoInspectionMessage message = GoTypeCheckingUtil.commonErrorDescription(assignmentInfo.right, rightType, leftType, result);
                GoTypeCheckingUtil.registerProblem(this.myHolder, assignmentInfo.right, message, leftType, result);
            }
        }), skipBlank);
    }

    private void checkTypesCompatibility(@NotNull GoTypeOwner left, @Nullable GoExpression right, @NotNull PsiElement operator, @NotNull PsiElement elementToReport) {
        GoType rightUnderlyingType;
        GoType leftType;
        GoType leftUnderlyingType;
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(12);
        }
        if (operator == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(13);
        }
        if (elementToReport == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(14);
        }
        GoType goType = leftUnderlyingType = (leftType = left.getGoType(null)) != null ? leftType.getUnderlyingType(left) : null;
        if (leftUnderlyingType instanceof GoCType) {
            return;
        }
        GoType rightType = right != null ? right.getGoType(null) : null;
        GoType goType2 = rightUnderlyingType = rightType != null ? rightType.getUnderlyingType(right) : null;
        if (rightUnderlyingType instanceof GoCType) {
            return;
        }
        if (!this.processNil(left, right, operator)) {
            return;
        }
        IElementType operatorType = operator.getNode().getElementType();
        if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isTypesMismatch(leftType, leftUnderlyingType, rightType, rightUnderlyingType, operatorType, left)) {
            this.myHolder.registerProblem(elementToReport, GoInspectionProblemUtil.message("go.inspection.problem.invalid.operation.mismatched.types", elementToReport.getText(), leftType.getPresentationText(), rightType.getPresentationText()), new LocalQuickFix[0]);
            return;
        }
        if (rightUnderlyingType != null && leftUnderlyingType != null && !SHIFT_OP.contains(operatorType)) {
            if (GoTypeUtil.isUntypedNumericType(leftUnderlyingType) && GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isTypedNumericType(rightUnderlyingType, left) && left instanceof GoExpression) {
                if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.canBeConverted((GoExpression)left, leftUnderlyingType, rightUnderlyingType)) {
                    leftUnderlyingType = rightUnderlyingType;
                } else {
                    this.registerConstantConvertProblem(elementToReport, left, rightUnderlyingType);
                    return;
                }
            }
            if (GoTypeUtil.isUntypedNumericType(rightUnderlyingType) && GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isTypedNumericType(leftUnderlyingType, left)) {
                if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.canBeConverted(right, rightUnderlyingType, leftUnderlyingType)) {
                    rightUnderlyingType = leftUnderlyingType;
                } else {
                    this.registerConstantConvertProblem(elementToReport, right, leftUnderlyingType);
                    return;
                }
            }
        }
        if (rightType != null) {
            if (SHIFT_OP.contains(operatorType)) {
                GoInspectionMessage message = GoBinaryAndUnaryExpressionTypesCompatibilityInspection.getInvalidShiftCountError(rightType, rightUnderlyingType, right, elementToReport);
                if (message != null) {
                    this.myHolder.registerProblem(elementToReport, message, new LocalQuickFix[0]);
                    return;
                }
            } else if (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToType(operatorType, rightType, rightUnderlyingType, right)) {
                @NlsSafe String presentationText = rightType.getPresentationText();
                this.registerOperatorNotDefined(elementToReport, operator, presentationText);
                return;
            }
        }
        if (leftType != null && left instanceof GoExpression && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToLeftOperand(operatorType, leftType, leftUnderlyingType, (GoExpression)left)) {
            @NlsSafe String presentationText = leftType.getPresentationText();
            this.registerOperatorNotDefined(elementToReport, operator, presentationText);
        }
    }

    private boolean processNil(@NotNull GoTypeOwner left, @Nullable GoExpression right, @NotNull PsiElement operator) {
        boolean bothNil;
        GoType type2;
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(15);
        }
        if (operator == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(16);
        }
        GoExpression l = left instanceof GoExpression ? ((GoExpression)left).unwrapParentheses() : null;
        GoExpression r = GoPsiImplUtil.unwrapParentheses(right);
        boolean leftNil = GoExpressionUtil.isNil(l);
        boolean rightNil = GoExpressionUtil.isNil(r);
        if (!leftNil && !rightNil) {
            return true;
        }
        GoExpression typeOwner = leftNil ? r : l;
        GoExpression nil = leftNil ? l : r;
        GoType goType = type2 = typeOwner != null ? typeOwner.getGoType(null) : null;
        if (type2 == null) {
            return false;
        }
        ASTNode operatorNode = operator.getNode();
        IElementType operatorType = operatorNode != null ? operatorNode.getElementType() : null;
        boolean bl = bothNil = leftNil && rightNil;
        if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isCompareOp(operatorType)) {
            if (!bothNil && !GoTypeUtil.isAllowedComparingToNil(type2, typeOwner)) {
                this.registerCannotConvertNilToType(nil, type2);
            } else if (ORDERED_COMPARE_OP.contains(operatorType)) {
                @NlsSafe String presentationText = type2.getPresentationText();
                this.registerOperatorNotDefined(typeOwner, operator, presentationText);
            }
        } else if (!bothNil) {
            this.registerCannotConvertNilToType(nil, type2);
        } else {
            this.registerOperatorNotDefined(l, operator, "nil");
        }
        return false;
    }

    private void registerCannotConvertNilToType(@NotNull GoTypeOwner typeOwner, @NotNull GoType type2) {
        if (typeOwner == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(17);
        }
        if (type2 == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(18);
        }
        this.myHolder.registerProblem((PsiElement)typeOwner, GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.nil.to.type", GoInspectionProblemUtil.code("nil"), GoInspectionProblemUtil.code(type2.getPresentationText())), new LocalQuickFix[0]);
    }

    private void registerOperatorNotDefined(@NotNull PsiElement element, @NotNull PsiElement operator, @Nls @NotNull String typeText) {
        if (element == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(19);
        }
        if (operator == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(20);
        }
        if (typeText == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(21);
        }
        this.myHolder.registerProblem(element, GoInspectionProblemUtil.message("go.inspection.problem.operator.not.defined", element.getText(), operator.getText(), typeText), new LocalQuickFix[0]);
    }

    private static boolean isTypesMismatch(@Nullable GoType leftType, @Nullable GoType leftUnderlyingType, @Nullable GoType rightType, @Nullable GoType rightUnderlyingType, @NotNull IElementType operatorType, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(22);
        }
        return leftType != null && rightType != null && leftUnderlyingType != null && rightUnderlyingType != null && !SHIFT_OP.contains(operatorType) && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedNumericAndNumeric(leftUnderlyingType, rightUnderlyingType, context) && !GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedStringAndString(leftUnderlyingType, rightUnderlyingType, context) && !GoTypeUtil.identical(leftType, rightType, false, context) && (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isCompareOp(operatorType) && !BOOL_OP.contains(operatorType) || !GoTypeUtil.isAssignable(leftType, null, rightType, context, false) && !GoTypeUtil.isAssignable(rightType, null, leftType, context, false));
    }

    private static boolean isUntypedStringAndString(@NotNull GoType left, @NotNull GoType right, @Nullable PsiElement context) {
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(23);
        }
        if (right == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(24);
        }
        return left instanceof GoLightType.LightUntypedStringType && GoTypeUtil.isString(right, context) || right instanceof GoLightType.LightUntypedStringType && GoTypeUtil.isString(left, context);
    }

    private static boolean isUntypedNumericAndNumeric(@NotNull GoType left, @NotNull GoType right, @Nullable PsiElement context) {
        if (left == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(25);
        }
        if (right == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(26);
        }
        return left instanceof GoLightType.LightUntypedNumericType && GoTypeUtil.isNumericType(right, context) || right instanceof GoLightType.LightUntypedNumericType && GoTypeUtil.isNumericType(left, context);
    }

    private static boolean isCompareOp(IElementType operatorType) {
        return COMPARE_OP.contains(operatorType) || ORDERED_COMPARE_OP.contains(operatorType);
    }

    private static void processAssignments(@NotNull List<? extends GoTypeOwner> leftElements, @NotNull List<GoExpression> rightExpressions, @NotNull Consumer<? super AssignmentInfo> consumer, boolean skipBlank) {
        GoExpression firstExpression;
        if (leftElements == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(27);
        }
        if (rightExpressions == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(29);
        }
        List<GoType> rightTypes = (firstExpression = (GoExpression)ContainerUtil.getFirstItem(rightExpressions)) != null && rightExpressions.size() == 1 && GoExpressionUtil.hasSecondBoolValueWhichCanBeOmitted(firstExpression) ? Arrays.asList(firstExpression.getGoType(null), GoLightType.getBoolType(firstExpression)) : GoTypeUtil.getTypesOfExpressions(rightExpressions);
        boolean isMultipleAssignment = rightExpressions.size() != rightTypes.size();
        int count2 = Math.min(leftElements.size(), rightTypes.size());
        for (int i = 0; i < count2; ++i) {
            GoTypeOwner left = leftElements.get(i);
            if (!skipBlank && left instanceof GoNamedElement && ((GoNamedElement)left).isBlank()) continue;
            GoExpression right = rightExpressions.get(isMultipleAssignment ? 0 : i);
            consumer.consume((Object)new AssignmentInfo(left, right, rightTypes.get(i), isMultipleAssignment));
        }
    }

    private static boolean isOperatorApplicableToUnaryExpressionType(@NotNull IElementType operatorType, @NotNull GoType unaryExpressionType, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(30);
        }
        if (unaryExpressionType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(31);
        }
        if (operatorType == GoTypes.MINUS || operatorType == GoTypes.PLUS) {
            return GoTypeUtil.isNumericType(unaryExpressionType, context);
        }
        if (operatorType == GoTypes.NOT) {
            return GoTypeUtil.isBoolean(unaryExpressionType, context);
        }
        if (operatorType == GoTypes.BIT_XOR) {
            return GoTypeUtil.isIntegerType(unaryExpressionType, context) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedIntegerOrCType(unaryExpressionType, context);
        }
        return true;
    }

    private static boolean isOperatorApplicableToLeftOperand(@NotNull IElementType operatorType, @NotNull GoType leftOperandType, @NotNull GoType leftOperandUnderlyingType, @NotNull GoExpression leftExpression) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(32);
        }
        if (leftOperandType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(33);
        }
        if (leftOperandUnderlyingType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(34);
        }
        if (leftExpression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(35);
        }
        if (SHIFT_OP.contains(operatorType)) {
            return GoTypeUtil.isIntegerType(leftOperandUnderlyingType, leftExpression) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedIntegerOrCType(leftOperandUnderlyingType, leftExpression) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.hasUntypedIntegerValue(leftExpression, leftOperandUnderlyingType, true);
        }
        return GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isOperatorApplicableToType(operatorType, leftOperandType, leftOperandUnderlyingType, leftExpression);
    }

    @Nullable
    private static GoInspectionMessage getInvalidShiftCountError(@NotNull GoType type2, @NotNull GoType underlyingType, @NotNull GoExpression expression, @NotNull PsiElement elementToReport) {
        if (type2 == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(36);
        }
        if (underlyingType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(37);
        }
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(38);
        }
        if (elementToReport == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(39);
        }
        if (underlyingType instanceof GoCType) {
            return null;
        }
        boolean isConstant = GoTypeUtil.isUntypedNumericType(underlyingType);
        if (isConstant) {
            if (GoBinaryAndUnaryExpressionTypesCompatibilityInspection.hasUntypedIntegerValue(expression, underlyingType, false)) {
                return null;
            }
            if (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.supportsSignedShift(expression)) {
                return GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.unsigned.integer", elementToReport.getText(), type2.getPresentationText());
            }
            return !GoTypeUtil.isIntegerType(underlyingType, expression) ? GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.integer", elementToReport.getText(), type2.getPresentationText()) : GoInspectionProblemUtil.message("go.inspection.problem.negative.shift.count", elementToReport.getText());
        }
        if (!GoBinaryAndUnaryExpressionTypesCompatibilityInspection.supportsSignedShift(expression)) {
            return !GoTypeUtil.isUintType(underlyingType, expression) ? GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.unsigned.integer", elementToReport.getText(), type2.getPresentationText()) : null;
        }
        return !GoTypeUtil.isIntegerType(underlyingType, expression) ? GoInspectionProblemUtil.message("go.inspection.problem.shift.count.must.be.integer", elementToReport.getText(), type2.getPresentationText()) : null;
    }

    private static boolean supportsSignedShift(@NotNull GoExpression expression) {
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(40);
        }
        return GoSdkUtil.featureSupported(expression, false, GoSdkVersion::supportsSignedShift) == GoSdkUtil.FeatureSupported.YES;
    }

    private static boolean isOperatorApplicableToType(@NotNull IElementType operatorType, @NotNull GoType operandType, @NotNull GoType operandUnderlyingType, @Nullable PsiElement context) {
        if (operatorType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(41);
        }
        if (operandType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(42);
        }
        if (operandUnderlyingType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(43);
        }
        if (MINUS_OP.contains(operatorType) || MUL_OP.contains(operatorType)) {
            return GoTypeUtil.isNumericType(operandUnderlyingType, context);
        }
        if (BOOL_OP.contains(operatorType)) {
            return GoTypeUtil.isBoolean(operandUnderlyingType, context);
        }
        if (INTEGER_OP.contains(operatorType)) {
            return GoTypeUtil.isIntegerType(operandUnderlyingType, context) || GoBinaryAndUnaryExpressionTypesCompatibilityInspection.isUntypedIntegerOrCType(operandUnderlyingType, context);
        }
        if (PLUS_OP.contains(operatorType)) {
            return GoTypeUtil.isPlusable(operandUnderlyingType, context);
        }
        if (COMPARE_OP.contains(operatorType)) {
            return GoTypeUtil.isComparable(operandType, context, false);
        }
        if (ORDERED_COMPARE_OP.contains(operatorType)) {
            return GoTypeUtil.isOrderedComparable(operandUnderlyingType, context);
        }
        return true;
    }

    private void registerConstantConvertProblem(@NotNull PsiElement element, @NotNull PsiElement constant, @NotNull GoType type2) {
        if (element == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(44);
        }
        if (constant == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(45);
        }
        if (type2 == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(46);
        }
        this.myHolder.registerProblem(element, GoInspectionProblemUtil.message("go.inspection.problem.cannot.convert.constant", element.getText(), constant.getText(), type2.getText()), new LocalQuickFix[0]);
    }

    private static boolean hasUntypedIntegerValue(@NotNull GoExpression expression, @NotNull GoType type2, boolean signed) {
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(47);
        }
        if (type2 == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(48);
        }
        if (!GoTypeUtil.isUntypedNumericType(type2)) {
            return false;
        }
        Value value = expression.getValue();
        if (value == null) {
            return true;
        }
        if (GoTypeUtil.isIntegerType(type2, expression)) {
            Long intValue = value.getInteger();
            return intValue != null && (signed || intValue >= 0L);
        }
        if (GoTypeUtil.isComplexType(type2, expression)) {
            Complex complex = value.getComplex();
            return complex != null && complex.im() == 0.0 && complex.re() == Math.floor(complex.re()) && (signed || complex.re() >= 0.0);
        }
        if (GoTypeUtil.isFloatType(type2, expression)) {
            Double doubleValue = value.getDouble();
            return doubleValue != null && doubleValue == Math.floor(doubleValue) && (signed || doubleValue >= 0.0);
        }
        return false;
    }

    private static boolean canBeConverted(@NotNull GoExpression expression, @NotNull GoType constExprType, @NotNull GoType targetType) {
        if (expression == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(49);
        }
        if (constExprType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(50);
        }
        if (targetType == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(51);
        }
        return GoInvalidExpressionConversionInspection.isValidConstExpressionConversion(expression, constExprType, targetType, false) != ThreeState.NO;
    }

    private static boolean isUntypedIntegerOrCType(@Nullable GoType type2, @Nullable PsiElement context) {
        return GoTypeUtil.isUntypedIntegerType(type2) || GoTypeUtil.isCType(type2, context);
    }

    private static boolean isTypedNumericType(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoBinaryAndUnaryExpressionTypesCompatibilityInspection.$$$reportNull$$$0(52);
        }
        return GoTypeUtil.isNumericType(type2, context) && !GoTypeUtil.isUntypedNumericType(type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sendStatement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channelType";
                break;
            }
            case 10: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightElements";
                break;
            }
            case 12: 
            case 15: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 14: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeOwner";
                break;
            }
            case 18: 
            case 36: 
            case 46: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeText";
                break;
            }
            case 22: 
            case 30: 
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operatorType";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightExpressions";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unaryExpressionType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperandType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperandUnderlyingType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 38: 
            case 40: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operandUnderlyingType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constExprType";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/legacyErrorInspections/GoBinaryAndUnaryExpressionTypesCompatibilityInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVarOrConstSpec";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitShortVarDeclaration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSendStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkSendExpressionType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIncDecStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypesCompatibility";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "processNil";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "registerCannotConvertNilToType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "registerOperatorNotDefined";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypesMismatch";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isUntypedStringAndString";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "isUntypedNumericAndNumeric";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorApplicableToUnaryExpressionType";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorApplicableToLeftOperand";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "getInvalidShiftCountError";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsSignedShift";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorApplicableToType";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConstantConvertProblem";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUntypedIntegerValue";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeConverted";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypedNumericType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class AssignmentInfo {
        final boolean multipleAssignment;
        final GoTypeOwner left;
        final GoExpression right;
        final GoType rightType;

        AssignmentInfo(@NotNull GoTypeOwner left, @NotNull GoExpression right, @Nullable GoType rightType, boolean multipleAssignment) {
            if (left == null) {
                AssignmentInfo.$$$reportNull$$$0(0);
            }
            if (right == null) {
                AssignmentInfo.$$$reportNull$$$0(1);
            }
            this.multipleAssignment = multipleAssignment;
            this.left = left;
            this.right = right;
            this.rightType = rightType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "left";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "right";
                    break;
                }
            }
            objectArray[1] = "com/goide/highlighting/legacyErrorInspections/GoBinaryAndUnaryExpressionTypesCompatibilityInspection$AssignmentInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

