/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.exitpoint;

import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBlock;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoRecursiveVisitor;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoType;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoReturnParametersHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    @NotNull
    private final PsiElement myTarget;
    @NotNull
    private final GoSignatureOwner mySignatureOwner;
    @Nullable
    private final PsiElement myParameter;
    private final int myIndex;

    private GoReturnParametersHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull GoSignatureOwner signatureOwner, @NotNull PsiElement target) {
        if (editor == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(1);
        }
        if (signatureOwner == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(2);
        }
        if (target == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(3);
        }
        super(editor, file);
        this.mySignatureOwner = signatureOwner;
        this.myTarget = target;
        this.myIndex = this.getIndex();
        this.myParameter = this.getParameter();
    }

    private PsiElement getParameter() {
        if (this.myTarget instanceof GoType || this.myTarget instanceof GoParamDefinition) {
            return this.myTarget;
        }
        if (this.myIndex == -1) {
            return null;
        }
        GoResult result = this.mySignatureOwner.getResult();
        if (result == null) {
            return null;
        }
        GoType type2 = result.getType();
        if (type2 != null) {
            return this.myIndex == 0 ? type2 : null;
        }
        GoParameters parameters = result.getParameters();
        if (parameters == null) {
            return null;
        }
        type2 = parameters.getTypeByIndex(this.myIndex);
        if (type2 != null) {
            return type2;
        }
        return parameters.getDefinitionByIndex(this.myIndex);
    }

    @Nullable
    public static GoReturnParametersHandler createForElement(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        PsiElement element;
        if (editor == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(5);
        }
        if (target == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(6);
        }
        if ((element = GoReturnParametersHandler.getResultParameterOrReturnedExpression(target)) == null || !GoReturnParametersHandler.isResultParameter(element) && !(element.getParent() instanceof GoReturnStatement)) {
            return null;
        }
        SyntaxTraverser.Api api = GoPsiTreeUtil.goTraverser().api;
        if (api.parents((Object)target).takeWhile(p -> p != element).filter(e -> e instanceof GoBlock || e instanceof GoResult || e instanceof GoParameters || e instanceof GoArgumentList || e instanceof GoLiteralValue).first() != null) {
            return null;
        }
        GoSignatureOwner signatureOwner = (GoSignatureOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GoSignatureOwner.class);
        GoBlock block = signatureOwner != null ? signatureOwner.getBlockIfExists() : null;
        return block != null ? new GoReturnParametersHandler(editor, file, signatureOwner, element) : null;
    }

    @Nullable
    private static PsiElement getResultParameterOrReturnedExpression(@NotNull PsiElement element) {
        PsiElement targetElement;
        if (element == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(7);
        }
        if ((targetElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GoReturnStatement.class, GoResult.class})) instanceof GoReturnStatement) {
            PsiElement expression = PsiTreeUtil.findPrevParent((PsiElement)targetElement, (PsiElement)element);
            return expression instanceof GoExpression ? expression : null;
        }
        return GoReturnParametersHandler.getElementFromSignatureResult(element);
    }

    @Nullable
    private static PsiElement getElementFromSignatureResult(@NotNull PsiElement element) {
        GoResult result;
        if (element == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(8);
        }
        if ((result = (GoResult)PsiTreeUtil.getParentOfType((PsiElement)element, GoResult.class)) == null) {
            return null;
        }
        GoParamDefinition definition = (GoParamDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, GoParamDefinition.class);
        if (definition != null) {
            return definition;
        }
        GoParameterDeclaration declaration = (GoParameterDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, GoParameterDeclaration.class);
        if (declaration != null) {
            return PsiTreeUtil.findPrevParent((PsiElement)declaration, (PsiElement)element);
        }
        PsiElement prevParent = PsiTreeUtil.findPrevParent((PsiElement)result, (PsiElement)element);
        if (prevParent instanceof GoType) {
            return prevParent;
        }
        return null;
    }

    private static boolean isResultParameter(@Nullable PsiElement target) {
        return target != null && GoReturnParametersHandler.isParameter(target) && PsiTreeUtil.getParentOfType((PsiElement)target, GoResult.class) != null;
    }

    private static boolean isParameter(@NotNull PsiElement target) {
        if (target == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(9);
        }
        PsiElement parent = target.getParent();
        return target instanceof GoParamDefinition || target instanceof GoType && (parent instanceof GoResult || GoReturnParametersHandler.isDeclarationWithoutDefinitions(parent));
    }

    private static boolean isDeclarationWithoutDefinitions(PsiElement parent) {
        return parent instanceof GoParameterDeclaration && ((GoParameterDeclaration)parent).getParamDefinitionList().isEmpty();
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Collections.singletonList(this.myTarget);
        if (list == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(11);
        }
        if (selectionConsumer == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(12);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        if (targets == null) {
            GoReturnParametersHandler.$$$reportNull$$$0(13);
        }
        if (this.myParameter != null) {
            this.addOccurrence(this.myParameter);
        }
        if (this.myParameter != null) {
            this.addOccurrence(this.myParameter);
        }
        GoBlock block = this.mySignatureOwner.getBlockIfExists();
        if (this.myIndex == -1 || block == null) {
            return;
        }
        block.accept(new GoRecursiveVisitor(){

            @Override
            public void visitReturnStatement(@NotNull GoReturnStatement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitReturnStatement(o);
                List<GoExpression> expressions = o.getExpressionList();
                int size = expressions.size();
                if (GoReturnParametersHandler.this.myIndex < size) {
                    GoReturnParametersHandler.this.addOccurrence(expressions.get(GoReturnParametersHandler.this.myIndex));
                    return;
                }
                if (size == 1) {
                    GoReturnParametersHandler.this.addOccurrence(expressions.get(0));
                }
            }

            @Override
            public void visitNamedSignatureOwner(@NotNull GoNamedSignatureOwner o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            @Override
            public void visitFunctionLit(@NotNull GoFunctionLit o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "o";
                objectArray2[1] = "com/goide/highlighting/exitpoint/GoReturnParametersHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNamedSignatureOwner";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFunctionLit";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private int getIndex() {
        if (this.myTarget instanceof GoExpression) {
            PsiElement parent = this.myTarget.getParent();
            return parent instanceof GoReturnStatement ? ((GoReturnStatement)parent).getExpressionList().indexOf(this.myTarget) : -1;
        }
        return this.getIndexFromResultParameters();
    }

    private int getIndexFromResultParameters() {
        GoType type2;
        GoResult result = this.mySignatureOwner.getResult();
        if (result == null) {
            return -1;
        }
        if (this.myTarget instanceof GoType && (type2 = result.getType()) == this.myTarget) {
            return 0;
        }
        GoParameters parameters = result.getParameters();
        if (parameters == null) {
            return -1;
        }
        if (this.myTarget instanceof GoType) {
            return parameters.getIndexOfType((GoType)this.myTarget);
        }
        if (this.myTarget instanceof GoParamDefinition) {
            return parameters.getIndexOfDefinition((GoParamDefinition)this.myTarget);
        }
        return -1;
    }

    public boolean highlightReferences() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatureOwner";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/exitpoint/GoReturnParametersHandler";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/exitpoint/GoReturnParametersHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createForElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResultParameterOrReturnedExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromSignatureResult";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

