/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.GoTypes;
import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoShortVariableDeclarationSpecChecker;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCommCase;
import com.goide.psi.GoCommClause;
import com.goide.psi.GoExpression;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoSelectStatementSpecChecker
extends GoSpecCheckerBase {
    public GoSelectStatementSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoSelectStatementSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitSelectStatement(@NotNull GoSelectStatement selectStatement) {
        if (selectStatement == null) {
            GoSelectStatementSpecChecker.$$$reportNull$$$0(1);
        }
        SmartList defaultCaseClauses = new SmartList();
        for (GoCommClause commClause : selectStatement.getCommClauseList()) {
            if (commClause.getDefault() != null) {
                defaultCaseClauses.add(commClause);
                continue;
            }
            GoCommCase commCase = commClause.getCommCase();
            GoRecvStatement recvStatement = commCase != null ? commCase.getRecvStatement() : null;
            if (recvStatement == null) continue;
            this.checkReceiveStatement(recvStatement);
        }
        if (defaultCaseClauses.size() > 1) {
            GoSpecCheckerUtil.reportMultipleDefaults("select", (List<GoCaseClause>)defaultCaseClauses, this.myHolder);
        }
    }

    private void checkReceiveStatement(@NotNull GoRecvStatement receiveStatement) {
        if (receiveStatement == null) {
            GoSelectStatementSpecChecker.$$$reportNull$$$0(2);
        }
        if (!this.checkReceiveExpression(receiveStatement)) {
            return;
        }
        if (receiveStatement.getVarAssign() != null) {
            GoShortVariableDeclarationSpecChecker.checkVarSpec(receiveStatement, receiveStatement.getVarDefinitionList(), receiveStatement.getRightExpressionsList(), this.myHolder);
        } else if (receiveStatement.getAssign() != null) {
            List<GoExpression> left = receiveStatement.getLeftExpressionsList();
            if (!GoSpecCheckerUtil.checkLeftHandSideOfAssignment(left, this.myHolder)) {
                return;
            }
            GoSpecCheckerUtil.checkAssignmentCountMismatch(receiveStatement, left, receiveStatement.getRightExpressionsList(), this.myHolder);
        }
    }

    private boolean checkReceiveExpression(@NotNull GoRecvStatement receiveStatement) {
        IElementType elementType;
        GoExpression receiveExpression;
        if (receiveStatement == null) {
            GoSelectStatementSpecChecker.$$$reportNull$$$0(3);
        }
        if ((receiveExpression = GoPsiImplUtil.unwrapParentheses(receiveStatement.getRecvExpression())) == null) {
            return true;
        }
        GoUnaryExpr unaryExpr = (GoUnaryExpr)ObjectUtils.tryCast((Object)receiveExpression, GoUnaryExpr.class);
        PsiElement operator = unaryExpr != null ? unaryExpr.getOperator() : null;
        IElementType iElementType = elementType = operator != null ? operator.getNode().getElementType() : null;
        if (!GoTypes.ARROW.equals(elementType)) {
            GoInspectionMessageWithI18n message = receiveStatement.getAssign() != null || receiveStatement.getVarAssign() != null ? GoInspectionMessageWithI18n.message("go.error.annotator.invalid.select.assignment") : GoInspectionMessageWithI18n.message("go.error.annotator.invalid.select.case");
            this.myHolder.newErrorAnnotation(receiveExpression, (GoInspectionMessage)message).create();
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectStatement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiveStatement";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoSelectStatementSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSelectStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReceiveStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReceiveExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

