/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.GoAnnotationHolderAdapter;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.legacyErrorInspections.GoDuplicateInspection;
import com.goide.highlighting.legacyErrorInspections.GoRecursiveTypeInspection;
import com.goide.highlighting.legacyErrorInspections.GoTypeCheckingUtil;
import com.goide.inspections.GoDuplicatesSearch;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.generics.GoTypeSet;
import com.goide.psi.impl.generics.GoTypeSetKt;
import com.goide.quickfix.GoDeleteQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoInterfaceTypeSpecChecker
extends GoSpecCheckerBase {
    private static final int CONSTRAINT_ELEMENT_DISPLAY_LIMIT = 3;

    public GoInterfaceTypeSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitInterfaceType(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(1);
        }
        this.checkMethods(interfaceType);
        GoDuplicateInspection.processDuplicates(interfaceType, new GoDuplicatesSearch.InterfaceScopeSearch(), new GoAnnotationHolderAdapter(this.myHolder));
        if (!GoInterfaceTypeSpecChecker.isTypeConstraintAllowedHere(interfaceType)) {
            this.checkIsNotConstraint(interfaceType, interfaceType);
        }
    }

    private void checkMethods(@NotNull GoInterfaceType interfaceType) {
        if (interfaceType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(2);
        }
        for (GoMethodSpec method : interfaceType.getMethodSpecList()) {
            GoSignature signature;
            GoTypeParameters typeParams;
            GoInspectionMessageWithI18n message;
            GoTypeReferenceExpression embedded = method.getTypeReferenceExpression();
            if (embedded != null) {
                if (!(embedded.resolve() instanceof GoTypeParamDefinition)) continue;
                message = GoInspectionMessageWithI18n.message("go.error.annotator.cannot.embed.type.parameter");
                this.myHolder.newErrorAnnotation(embedded, (GoInspectionMessage)message).create();
                continue;
            }
            if (method.isBlank()) {
                message = GoInspectionMessageWithI18n.message("go.error.annotator.method.name.in.interface.cannot.be.blank");
                this.myHolder.newErrorAnnotation(Objects.requireNonNull(method.getIdentifier()), (GoInspectionMessage)message).create();
            }
            if ((typeParams = (signature = method.getSignature()) != null ? signature.getTypeParameters() : null) == null) continue;
            GoInspectionMessageWithI18n message2 = GoInspectionMessageWithI18n.message("go.error.annotator.interface.method.must.have.no.type.parameters");
            GoInterfaceTypeSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(typeParams, (GoInspectionMessage)message2), GoDeleteQuickFix.Fixes.DELETE_TYPE_PARAMETERS_FIX, typeParams, message2).create();
        }
    }

    @Override
    public void visitTypeSpec(@NotNull GoTypeSpec interfaceTypeSpec) {
        GoType type2;
        if (interfaceTypeSpec == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(3);
        }
        if ((type2 = interfaceTypeSpec.getSpecType().getType()) instanceof GoInterfaceType) {
            GoRecursiveTypeInspection.checkHasRecursiveReference(interfaceTypeSpec, new GoAnnotationHolderAdapter(this.myHolder));
        }
    }

    @Override
    public void visitTypeReferenceExpression(@NotNull GoTypeReferenceExpression ref) {
        if (ref == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(4);
        }
        super.visitTypeReferenceExpression(ref);
        this.checkIsNotConstraint(ref);
    }

    @Override
    public void visitIndexOrSliceExpr(@NotNull GoIndexOrSliceExpr o) {
        if (o == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(5);
        }
        super.visitIndexOrSliceExpr(o);
        PsiElement typeArgument = GoPsiUtil.getTypeArgument(o);
        if (typeArgument instanceof GoReferenceExpression) {
            this.checkIsNotConstraint((GoReferenceExpression)typeArgument);
        }
    }

    private void checkIsNotConstraint(@NotNull GoResolvable ref) {
        ResolveState state;
        GoType underlyingType;
        PsiElement parent;
        if (ref == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(6);
        }
        if ((parent = ref.getParent()) instanceof GoMethodSpec || parent instanceof GoType && GoInterfaceTypeSpecChecker.isTypeConstraintAllowedHere((GoType)parent)) {
            return;
        }
        PsiElement type2 = ref.resolve();
        if (type2 instanceof GoTypeSpec && (underlyingType = ((GoTypeSpec)type2).getGoUnderlyingType(state = GoPsiImplUtil.createContextOnElement(ref))) != null) {
            this.checkIsNotConstraint(ref, underlyingType);
        }
    }

    private void checkIsNotConstraint(@NotNull PsiElement o, @NotNull GoType underlyingType) {
        if (o == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(7);
        }
        if (underlyingType == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(8);
        }
        if (GoInterfaceTypeSpecChecker.isConstraint(underlyingType, o)) {
            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)GoInterfaceTypeSpecChecker.getConstraintUsedAsNormalInterfaceErrorMessage(underlyingType)).create();
        }
    }

    private static boolean isTypeConstraintAllowedHere(@NotNull GoType type2) {
        PsiElement parent;
        if (type2 == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(9);
        }
        return (parent = type2.getParent()) instanceof GoSpecType || parent instanceof GoMethodSpec || parent instanceof GoConstraintTerm || GoTypeUtil.isTypeParameter(type2, type2);
    }

    @NotNull
    private static GoInspectionMessageWithI18n getConstraintUsedAsNormalInterfaceErrorMessage(@NotNull GoType type2) {
        GoTypeSet typeSet;
        if (type2 == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(10);
        }
        if ((typeSet = GoTypeSetKt.computeTypeSet(type2, ResolveState.initial())) == GoTypeSet.Comparable.INSTANCE) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.comparable.outside.of.type.parameter");
            if (goInspectionMessageWithI18n == null) {
                GoInterfaceTypeSpecChecker.$$$reportNull$$$0(11);
            }
            return goInspectionMessageWithI18n;
        }
        if (!(typeSet instanceof GoTypeSet.Terms)) {
            GoInspectionMessageWithI18n goInspectionMessageWithI18n = GoInspectionMessageWithI18n.message("go.error.annotator.constraint.outside.of.type.parameter");
            if (goInspectionMessageWithI18n == null) {
                GoInterfaceTypeSpecChecker.$$$reportNull$$$0(12);
            }
            return goInspectionMessageWithI18n;
        }
        GoTypeSet.Terms terms = (GoTypeSet.Terms)typeSet;
        List constraintElements = StreamEx.of(terms.getTerms()).map(term -> (StubBasedPsiElement)ObjectUtils.chooseNotNull((Object)term.getConstraintTerm(), (Object)term.getTypeReferenceExpression())).nonNull().toImmutableList();
        GoInspectionMessageWithI18n goInspectionMessageWithI18n = constraintElements.isEmpty() ? GoInspectionMessageWithI18n.message("go.error.annotator.constraint.outside.of.type.parameter") : GoInspectionMessageWithI18n.message("go.error.annotator.constraint.elements.outside.of.type.parameter", constraintElements.size(), GoTypeCheckingUtil.joinShortened(constraintElements, GoSpecCheckerBase::code, ", ", 3));
        if (goInspectionMessageWithI18n == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(13);
        }
        return goInspectionMessageWithI18n;
    }

    private static boolean isConstraint(@NotNull GoType type2, @Nullable PsiElement context) {
        if (type2 == null) {
            GoInterfaceTypeSpecChecker.$$$reportNull$$$0(14);
        }
        return GoTypeUtil.findFirstMatchedInterfaceDfs(type2, t -> !GoTypeUtil.isBasicInterface(t, context)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceTypeSpec";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/errors/GoInterfaceTypeSpecChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/errors/GoInterfaceTypeSpecChecker";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintUsedAsNormalInterfaceErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitInterfaceType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMethods";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeSpec";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeReferenceExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitIndexOrSliceExpr";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIsNotConstraint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTypeConstraintAllowedHere";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintUsedAsNormalInterfaceErrorMessage";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isConstraint";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

