/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.exitpoint.GoBreakAndContinueStatementsExitPointHandler;
import com.goide.i18n.GoBundle;
import com.goide.index.GoLinkNameIndex;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBreakStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCommClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFallthroughStatement;
import com.goide.psi.GoFile;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoGotoStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPsiTreeChangeProcessor;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtilKt;
import com.goide.psi.impl.generics.GoTypeInstantiationKt;
import com.goide.quickfix.GoAddFunctionBlockQuickFix;
import com.goide.sdk.GoSdkUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.plan9.intel.AsmIntelFileType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoFunctionDeclarationSpecChecker
extends GoSpecCheckerBase {
    public GoFunctionDeclarationSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitFunctionOrMethodDeclaration(@NotNull GoFunctionOrMethodDeclaration o) {
        if (o == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(1);
        }
        this.check(o);
    }

    @Override
    public void visitFunctionLit(@NotNull GoFunctionLit o) {
        if (o == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(2);
        }
        this.check(o);
    }

    private void check(@NotNull GoSignatureOwner o) {
        if (o == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(3);
        }
        this.checkTerminating(o.getSignature(), o.getBlockIfExists());
        if (o instanceof GoFunctionOrMethodDeclaration) {
            this.checkCanOmitBody((GoFunctionOrMethodDeclaration)o);
        }
    }

    private void checkTerminating(@Nullable GoSignature signature, @Nullable GoBlock block) {
        GoResult result;
        if (block == null) {
            return;
        }
        GoResult goResult = result = signature != null ? signature.getResult() : null;
        if (result == null || result.isVoid() || GoFunctionDeclarationSpecChecker.isTerminating(block)) {
            return;
        }
        PsiElement lastLeaf = GoPsiUtilKt.getLastNonErrorLeaf(block);
        AnnotationBuilder annotation = this.myHolder.newErrorAnnotation(lastLeaf, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.inspection.problem.missing.return"));
        if (block.getRbrace() != null && !this.myHolder.getOriginalHolder().isBatchMode()) {
            annotation = annotation.withFix((IntentionAction)new AddReturnFix(block));
        }
        annotation.create();
    }

    private static boolean isTerminating(@Nullable GoCompositeElement s) {
        if (s instanceof GoReturnStatement || s instanceof GoGotoStatement) {
            return true;
        }
        if (s instanceof GoSimpleStatement) {
            GoLeftHandExprList list = ((GoSimpleStatement)s).getLeftHandExprList();
            GoExpression expression = (GoExpression)ContainerUtil.getFirstItem(list != null ? list.getExpressionList() : null);
            return expression instanceof GoCallExpr && GoPsiImplUtil.isPanic((GoCallExpr)expression);
        }
        if (s instanceof GoBlock) {
            return GoFunctionDeclarationSpecChecker.isTerminating((GoCompositeElement)ContainerUtil.getLastItem(((GoBlock)s).getStatementList()));
        }
        if (s instanceof GoIfStatement) {
            GoBlock block = ((GoIfStatement)s).getBlock();
            GoElseStatement st = ((GoIfStatement)s).getElseStatement();
            return GoFunctionDeclarationSpecChecker.isTerminating(block) && GoFunctionDeclarationSpecChecker.isTerminating(st);
        }
        if (s instanceof GoElseStatement) {
            GoIfStatement ifStatement = ((GoElseStatement)s).getIfStatement();
            if (ifStatement != null) {
                return GoFunctionDeclarationSpecChecker.isTerminating(ifStatement);
            }
            GoBlock block = ((GoElseStatement)s).getBlock();
            return GoFunctionDeclarationSpecChecker.isTerminating(block);
        }
        if (s instanceof GoForStatement) {
            GoForStatement f = (GoForStatement)s;
            GoForClause forClause = f.getForClause();
            if (forClause != null && forClause.getExpression() != null || f.getExpression() != null || f.getRangeClause() != null) {
                return false;
            }
            GoBlock block = f.getBlock();
            return block == null || !GoFunctionDeclarationSpecChecker.hasReferringBreakStatement(f);
        }
        if (s instanceof GoExprSwitchStatement) {
            return GoFunctionDeclarationSpecChecker.isTerminating((GoExprSwitchStatement)s, ((GoExprSwitchStatement)s).getExprCaseClauseList());
        }
        if (s instanceof GoTypeSwitchStatement) {
            return GoFunctionDeclarationSpecChecker.isTerminating((GoTypeSwitchStatement)s, ((GoTypeSwitchStatement)s).getTypeCaseClauseList());
        }
        if (s instanceof GoSelectStatement) {
            GoSelectStatement selectStatement = (GoSelectStatement)s;
            for (GoCommClause clause : selectStatement.getCommClauseList()) {
                List<GoStatement> statements = clause.getStatementList();
                if (GoFunctionDeclarationSpecChecker.hasReferringBreakStatement(selectStatement)) {
                    return false;
                }
                if (GoFunctionDeclarationSpecChecker.isTerminating((GoCompositeElement)ContainerUtil.getLastItem(statements))) continue;
                return false;
            }
            return true;
        }
        if (s instanceof GoLabeledStatement) {
            GoLabeledStatement labeledStatement = (GoLabeledStatement)s;
            return GoFunctionDeclarationSpecChecker.isTerminating(labeledStatement.getStatement());
        }
        if (s instanceof GoStatement && ((GoStatement)s).getBlock() != null) {
            return GoFunctionDeclarationSpecChecker.isTerminating(((GoStatement)s).getBlock());
        }
        return false;
    }

    private static boolean isTerminating(@NotNull GoSwitchStatement switchStatement, @NotNull List<? extends GoCaseClause> clauses) {
        if (switchStatement == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(4);
        }
        if (clauses == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(5);
        }
        boolean hasDefault = false;
        for (GoCaseClause goCaseClause : clauses) {
            hasDefault |= goCaseClause.getDefault() != null;
            List<GoStatement> statements = goCaseClause.getStatementList();
            if (GoFunctionDeclarationSpecChecker.hasReferringBreakStatement(switchStatement)) {
                return false;
            }
            GoStatement last = (GoStatement)ContainerUtil.getLastItem(statements);
            if (last instanceof GoFallthroughStatement || GoFunctionDeclarationSpecChecker.isTerminating(last)) continue;
            return false;
        }
        return hasDefault;
    }

    private static boolean hasReferringBreakStatement(@NotNull PsiElement breakStatementOwner) {
        if (breakStatementOwner == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(6);
        }
        return !((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)breakStatementOwner)).traverse().filter(GoBreakStatement.class).filter(statement -> {
            PsiElement owner = GoBreakAndContinueStatementsExitPointHandler.getStatementOwnerOrResolve(statement);
            if (breakStatementOwner.equals(owner)) {
                return true;
            }
            if (owner instanceof GoLabelDefinition) {
                PsiElement parent = owner.getParent();
                return parent instanceof GoLabeledStatement && breakStatementOwner.equals(((GoLabeledStatement)parent).getStatement());
            }
            return false;
        }).isEmpty();
    }

    private void checkCanOmitBody(@NotNull GoFunctionOrMethodDeclaration o) {
        GoFile containingFile;
        PsiDirectory directory;
        if (o == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(7);
        }
        if (!((directory = (containingFile = o.getContainingFile()).getParent()) == null || GoPsiImplUtil.builtin((PsiElement)containingFile) || GoSdkUtil.isInSdk((PsiFileSystemItem)directory) || GoFunctionDeclarationSpecChecker.hasAssemblerFiles(directory).booleanValue() || o.getBlock() != null)) {
            if (GoFunctionDeclarationSpecChecker.isFunctionWithGoLinkNameDirective(o)) {
                return;
            }
            String elementDescription = UsageViewUtil.getType((PsiElement)o);
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.missing.function.body", elementDescription);
            this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message).withFix((IntentionAction)new GoAddFunctionBlockQuickFix(o)).create();
        }
    }

    private static Boolean hasAssemblerFiles(@NotNull PsiDirectory directory) {
        if (directory == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(8);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)directory, () -> {
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            for (VirtualFile file : directory.getVirtualFile().getChildren()) {
                if (!fileTypeRegistry.isFileOfType(file, (FileType)AsmIntelFileType.INSTANCE)) continue;
                return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)directory)});
            }
            return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{GoPsiTreeChangeProcessor.packageModificationTracker((PsiElement)directory)});
        });
    }

    private static boolean isFunctionWithGoLinkNameDirective(@NotNull GoFunctionOrMethodDeclaration o) {
        GoFunctionDeclaration func;
        if (o == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(9);
        }
        if ((func = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)o, GoFunctionDeclaration.class)) == null) {
            return false;
        }
        String funcName = func.getName();
        if (StringUtil.isEmpty((String)funcName)) {
            return false;
        }
        GoPackage pkg = GoPackage.of(o.getContainingFile());
        if (pkg == null) {
            return false;
        }
        return GoLinkNameIndex.getSymbolName(funcName, pkg.getScope((PsiFile)o.getContainingFile())) != null;
    }

    @Override
    public void visitReferenceExpression(@NotNull GoReferenceExpression o) {
        if (o == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(10);
        }
        super.visitReferenceExpression(o);
        this.checkGenericFunctionIsInstantiated(o);
    }

    private void checkGenericFunctionIsInstantiated(@NotNull GoResolvable reference) {
        PsiElement parent;
        if (reference == null) {
            GoFunctionDeclarationSpecChecker.$$$reportNull$$$0(11);
        }
        if ((parent = reference.getParent()) instanceof GoCallExpr && ((GoCallExpr)parent).getExpression() == reference) {
            return;
        }
        if (parent instanceof GoIndexOrSliceExpr && ((GoIndexOrSliceExpr)parent).getExpression() == reference) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (!(resolved instanceof GoFunctionDeclaration)) {
            return;
        }
        if (!GoTypeInstantiationKt.hasTypeParameters((GoNamedElement)resolved)) {
            return;
        }
        this.myHolder.newErrorAnnotation(reference, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.generic.function.without.instantiation")).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clauses";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatementOwner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoFunctionDeclarationSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunctionOrMethodDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunctionLit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isTerminating";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasReferringBreakStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCanOmitBody";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAssemblerFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionWithGoLinkNameDirective";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkGenericFunctionIsInstantiated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AddReturnFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private AddReturnFix(@NotNull GoBlock block) {
            if (block == null) {
                AddReturnFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)block);
        }

        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.fix.add.return.statement.name", (Object[])new Object[0]);
            if (string == null) {
                AddReturnFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                AddReturnFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                AddReturnFix.$$$reportNull$$$0(3);
            }
            if (file == null) {
                AddReturnFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                AddReturnFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                AddReturnFix.$$$reportNull$$$0(6);
            }
            if (!(file instanceof GoFile) || editor == null || !(startElement instanceof GoBlock)) {
                return;
            }
            PsiElement brace = ((GoBlock)startElement).getRbrace();
            if (brace == null) {
                return;
            }
            Template template = TemplateSettings.getInstance().getTemplateById("go_lang_add_return");
            if (template == null) {
                return;
            }
            int start = brace.getTextRange().getStartOffset();
            editor.getCaretModel().moveToOffset(start);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            template.setToReformat(true);
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, true, Collections.emptyMap(), null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/highlighting/errors/GoFunctionDeclarationSpecChecker$AddReturnFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/highlighting/errors/GoFunctionDeclarationSpecChecker$AddReturnFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

