/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoShortVariableDeclarationSpecChecker;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.project.GoModuleSettings;
import com.goide.psi.GoChannelType;
import com.goide.psi.GoExpression;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStatement;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoEnableRangeFuncExperimentQuickFix;
import com.goide.quickfix.GoShowSdkConfigurableFix;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoUtil;
import com.goide.vgo.mod.quickfix.VgoAddOrUpdateGoVersionFix;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class GoForStatementSpecChecker
extends GoSpecCheckerBase {
    private final boolean rangeFuncExperimentEnabled;

    public GoForStatementSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
        Module module = GoUtil.module((PsiElement)holder.getFile());
        GoModuleSettings settings = module != null ? GoModuleSettings.getInstance(module) : null;
        this.rangeFuncExperimentEnabled = settings != null && settings.getTargetSystem().supportsExperiment("rangefunc");
    }

    @Override
    public void visitForStatement(@NotNull GoForStatement forStatement) {
        GoForClause forClause;
        if (forStatement == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(1);
        }
        if ((forClause = forStatement.getForClause()) != null) {
            this.checkForClause(forClause);
            return;
        }
        GoRangeClause rangeClause = forStatement.getRangeClause();
        if (rangeClause != null) {
            this.checkRangeClause(rangeClause);
        }
    }

    private void checkForClause(@NotNull GoForClause forClause) {
        GoStatement statement;
        if (forClause == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(2);
        }
        if ((statement = forClause.getPostStatement()) != null && statement.getFirstChild() instanceof GoShortVarDeclaration) {
            this.myHolder.newErrorAnnotation(statement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.declare.in.post.statement.of.for.loop")).create();
        }
    }

    private void checkRangeClause(@NotNull GoRangeClause rangeClause) {
        GoSdkUtil.FeatureSupported supported;
        GoExpression rangeExpression;
        GoType rangeExpressionType;
        if (rangeClause == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(3);
        }
        GoType goType = rangeExpressionType = (rangeExpression = rangeClause.getRangeExpression()) != null ? rangeExpression.getGoUnderlyingType(null) : null;
        if (!GoTypeUtil.isIterable(rangeExpressionType, rangeExpression)) {
            return;
        }
        if (GoTypeUtil.isIntegerType(rangeExpressionType, null) && !this.checkRangeClauseSupported(rangeClause, supported = GoSdkUtil.featureSupported(rangeExpression, false, GoSdkVersion::supportsRangeOverInt), "go.error.annotator.needs.update.for.range.over.int")) {
            return;
        }
        if (GoTypeUtil.isIteratorType(rangeExpressionType, null)) {
            supported = GoSdkUtil.featureSupported(rangeExpression, false, GoSdkVersion::supportsRangeOverFunc);
            if (!this.checkRangeClauseSupported(rangeClause, supported, "go.error.annotator.needs.update.for.range.over.func")) {
                return;
            }
            if (!this.rangeFuncExperimentEnabled) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.needs.experiment.for.range.over.func");
                AnnotationBuilder annotationBuilder = this.myHolder.newErrorAnnotation(rangeClause, (GoInspectionMessage)message);
                GoForStatementSpecChecker.withQuickFix(annotationBuilder, new GoEnableRangeFuncExperimentQuickFix(), rangeClause, message).create();
                return;
            }
        }
        if (rangeClause.getAssign() != null) {
            List<GoExpression> assignedExpressions = rangeClause.getLeftExpressionsList();
            GoSpecCheckerUtil.checkLeftHandSideOfAssignment(assignedExpressions, this.myHolder);
            this.checkAssignmentCountMismatch(rangeClause, assignedExpressions.size(), rangeExpressionType, rangeExpression);
        } else if (rangeClause.getVarAssign() != null) {
            this.checkAssignmentCountMismatch(rangeClause, rangeClause.getDefinitionList().size(), rangeExpressionType, rangeExpression);
            GoShortVariableDeclarationSpecChecker.checkNoNewVarsInShortVarDeclaration(rangeClause, this.myHolder);
        } else {
            this.checkAssignmentCountMismatch(rangeClause, 0, rangeExpressionType, rangeExpression);
        }
    }

    private boolean checkRangeClauseSupported(@NotNull GoRangeClause rangeClause, @NotNull GoSdkUtil.FeatureSupported supported, @NotNull @PropertyKey(resourceBundle="messages.GoBundle") @NotNull @PropertyKey(resourceBundle="messages.GoBundle") String errorKey) {
        if (rangeClause == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(4);
        }
        if (supported == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(5);
        }
        if (errorKey == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(6);
        }
        if (supported == GoSdkUtil.FeatureSupported.NO) {
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message(errorKey);
            GoForStatementSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(rangeClause, (GoInspectionMessage)message), new GoShowSdkConfigurableFix(), rangeClause, message).create();
            return false;
        }
        if (supported == GoSdkUtil.FeatureSupported.NEED_VERSION_UPDATE) {
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message(errorKey);
            GoForStatementSpecChecker.withQuickFix(this.myHolder.newErrorAnnotation(rangeClause, (GoInspectionMessage)message), new VgoAddOrUpdateGoVersionFix(GoSdkVersion.GO_1_22), rangeClause, message).create();
            return false;
        }
        return true;
    }

    private void checkAssignmentCountMismatch(@NotNull GoRangeClause rangeClause, int leftHandElementsCount, GoType rangeExpressionType, @NotNull GoExpression rangeExpression) {
        if (rangeClause == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(7);
        }
        if (rangeExpression == null) {
            GoForStatementSpecChecker.$$$reportNull$$$0(8);
        }
        if (rangeExpressionType instanceof GoChannelType || GoTypeUtil.isIntegerType(rangeExpressionType, null)) {
            if (leftHandElementsCount > 1) {
                this.myHolder.newErrorAnnotation(rangeClause, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.too.many.variables.in.range", 1)).create();
            }
            return;
        }
        GoSignature yieldSignature = GoTypeUtil.getYieldSignatureFromIteratorType(rangeExpressionType, null);
        if (yieldSignature != null) {
            int count2 = yieldSignature.getParameters().getParameterCount();
            if (leftHandElementsCount != count2) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.incorrect.variables.count.in.range.over.func", rangeExpression.getText(), count2);
                this.myHolder.newErrorAnnotation(rangeClause, (GoInspectionMessage)message).create();
            }
            return;
        }
        if (leftHandElementsCount > 2) {
            this.myHolder.newErrorAnnotation(rangeClause, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.too.many.variables.in.range", 2)).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forClause";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeClause";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supported";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeExpression";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoForStatementSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForClause";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRangeClause";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRangeClauseSupported";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentCountMismatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

