/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoCompositeType;
import com.goide.psi.GoConstraintElem;
import com.goide.psi.GoConstraintTerm;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoConstraintTermSpecChecker
extends GoSpecCheckerBase {
    public GoConstraintTermSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitConstraintTerm(@NotNull GoConstraintTerm o) {
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(1);
        }
        super.visitConstraintTerm(o);
        if (o.hasTilde()) {
            this.checkApproximationConstraint(o);
        } else {
            PsiElement resolve2;
            GoType type2 = o.getType();
            GoTypeReferenceExpression typeRef = type2.getTypeReferenceExpression();
            PsiElement psiElement = resolve2 = typeRef != null ? typeRef.resolve() : null;
            if (resolve2 instanceof GoTypeParamDefinition) {
                if (GoConstraintTermSpecChecker.isConstraintInTypeParametersDeclaration(o)) {
                    this.myHolder.newErrorAnnotation(typeRef, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.type.parameter.as.constraint")).create();
                } else {
                    this.myHolder.newErrorAnnotation(typeRef, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.embed.type.parameter")).create();
                }
                return;
            }
            if (GoConstraintTermSpecChecker.isTermInUnion(o)) {
                GoCompositeElement errorElement;
                GoType typeToCheck = resolve2 instanceof GoTypeSpec ? ((GoTypeSpec)resolve2).getSpecType().getType() : type2;
                GoCompositeElement goCompositeElement = errorElement = typeRef != null ? typeRef : type2;
                if (GoConstraintTermSpecChecker.isInterfaceWithMethods(typeToCheck)) {
                    this.myHolder.newErrorAnnotation(errorElement, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.interface.with.methods.in.union")).create();
                } else if (GoConstraintTermSpecChecker.isInterfaceWithEmbeddedComparable(typeToCheck)) {
                    if (GoPsiImplUtil.builtin(typeToCheck)) {
                        this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.comparable.in.union")).create();
                    } else {
                        this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.use.type.embedding.comparable.in.union", errorElement.getText())).create();
                    }
                }
            }
        }
    }

    private static boolean isConstraintInTypeParametersDeclaration(@NotNull GoConstraintTerm o) {
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(2);
        }
        return o.getParent() != null && o.getParent().getParent() instanceof GoTypeParameterDeclaration;
    }

    private void checkApproximationConstraint(@NotNull GoConstraintTerm o) {
        GoType type2;
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(3);
        }
        if ((type2 = GoPsiImplUtil.unwrapGoParType(o.getType())) instanceof GoInterfaceType) {
            this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.constraint.term.on.interface", type2.getText())).create();
            return;
        }
        if (type2 instanceof GoCompositeType) {
            return;
        }
        PsiElement resolve2 = type2.resolve(o);
        if (resolve2 instanceof GoTypeParamDefinition) {
            this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.embed.type.parameter")).create();
            return;
        }
        GoTypeSpec resolveTypeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)resolve2, GoTypeSpec.class);
        if (resolveTypeSpec != null) {
            GoType underlyingType = resolveTypeSpec.getGoUnderlyingType(ResolveState.initial());
            if (!(underlyingType instanceof GoInterfaceType) && GoTypeUtil.identical(type2, underlyingType, true, null)) {
                return;
            }
            if (underlyingType instanceof GoInterfaceType) {
                this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.constraint.term.on.interface", type2.getText())).create();
            } else {
                this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.constraint.term.underlying.type.is.not.self", type2.getText())).create();
            }
        }
    }

    private static boolean isInterfaceWithMethods(@Nullable GoType type2) {
        return type2 instanceof GoInterfaceType && !((GoInterfaceType)type2).getMethods().isEmpty();
    }

    private static boolean isTermInUnion(@NotNull GoConstraintTerm o) {
        GoConstraintElem constraintElem;
        if (o == null) {
            GoConstraintTermSpecChecker.$$$reportNull$$$0(4);
        }
        return (constraintElem = (GoConstraintElem)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)o, GoConstraintElem.class)) != null && constraintElem.getConstraintTermList().size() > 1;
    }

    private static boolean isInterfaceWithEmbeddedComparable(@Nullable GoType type2) {
        return GoTypeUtil.findFirstMatchedInterfaceDfs(type2, iface -> GoTypeUtil.isBuiltinComparable(iface, type2)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoConstraintTermSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstraintTerm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstraintInTypeParametersDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApproximationConstraint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTermInUnion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

