/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstSpec;
import com.goide.psi.GoExpression;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GoConstDeclarationSpecChecker
extends GoSpecCheckerBase {
    public GoConstDeclarationSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoConstDeclarationSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitConstDeclaration(@NotNull GoConstDeclaration constDeclaration) {
        if (constDeclaration == null) {
            GoConstDeclarationSpecChecker.$$$reportNull$$$0(1);
        }
        if (!this.checkStructure(constDeclaration)) {
            return;
        }
        for (GoConstSpec spec : constDeclaration.getConstSpecList()) {
            GoType type2 = spec.getType();
            if (type2 != null && !GoTypeUtil.isConstantType(type2, spec) && !GoTypeUtil.isCType(type2, spec)) {
                this.myHolder.newErrorAnnotation(type2, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.invalid.constant.type")).create();
            }
            List<GoExpression> initializers = spec.getExpressionList();
            initializers.forEach(initializer -> GoExpressionUtil.processNonConstantExpressions(initializer, null, (Processor<? super GoExpression>)((Processor)nonConstant -> {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.error.annotator.const.initializer.is.not.a.constant", GoInspectionUtil.getPresentableText(nonConstant));
                this.myHolder.newErrorAnnotation((PsiElement)nonConstant, (GoInspectionMessage)message).create();
                return true;
            })));
            GoSpecCheckerUtil.checkAssignmentCountMismatch(spec, spec.getConstDefinitionList(), initializers, this.myHolder);
        }
    }

    private boolean checkStructure(@NotNull GoConstDeclaration constDeclaration) {
        if (constDeclaration == null) {
            GoConstDeclarationSpecChecker.$$$reportNull$$$0(2);
        }
        boolean noProblems = true;
        List<GoConstSpec> constSpecs = constDeclaration.getConstSpecList();
        GoConstSpec first = (GoConstSpec)ContainerUtil.getFirstItem(constSpecs);
        if (first != null && first.getExpressionList().isEmpty()) {
            this.myHolder.newErrorAnnotation(first, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.missing.value.in.const.declaration")).create();
            noProblems = false;
        }
        int prevExprCount = -1;
        for (GoConstSpec spec : constSpecs) {
            int exprCount = spec.getExpressionList().size();
            if (prevExprCount >= 0 && exprCount == 0 && spec.getConstDefinitionList().size() != prevExprCount) {
                this.myHolder.newErrorAnnotation(spec, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.extra.expression.in.const.declaration")).create();
                noProblems = false;
            }
            prevExprCount = exprCount != 0 ? exprCount : prevExprCount;
        }
        return noProblems;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constDeclaration";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoConstDeclarationSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConstDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStructure";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

