/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting.errors;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerBase;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoAddLocalVarForExpressionQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class GoCallExpressionSpecChecker
extends GoSpecCheckerBase {
    public GoCallExpressionSpecChecker(@NotNull GoAnnotationHolder holder) {
        if (holder == null) {
            GoCallExpressionSpecChecker.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    @Override
    public void visitCallExpr(@NotNull GoCallExpr call) {
        if (call == null) {
            GoCallExpressionSpecChecker.$$$reportNull$$$0(1);
        }
        this.checkCanCallPointerMethodOnNonPointer(call);
    }

    private void checkCanCallPointerMethodOnNonPointer(@NotNull GoCallExpr call) {
        GoReferenceExpression calledReference;
        GoExpression qualifier;
        if (call == null) {
            GoCallExpressionSpecChecker.$$$reportNull$$$0(2);
        }
        GoExpression goExpression = qualifier = (calledReference = GoPsiUtil.getCallReference(call)) != null ? calledReference.getExpressionQualifier() : null;
        if (qualifier == null) {
            return;
        }
        GoMethodDeclaration calledMethod = (GoMethodDeclaration)ObjectUtils.tryCast((Object)calledReference.resolve(), GoMethodDeclaration.class);
        if (calledMethod == null || !(calledMethod.getReceiverType() instanceof GoPointerType)) {
            return;
        }
        if (GoPsiUtil.isMethodExpressionQualifier(qualifier)) {
            return;
        }
        GoType qualifierType = Optional.of(qualifier).map(q -> q.getGoType(null)).map(t -> GoTypeUtil.unwrapAliasIfNamed(t, call)).orElse(null);
        if (!(qualifierType == null || qualifierType instanceof GoPointerType || GoCallExpressionSpecChecker.contains(GoTypeUtil.getMethodSet(qualifierType, call), calledMethod) || GoExpressionUtil.isAddressable(qualifier))) {
            String qualifierText = qualifier.getText();
            this.myHolder.newErrorAnnotation(call, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.error.annotator.cannot.call.pointer.method", qualifierText)).withFix((IntentionAction)new AddLocalVarForQualifierQuickFix(qualifier, qualifierText)).create();
        }
    }

    private static boolean contains(@NotNull List<? extends GoNamedSignatureOwner> methods, @NotNull GoMethodDeclaration method) {
        if (methods == null) {
            GoCallExpressionSpecChecker.$$$reportNull$$$0(3);
        }
        if (method == null) {
            GoCallExpressionSpecChecker.$$$reportNull$$$0(4);
        }
        return ContainerUtil.exists(methods, m -> GoPsiUtil.isSameNamedMethod(m, method, false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/goide/highlighting/errors/GoCallExpressionSpecChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallExpr";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCanCallPointerMethodOnNonPointer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AddLocalVarForQualifierQuickFix
    extends GoAddLocalVarForExpressionQuickFix {
        private final String myQualifierText;

        public AddLocalVarForQualifierQuickFix(GoExpression qualifier, String qualifierText) {
            super(qualifier);
            this.myQualifierText = qualifierText;
        }

        @Override
        @NotNull
        public String getText() {
            String string = GoBundle.message((String)"go.fix.introduce.local.variable.for.expression", (Object[])new Object[]{this.myQualifierText});
            if (string == null) {
                AddLocalVarForQualifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/highlighting/errors/GoCallExpressionSpecChecker$AddLocalVarForQualifierQuickFix", "getText"));
        }
    }
}

