/*
 * Decompiled with CFR 0.152.
 */
package com.goide.highlighting;

import com.goide.GoConstants;
import com.goide.directiveComment.GoDirectiveComment;
import com.goide.highlighting.GoSyntaxHighlightingColors;
import com.goide.inspections.GoDecodedStringLiteralRangeConverter;
import com.goide.inspections.GoInspectionUtil;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoFile;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoLiteral;
import com.goide.psi.GoMethodSpec;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoReferenceExpressionBase;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoSwitchStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class GoHighlightingAnnotator
implements Annotator,
DumbAware {
    @TestOnly
    private static final Key<Boolean> DISABLED = Key.create((String)"GoHighlightingAnnotatorDisabled");

    public GoHighlightingAnnotator() {
        PluginVerifier.verifyUltimatePlugin();
    }

    private static void highlightRefIfNeeded(@NotNull GoReferenceExpressionBase o, @Nullable PsiElement resolve2, @NotNull AnnotationHolder holder) {
        if (o == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (resolve2 instanceof GoTypeSpec) {
            GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getTypeReferenceColor((GoTypeSpec)resolve2));
        } else if (resolve2 instanceof GoConstDefinition) {
            TextAttributesKey color = GoPsiImplUtil.builtin(resolve2) ? GoSyntaxHighlightingColors.BUILTIN_CONSTANT : GoHighlightingAnnotator.getColor((GoConstDefinition)resolve2);
            GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, color);
        } else if (resolve2 instanceof GoVarDefinition) {
            if (o.getParent() instanceof GoCallExpr) {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColorForCall((GoVarDefinition)resolve2));
            } else {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColor((GoVarDefinition)resolve2));
            }
        } else if (resolve2 instanceof GoFieldDefinition) {
            if (o.getParent() instanceof GoCallExpr) {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColorForCall((GoFieldDefinition)resolve2));
            } else {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColor((GoFieldDefinition)resolve2));
            }
        } else if (resolve2 instanceof GoAnonymousFieldDefinition) {
            if (o.getParent() instanceof GoCallExpr) {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColorForCall((GoAnonymousFieldDefinition)resolve2));
            } else {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColor((GoAnonymousFieldDefinition)resolve2));
            }
        } else if (resolve2 instanceof GoFunctionOrMethodDeclaration || resolve2 instanceof GoMethodSpec) {
            PsiElement parent = o.getParent();
            if (parent instanceof GoCallExpr) {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColorForCall((GoNamedSignatureOwner)resolve2));
            } else {
                GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoHighlightingAnnotator.getColor((GoNamedSignatureOwner)resolve2));
            }
        } else if (resolve2 instanceof GoReceiver) {
            GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoSyntaxHighlightingColors.METHOD_RECEIVER);
        } else if (resolve2 instanceof GoParamDefinition) {
            GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoSyntaxHighlightingColors.FUNCTION_PARAMETER);
        } else if (GoPsiUtil.isImportSpecOrPackage(resolve2)) {
            GoHighlightingAnnotator.setHighlighting(o.getIdentifier(), holder, GoSyntaxHighlightingColors.PACKAGE);
        }
    }

    private static TextAttributesKey getTypeReferenceColor(@Nullable GoTypeSpec o) {
        GoType type2;
        if (GoPsiImplUtil.builtin(o)) {
            return GoSyntaxHighlightingColors.BUILTIN_TYPE_REFERENCE;
        }
        GoType goType = type2 = o != null ? o.getGoType(null) : null;
        if (type2 != null) {
            type2 = type2 instanceof GoSpecType ? ((GoSpecType)type2).getType() : type2;
            boolean isPublic = o.isPublic();
            if (type2 instanceof GoInterfaceType) {
                return isPublic ? GoSyntaxHighlightingColors.EXPORTED_INTERFACE_REFERENCE : GoSyntaxHighlightingColors.LOCAL_INTERFACE_REFERENCE;
            }
            if (type2 instanceof GoStructType) {
                return isPublic ? GoSyntaxHighlightingColors.EXPORTED_STRUCT_REFERENCE : GoSyntaxHighlightingColors.LOCAL_STRUCT_REFERENCE;
            }
        }
        return GoSyntaxHighlightingColors.TYPE_SPEC_REFERENCE;
    }

    private static TextAttributesKey getColor(GoConstDefinition o) {
        if (GoHighlightingAnnotator.isPackageWide(o)) {
            return o.isPublic() ? GoSyntaxHighlightingColors.PACKAGE_EXPORTED_CONSTANT : GoSyntaxHighlightingColors.PACKAGE_LOCAL_CONSTANT;
        }
        return GoSyntaxHighlightingColors.LOCAL_CONSTANT;
    }

    private static TextAttributesKey getColorForCall(GoFieldDefinition o) {
        return o.isPublic() ? GoSyntaxHighlightingColors.STRUCT_EXPORTED_MEMBER_CALL : GoSyntaxHighlightingColors.STRUCT_LOCAL_MEMBER_CALL;
    }

    private static TextAttributesKey getColor(GoFieldDefinition o) {
        return o.isPublic() ? GoSyntaxHighlightingColors.STRUCT_EXPORTED_MEMBER : GoSyntaxHighlightingColors.STRUCT_LOCAL_MEMBER;
    }

    private static TextAttributesKey getColorForCall(GoAnonymousFieldDefinition o) {
        return o.isPublic() ? GoSyntaxHighlightingColors.STRUCT_EXPORTED_MEMBER_CALL : GoSyntaxHighlightingColors.STRUCT_LOCAL_MEMBER_CALL;
    }

    private static TextAttributesKey getColor(GoAnonymousFieldDefinition o) {
        return o.isPublic() ? GoSyntaxHighlightingColors.STRUCT_EXPORTED_MEMBER : GoSyntaxHighlightingColors.STRUCT_LOCAL_MEMBER;
    }

    private static TextAttributesKey getColor(GoVarDefinition o) {
        if (GoPsiImplUtil.builtin(o)) {
            return GoSyntaxHighlightingColors.BUILTIN_VARIABLE;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)o, GoForStatement.class) != null || PsiTreeUtil.getParentOfType((PsiElement)o, GoIfStatement.class) != null || PsiTreeUtil.getParentOfType((PsiElement)o, GoSwitchStatement.class) != null) {
            if (!o.isBlank() && !GoInspectionUtil.isPrimaryDefinition(o)) {
                return GoSyntaxHighlightingColors.REASSIGNMENT_IN_SHORT_VAR_DECLARATION;
            }
            return GoExpressionUtil.getShadowedElement(o) == null ? GoSyntaxHighlightingColors.SCOPE_VARIABLE : GoSyntaxHighlightingColors.SHADOWING_VARIABLE;
        }
        if (GoHighlightingAnnotator.isPackageWide(o)) {
            return o.isPublic() ? GoSyntaxHighlightingColors.PACKAGE_EXPORTED_VARIABLE : GoSyntaxHighlightingColors.PACKAGE_LOCAL_VARIABLE;
        }
        if (!o.isBlank() && !GoInspectionUtil.isPrimaryDefinition(o)) {
            return GoSyntaxHighlightingColors.REASSIGNMENT_IN_SHORT_VAR_DECLARATION;
        }
        return GoExpressionUtil.getShadowedElement(o) == null ? GoSyntaxHighlightingColors.LOCAL_VARIABLE : GoSyntaxHighlightingColors.SHADOWING_VARIABLE;
    }

    private static TextAttributesKey getColorForCall(GoVarDefinition o) {
        if (GoHighlightingAnnotator.isPackageWide(o)) {
            return o.isPublic() ? GoSyntaxHighlightingColors.PACKAGE_EXPORTED_VARIABLE_CALL : GoSyntaxHighlightingColors.PACKAGE_LOCAL_VARIABLE_CALL;
        }
        return GoSyntaxHighlightingColors.LOCAL_VARIABLE_CALL;
    }

    private static TextAttributesKey getColor(GoNamedSignatureOwner o) {
        if (GoPsiImplUtil.builtin(o)) {
            return GoSyntaxHighlightingColors.BUILTIN_FUNCTION;
        }
        return o.isPublic() ? GoSyntaxHighlightingColors.EXPORTED_FUNCTION : GoSyntaxHighlightingColors.LOCAL_FUNCTION;
    }

    private static TextAttributesKey getColorForCall(GoNamedSignatureOwner o) {
        if (GoPsiImplUtil.builtin(o)) {
            return GoSyntaxHighlightingColors.BUILTIN_FUNCTION_CALL;
        }
        return o.isPublic() ? GoSyntaxHighlightingColors.EXPORTED_FUNCTION_CALL : GoSyntaxHighlightingColors.LOCAL_FUNCTION_CALL;
    }

    private static TextAttributesKey getColor(@Nullable GoTypeSpec o) {
        GoType type2;
        GoType goType = type2 = o != null ? o.getGoType(null) : null;
        if (type2 != null) {
            type2 = type2 instanceof GoSpecType ? ((GoSpecType)type2).getType() : type2;
            boolean isPublic = o.isPublic();
            if (type2 instanceof GoInterfaceType) {
                return isPublic ? GoSyntaxHighlightingColors.PACKAGE_EXPORTED_INTERFACE : GoSyntaxHighlightingColors.PACKAGE_LOCAL_INTERFACE;
            }
            if (type2 instanceof GoStructType) {
                return isPublic ? GoSyntaxHighlightingColors.PACKAGE_EXPORTED_STRUCT : GoSyntaxHighlightingColors.PACKAGE_LOCAL_STRUCT;
            }
        }
        return GoSyntaxHighlightingColors.TYPE_SPECIFICATION;
    }

    private static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (element == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(3);
        }
        if (key == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(4);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
        GoHighlightingAnnotator.newSilentAnnotation(holder, key.getExternalName()).range(element).textAttributes(key).create();
    }

    private static void setHighlighting(@NotNull TextRange range, @NotNull AnnotationHolder holder, @NotNull TextAttributesKey key) {
        if (range == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(6);
        }
        if (key == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(7);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).enforcedTextAttributes(TextAttributes.ERASE_MARKER).create();
        GoHighlightingAnnotator.newSilentAnnotation(holder, key.getExternalName()).range(range).textAttributes(key).create();
    }

    private static void setDirectiveCommentHighlighting(@NotNull AnnotationHolder holder, @NotNull TextRange range) {
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(8);
        }
        if (range == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(9);
        }
        GoHighlightingAnnotator.newSilentAnnotation(holder, "comment keyword").range(range).textAttributes(GoSyntaxHighlightingColors.COMMENT_KEYWORD).create();
    }

    @NotNull
    private static AnnotationBuilder newSilentAnnotation(@NotNull AnnotationHolder holder, @NotNull String testDescription) {
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(10);
        }
        if (testDescription == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(11);
        }
        AnnotationBuilder annotationBuilder = ApplicationManager.getApplication().isUnitTestMode() ? holder.newAnnotation(HighlightSeverity.INFORMATION, testDescription) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        if (annotationBuilder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(12);
        }
        return annotationBuilder;
    }

    private static boolean isPackageWide(@NotNull GoVarDefinition o) {
        PsiElement declaration;
        if (o == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(13);
        }
        return (declaration = PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{GoVarDeclaration.class, GoFunctionLit.class})) instanceof GoVarDeclaration && declaration.getParent() instanceof GoFile;
    }

    private static boolean isPackageWide(@NotNull GoConstDefinition o) {
        PsiElement declaration;
        if (o == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(14);
        }
        return (declaration = PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{GoConstDeclaration.class, GoFunctionLit.class})) instanceof GoConstDeclaration && declaration.getParent() instanceof GoFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement o, @NotNull AnnotationHolder holder) {
        boolean isDisableInTests;
        if (o == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(15);
        }
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(16);
        }
        if (holder.isBatchMode()) {
            return;
        }
        boolean bl = isDisableInTests = ApplicationManager.getApplication().isUnitTestMode() && TestModeFlags.is(DISABLED);
        if (isDisableInTests || !o.isValid()) {
            return;
        }
        if (o instanceof PsiComment) {
            for (String flag : GoConstants.COMPILER_FLAGS) {
                if (!GoPsiUtil.isFlaggedComment(o, flag)) continue;
                GoHighlightingAnnotator.setDirectiveCommentHighlighting(holder, TextRange.from((int)(o.getTextRange().getStartOffset() + 2), (int)flag.length()));
                return;
            }
            if (GoPsiUtil.isBuildTagComment(StringUtil.trimStart((String)o.getText(), (String)"//"))) {
                int whitespaceCount = StringUtil.countChars((CharSequence)o.getText(), (char)' ', (int)2, (boolean)true);
                int startOffset = o.getTextRange().getStartOffset() + 2 + whitespaceCount;
                GoHighlightingAnnotator.setDirectiveCommentHighlighting(holder, TextRange.from((int)startOffset, (int)"+build".length()));
                return;
            }
            GoDirectiveComment directiveComment = GoDirectiveComment.directiveCommentFrom((PsiComment)o);
            if (directiveComment != null && "embed".equals(directiveComment.getName())) {
                GoHighlightingAnnotator.setDirectiveCommentHighlighting(holder, directiveComment.getPrefixAndNameRange((PsiComment)o));
            }
        } else if (o instanceof GoLiteral) {
            GoLiteral literal = (GoLiteral)o;
            if (literal.getHex() != null || literal.getOct() != null) {
                GoHighlightingAnnotator.setHighlighting(o, holder, GoSyntaxHighlightingColors.NUMBER);
            }
        } else if (o instanceof GoStringLiteral) {
            GoStringLiteral literal = (GoStringLiteral)o;
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
                List<GoFmtStringToken> tokens = GoHighlightingAnnotator.findFmtStringTokens(literal);
                List targetTokens = ContainerUtil.filter(tokens, t -> t instanceof GoFmtStringPlaceholder || t instanceof GoFmtStringEscapedPercent);
                if (targetTokens.isEmpty()) {
                    return;
                }
                GoDecodedStringLiteralRangeConverter converter = new GoDecodedStringLiteralRangeConverter(literal);
                int literalOffset = literal.getTextOffset();
                for (GoFmtStringToken token : targetTokens) {
                    TextRange originalRange = converter.computeRange(token.getStart(), token.getEnd());
                    if (originalRange == null) continue;
                    GoHighlightingAnnotator.setHighlighting(originalRange.shiftRight(literalOffset), holder, GoSyntaxHighlightingColors.VALID_STRING_ESCAPE);
                }
            });
        } else if (o instanceof GoReferenceExpressionBase) {
            GoReferenceExpressionBase ref = (GoReferenceExpressionBase)o;
            PsiReference reference = ref.getReference();
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> GoHighlightingAnnotator.highlightRefIfNeeded(ref, reference.resolve(), holder));
        } else if (o instanceof GoConstDefinition) {
            GoConstDefinition constDef = (GoConstDefinition)o;
            GoHighlightingAnnotator.setHighlighting(o, holder, GoHighlightingAnnotator.getColor(constDef));
        } else if (o instanceof GoVarDefinition) {
            GoVarDefinition varDef = (GoVarDefinition)o;
            GoHighlightingAnnotator.setHighlighting(o, holder, GoHighlightingAnnotator.getColor(varDef));
        } else if (o instanceof GoFieldDefinition) {
            GoFieldDefinition fieldDef = (GoFieldDefinition)o;
            GoHighlightingAnnotator.setHighlighting(o, holder, GoHighlightingAnnotator.getColor(fieldDef));
        } else if (o instanceof GoParamDefinition) {
            GoHighlightingAnnotator.setHighlighting(o, holder, GoSyntaxHighlightingColors.FUNCTION_PARAMETER);
        } else if (o instanceof GoLabelDefinition || o instanceof GoLabelRef) {
            GoHighlightingAnnotator.setHighlighting(o, holder, GoSyntaxHighlightingColors.LABEL);
        } else if (o instanceof GoImportSpec) {
            if (((GoImportSpec)o).isDot()) {
                PsiElement psiElement = o;
                synchronized (psiElement) {
                    Set importUsers = (Set)o.getUserData(GoReferenceBase.IMPORT_USERS);
                    if (importUsers != null) {
                        Set newImportUsers = importUsers.stream().filter(PsiElement::isValid).collect(Collectors.toSet());
                        o.putUserData(GoReferenceBase.IMPORT_USERS, newImportUsers.isEmpty() ? null : newImportUsers);
                    }
                }
            }
        } else {
            GoHighlightingAnnotator.annotateThroughParent(o, holder);
        }
    }

    private static void annotateThroughParent(@NotNull PsiElement o, @NotNull AnnotationHolder holder) {
        PsiElement identifier;
        PsiElement parent;
        if (o == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(18);
        }
        if ((parent = o.getParent()) instanceof GoImportSpec) {
            PsiElement dot;
            PsiElement identifier2 = ((GoImportSpec)parent).getIdentifier();
            if (identifier2 == o) {
                GoHighlightingAnnotator.setHighlighting(identifier2, holder, GoSyntaxHighlightingColors.PACKAGE);
            }
            if ((dot = ((GoImportSpec)parent).getDot()) == o) {
                GoHighlightingAnnotator.setHighlighting(dot, holder, GoSyntaxHighlightingColors.PACKAGE);
            }
        } else if (parent instanceof GoPackageClause) {
            PsiElement identifier3 = ((GoPackageClause)parent).getIdentifier();
            if (identifier3 == o) {
                GoHighlightingAnnotator.setHighlighting(identifier3, holder, GoSyntaxHighlightingColors.PACKAGE);
            }
        } else if (parent instanceof GoSpecType) {
            PsiElement identifier4 = ((GoSpecType)parent).getIdentifier();
            if (identifier4 == o) {
                GoHighlightingAnnotator.setHighlighting(identifier4, holder, GoHighlightingAnnotator.getColor((GoTypeSpec)ObjectUtils.tryCast((Object)parent.getParent(), GoTypeSpec.class)));
            }
        } else if (parent instanceof GoReceiver) {
            PsiElement identifier5 = ((GoReceiver)parent).getIdentifier();
            if (identifier5 == o) {
                GoHighlightingAnnotator.setHighlighting(identifier5, holder, GoSyntaxHighlightingColors.METHOD_RECEIVER);
            }
        } else if (parent instanceof GoNamedSignatureOwner && (identifier = ((GoNamedSignatureOwner)parent).getIdentifier()) == o) {
            GoHighlightingAnnotator.setHighlighting(identifier, holder, GoHighlightingAnnotator.getColor((GoNamedSignatureOwner)parent));
        }
    }

    @NotNull
    private static List<GoFmtStringToken> findFmtStringTokens(@NotNull GoStringLiteral literal) {
        if (literal == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(19);
        }
        if (!(literal.getParent() instanceof GoArgumentList)) {
            List<GoFmtStringToken> list = Collections.emptyList();
            if (list == null) {
                GoHighlightingAnnotator.$$$reportNull$$$0(20);
            }
            return list;
        }
        GoFmtStringUtil.FmtFunctionInfo fmtFunction = GoFmtStringUtil.findFormattingFunction(literal);
        GoFmtStringUtil.FmtCallArguments args = fmtFunction != null ? fmtFunction.getFmtStringAndRestArguments() : null;
        List<GoFmtStringToken> list = args != null && args.getFmtString() == literal ? GoFmtStringUtil.parse(literal) : Collections.emptyList();
        if (list == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(21);
        }
        return list;
    }

    @TestOnly
    public static void disable(@NotNull Disposable disposable) {
        if (disposable == null) {
            GoHighlightingAnnotator.$$$reportNull$$$0(22);
        }
        TestModeFlags.set(DISABLED, (Object)true, (Disposable)disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDescription";
                break;
            }
            case 12: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/highlighting/GoHighlightingAnnotator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/highlighting/GoHighlightingAnnotator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newSilentAnnotation";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findFmtStringTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "highlightRefIfNeeded";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHighlighting";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDirectiveCommentHighlighting";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newSilentAnnotation";
                break;
            }
            case 12: 
            case 20: 
            case 21: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPackageWide";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "annotateThroughParent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findFmtStringTokens";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "disable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 20, 21 -> new IllegalStateException(string);
        };
    }
}

