/*
 * Decompiled with CFR 0.152.
 */
package com.goide.generate;

import com.goide.editor.template.GoLiveTemplateContextType;
import com.goide.execution.testing.GoTestFramework;
import com.goide.execution.testing.GoTestFunctionType;
import com.goide.psi.GoFile;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoGenerateTestActionBase
extends CodeInsightAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(GoGenerateTestActionBase.class);
    @NotNull
    private final GoTestFramework myFramework;
    @NotNull
    private final CodeInsightActionHandler myHandler;

    protected GoGenerateTestActionBase(@NotNull GoTestFramework framework, @NotNull CodeInsightActionHandler handler) {
        if (framework == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(1);
        }
        this.myFramework = framework;
        this.myHandler = handler;
    }

    @NotNull
    public static String importTestingPackageIfNeeded(@NotNull GoFile file) {
        if (file == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(2);
        }
        String string = GoRefactoringUtil.importPackageIfNeeded(file, "testing");
        if (string == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CodeInsightActionHandler codeInsightActionHandler = this.myHandler;
        if (codeInsightActionHandler == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(4);
        }
        return codeInsightActionHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GoGenerateTestActionBase.$$$reportNull$$$0(7);
        }
        if (!this.myFramework.isAvailableOnFile(file)) {
            return false;
        }
        GoLiveTemplateContextType.File fileContextType = (GoLiveTemplateContextType.File)TemplateContextTypes.getByClassOrNull(GoLiveTemplateContextType.File.class);
        if (fileContextType == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        return fileContextType.isInContext(TemplateActionContext.create((PsiFile)file, (Editor)editor, (int)offset, (int)offset, (boolean)false));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/generate/GoGenerateTestActionBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/generate/GoGenerateTestActionBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "importTestingPackageIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "importTestingPackageIfNeeded";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    protected static class GoGenerateTestActionHandler
    implements CodeInsightActionHandler {
        @NotNull
        private final GoTestFunctionType myType;
        @NotNull
        private final String myTemplateName;

        public GoGenerateTestActionHandler(@NotNull GoTestFunctionType type2, @NotNull String templateName) {
            if (type2 == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(0);
            }
            if (templateName == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(1);
            }
            this.myType = type2;
            this.myTemplateName = templateName;
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            if (project == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(2);
            }
            if (editor == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(3);
            }
            if (file == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(4);
            }
            if (!(file instanceof GoFile)) {
                return;
            }
            String testingQualifier = null;
            if (this.myType.getParamType() != null) {
                testingQualifier = GoGenerateTestActionBase.importTestingPackageIfNeeded((GoFile)file);
                PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            }
            EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)"\n");
            this.expandTemplate(project, editor, testingQualifier);
        }

        private void expandTemplate(@NotNull Project project, @NotNull Editor editor, @Nullable String testingQualifier) {
            if (project == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(5);
            }
            if (editor == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(6);
            }
            FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project);
            FileTemplate fileTemplate = templateManager.getCodeTemplate(this.myTemplateName);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("PARAM_NAME", this.myType.getParamName());
            attributes.put("PARAM_TYPE", this.myType.getQualifiedParamType(testingQualifier));
            try {
                TemplateImpl liveTemplate = GoGenerateTestActionHandler.createLiveTemplateFromText(fileTemplate.getText(attributes));
                TemplateManager.getInstance((Project)project).startTemplate(editor, (Template)liveTemplate);
            }
            catch (IOException e) {
                LOG.error("Cannot generate " + this.myType.getPrefix(), (Throwable)e);
            }
        }

        @NotNull
        private static TemplateImpl createLiveTemplateFromText(@NotNull String templateText) {
            if (templateText == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(7);
            }
            TemplateImpl template = new TemplateImpl("", templateText, "");
            template.setToReformat(true);
            int count2 = template.getSegmentsCount();
            for (int i = 0; i < count2; ++i) {
                String segmentName = template.getSegmentName(i);
                if (TemplateImpl.INTERNAL_VARS_SET.contains(segmentName)) continue;
                template.addVariable(segmentName, "", "", true);
            }
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                GoGenerateTestActionHandler.$$$reportNull$$$0(8);
            }
            return templateImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateName";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateText";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/generate/GoGenerateTestActionBase$GoGenerateTestActionHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/generate/GoGenerateTestActionBase$GoGenerateTestActionHandler";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createLiveTemplateFromText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "expandTemplate";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createLiveTemplateFromText";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8 -> new IllegalStateException(string);
            };
        }
    }
}

