/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter.settings;

import com.goide.GoFileType;
import com.goide.configuration.GoUIUtil;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.highlighting.GoSyntaxHighlighter;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.impl.GoElementFactory;
import com.goide.util.GoImportsSorter;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoCodeStyleImportsPanel
extends CodeStyleAbstractPanel {
    @NonNls
    private static final HashSet<String> PREDEFINED_SDK_PATHS = ContainerUtil.newHashSet((Object[])new String[]{"fmt", "errors", "bytes"});
    @NonNls
    private static final String PREVIEW_TEXT = "package main\n\nimport (\n\t\"fmt\"\n\t\"bytes\"\n\t\"localPackage\"\n\t\"golang.org/x/tools/cmd/gotype\"\n\t\"appengine\"\n\n\t\"errors\"\n)\nimport \"github.com/dlsniper/go-metrics\"";
    private final JPanel myPanel;
    private JCheckBox myUseBackQuotesForImports;
    private JCheckBox myAddParenthesesForImport;
    private JCheckBox myRemoveRedundantImportAliases;
    private ComboBox<GoCodeStyleSettings.ImportSorting> myImportSortingComboBox;
    private JCheckBox myCbGroupStdlibImports;
    private JCheckBox myCbMoveAllImportsInOneDeclaration;
    private JCheckBox myCbMoveAllStdlibImportsInOneGroup;
    private JCheckBox myLocalGroup;
    private JBRadioButton myForCurrentProjectPackages;
    private JBRadioButton myForImportsWithPrefix;
    private ExpandableTextField myPackagePrefixes;

    public GoCodeStyleImportsPanel(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(0);
        }
        super(settings);
        this.myPanel = this.createPanel();
    }

    private JPanel createPanel() {
        this.myUseBackQuotesForImports = new JCheckBox(GoBundle.message((String)"go.fmt.use.back.quotes.for.imports", (Object[])new Object[0]));
        this.myAddParenthesesForImport = new JCheckBox(GoBundle.message((String)"go.fmt.add.parentheses.for.single.import", (Object[])new Object[0]));
        this.myRemoveRedundantImportAliases = new JCheckBox(GoBundle.message((String)"go.fmt.remove.redundant.import.aliases", (Object[])new Object[0]));
        this.myImportSortingComboBox = new ComboBox((Object[])new GoCodeStyleSettings.ImportSorting[]{GoCodeStyleSettings.ImportSorting.GOFMT, GoCodeStyleSettings.ImportSorting.GOIMPORTS, GoCodeStyleSettings.ImportSorting.NONE});
        this.myImportSortingComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value -> value.getDescription()));
        this.myCbGroupStdlibImports = new JCheckBox(GoBundle.message((String)"go.fmt.group.stdlib.imports", (Object[])new Object[0]));
        this.myCbMoveAllImportsInOneDeclaration = new JCheckBox(GoBundle.message((String)"go.fmt.move.all.imports.in.single.declaration", (Object[])new Object[0]));
        this.myCbMoveAllStdlibImportsInOneGroup = new JCheckBox(GoBundle.message((String)"go.fmt.move.all.stdlib.imports.in.single.group", (Object[])new Object[0]));
        this.myLocalGroup = new JCheckBox(GoBundle.message((String)"go.fmt.create.local.group.label", (Object[])new Object[0]));
        ButtonGroup group = new ButtonGroup();
        this.myForCurrentProjectPackages = new JBRadioButton(GoBundle.message((String)"go.fmt.for.current.project.packages", (Object[])new Object[0]));
        this.myForImportsWithPrefix = new JBRadioButton(GoBundle.message((String)"go.fmt.for.imports.starting.with.prefix", (Object[])new Object[0]));
        group.add((AbstractButton)this.myForCurrentProjectPackages);
        group.add((AbstractButton)this.myForImportsWithPrefix);
        this.myPackagePrefixes = new ExpandableTextField(list -> Arrays.asList(list.split(",")), list -> StringUtil.join((Collection)list, (String)",")){

            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return new Dimension(300, size.height);
            }
        };
        this.myLocalGroup.addActionListener(e -> {
            this.myForCurrentProjectPackages.setEnabled(this.myLocalGroup.isSelected());
            this.myForImportsWithPrefix.setEnabled(this.myLocalGroup.isSelected());
            this.myPackagePrefixes.setEnabled(this.myLocalGroup.isSelected() && this.myForImportsWithPrefix.isSelected());
        });
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GoCodeStyleImportsPanel.this.myPackagePrefixes.setEnabled(GoCodeStyleImportsPanel.this.myForImportsWithPrefix.isSelected());
            }
        };
        this.myForCurrentProjectPackages.addActionListener(listener2);
        this.myForImportsWithPrefix.addActionListener(listener2);
        this.myImportSortingComboBox.addItemListener(e -> this.updateEnabled((GoCodeStyleSettings.ImportSorting)((Object)((Object)e.getItem()))));
        this.myCbGroupStdlibImports.addChangeListener(e -> this.myCbMoveAllStdlibImportsInOneGroup.setEnabled(this.myCbGroupStdlibImports.isSelected()));
        FormBuilder builder = FormBuilder.createFormBuilder().addComponent((JComponent)this.myUseBackQuotesForImports).addComponent((JComponent)this.myAddParenthesesForImport).addComponent((JComponent)this.myRemoveRedundantImportAliases).addLabeledComponent(GoBundle.message((String)"go.fmt.import.sorting.type", (Object[])new Object[0]), this.myImportSortingComboBox).addComponent((JComponent)this.myCbMoveAllImportsInOneDeclaration).addComponent((JComponent)this.myCbGroupStdlibImports).setFormLeftIndent(10).addComponent((JComponent)this.myCbMoveAllStdlibImportsInOneGroup).setFormLeftIndent(0).addComponent((JComponent)this.myLocalGroup).setFormLeftIndent(10).addComponent((JComponent)this.myForCurrentProjectPackages).addComponent((JComponent)this.myForImportsWithPrefix).addComponent((JComponent)this.myPackagePrefixes).addComponent((JComponent)ComponentPanelBuilder.createCommentComponent((String)GoBundle.message((String)"go.fmt.for.imports.starting.with.prefix.comment", (Object[])new Object[0]), (boolean)true)).setFormLeftIndent(0).addComponentFillVertically((JComponent)new JPanel(), 0);
        JPanel previewPanel = new JPanel();
        this.installPreviewPanel(previewPanel);
        return GoUIUtil.wrapWithPreviewPanel(builder.getPanel(), previewPanel);
    }

    @NotNull
    protected PsiFile doReformat(Project project, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().getDocument(psiFile.getViewProvider().getVirtualFile());
        Object sortingType = Objects.requireNonNull(this.myImportSortingComboBox.getSelectedItem());
        GoImportsSorter sorter = new GoImportsSorter((GoFile)psiFile, (GoCodeStyleSettings.ImportSorting)((Object)sortingType), this.myCbGroupStdlibImports.isSelected(), this.myCbMoveAllImportsInOneDeclaration.isSelected(), this.myCbMoveAllStdlibImportsInOneGroup.isSelected(), PREDEFINED_SDK_PATHS, this.myLocalGroup.isSelected(), this.getLocalGroupMode(), this.myPackagePrefixes.getText());
        sorter.sortImports();
        ((SyntaxTraverser)GoPsiTreeUtil.goTraverser().withRoot((Object)psiFile)).filter(GoImportSpec.class).forEach(importSpec -> {
            GoImportDeclaration declaration = (GoImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)importSpec, GoImportDeclaration.class);
            if (declaration != null && declaration.getImportSpecList().size() == 1) {
                GoImportDeclaration replacement = GoElementFactory.createImportDeclaration(psiFile, importSpec.getPath(), importSpec.getAlias(), this.myAddParenthesesForImport.isSelected());
                declaration.replace(replacement);
            } else {
                GoImportSpec spec = GoElementFactory.createImportSpec(psiFile, importSpec.getPath(), importSpec.getAlias());
                importSpec.replace(spec);
            }
        });
        PsiFile psiFile2 = super.doReformat(project, psiFile);
        if (psiFile2 == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(2);
        }
        return psiFile2;
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = GoBundle.message((String)"go.fmt.imports.tab.title", (Object[])new Object[0]);
        if (string == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected int getRightMargin() {
        return 0;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(4);
        }
        return HighlighterFactory.createHighlighter((SyntaxHighlighter)new GoSyntaxHighlighter(), (EditorColorsScheme)scheme);
    }

    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = GoFileType.INSTANCE;
        if (languageFileType == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(5);
        }
        return languageFileType;
    }

    @Nullable
    protected String getPreviewText() {
        return PREVIEW_TEXT;
    }

    public void apply(@NotNull CodeStyleSettings rootSettings) throws ConfigurationException {
        if (rootSettings == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(6);
        }
        if (this.myLocalGroup.isSelected() && GoCodeStyleSettings.LocalGroupMode.PREFIX.equals((Object)this.getLocalGroupMode()) && StringUtil.isEmptyOrSpaces((String)this.myPackagePrefixes.getText())) {
            throw new ConfigurationException(GoBundle.message((String)"go.fmt.imports.prefix.error.empty.message", (Object[])new Object[0]), GoBundle.message((String)"go.fmt.imports.prefix.error.title", (Object[])new Object[0]));
        }
        GoCodeStyleSettings settings = (GoCodeStyleSettings)rootSettings.getCustomSettings(GoCodeStyleSettings.class);
        settings.USE_BACK_QUOTES_FOR_IMPORTS = this.myUseBackQuotesForImports.isSelected();
        settings.ADD_PARENTHESES_FOR_SINGLE_IMPORT = this.myAddParenthesesForImport.isSelected();
        settings.REMOVE_REDUNDANT_IMPORT_ALIASES = this.myRemoveRedundantImportAliases.isSelected();
        settings.IMPORT_SORTING = (GoCodeStyleSettings.ImportSorting)((Object)this.myImportSortingComboBox.getSelectedItem());
        settings.GROUP_STDLIB_IMPORTS = this.myCbGroupStdlibImports.isSelected();
        settings.MOVE_ALL_IMPORTS_IN_ONE_DECLARATION = this.myCbMoveAllImportsInOneDeclaration.isSelected();
        settings.MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP = this.myCbMoveAllStdlibImportsInOneGroup.isSelected();
        settings.CREATE_LOCAL_GROUP = this.myLocalGroup.isSelected();
        settings.LOCAL_GROUP_MODE = this.getLocalGroupMode();
        settings.LOCAL_PACKAGE_PREFIXES = StringUtil.nullize((String)this.myPackagePrefixes.getText());
    }

    public boolean isModified(CodeStyleSettings rootSettings) {
        GoCodeStyleSettings settings = (GoCodeStyleSettings)rootSettings.getCustomSettings(GoCodeStyleSettings.class);
        if (this.myUseBackQuotesForImports.isSelected() != settings.USE_BACK_QUOTES_FOR_IMPORTS) {
            return true;
        }
        if (this.myAddParenthesesForImport.isSelected() != settings.ADD_PARENTHESES_FOR_SINGLE_IMPORT) {
            return true;
        }
        if (this.myRemoveRedundantImportAliases.isSelected() != settings.REMOVE_REDUNDANT_IMPORT_ALIASES) {
            return true;
        }
        return settings.IMPORT_SORTING != this.myImportSortingComboBox.getSelectedItem() || settings.GROUP_STDLIB_IMPORTS != this.myCbGroupStdlibImports.isSelected() || settings.MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP != this.myCbMoveAllStdlibImportsInOneGroup.isSelected() || settings.MOVE_ALL_IMPORTS_IN_ONE_DECLARATION != this.myCbMoveAllImportsInOneDeclaration.isSelected() || settings.CREATE_LOCAL_GROUP != this.myLocalGroup.isSelected() || settings.LOCAL_GROUP_MODE != this.getLocalGroupMode() || !Objects.equals(settings.LOCAL_PACKAGE_PREFIXES, this.myPackagePrefixes.getText());
    }

    @Nullable
    public JComponent getPanel() {
        return this.myPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(7);
        }
        GoCodeStyleSettings settings = (GoCodeStyleSettings)rootSettings.getCustomSettings(GoCodeStyleSettings.class);
        this.myUseBackQuotesForImports.setSelected(settings.USE_BACK_QUOTES_FOR_IMPORTS);
        this.myAddParenthesesForImport.setSelected(settings.ADD_PARENTHESES_FOR_SINGLE_IMPORT);
        this.myRemoveRedundantImportAliases.setSelected(settings.REMOVE_REDUNDANT_IMPORT_ALIASES);
        this.myImportSortingComboBox.setSelectedItem((Object)settings.IMPORT_SORTING);
        this.myCbGroupStdlibImports.setSelected(settings.GROUP_STDLIB_IMPORTS);
        this.myCbMoveAllImportsInOneDeclaration.setSelected(settings.MOVE_ALL_IMPORTS_IN_ONE_DECLARATION);
        this.myCbMoveAllStdlibImportsInOneGroup.setSelected(settings.MOVE_ALL_STDLIB_IMPORTS_IN_ONE_GROUP);
        this.myLocalGroup.setSelected(settings.CREATE_LOCAL_GROUP);
        this.myForCurrentProjectPackages.setSelected(settings.LOCAL_GROUP_MODE == GoCodeStyleSettings.LocalGroupMode.PROJECT);
        this.myForImportsWithPrefix.setSelected(settings.LOCAL_GROUP_MODE == GoCodeStyleSettings.LocalGroupMode.PREFIX);
        this.myPackagePrefixes.setText(settings.LOCAL_PACKAGE_PREFIXES);
        this.updateEnabled(settings.IMPORT_SORTING);
    }

    private void updateEnabled(@NotNull GoCodeStyleSettings.ImportSorting importSorting) {
        if (importSorting == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(8);
        }
        boolean sortingConfigured = importSorting != GoCodeStyleSettings.ImportSorting.NONE;
        this.myCbGroupStdlibImports.setEnabled(sortingConfigured);
        this.myCbMoveAllImportsInOneDeclaration.setEnabled(sortingConfigured);
        this.myCbMoveAllStdlibImportsInOneGroup.setEnabled(this.myCbGroupStdlibImports.isSelected() && sortingConfigured);
        this.myLocalGroup.setEnabled(sortingConfigured);
        this.myForCurrentProjectPackages.setEnabled(sortingConfigured && this.myLocalGroup.isSelected());
        this.myForImportsWithPrefix.setEnabled(sortingConfigured && this.myLocalGroup.isSelected());
        this.myPackagePrefixes.setEnabled(sortingConfigured && this.myLocalGroup.isSelected() && this.myForImportsWithPrefix.isSelected());
    }

    @NotNull
    private GoCodeStyleSettings.LocalGroupMode getLocalGroupMode() {
        GoCodeStyleSettings.LocalGroupMode localGroupMode = this.myForCurrentProjectPackages.isSelected() ? GoCodeStyleSettings.LocalGroupMode.PROJECT : GoCodeStyleSettings.LocalGroupMode.PREFIX;
        if (localGroupMode == null) {
            GoCodeStyleImportsPanel.$$$reportNull$$$0(9);
        }
        return localGroupMode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/settings/GoCodeStyleImportsPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSorting";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/settings/GoCodeStyleImportsPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doReformat";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGroupMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doReformat";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 9 -> new IllegalStateException(string);
        };
    }
}

