/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.formatter.GoChildrenAlignment;
import com.goide.formatter.GoFormattingBlock;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoLineCommentBlock
extends GoFormattingBlock {
    private List<Block> mySubBlocks;

    public GoLineCommentBlock(@NotNull GoFormattingBlock parent, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable GoChildrenAlignment childrenAlignment) {
        if (parent == null) {
            GoLineCommentBlock.$$$reportNull$$$0(0);
        }
        if (node == null) {
            GoLineCommentBlock.$$$reportNull$$$0(1);
        }
        super(parent, node, alignment, indent, null, childrenAlignment);
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = this.buildSubBlocks();
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            GoLineCommentBlock.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<Block> buildSubBlocks() {
        SmartList result = new SmartList();
        TextRange range = this.getTextRange();
        ASTNode node = this.getNode();
        String text = node.getText();
        if (GoLineCommentBlock.canBeFormatted(StringUtil.trimStart((String)text, (String)"//"), this.myContext.getGoCodeStyleSettings())) {
            result.add(new SlashesBlock(node, TextRange.from((int)range.getStartOffset(), (int)2)));
            int spaceCount = StringUtil.countChars((CharSequence)text, (char)' ', (int)2, (boolean)true);
            result.add(new CommentTextBlock(node, TextRange.create((int)(range.getStartOffset() + 2 + spaceCount), (int)range.getEndOffset())));
        }
        SmartList smartList = result;
        if (smartList == null) {
            GoLineCommentBlock.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @Override
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            GoLineCommentBlock.$$$reportNull$$$0(4);
        }
        if (child1 instanceof SlashesBlock && child2 instanceof CommentTextBlock) {
            GoCodeStyleSettings settings = this.myContext.getGoCodeStyleSettings();
            int minSpaces = settings.ADD_LEADING_SPACE_TO_COMMENTS && !child2.getTextRange().isEmpty() ? 1 : 0;
            return Spacing.createSpacing((int)minSpaces, (int)Integer.MAX_VALUE, (int)0, (boolean)false, (int)0);
        }
        return super.getSpacing(child1, child2);
    }

    public static boolean canBeFormatted(@NotNull String commentText, @NotNull GoCodeStyleSettings settings) {
        if (commentText == null) {
            GoLineCommentBlock.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            GoLineCommentBlock.$$$reportNull$$$0(6);
        }
        return !commentText.startsWith("\t") && !GoLineCommentBlock.isDirectiveComment(commentText, settings);
    }

    public static boolean isDirectiveComment(@NotNull String commentText, @Nullable GoCodeStyleSettings settings) {
        if (commentText == null) {
            GoLineCommentBlock.$$$reportNull$$$0(7);
        }
        return GoLineCommentBlock.isStandardDirectiveComment(commentText) || GoLineCommentBlock.isExportDirective(commentText) || GoLineCommentBlock.isGolandDirectiveComment(commentText) || GoLineCommentBlock.isUserDefinedDirective(commentText, settings);
    }

    public static boolean isGolandDirectiveComment(@NotNull String commentText) {
        if (commentText == null) {
            GoLineCommentBlock.$$$reportNull$$$0(8);
        }
        return commentText.startsWith("noinspection ") || commentText.startsWith("language=");
    }

    private static boolean isExportDirective(@NotNull String commentText) {
        if (commentText == null) {
            GoLineCommentBlock.$$$reportNull$$$0(9);
        }
        return commentText.equals("export") || commentText.startsWith("export ");
    }

    private static boolean isUserDefinedDirective(@NotNull String commentText, @Nullable GoCodeStyleSettings settings) {
        if (commentText == null) {
            GoLineCommentBlock.$$$reportNull$$$0(10);
        }
        return settings != null && !settings.requiresLeadingSpace(commentText);
    }

    public static boolean isStandardDirectiveComment(@NotNull String commentText) {
        if (commentText == null) {
            GoLineCommentBlock.$$$reportNull$$$0(11);
        }
        if (commentText.startsWith("line ")) {
            return true;
        }
        int colon = commentText.indexOf(":");
        if (colon <= 0 || colon + 1 >= commentText.length()) {
            return false;
        }
        for (int i = 0; i <= colon + 1; ++i) {
            char c;
            if (i == colon || 'a' <= (c = commentText.charAt(i)) && c <= 'z' || '0' <= c && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoLineCommentBlock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoLineCommentBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canBeFormatted";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectiveComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGolandDirectiveComment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExportDirective";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUserDefinedDirective";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStandardDirectiveComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class SlashesBlock
    extends AbstractBlock {
        private final TextRange myTextRange;

        private SlashesBlock(@NotNull ASTNode node, @NotNull TextRange textRange) {
            if (node == null) {
                SlashesBlock.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                SlashesBlock.$$$reportNull$$$0(1);
            }
            super(node, null, null);
            this.myTextRange = textRange;
        }

        protected List<Block> buildChildren() {
            return ContainerUtil.emptyList();
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                SlashesBlock.$$$reportNull$$$0(2);
            }
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myTextRange;
            if (textRange == null) {
                SlashesBlock.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        public String toString() {
            int start = this.myNode.getTextRange().getStartOffset();
            return this.myNode.getChars().subSequence(this.myTextRange.getStartOffset() - start, this.myTextRange.getEndOffset() - start).toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/formatter/GoLineCommentBlock$SlashesBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/formatter/GoLineCommentBlock$SlashesBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CommentTextBlock
    extends AbstractBlock {
        private final TextRange myTextRange;

        private CommentTextBlock(@NotNull ASTNode node, @NotNull TextRange textRange) {
            if (node == null) {
                CommentTextBlock.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                CommentTextBlock.$$$reportNull$$$0(1);
            }
            super(node, null, null);
            this.myTextRange = textRange;
        }

        protected List<Block> buildChildren() {
            return ContainerUtil.emptyList();
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                CommentTextBlock.$$$reportNull$$$0(2);
            }
            return null;
        }

        public boolean isLeaf() {
            return true;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myTextRange;
            if (textRange == null) {
                CommentTextBlock.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @NotNull
        public String getText() {
            int start = this.myNode.getTextRange().getStartOffset();
            String string = this.myNode.getChars().subSequence(this.myTextRange.getStartOffset() - start, this.myTextRange.getEndOffset() - start).toString();
            if (string == null) {
                CommentTextBlock.$$$reportNull$$$0(4);
            }
            return string;
        }

        public String toString() {
            return this.getText();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/formatter/GoLineCommentBlock$CommentTextBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/formatter/GoLineCommentBlock$CommentTextBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

