/*
 * Decompiled with CFR 0.152.
 */
package com.goide.formatter;

import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.formatter.GoCallArgListBlock;
import com.goide.formatter.GoCallQualifierBlock;
import com.goide.formatter.GoChildrenAlignment;
import com.goide.formatter.GoDependentLFSpacingSettings;
import com.goide.formatter.GoFormatterUtil;
import com.goide.formatter.GoFormattingContext;
import com.goide.formatter.GoFormattingRules;
import com.goide.formatter.GoLineCommentBlock;
import com.goide.formatter.GoMultilineCommentBlock;
import com.goide.formatter.GoRawStringFormattingBlock;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.psi.GoAddExpr;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBuiltinArgumentList;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCommCase;
import com.goide.psi.GoConditionalExpr;
import com.goide.psi.GoConversionExpr;
import com.goide.psi.GoElement;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportList;
import com.goide.psi.GoIndexOrSliceExpr;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoMulExpr;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoParenthesesExpr;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoResult;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarOrConstDeclaration;
import com.goide.psi.GoVarOrConstSpec;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoExpressionUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.stubs.GoTokenSets;
import com.goide.stubs.types.GoTypeStubElementType;
import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoFormattingBlock
extends UserDataHolderBase
implements ASTBlock {
    private static final Logger LOG = Logger.getInstance(GoFormattingBlock.class);
    private static final TokenSet BRACES_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GoTypes.LBRACE, GoTypes.RBRACE, GoTypes.LBRACK, GoTypes.RBRACK, GoTypes.LPAREN, GoTypes.RPAREN});
    private static final TokenSet BLOCK_START_WORDS_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GoTypes.INTERFACE, GoTypes.STRUCT, GoTypes.CASE, GoTypes.SWITCH_START, GoTypes.DEFAULT});
    private static final TokenSet ARGUMENT_LIST_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{GoTypes.ARGUMENT_LIST, GoTypes.BUILTIN_ARGUMENT_LIST});
    @NotNull
    final GoFormattingContext myContext;
    @Nullable
    private final GoFormattingBlock myParent;
    @NotNull
    private final PsiElement myPsi;
    @NotNull
    private final ASTNode myNode;
    @Nullable
    private final Alignment myAlignment;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Wrap myWrap;
    @Nullable
    private final GoChildrenAlignment myChildrenAlignment;
    private final int myExprDepth;
    @Nullable
    private List<Block> mySubBlocks;

    GoFormattingBlock(@NotNull GoFormattingContext context, @Nullable GoFormattingBlock parent, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable GoChildrenAlignment childrenAlignment, int exprDepth) {
        if (context == null) {
            GoFormattingBlock.$$$reportNull$$$0(0);
        }
        if (node == null) {
            GoFormattingBlock.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myParent = parent;
        this.myPsi = node.getPsi();
        this.myNode = node;
        this.myAlignment = alignment;
        this.myIndent = indent;
        this.myWrap = wrap;
        this.myChildrenAlignment = childrenAlignment;
        this.myExprDepth = exprDepth;
    }

    GoFormattingBlock(@NotNull GoFormattingBlock parent, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable GoChildrenAlignment childrenAlignment) {
        if (parent == null) {
            GoFormattingBlock.$$$reportNull$$$0(2);
        }
        if (node == null) {
            GoFormattingBlock.$$$reportNull$$$0(3);
        }
        this(parent.myContext, parent, node, alignment, indent, wrap, childrenAlignment, GoFormatterUtil.getChildExprDepth(parent, node.getPsi()));
    }

    @Nullable
    GoFormattingBlock getParent() {
        return this.myParent;
    }

    @NotNull
    private PsiElement getPsi() {
        PsiElement psiElement = this.myPsi;
        if (psiElement == null) {
            GoFormattingBlock.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @Nullable
    GoFormattingBlock findParentBlock(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(5);
        }
        for (GoFormattingBlock block = this; block != null; block = block.getParent()) {
            if (block.getPsi() != element) continue;
            return block;
        }
        return null;
    }

    @Nullable
    GoFormattingBlock findChildBlock(@NotNull PsiElement childElement) {
        if (childElement == null) {
            GoFormattingBlock.$$$reportNull$$$0(6);
        }
        for (Block block : this.getSubBlocks()) {
            GoFormattingBlock goBlock = (GoFormattingBlock)((Object)ObjectUtils.tryCast((Object)block, GoFormattingBlock.class));
            if (goBlock == null || childElement != goBlock.getPsi()) continue;
            return goBlock;
        }
        return null;
    }

    int getExprDepth() {
        return this.myExprDepth;
    }

    @NotNull
    private static Indent indentIfNotBrace(@NotNull ASTNode child) {
        if (child == null) {
            GoFormattingBlock.$$$reportNull$$$0(7);
        }
        Indent indent = BRACES_TOKEN_SET.contains(child.getElementType()) ? Indent.getNoneIndent() : Indent.getNormalIndent();
        if (indent == null) {
            GoFormattingBlock.$$$reportNull$$$0(8);
        }
        return indent;
    }

    private static boolean isTopLevelDeclaration(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(9);
        }
        return element instanceof GoPackageClause || element instanceof GoImportList || element instanceof GoTopLevelDeclaration;
    }

    private static boolean isNeedLineBreakAfterMultilineComment(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(10);
        }
        return element instanceof GoImportList || element instanceof GoTopLevelDeclaration;
    }

    private static Spacing lineBreak() {
        return GoFormattingBlock.lineBreak(true);
    }

    private static Spacing lineBreak(boolean keepLineBreaks) {
        return GoFormattingBlock.lineBreak(0, keepLineBreaks);
    }

    private static Spacing lineBreak(int lineBreaks, boolean keepLineBreaks) {
        return Spacing.createSpacing((int)0, (int)0, (int)(lineBreaks + 1), (boolean)keepLineBreaks, (int)(keepLineBreaks ? 1 : 0));
    }

    private static Spacing none() {
        return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
    }

    private static Spacing one() {
        return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
    }

    @NotNull
    public ASTNode getNode() {
        ASTNode aSTNode = this.myNode;
        if (aSTNode == null) {
            GoFormattingBlock.$$$reportNull$$$0(11);
        }
        return aSTNode;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myNode.getTextRange();
        if (textRange == null) {
            GoFormattingBlock.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.mySubBlocks == null) {
            this.mySubBlocks = this.buildSubBlocks();
        }
        List<Block> list = this.mySubBlocks;
        if (list == null) {
            GoFormattingBlock.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private List<Block> buildSubBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        PsiElement psi = this.myNode.getPsi();
        if (this.splitCallExpression(psi, blocks)) {
            ArrayList<Block> arrayList = blocks;
            if (arrayList == null) {
                GoFormattingBlock.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        if (this.splitReturnStatement(psi, blocks)) {
            ArrayList<Block> arrayList = blocks;
            if (arrayList == null) {
                GoFormattingBlock.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        GoFormattingRules formattingRules = this.myContext.getFormattingRules();
        Map<PsiElement, GoChildrenAlignment> childrenAlignmentMap = GoChildrenAlignment.buildChildrenAlignmentMap(psi, formattingRules, this.myChildrenAlignment);
        GoChildrenAlignment commentsAlignment = GoChildrenAlignment.buildCommentAlignment(this, psi, formattingRules, childrenAlignmentMap);
        Map<PsiElement, Wrap> childrenWrap = this.getChildrenWrap(psi);
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType childType = child.getElementType();
            if (child.getTextRange().getLength() == 0 || childType == TokenType.WHITE_SPACE) continue;
            PsiElement childPsi = child.getPsi();
            ContainerUtil.addIfNotNull(blocks, (Object)this.createVoidBlockBeforeChild(childPsi, commentsAlignment));
            Wrap childWrap = childrenWrap.get(childPsi);
            GoFormattingBlock e = this.buildSubBlock(child, childrenAlignmentMap.get(childPsi), commentsAlignment.getAlignment(childPsi), childWrap);
            blocks.add((Block)e);
            ContainerUtil.addIfNotNull(blocks, (Object)this.createVoidBlockAfterChild(childPsi));
        }
        ArrayList<Block> arrayList = blocks;
        if (arrayList == null) {
            GoFormattingBlock.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @NotNull
    private Map<PsiElement, Wrap> getChildrenWrap(@NotNull PsiElement parent) {
        if (parent == null) {
            GoFormattingBlock.$$$reportNull$$$0(17);
        }
        HashMap<PsiElement, Wrap> result = new HashMap<PsiElement, Wrap>();
        CommonCodeStyleSettings settings = this.myContext.getCommonCodeStyleSettings();
        GoCodeStyleSettings goSettings = this.myContext.getGoCodeStyleSettings();
        if (parent instanceof GoArgumentList) {
            Wrap childWrap = Wrap.createWrap((int)settings.CALL_PARAMETERS_WRAP, (boolean)true);
            for (PsiElement child : CollectionsKt.drop(GoPsiUtil.getArguments((GoArgumentList)parent), (int)1)) {
                result.put(child, childWrap);
            }
        } else if (parent instanceof GoLiteralValue) {
            Wrap childWrap = Wrap.createWrap((int)goSettings.WRAP_COMP_LIT, (boolean)true);
            for (GoElement child : CollectionsKt.drop(((GoLiteralValue)parent).getElementList(), (int)1)) {
                result.put(child, childWrap);
            }
        } else if (parent instanceof GoParameters) {
            Wrap childWrap = parent.getParent() instanceof GoResult ? Wrap.createWrap((int)goSettings.WRAP_FUNC_RESULT, (boolean)true) : Wrap.createWrap((int)goSettings.WRAP_FUNC_PARAMS, (boolean)true);
            for (GoParameterDeclaration child : CollectionsKt.drop(((GoParameters)parent).getParameterDeclarationList(), (int)1)) {
                result.put(child, childWrap);
            }
        } else if (GoFormatterUtil.isLongOneLineFunctionBlock(parent)) {
            for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child instanceof LeafPsiElement && child.getElementType() != GoTypes.RBRACE) continue;
                result.put(child.getPsi(), Wrap.createWrap((WrapType)WrapType.ALWAYS, (boolean)true));
            }
        }
        HashMap<PsiElement, Wrap> hashMap = result;
        if (hashMap == null) {
            GoFormattingBlock.$$$reportNull$$$0(18);
        }
        return hashMap;
    }

    private boolean splitCallExpression(@NotNull PsiElement element, @NotNull List<Block> blocks) {
        GoQualifier qualifier;
        String lastLine;
        GoCallExpr call;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(19);
        }
        if (blocks == null) {
            GoFormattingBlock.$$$reportNull$$$0(20);
        }
        if ((call = (GoCallExpr)ObjectUtils.tryCast((Object)element, GoCallExpr.class)) == null) {
            return false;
        }
        GoReferenceExpression expression = (GoReferenceExpression)ObjectUtils.tryCast((Object)call.getExpression(), GoReferenceExpression.class);
        String text = expression != null ? expression.getText() : "";
        int lastLineStart = text.lastIndexOf("\n");
        if (lastLineStart >= 0 && !(lastLine = text.substring(lastLineStart)).contains(".") && GoFormatterUtil.isMultiline(call.getArgumentList(), this.myContext.getFormattingRules()) && (qualifier = expression.getQualifier()) != null) {
            PsiElement identifier = expression.getIdentifier();
            blocks.add((Block)new GoCallQualifierBlock(this, this.myNode, qualifier, identifier));
            blocks.add((Block)new GoCallArgListBlock(this, this.myNode, identifier, call.getArgumentList()));
            return true;
        }
        return false;
    }

    private boolean splitReturnStatement(@NotNull PsiElement element, @NotNull List<Block> blocks) {
        GoReturnStatement returnStmt;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(21);
        }
        if (blocks == null) {
            GoFormattingBlock.$$$reportNull$$$0(22);
        }
        if ((returnStmt = (GoReturnStatement)ObjectUtils.tryCast((Object)element, GoReturnStatement.class)) != null && this.shouldIndentExpressions(returnStmt)) {
            for (ASTNode node = returnStmt.getFirstChild().getNode(); node != null; node = node.getTreeNext()) {
                if (GoFormatterUtil.isEmptyOrWhitespace(node)) continue;
                Indent indent = node.getPsi() instanceof GoExpression ? Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true) : null;
                blocks.add((Block)new GoFormattingBlock(this, node, null, indent, null, null));
            }
            return true;
        }
        return false;
    }

    private boolean shouldIndentExpressions(@NotNull GoReturnStatement returnStmt) {
        List<GoExpression> expressions;
        if (returnStmt == null) {
            GoFormattingBlock.$$$reportNull$$$0(23);
        }
        if ((expressions = returnStmt.getExpressionList()).size() >= 2) {
            PsiElement prev = returnStmt.getReturn();
            int multilineCount = 0;
            for (GoExpression expression : expressions) {
                if (GoFormatterUtil.countNewLinesBetween(prev, expression) != 0) {
                    return true;
                }
                if (GoFormatterUtil.isMultiline(expression, this.myContext.getFormattingRules())) {
                    ++multilineCount;
                }
                prev = expression;
            }
            return multilineCount > 1;
        }
        return false;
    }

    @Nullable
    private Block createVoidBlockBeforeChild(@NotNull PsiElement child, @NotNull GoChildrenAlignment commentsAlignment) {
        Alignment voidBlockAlignment;
        if (child == null) {
            GoFormattingBlock.$$$reportNull$$$0(24);
        }
        if (commentsAlignment == null) {
            GoFormattingBlock.$$$reportNull$$$0(25);
        }
        Alignment alignment = voidBlockAlignment = this.myChildrenAlignment != null ? this.myChildrenAlignment.getVoidBlockAlignmentBefore(child) : null;
        if (voidBlockAlignment == null && child instanceof PsiComment) {
            voidBlockAlignment = commentsAlignment.getVoidBlockAlignmentBefore(child);
        }
        if (voidBlockAlignment == null) {
            return null;
        }
        int offset = child.getTextRange().getStartOffset();
        return new VoidBlock(offset, voidBlockAlignment);
    }

    @Nullable
    private Block createVoidBlockAfterChild(@NotNull PsiElement child) {
        Alignment voidBlockAlignment;
        if (child == null) {
            GoFormattingBlock.$$$reportNull$$$0(26);
        }
        Alignment alignment = voidBlockAlignment = this.myChildrenAlignment != null ? this.myChildrenAlignment.getVoidBlockAlignmentAfter(child) : null;
        if (voidBlockAlignment == null) {
            return null;
        }
        int offset = child.getTextRange().getEndOffset();
        return new VoidBlock(offset, voidBlockAlignment);
    }

    @NotNull
    private GoFormattingBlock buildSubBlock(@NotNull ASTNode child, @Nullable GoChildrenAlignment childrenAlignment, @Nullable Alignment alignmentForComment, @Nullable Wrap wrap) {
        if (child == null) {
            GoFormattingBlock.$$$reportNull$$$0(27);
        }
        Alignment alignment = this.getAlignment(child.getPsi(), alignmentForComment);
        Indent indent = this.calcIndent(child);
        IElementType type2 = child.getElementType();
        if (type2 == GoParserDefinition.Lazy.LINE_COMMENT) {
            return new GoLineCommentBlock(this, child, alignment, indent, childrenAlignment);
        }
        if (type2 == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
            return new GoMultilineCommentBlock(this, child, alignment, indent, childrenAlignment);
        }
        return type2 == GoTypes.RAW_STRING && child.textContains('\n') ? new GoRawStringFormattingBlock(this, child, alignment, childrenAlignment) : new GoFormattingBlock(this, child, alignment, indent, wrap, childrenAlignment);
    }

    @Nullable
    private Alignment getAlignment(@NotNull PsiElement psi, @Nullable Alignment alignmentForComment) {
        if (psi == null) {
            GoFormattingBlock.$$$reportNull$$$0(28);
        }
        if (psi instanceof PsiComment) {
            return alignmentForComment;
        }
        return this.myChildrenAlignment != null ? this.myChildrenAlignment.getAlignment(psi) : null;
    }

    @NotNull
    private Indent calcIndent(@NotNull ASTNode child) {
        if (child == null) {
            GoFormattingBlock.$$$reportNull$$$0(29);
        }
        IElementType parentType = this.myNode.getElementType();
        IElementType type2 = child.getElementType();
        PsiElement psi = child.getPsi();
        if (type2 == GoTypes.PARAM_DEFINITION) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(30);
            }
            return indent;
        }
        if (type2 == GoTypes.VAR_DEFINITION || type2 == GoTypes.CONST_DEFINITION) {
            if (parentType == GoTypes.SHORT_VAR_DECLARATION) {
                Indent indent = Indent.getContinuationWithoutFirstIndent();
                if (indent == null) {
                    GoFormattingBlock.$$$reportNull$$$0(31);
                }
                return indent;
            }
            if (GoFormattingBlock.isSpecInDeclarationWithoutLParen(this.myNode)) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    GoFormattingBlock.$$$reportNull$$$0(32);
                }
                return indent;
            }
        }
        if (parentType == GoTypes.PARAMETER_DECLARATION && type2 instanceof GoTypeStubElementType) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(33);
            }
            return indent;
        }
        if (parentType == GoTypes.TYPE_LIST && type2 instanceof GoTypeStubElementType) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(34);
            }
            return indent;
        }
        if (type2 == GoTypes.LABELED_STATEMENT) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(35);
            }
            return indent;
        }
        if (parentType == GoTypes.LABELED_STATEMENT && (psi instanceof GoStatement || GoParserDefinition.Lazy.COMMENTS.contains(type2))) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(36);
            }
            return indent;
        }
        if (BLOCK_START_WORDS_TOKEN_SET.contains(type2)) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(37);
            }
            return indent;
        }
        if (type2 == GoTypes.COMM_CASE) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(38);
            }
            return indent;
        }
        if (ARGUMENT_LIST_TOKEN_SET.contains(parentType) && type2 != GoTypes.LPAREN && type2 != GoTypes.RPAREN) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(39);
            }
            return indent;
        }
        if (parentType == GoTypes.LITERAL_VALUE && psi instanceof PsiComment && !this.myContext.getFormattingRules().indentLiteralLoneComments() && GoFormatterUtil.consistsOfCommentsAndWhitespaces(this.myNode.getPsi())) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(40);
            }
            return indent;
        }
        if (GoTokenSets.BLOCKS.contains(parentType)) {
            return GoFormattingBlock.isCommentBeforeCase(type2, parentType, psi) ? Indent.getNoneIndent() : GoFormattingBlock.indentIfNotBrace(child);
        }
        if (GoTokenSets.SWITCH_STATEMENTS.contains(parentType) && GoParserDefinition.Lazy.COMMENTS.contains(type2)) {
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)psi);
            IElementType prevSiblingType = prevSibling != null ? prevSibling.getNode().getElementType() : null;
            boolean beforeFirstCaseClause = prevSiblingType == GoTypes.LBRACE;
            Indent indent = beforeFirstCaseClause ? Indent.getNoneIndent() : Indent.getNormalIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(41);
            }
            return indent;
        }
        if (parentType == GoTypes.IMPORT_DECLARATION) {
            Indent indent = this.indentOfMultipleDeclarationChild(type2, GoTypes.IMPORT_SPEC);
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(42);
            }
            return indent;
        }
        if (parentType == GoTypes.CONST_DECLARATION) {
            Indent indent = this.indentOfMultipleDeclarationChild(type2, GoTypes.CONST_SPEC);
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(43);
            }
            return indent;
        }
        if (parentType == GoTypes.VAR_DECLARATION) {
            Indent indent = this.indentOfMultipleDeclarationChild(type2, GoTypes.VAR_SPEC);
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(44);
            }
            return indent;
        }
        if (parentType == GoTypes.TYPE_DECLARATION) {
            Indent indent = this.indentOfMultipleDeclarationChild(type2, GoTypes.TYPE_SPEC);
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(45);
            }
            return indent;
        }
        if (parentType == GoTypes.REFERENCE_EXPRESSION && (type2 == GoTypes.IDENTIFIER || GoParserDefinition.Lazy.COMMENTS.contains(type2)) && FormatterUtil.hasPrecedingSiblingOfType((ASTNode)child, (IElementType)GoTypes.DOT, (IElementType[])new IElementType[0])) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(46);
            }
            return indent;
        }
        if (psi instanceof GoExpression) {
            Indent indent = GoFormattingBlock.isInsideVarOrConstSpecAfterComment(psi) ? Indent.getNoneIndent() : Indent.getContinuationWithoutFirstIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(47);
            }
            return indent;
        }
        if (GoParserDefinition.Lazy.COMMENTS.contains(type2)) {
            if (this.myNode.getPsi() instanceof GoExpression) {
                Indent indent = Indent.getContinuationWithoutFirstIndent();
                if (indent == null) {
                    GoFormattingBlock.$$$reportNull$$$0(48);
                }
                return indent;
            }
            Indent indent = GoTokenSets.BLOCKS.contains(parentType) ? Indent.getNormalIndent() : Indent.getNoneIndent();
            if (indent == null) {
                GoFormattingBlock.$$$reportNull$$$0(49);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            GoFormattingBlock.$$$reportNull$$$0(50);
        }
        return indent;
    }

    private static boolean isInsideVarOrConstSpecAfterComment(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(51);
        }
        if (element.getParent() instanceof GoVarOrConstSpec) {
            PsiComment comment = (PsiComment)ObjectUtils.tryCast((Object)PsiTreeUtil.prevVisibleLeaf((PsiElement)element), PsiComment.class);
            PsiElement beforeComment = comment != null ? PsiTreeUtil.prevVisibleLeaf((PsiElement)comment) : null;
            return beforeComment != null && beforeComment.textMatches((CharSequence)"=");
        }
        return false;
    }

    private static boolean isSpecInDeclarationWithoutLParen(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            GoFormattingBlock.$$$reportNull$$$0(52);
        }
        if ((nodeType = node.getElementType()) != GoTypes.VAR_SPEC && nodeType != GoTypes.CONST_SPEC) {
            return false;
        }
        ASTNode parent = node.getTreeParent();
        return parent != null && (parent.getElementType() == GoTypes.VAR_DECLARATION || parent.getElementType() == GoTypes.CONST_DECLARATION) && ((GoVarOrConstDeclaration)parent.getPsi()).getLparen() == null;
    }

    private static boolean isCommentBeforeCase(@NotNull IElementType type2, @NotNull IElementType parentType, @NotNull PsiElement psi) {
        if (type2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(53);
        }
        if (parentType == null) {
            GoFormattingBlock.$$$reportNull$$$0(54);
        }
        if (psi == null) {
            GoFormattingBlock.$$$reportNull$$$0(55);
        }
        if (GoParserDefinition.Lazy.COMMENTS.contains(type2) && GoTokenSets.CASE_CLAUSES.contains(parentType)) {
            PsiElement nextSibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)psi);
            IElementType nextType = nextSibling != null ? nextSibling.getNode().getElementType() : null;
            return nextType == GoTypes.CASE || nextType == GoTypes.DEFAULT || nextSibling instanceof GoCommCase;
        }
        return false;
    }

    private Indent indentOfMultipleDeclarationChild(@NotNull IElementType childType, @NotNull IElementType specType) {
        if (childType == null) {
            GoFormattingBlock.$$$reportNull$$$0(56);
        }
        if (specType == null) {
            GoFormattingBlock.$$$reportNull$$$0(57);
        }
        if (childType == specType) {
            return Indent.getNormalIndent();
        }
        return GoParserDefinition.Lazy.COMMENTS.contains(childType) && this.myNode.findChildByType(specType) != null ? Indent.getNormalIndent() : Indent.getNoneIndent();
    }

    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(58);
        }
        if (child1 instanceof VoidBlock || child1 != null && ContainerUtil.getLastItem((List)child1.getSubBlocks()) instanceof VoidBlock) {
            return GoFormattingBlock.none();
        }
        if (child2 instanceof VoidBlock) {
            return GoFormattingBlock.one();
        }
        if (child1 instanceof GoFormattingBlock && child2 instanceof GoFormattingBlock) {
            Spacing spacingInBlock;
            ASTNode n1 = ((GoFormattingBlock)child1).getNode();
            ASTNode n2 = ((GoFormattingBlock)child2).getNode();
            PsiElement psi1 = n1.getPsi();
            PsiElement psi2 = n2.getPsi();
            IElementType type1 = n1.getElementType();
            IElementType type2 = n2.getElementType();
            if (psi1 == null || psi2 == null) {
                LOG.error("Cannot calculate spacing between:\n" + type1 + ": '" + n1.getText() + "' and \n" + type2 + ": '" + n2.getText() + "'\n");
                return this.myContext.getSpacingBuilder().getSpacing((Block)this, child1, child2);
            }
            if (type1 == GoTypes.FIELD_DEFINITION && psi2 instanceof GoType) {
                return GoFormattingBlock.one();
            }
            PsiElement parent = psi1.getParent();
            if ((type1 == GoTypes.COLON || type2 == GoTypes.COLON) && parent instanceof GoIndexOrSliceExpr) {
                return this.spacingForSliceIndices(type1, type2, type1 == GoTypes.COLON ? psi1 : psi2, (GoIndexOrSliceExpr)parent);
            }
            if (psi2 instanceof PsiErrorElement && psi2.textMatches((CharSequence)"{")) {
                return GoFormattingBlock.one();
            }
            if (type2 == GoTypes.ELSE && !(psi2.getParent() instanceof GoElseStatement)) {
                return GoFormattingBlock.one();
            }
            if (psi1 instanceof GoIfStatement && psi2 instanceof PsiErrorElement && psi2.textMatches((CharSequence)"else")) {
                return GoFormattingBlock.one();
            }
            Spacing spacingForStructOrInterfaceType = this.getSpacingForStructOrInterfaceType(parent, type1, type2);
            if (spacingForStructOrInterfaceType != null) {
                return spacingForStructOrInterfaceType;
            }
            Spacing topLevelDeclarationsSpacing = GoFormattingBlock.getTopLevelDeclarationSpacing(psi1, psi2, type1);
            if (topLevelDeclarationsSpacing != null) {
                return topLevelDeclarationsSpacing;
            }
            if (psi1 instanceof GoStatement && psi2 instanceof GoStatement) {
                return GoFormattingBlock.lineBreak();
            }
            if (parent instanceof GoBlock && (spacingInBlock = this.getSpacingInBlock(type1, type2, (GoBlock)parent)) != null) {
                return spacingInBlock;
            }
            for (GoDependentLFSpacingSettings d : this.myContext.getDependentLFSpacingSettings()) {
                Spacing spacing = d.getSpacing(parent, type1, type2);
                if (spacing == null) continue;
                return spacing;
            }
            Spacing spacingForComments = this.getSpacingForComment(parent, psi1, psi2, type1, type2);
            if (spacingForComments != null) {
                return spacingForComments;
            }
            if ((type1 == GoTypes.VAR_DEFINITION || type1 == GoTypes.CONST_DEFINITION) && psi2 instanceof GoType) {
                return GoFormattingBlock.one();
            }
            if (type1 == GoTypes.IDENTIFIER && psi2 instanceof GoType && parent instanceof GoSpecType) {
                return GoFormattingBlock.one();
            }
            if (type2 == GoTypes.RBRACE && psi1 instanceof GoLabeledStatement && ((GoLabeledStatement)psi1).getStatement() == null) {
                return GoFormattingBlock.lineBreak(0, false);
            }
            if (parent instanceof GoBinaryExpr && this.myContext.getFormattingRules().useDepthAlgorithmForBinaryExpressions()) {
                boolean comments = GoParserDefinition.Lazy.COMMENTS.contains(type1) || GoParserDefinition.Lazy.COMMENTS.contains(type2);
                PsiElement operator = ((GoBinaryExpr)parent).getOperator();
                if (!(comments || operator == null || psi1 != operator && psi2 != operator)) {
                    int cutoff = GoFormatterUtil.cutoff(this.myContext, (GoBinaryExpr)parent, this.myExprDepth);
                    int precedence = GoFormatterUtil.getPrecedence(operator.getNode().getElementType());
                    boolean printBlank = precedence < cutoff;
                    return printBlank ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0) : Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)0);
                }
            }
            if ((parent instanceof GoAddExpr || parent instanceof GoMulExpr) && this.mustNotHaveSpacing(parent, psi2)) {
                return GoFormattingBlock.none();
            }
        }
        return this.myContext.getSpacingBuilder().getSpacing((Block)this, child1, child2);
    }

    private Spacing getSpacingInBlock(@NotNull IElementType type1, @NotNull IElementType type2, @NotNull GoBlock block) {
        if (type1 == null) {
            GoFormattingBlock.$$$reportNull$$$0(59);
        }
        if (type2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(60);
        }
        if (block == null) {
            GoFormattingBlock.$$$reportNull$$$0(61);
        }
        PsiElement grandParent = block.getParent();
        if (type1 == GoTypes.LBRACE && type2 == GoTypes.RBRACE && !(grandParent instanceof GoSignatureOwner)) {
            return GoFormattingBlock.lineBreak(0, true);
        }
        if (!(!(grandParent instanceof GoSignatureOwner) || GoFormatterUtil.isMultiline(block, this.myContext.getFormattingRules()) || type1 != GoTypes.SEMICOLON && type1 != GoTypes.LBRACE && type2 != GoTypes.RBRACE || GoFormatterUtil.isMultiline(grandParent, this.myContext.getFormattingRules()))) {
            return type1 == GoTypes.LBRACE && type2 == GoTypes.RBRACE ? GoFormattingBlock.none() : GoFormattingBlock.one();
        }
        return null;
    }

    private static Spacing getTopLevelDeclarationSpacing(@NotNull PsiElement psi1, @NotNull PsiElement psi2, @NotNull IElementType type1) {
        if (psi1 == null) {
            GoFormattingBlock.$$$reportNull$$$0(62);
        }
        if (psi2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(63);
        }
        if (type1 == null) {
            GoFormattingBlock.$$$reportNull$$$0(64);
        }
        if (GoFormattingBlock.isTopLevelDeclaration(psi2) && (GoFormattingBlock.isTopLevelDeclaration(psi1) || type1 == GoTypes.SEMICOLON)) {
            boolean sameKind = psi1.getClass().equals(psi2.getClass()) || psi1 instanceof GoFunctionOrMethodDeclaration && psi2 instanceof GoFunctionOrMethodDeclaration;
            return sameKind ? GoFormattingBlock.lineBreak() : GoFormattingBlock.lineBreak(1, true);
        }
        return null;
    }

    @NotNull
    private Spacing spacingForSliceIndices(@NotNull IElementType type1, @NotNull IElementType type2, @NotNull PsiElement colon, @NotNull GoIndexOrSliceExpr slice) {
        if (type1 == null) {
            GoFormattingBlock.$$$reportNull$$$0(65);
        }
        if (type2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(66);
        }
        if (colon == null) {
            GoFormattingBlock.$$$reportNull$$$0(67);
        }
        if (slice == null) {
            GoFormattingBlock.$$$reportNull$$$0(68);
        }
        if (type1 == GoTypes.LBRACK && type2 == GoTypes.COLON) {
            Spacing spacing = GoFormattingBlock.none();
            if (spacing == null) {
                GoFormattingBlock.$$$reportNull$$$0(69);
            }
            return spacing;
        }
        if (this.myExprDepth > 1) {
            Spacing spacing = GoFormattingBlock.none();
            if (spacing == null) {
                GoFormattingBlock.$$$reportNull$$$0(70);
            }
            return spacing;
        }
        if (!this.myContext.getFormattingRules().splitSliceIndices()) {
            PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)colon);
            if (!(next instanceof GoExpression)) {
                Spacing spacing = GoFormattingBlock.none();
                if (spacing == null) {
                    GoFormattingBlock.$$$reportNull$$$0(71);
                }
                return spacing;
            }
            PsiElement previous = PsiTreeUtil.skipWhitespacesBackward((PsiElement)colon);
            if (!(previous instanceof GoExpression)) {
                Spacing spacing = GoFormattingBlock.none();
                if (spacing == null) {
                    GoFormattingBlock.$$$reportNull$$$0(72);
                }
                return spacing;
            }
            Spacing spacing = previous instanceof GoBinaryExpr || next instanceof GoBinaryExpr ? GoFormattingBlock.one() : GoFormattingBlock.none();
            if (spacing == null) {
                GoFormattingBlock.$$$reportNull$$$0(73);
            }
            return spacing;
        }
        Trinity<GoExpression, GoExpression, GoExpression> indices = slice.getIndices();
        List expressions = (List)ContainerUtil.addAllNotNull(new ArrayList(), (Object[])new GoExpression[]{(GoExpression)indices.first, (GoExpression)indices.second, (GoExpression)indices.third});
        if (expressions.size() > 1) {
            for (GoExpression expression : expressions) {
                if (!(expression instanceof GoBinaryExpr)) continue;
                Spacing spacing = GoFormattingBlock.one();
                if (spacing == null) {
                    GoFormattingBlock.$$$reportNull$$$0(74);
                }
                return spacing;
            }
        }
        Spacing spacing = GoFormattingBlock.none();
        if (spacing == null) {
            GoFormattingBlock.$$$reportNull$$$0(75);
        }
        return spacing;
    }

    private boolean mustNotHaveSpacing(@NotNull PsiElement expression, @Nullable PsiElement psi2) {
        if (expression == null) {
            GoFormattingBlock.$$$reportNull$$$0(76);
        }
        if (!(expression instanceof GoBinaryExpr)) {
            return false;
        }
        PsiElement parent = expression.getParent();
        GoExpression right = ((GoBinaryExpr)expression).getRight();
        if (right instanceof GoUnaryExpr && GoFormattingBlock.needSpace((GoUnaryExpr)right)) {
            return false;
        }
        if (GoFormatterUtil.isMultiline(expression, this.myContext.getFormattingRules())) {
            return !(psi2 instanceof PsiComment) && !GoFormatterUtil.isFirstElementOnLine(psi2) && (GoFormattingBlock.isInArgumentListWithFewArguments(expression) || GoFormattingBlock.hasBinaryExpressionParentOfAnotherType(expression));
        }
        if (parent instanceof GoIndexOrSliceExpr) {
            return true;
        }
        if (GoFormattingBlock.isMultipleAssignment(parent)) {
            return true;
        }
        if (GoFormattingBlock.isInIndexOrMultipleAssignmentOrArgumentListWithFewArguments(expression)) {
            return !(psi2 instanceof PsiComment);
        }
        if (!(psi2 instanceof PsiComment) && GoFormattingBlock.hasBinaryExpressionParentOfAnotherType(expression)) {
            return true;
        }
        if (GoFormattingBlock.hasBoolExpressionParent(expression)) {
            return true;
        }
        if (GoPsiTreeUtil.goTraverser().api.parents((Object)expression).filter(GoFormattingBlock::isInIndex).size() > 1) {
            return true;
        }
        PsiElement firstNotParensParent = PsiTreeUtil.skipParentsOfType((PsiElement)expression, (Class[])new Class[]{GoParenthesesExpr.class});
        if (firstNotParensParent instanceof GoAddExpr || firstNotParensParent instanceof GoMulExpr) {
            return this.mustNotHaveSpacing(firstNotParensParent, psi2);
        }
        return GoFormattingBlock.isInMultiArgumentsCall(expression);
    }

    private static boolean isInMultiArgumentsCall(@NotNull PsiElement expression) {
        GoArgumentList arguments;
        if (expression == null) {
            GoFormattingBlock.$$$reportNull$$$0(77);
        }
        GoCallExpr call = (GoCallExpr)ObjectUtils.tryCast((Object)((arguments = (GoArgumentList)ObjectUtils.tryCast((Object)expression.getParent(), GoArgumentList.class)) != null ? arguments.getParent() : null), GoCallExpr.class);
        while (call != null) {
            PsiElement callParent = call.getParent();
            if (callParent instanceof GoReferenceExpression) {
                call = (GoCallExpr)ObjectUtils.tryCast((Object)callParent.getParent(), GoCallExpr.class);
                if (call == null || call.getArgumentList().getExpressionList().size() <= 1) continue;
                return true;
            }
            if (!(callParent instanceof GoArgumentList)) break;
            call = (GoCallExpr)ObjectUtils.tryCast((Object)callParent.getParent(), GoCallExpr.class);
        }
        return false;
    }

    private static boolean needSpace(@NotNull GoUnaryExpr expression) {
        PsiElement operator;
        IElementType operatorType;
        if (expression == null) {
            GoFormattingBlock.$$$reportNull$$$0(78);
        }
        IElementType iElementType = operatorType = (operator = expression.getOperator()) != null ? operator.getNode().getElementType() : null;
        if (operatorType == GoTypes.PLUS || operatorType == GoTypes.MINUS || operatorType == GoTypes.BIT_AND) {
            return GoFormattingBlock.hasPrevSiblingWithNodeType(expression, operatorType);
        }
        if (operatorType == GoTypes.MUL) {
            return GoFormattingBlock.hasPrevSiblingWithNodeType(expression, GoTypes.QUOTIENT);
        }
        if (operatorType == GoTypes.BIT_XOR) {
            return GoFormattingBlock.hasPrevSiblingWithNodeType(expression, GoTypes.BIT_AND);
        }
        return false;
    }

    private static boolean hasPrevSiblingWithNodeType(@NotNull PsiElement element, @NotNull IElementType nodeType) {
        PsiElement prev;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(79);
        }
        if (nodeType == null) {
            GoFormattingBlock.$$$reportNull$$$0(80);
        }
        return (prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class})) != null && prev.getNode().getElementType() == nodeType;
    }

    private static boolean hasBoolExpressionParent(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(81);
        }
        return GoExpressionUtil.isBoolExpression((parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{GoMulExpr.class, GoAddExpr.class, GoParenthesesExpr.class})) instanceof GoConditionalExpr ? parent.getParent() : parent);
    }

    private static boolean isInIndexOrMultipleAssignmentOrArgumentListWithFewArguments(@NotNull PsiElement element) {
        PsiElement find;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(82);
        }
        return (find = (PsiElement)GoPsiTreeUtil.goTraverser().api.parents((Object)element.getParent()).takeWhile(e -> e instanceof GoArgumentList || e instanceof GoConversionExpr || e instanceof GoCallExpr).find(e -> e instanceof GoBuiltinArgumentList || e instanceof GoArgumentList && ((GoArgumentList)e).getExpressionList().size() > 1 || e instanceof GoExpression && GoFormattingBlock.isInBinaryExpressionOrIndexOrMultipleAssignment(e))) != null;
    }

    private static boolean isInArgumentListWithFewArguments(@NotNull PsiElement element) {
        PsiElement find;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(83);
        }
        return (find = (PsiElement)GoPsiTreeUtil.goTraverser().api.parents((Object)element.getParent()).takeWhile(e -> e instanceof GoBinaryExpr || e instanceof GoArgumentList || e instanceof GoConversionExpr || e instanceof GoCallExpr).find(e -> e instanceof GoBuiltinArgumentList || e instanceof GoArgumentList && ((GoArgumentList)e).getExpressionList().size() > 1)) != null;
    }

    private static boolean hasBinaryExpressionParentOfAnotherType(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(84);
        }
        boolean mul = element instanceof GoMulExpr;
        return PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{mul ? GoMulExpr.class : GoAddExpr.class}) instanceof GoBinaryExpr;
    }

    private static boolean isInBinaryExpressionOrIndexOrMultipleAssignment(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(85);
        }
        return (parent = element.getParent()) instanceof GoBinaryExpr || GoFormattingBlock.isMultipleAssignment(parent) || GoFormattingBlock.isInIndex(element);
    }

    private static boolean isInIndex(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(86);
        }
        PsiElement parent = element.getParent();
        return element instanceof GoExpression && parent instanceof GoIndexOrSliceExpr && ((GoIndexOrSliceExpr)parent).getExpression() != element;
    }

    private static boolean isMultipleAssignment(@NotNull PsiElement element) {
        if (element == null) {
            GoFormattingBlock.$$$reportNull$$$0(87);
        }
        return element instanceof GoAssignmentStatement && ((GoAssignmentStatement)element).getExpressionList().size() > 1 || element instanceof GoVarSpec && ((GoVarSpec)element).getExpressionList().size() > 1;
    }

    @Nullable
    private Spacing getSpacingForComment(@NotNull PsiElement parent, @NotNull PsiElement psi1, @NotNull PsiElement psi2, @NotNull IElementType type1, @NotNull IElementType type2) {
        if (parent == null) {
            GoFormattingBlock.$$$reportNull$$$0(88);
        }
        if (psi1 == null) {
            GoFormattingBlock.$$$reportNull$$$0(89);
        }
        if (psi2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(90);
        }
        if (type1 == null) {
            GoFormattingBlock.$$$reportNull$$$0(91);
        }
        if (type2 == null) {
            GoFormattingBlock.$$$reportNull$$$0(92);
        }
        boolean secondIsComment = GoParserDefinition.Lazy.COMMENTS.contains(type2);
        if (type1 == GoParserDefinition.Lazy.MULTILINE_COMMENT || GoFormattingBlock.isTopLevelDeclaration(psi1) && secondIsComment) {
            if (GoFormatterUtil.countNewLinesBetween(psi1, psi2) != 0) {
                return !GoParserDefinition.Lazy.COMMENTS.contains(type1) ? GoFormattingBlock.lineBreak(1, true) : GoFormattingBlock.lineBreak(0, true);
            }
            if (type1 == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
                if (GoFormatterUtil.isMultiline(psi1, this.myContext.getFormattingRules()) || type2 == GoTypes.RPAREN) {
                    return GoFormattingBlock.none();
                }
                if (GoFormattingBlock.isNeedLineBreakAfterMultilineComment(psi2)) {
                    return GoFormattingBlock.lineBreak(false);
                }
                if (type2 == GoTypes.COMMA) {
                    return GoFormattingBlock.none();
                }
                if (type2 == GoTypes.RBRACE) {
                    if (parent.getNode().getElementType() == GoTypes.BLOCK) {
                        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                    }
                    PsiElement elementBeforeComment = PsiTreeUtil.skipWhitespacesBackward((PsiElement)psi1);
                    boolean loneComment = elementBeforeComment != null && elementBeforeComment.getNode().getElementType() == GoTypes.LBRACE;
                    return loneComment ? GoFormattingBlock.one() : GoFormattingBlock.none();
                }
                return GoFormattingBlock.one();
            }
        }
        return null;
    }

    @Nullable
    private Spacing getSpacingForStructOrInterfaceType(PsiElement parent, IElementType type1, IElementType type2) {
        boolean oneLineType;
        if (!(parent instanceof GoStructType) && !(parent instanceof GoInterfaceType)) {
            return null;
        }
        boolean bl = oneLineType = !GoFormatterUtil.isMultiline(parent, this.myContext.getFormattingRules());
        if ((type1 == GoTypes.STRUCT || type1 == GoTypes.INTERFACE) && type2 == GoTypes.LBRACE) {
            return oneLineType ? GoFormattingBlock.none() : GoFormattingBlock.one();
        }
        if (type1 == GoTypes.LBRACE && type2 == GoTypes.RBRACE) {
            return oneLineType ? GoFormattingBlock.none() : GoFormattingBlock.lineBreak(false);
        }
        if (type1 == GoTypes.LBRACE && GoParserDefinition.Lazy.COMMENTS.contains(type2)) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)1);
        }
        if (type1 == GoTypes.LBRACE || type2 == GoTypes.RBRACE) {
            return oneLineType ? GoFormattingBlock.one() : GoFormattingBlock.lineBreak(GoParserDefinition.Lazy.COMMENTS.contains(type1));
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Indent childIndent = Indent.getNoneIndent();
        IElementType parentType = this.myNode.getElementType();
        if (GoTokenSets.BLOCKS.contains(parentType) || parentType == GoTypes.IMPORT_DECLARATION || parentType == GoTypes.CONST_DECLARATION || parentType == GoTypes.VAR_DECLARATION || parentType == GoTypes.TYPE_DECLARATION || ARGUMENT_LIST_TOKEN_SET.contains(parentType)) {
            childIndent = Indent.getNormalIndent();
        }
        if (parentType == GoTypes.EXPR_SWITCH_STATEMENT || parentType == GoTypes.TYPE_SWITCH_STATEMENT || parentType == GoTypes.SELECT_STATEMENT) {
            Block block;
            List<Block> subBlocks = this.getSubBlocks();
            Block block2 = block = subBlocks.size() > newChildIndex ? subBlocks.get(newChildIndex - 1) : null;
            if (block instanceof GoFormattingBlock && ((GoFormattingBlock)block).getNode().getElementType() != GoTypes.LBRACE) {
                childIndent = Indent.getNormalIndent((boolean)true);
            }
        }
        return new ChildAttributes(childIndent, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 8, 11, 12, 13, 14, 15, 16, 18, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 69, 70, 71, 72, 73, 74, 75 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 17: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/formatter/GoFormattingBlock";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 19: 
            case 21: 
            case 51: 
            case 79: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 7: 
            case 24: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStmt";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentsAlignment";
                break;
            }
            case 28: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 59: 
            case 64: 
            case 65: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 60: 
            case 66: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 62: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi1";
                break;
            }
            case 63: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi2";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colon";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "slice";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/formatter/GoFormattingBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsi";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "indentIfNotBrace";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSubBlocks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenWrap";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIndent";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "spacingForSliceIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findParentBlock";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildBlock";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "indentIfNotBrace";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNeedLineBreakAfterMultilineComment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenWrap";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "splitCallExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "splitReturnStatement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndentExpressions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createVoidBlockBeforeChild";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createVoidBlockAfterChild";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildSubBlock";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAlignment";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "calcIndent";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isInsideVarOrConstSpecAfterComment";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isSpecInDeclarationWithoutLParen";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isCommentBeforeCase";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "indentOfMultipleDeclarationChild";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingInBlock";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelDeclarationSpacing";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "spacingForSliceIndices";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "mustNotHaveSpacing";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isInMultiArgumentsCall";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "needSpace";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "hasPrevSiblingWithNodeType";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "hasBoolExpressionParent";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isInIndexOrMultipleAssignmentOrArgumentListWithFewArguments";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isInArgumentListWithFewArguments";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "hasBinaryExpressionParentOfAnotherType";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isInBinaryExpressionOrIndexOrMultipleAssignment";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isInIndex";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isMultipleAssignment";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getSpacingForComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 8, 11, 12, 13, 14, 15, 16, 18, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 69, 70, 71, 72, 73, 74, 75 -> new IllegalStateException(string);
        };
    }

    private static final class VoidBlock
    implements Block {
        private final int offset;
        private final Alignment alignment;

        private VoidBlock(int offset, @Nullable Alignment alignment) {
            this.offset = offset;
            this.alignment = alignment;
        }

        @NotNull
        public TextRange getTextRange() {
            return new TextRange(this.offset, this.offset);
        }

        @NotNull
        public List<Block> getSubBlocks() {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                VoidBlock.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Nullable
        public Wrap getWrap() {
            return null;
        }

        @Nullable
        public Indent getIndent() {
            return null;
        }

        @Nullable
        public Alignment getAlignment() {
            return this.alignment;
        }

        @Nullable
        public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
            if (child2 == null) {
                VoidBlock.$$$reportNull$$$0(1);
            }
            return null;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            return new ChildAttributes(null, null);
        }

        public boolean isIncomplete() {
            return false;
        }

        public boolean isLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/formatter/GoFormattingBlock$VoidBlock";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubBlocks";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/formatter/GoFormattingBlock$VoidBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSpacing";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

