/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.frameworks.gofuzz;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/goide/execution/testing/frameworks/gofuzz/GoFuzzConsoleFilterBase;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectoryUrl", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "checkFileExistence", "", "getCheckFileExistence", "()Z", "pathPrefix", "getPathPrefix", "()Ljava/lang/String;", "pattern", "Ljava/util/regex/Pattern;", "getPattern", "()Ljava/util/regex/Pattern;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "intellij.go.impl"})
public abstract class GoFuzzConsoleFilterBase
implements Filter {
    @NotNull
    private final Project project;
    @NotNull
    private final String workingDirectoryUrl;
    private final boolean checkFileExistence;

    public GoFuzzConsoleFilterBase(@NotNull Project project, @NotNull String workingDirectoryUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workingDirectoryUrl, (String)"workingDirectoryUrl");
        this.project = project;
        this.workingDirectoryUrl = workingDirectoryUrl;
    }

    @NotNull
    protected abstract Pattern getPattern();

    @NotNull
    protected abstract String getPathPrefix();

    protected boolean getCheckFileExistence() {
        return this.checkFileExistence;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = this.getPattern().matcher(line);
        if (matcher.find()) {
            int lineStart = entireLength - line.length();
            String corpusFilePath = matcher.group("fuzzCorpusFilePath");
            String path = this.workingDirectoryUrl + "/" + this.getPathPrefix() + corpusFilePath;
            if (this.getCheckFileExistence() && VirtualFileManager.getInstance().findFileByUrl(path) == null) {
                return null;
            }
            HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)new UrlFilter.FileUrlHyperlinkInfo(this.project, VfsUtilCore.urlToPath((String)path), 0, 0, path, false);
            int startOffset = matcher.start("fuzzCorpusFilePath");
            int endOffset = matcher.end("fuzzCorpusFilePath");
            return new Filter.Result(lineStart + startOffset, lineStart + endOffset, hyperlinkInfo);
        }
        return null;
    }
}

