/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.creator;

import com.goide.codeInsight.imports.GoImportPackageQuickFix;
import com.goide.execution.testing.creator.GoStringBuilder;
import com.goide.formatter.GoFormatterUtil;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoPointerType;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameterDeclaration;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoElementFactory;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoStdlibUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTestGenerator {
    static final String TESTIFY_ASSERT_PACKAGE = "github.com/stretchr/testify/assert";
    private final GoFile myTargetTestFile;
    private final String myTestPackageName;
    private final String myTestImportPath;
    private final Map<String, Pair<String, String>> myPackageNames;
    private final Set<String> myOccupiedNames;
    private boolean myUseTestifyAssert;

    public GoTestGenerator(@NotNull GoFile targetTestFile) {
        if (targetTestFile == null) {
            GoTestGenerator.$$$reportNull$$$0(0);
        }
        this.myPackageNames = new HashMap<String, Pair<String, String>>();
        this.myOccupiedNames = new HashSet<String>();
        this.myTargetTestFile = targetTestFile;
        this.myTestPackageName = this.myTargetTestFile.getPackageName();
        this.myTestImportPath = this.importPath(this.myTargetTestFile);
        MultiMap<String, GoImportSpec> importsMap = this.myTargetTestFile.getImportMap();
        for (String localName : importsMap.keySet()) {
            for (GoImportSpec spec : importsMap.get((Object)localName)) {
                this.myPackageNames.put(spec.getPath(), (Pair<String, String>)Pair.create((Object)localName, (Object)spec.getAlias()));
            }
        }
        this.myTargetTestFile.getConstants().forEach(it -> ContainerUtil.addIfNotNull(this.myOccupiedNames, (Object)it.getName()));
        this.myTargetTestFile.getVars().forEach(it -> ContainerUtil.addIfNotNull(this.myOccupiedNames, (Object)it.getName()));
        this.myTargetTestFile.getTypes().forEach(it -> ContainerUtil.addIfNotNull(this.myOccupiedNames, (Object)it.getName()));
        this.myTargetTestFile.getFunctions().forEach(it -> ContainerUtil.addIfNotNull(this.myOccupiedNames, (Object)it.getName()));
    }

    public void setUseTestifyAssert(boolean useTestifyAssert) {
        this.myUseTestifyAssert = useTestifyAssert;
    }

    @NotNull
    public List<GoFunctionDeclaration> generateTests(@NotNull List<GoFunctionOrMethodDeclaration> functions) {
        if (functions == null) {
            GoTestGenerator.$$$reportNull$$$0(1);
        }
        if (functions.isEmpty()) {
            List<GoFunctionDeclaration> list = Collections.emptyList();
            if (list == null) {
                GoTestGenerator.$$$reportNull$$$0(2);
            }
            return list;
        }
        GoFile generatedTest = GoElementFactory.createFileFromText(this.myTargetTestFile.getProject(), this.generateTestFile(functions));
        ArrayList<? extends GoFunctionDeclaration> generatedFunctions = new ArrayList<GoFunctionDeclaration>(generatedTest.getFunctions());
        if (generatedFunctions.isEmpty()) {
            List<GoFunctionDeclaration> list = Collections.emptyList();
            if (list == null) {
                GoTestGenerator.$$$reportNull$$$0(3);
            }
            return list;
        }
        GoImportList targetImports = Objects.requireNonNull(this.myTargetTestFile.getImportList());
        Set<String> existingImportPaths = this.myTargetTestFile.getImportedPackagesMap().keySet();
        for (GoImportSpec anImport : generatedTest.getImports()) {
            if (existingImportPaths.contains(anImport.getPath())) continue;
            targetImports.addImport(anImport.getPath(), anImport.getAlias());
        }
        ArrayList<GoFunctionDeclaration> result = new ArrayList<GoFunctionDeclaration>();
        Collections.sort(generatedFunctions, Comparator.comparing(PsiNamedElement::getName));
        PsiElement newLine = GoElementFactory.createNewLine(this.myTargetTestFile.getProject(), 2);
        for (GoFunctionDeclaration goFunctionDeclaration : generatedFunctions) {
            this.myTargetTestFile.add(newLine);
            PsiElement added = this.myTargetTestFile.add(goFunctionDeclaration);
            ContainerUtil.addIfNotNull(result, (Object)((GoFunctionDeclaration)ObjectUtils.tryCast((Object)added, GoFunctionDeclaration.class)));
        }
        GoFormatterUtil.reformat((PsiFile)this.myTargetTestFile, result);
        ArrayList<GoFunctionDeclaration> arrayList = result;
        if (arrayList == null) {
            GoTestGenerator.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NonNls
    private String generateTestFile(@NotNull List<GoFunctionOrMethodDeclaration> functions) {
        if (functions == null) {
            GoTestGenerator.$$$reportNull$$$0(5);
        }
        assert (!functions.isEmpty());
        GoStringBuilder out = new GoStringBuilder();
        if (this.myTestPackageName == null) {
            throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.test.package.name", (Object[])new Object[0]));
        }
        if (this.myTestImportPath == null) {
            throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.test.import.path", (Object[])new Object[0]));
        }
        String testingDot = this.importPackage("testing");
        String packageQualifier = this.getPackageQualifier(functions.iterator().next());
        List testProperties = ContainerUtil.map(functions, it -> this.getTestProperties((GoFunctionOrMethodDeclaration)it, packageQualifier));
        for (TestProperties properties : testProperties) {
            out.block("func " + properties.testName + "(" + properties.tVarName + " *" + testingDot + "T) ", () -> {
                GoTestGenerator.declareFieldsType(out, properties);
                GoTestGenerator.declareArgsType(out, properties);
                GoTestGenerator.declareTestCaseType(out, properties);
                GoTestGenerator.declareTestCases(out, properties);
                this.runTests(out, properties, testingDot);
            });
        }
        return "package pkg\n\n" + this.getImportsSection() + "\n\n" + out;
    }

    private void runTests(@NotNull GoStringBuilder out, @NotNull TestProperties properties, @NotNull String testingDot) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(6);
        }
        if (testingDot == null) {
            GoTestGenerator.$$$reportNull$$$0(7);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(8);
        }
        out.block("for _, " + properties.testCaseName + " := range " + properties.testCasesName + " ", () -> {
            String testName = properties.getTestCaseField("name");
            out.block(properties.tVarName + ".Run(" + testName + ", func(" + properties.tVarName + " *" + testingDot + "T) ", () -> {
                this.initReceiver(out, properties);
                this.initWriters(out, properties);
                if (this.myUseTestifyAssert) {
                    this.generateTestifyAsserts(out, properties);
                } else {
                    if (!properties.isCallInline()) {
                        out.indent(GoTestGenerator.call(properties)).append("\n");
                    }
                    if (properties.isReturnsError()) {
                        GoTestGenerator.checkError(out, properties);
                    }
                    for (TestInOut writer : properties.writers) {
                        GoTestGenerator.checkWriter(out, properties, writer);
                    }
                    for (FunctionResult result : properties.results) {
                        if (properties.isErrorResult(result)) continue;
                        this.checkResult(out, properties, result);
                    }
                }
            }, false).append(")\n");
        });
    }

    private void checkResult(@NotNull GoStringBuilder out, @NotNull TestProperties properties, @NotNull FunctionResult testResult) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(9);
        }
        if (testResult == null) {
            GoTestGenerator.$$$reportNull$$$0(10);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(11);
        }
        out.indent("if ");
        if (properties.isCallInline()) {
            out.append(GoTestGenerator.call(properties)).append("; ");
        }
        if (testResult.isBasicType) {
            out.append(testResult.gotName).append(" != ").append(properties.getTestCaseField(testResult.wantName)).append(" ");
        } else {
            String reflectDot = this.importPackage("reflect");
            out.append("!").append(reflectDot).append("DeepEqual(").append(testResult.gotName).append(", ").append(properties.getTestCaseField(testResult.wantName)).append(") ");
        }
        out.block(() -> {
            out.indent(properties.tVarName).append(".Errorf(\"").append(properties.functionName).append("() ");
            if (properties.results.size() > 1) {
                out.append(testResult.gotName).append(" ");
            }
            out.append("= %v, want %v\", ").append(testResult.gotName).append(", ").append(properties.getTestCaseField(testResult.wantName)).append(")\n");
        });
    }

    private static void checkWriter(@NotNull GoStringBuilder out, @NotNull TestProperties properties, @NotNull TestInOut writer) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(12);
        }
        if (writer == null) {
            GoTestGenerator.$$$reportNull$$$0(13);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(14);
        }
        String wantName = writer.wantName;
        String gotName = "got" + StringUtil.capitalize((String)StringUtil.trimStart((String)wantName, (String)"want"));
        out.indent("if ").append(gotName).append(" := ").append(writer.inputName).append(".String(); ");
        out.append(gotName).append(" != ").append(properties.getTestCaseField(wantName)).block(() -> {
            out.indent(properties.tVarName).append(".Errorf(\"").append(properties.functionName).append("() ");
            if (properties.hasSeveralChecks()) {
                out.append(gotName).append(" ");
            }
            out.append("= %v, want %v\", ").append(gotName).append(", ").append(properties.getTestCaseField(wantName)).append(")\n");
        });
    }

    private static void checkError(GoStringBuilder out, TestProperties properties) {
        out.indent("if ");
        if (properties.isCallInline()) {
            out.append(GoTestGenerator.call(properties)).append("; ");
        }
        String err = properties.errorName;
        String wantErr = properties.wantErrorName;
        out.indent("(" + err + " != nil) != " + properties.getTestCaseField(wantErr) + " ").block(() -> {
            out.indent(properties.tVarName).append(".Errorf(\"").append(properties.functionName).append("() error = %v, " + wantErr + " %v\", " + err + ", " + properties.getTestCaseField(wantErr) + ")\n");
            if (properties.hasSeveralChecks()) {
                out.indent("return");
            }
        });
    }

    private void initReceiver(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        Receiver receiver;
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(15);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(16);
        }
        if ((receiver = properties.receiver) != null && receiver.isStruct && !properties.hasTypeParams()) {
            out.indent(receiver.name).append(" := ");
            if (receiver.isPointer) {
                out.append("&");
            }
            out.append(receiver.type);
            if (receiver.fields.isEmpty()) {
                out.append("{}");
            } else {
                out.block(() -> {
                    for (ReceiverField field : receiver.fields) {
                        out.indent(field.name).append(": ").append(properties.getTestCaseField("fields")).append(".").append(field.name).append(",\n");
                    }
                });
            }
        }
    }

    private void initWriters(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(17);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(18);
        }
        if (!properties.writers.isEmpty()) {
            String bytesDot = this.importPackage("bytes");
            for (TestInOut writer : properties.writers) {
                out.indent(writer.inputName).append(" := &").append(bytesDot).append("Buffer{}\n");
            }
        }
    }

    private static void declareFieldsType(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        Receiver receiver;
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(19);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(20);
        }
        if ((receiver = properties.receiver) != null && !receiver.fields.isEmpty() && !properties.hasTypeParams()) {
            out.declareStructType(properties.fieldsTypeName, () -> {
                for (ReceiverField field : receiver.fields) {
                    out.indent(field.name).append(" ").append(field.type).append("\n");
                }
            });
        }
    }

    private static void declareArgsType(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(21);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(22);
        }
        if (!properties.inputs.isEmpty()) {
            String argsTypeDecl = properties.argsTypeName + GoTestGenerator.getTypeParametersDeclaration(properties.argTypeParams);
            out.declareStructType(argsTypeDecl, () -> {
                for (TestIn input2 : properties.inputs) {
                    out.indent(input2.name).append(" ").append(input2.type).append("\n");
                }
            });
        }
    }

    private static String getTypeParametersDeclaration(@NotNull Collection<TypeParam> typeParams) {
        if (typeParams == null) {
            GoTestGenerator.$$$reportNull$$$0(23);
        }
        if (typeParams.isEmpty()) {
            return "";
        }
        return "[" + StringUtil.join(typeParams, tp -> tp.name + " " + tp.constraint, (String)", ") + "]";
    }

    private static String getTypeParametersInstantiation(@NotNull List<TypeParam> typeParams) {
        if (typeParams == null) {
            GoTestGenerator.$$$reportNull$$$0(24);
        }
        if (typeParams.isEmpty()) {
            return "";
        }
        return "[" + StringUtil.join(typeParams, tp -> tp.name, (String)", ") + "]";
    }

    private static void declareTestCaseType(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(25);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(26);
        }
        if (!properties.hasTypeParams()) {
            return;
        }
        out.block("type " + GoTestGenerator.getTestCaseTypeDeclaration(properties) + " struct ", () -> GoTestGenerator.declareTestCaseTypeFields(out, properties));
    }

    @NotNull
    private static String getTestCaseTypeDeclaration(@NotNull TestProperties properties) {
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(27);
        }
        if (properties.receiver != null && !properties.receiver.typeParams.isEmpty()) {
            String string = "testCase" + GoTestGenerator.getTypeParametersDeclaration(properties.receiver.typeParams);
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(28);
            }
            return string;
        }
        LinkedHashMap allTypeParams = new LinkedHashMap();
        properties.argTypeParams.forEach(tp -> allTypeParams.put(tp.name, tp));
        properties.returnTypeParams.forEach(tp -> allTypeParams.put(tp.name, tp));
        String string = "testCase" + GoTestGenerator.getTypeParametersDeclaration(allTypeParams.values());
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static void declareTestCases(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(30);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(31);
        }
        if (properties.hasTypeParams()) {
            out.block(properties.testCasesName + " := []testCase[/* TODO: Insert concrete types here */] ", () -> GoTestGenerator.declareTodoComment(out));
        } else {
            out.block(properties.testCasesName + " := []struct ", () -> GoTestGenerator.declareTestCaseTypeFields(out, properties), false).block(() -> GoTestGenerator.declareTodoComment(out));
        }
    }

    private static void declareTodoComment(@NotNull GoStringBuilder out) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(32);
        }
        out.indent("// TODO: Add test cases.\n");
    }

    private static void declareTestCaseTypeFields(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(33);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(34);
        }
        out.indent("name string\n");
        Receiver receiver = properties.receiver;
        if (receiver != null) {
            if (properties.hasTypeParams()) {
                String instantiatedType = receiver.type + GoTestGenerator.getTypeParametersInstantiation(receiver.typeParams);
                out.indent(receiver.name).append(" ").append(instantiatedType).append("\n");
            } else if (!receiver.fields.isEmpty()) {
                out.indent("fields " + properties.fieldsTypeName + "\n");
            } else if (!receiver.isStruct) {
                out.indent(receiver.name).append(" ").append(receiver.type).append("\n");
            }
        }
        if (!properties.inputs.isEmpty()) {
            out.indent("args " + properties.argsTypeName + GoTestGenerator.getTypeParametersInstantiation(properties.argTypeParams) + "\n");
        }
        for (TestWant want : properties.wants) {
            out.indent(want.name).append(" ").append(want.type).append("\n");
        }
    }

    private static String call(@NotNull TestProperties properties) {
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(35);
        }
        StringBuilder result = new StringBuilder();
        if (!properties.results.isEmpty()) {
            result.append(String.join((CharSequence)", ", ContainerUtil.map(properties.results, it -> it.gotName)));
            result.append(" := ");
        }
        result.append(GoTestGenerator.callNoAssign(properties));
        return result.toString();
    }

    private static String callNoAssign(@NotNull TestProperties properties) {
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(36);
        }
        StringBuilder result = new StringBuilder();
        Receiver receiver = properties.receiver;
        if (receiver != null) {
            String receiverExpression = receiver.isStruct && !properties.hasTypeParams() ? receiver.name : properties.getTestCaseField(receiver.name);
            result.append(receiverExpression).append(".");
        } else {
            result.append(properties.packageQualifier);
        }
        result.append(properties.functionName).append("(").append(String.join((CharSequence)", ", properties.getArgExpressions())).append(")");
        return result.toString();
    }

    @NotNull
    private TestProperties getTestProperties(@NotNull GoFunctionOrMethodDeclaration function, @NotNull String packageQualifier) {
        GoSignature signature;
        if (function == null) {
            GoTestGenerator.$$$reportNull$$$0(37);
        }
        if (packageQualifier == null) {
            GoTestGenerator.$$$reportNull$$$0(38);
        }
        if ((signature = function.getSignature()) == null) {
            throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.function.signature", (Object[])new Object[0]));
        }
        return new TestProperties(function, packageQualifier);
    }

    private void generateTestifyAsserts(@NotNull GoStringBuilder out, @NotNull TestProperties properties) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(39);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(40);
        }
        if (properties.writers.isEmpty() && properties.results.isEmpty()) {
            out.indent(GoTestGenerator.call(properties)).append("\n");
        } else if (properties.writers.isEmpty() && properties.results.size() == 1) {
            FunctionResult result = properties.results.get(0);
            if (properties.isReturnsError()) {
                this.testifyCheckError(out, properties, GoTestGenerator.callNoAssign(properties));
            } else {
                out.indent(this.testifyAssertEqualf(properties, properties.getTestCaseField(result.wantName), GoTestGenerator.callNoAssign(properties))).append("\n");
            }
        } else {
            out.indent(GoTestGenerator.call(properties)).append("\n");
            if (properties.isReturnsError()) {
                this.testifyCheckError(out, properties, properties.errorName);
            }
            for (TestInOut writer : properties.writers) {
                out.indent(this.testifyAssertEqualf(properties, properties.getTestCaseField(writer.wantName), writer.inputName + ".String()")).append("\n");
            }
            for (FunctionResult result : properties.results) {
                if (properties.isErrorResult(result)) continue;
                out.indent(this.testifyAssertEqualf(properties, properties.getTestCaseField(result.wantName), result.gotName)).append("\n");
            }
        }
    }

    @NotNull
    private String testifyAssertEqualf(@NotNull TestProperties properties, @NotNull String want, @NotNull String got) {
        if (want == null) {
            GoTestGenerator.$$$reportNull$$$0(41);
        }
        if (got == null) {
            GoTestGenerator.$$$reportNull$$$0(42);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(43);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(properties.tVarName);
        args.add(want);
        args.add(got);
        args.add("\"" + properties.functionName + "(" + Strings.join(Collections.nCopies(properties.argExpressions.size(), "%v"), (String)", ") + ")\"");
        args.addAll(properties.getArgExpressions());
        String string = this.testifyAssertQName("Equalf") + "(" + StringUtil.join(args, (String)", ") + ")";
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(44);
        }
        return string;
    }

    private void testifyCheckError(@NotNull GoStringBuilder out, @NotNull TestProperties properties, @NotNull String gotErr) {
        if (out == null) {
            GoTestGenerator.$$$reportNull$$$0(45);
        }
        if (gotErr == null) {
            GoTestGenerator.$$$reportNull$$$0(46);
        }
        if (properties == null) {
            GoTestGenerator.$$$reportNull$$$0(47);
        }
        out.indent();
        if (properties.hasSeveralChecks()) {
            out.append("if !");
        }
        out.append(properties.getTestCaseField(properties.wantErrorName));
        out.append("(");
        out.append(properties.tVarName).append(", ");
        out.append(gotErr).append(", ");
        out.append(this.importPackage("fmt") + "Sprintf(");
        out.append("\"" + properties.functionName + "(" + Strings.join(Collections.nCopies(properties.argExpressions.size(), "%v"), (String)", ") + ")\", ");
        out.append(String.join((CharSequence)", ", properties.getArgExpressions()));
        out.append("))");
        if (properties.hasSeveralChecks()) {
            out.block(() -> out.indent("return"));
        } else {
            out.append("\n");
        }
    }

    private String testifyAssertQName(@NotNull String symbolName) {
        if (symbolName == null) {
            GoTestGenerator.$$$reportNull$$$0(48);
        }
        String assertDot = this.importPackage(TESTIFY_ASSERT_PACKAGE, "assert");
        return assertDot + symbolName;
    }

    @NotNull
    public String getTypeExpression(@NotNull GoType type2, boolean variadic) {
        if (type2 == null) {
            GoTestGenerator.$$$reportNull$$$0(49);
        }
        String typeText = this.getTypeText(type2);
        if (variadic) {
            String string = "[]" + typeText;
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(50);
            }
            return string;
        }
        String string = typeText;
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static String getInputName(@NotNull Set<String> usedNames, @Nullable String name, int index) {
        if (usedNames == null) {
            GoTestGenerator.$$$reportNull$$$0(52);
        }
        if (name != null) {
            String string = name;
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(53);
            }
            return string;
        }
        String string = GoTestGenerator.chooseNameWithSuffix(usedNames, "in", index);
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(54);
        }
        return string;
    }

    @NotNull
    @NonNls
    private static String getResultName(@Nullable String returnName, int index) {
        if (returnName != null) {
            String string = "got" + StringUtil.capitalize((String)returnName);
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(55);
            }
            return string;
        }
        Object object = index == 0 ? "got" : "got" + index;
        if (object == null) {
            GoTestGenerator.$$$reportNull$$$0(56);
        }
        return object;
    }

    @NotNull
    @NonNls
    private static String getWantName(@Nullable String name, int index) {
        if (name != null) {
            String string = "want" + StringUtil.capitalize((String)name);
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(57);
            }
            return string;
        }
        Object object = index == 0 ? "want" : "want" + index;
        if (object == null) {
            GoTestGenerator.$$$reportNull$$$0(58);
        }
        return object;
    }

    @NotNull
    private String getPackageQualifier(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoTestGenerator.$$$reportNull$$$0(59);
        }
        GoFile file = function.getContainingFile();
        String packageName = file.getPackageName();
        String importPath = this.importPath(file);
        return this.importPackage(importPath, packageName);
    }

    @NotNull
    private String getTestName(@NotNull GoFunctionOrMethodDeclaration function) {
        String name;
        if (function == null) {
            GoTestGenerator.$$$reportNull$$$0(60);
        }
        if ((name = function.getName()) != null && name.startsWith("Test")) {
            return GoTestGenerator.chooseName(this.myOccupiedNames, name, new String[0]);
        }
        if (function instanceof GoMethodDeclaration) {
            GoType type2 = ((GoMethodDeclaration)function).getReceiverType();
            if (type2 == null) {
                throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.method.receiver.type", (Object[])new Object[]{function.getName()}));
            }
            PsiElement resolve2 = GoTypeUtil.unwrapPointerAndParTypes(type2).resolve((ResolveState)null);
            if (resolve2 instanceof GoNamedElement) {
                Object receiverTypeName = ((GoNamedElement)resolve2).getName();
                if (!((GoNamedElement)resolve2).isPublic()) {
                    receiverTypeName = "_" + (String)receiverTypeName;
                }
                return GoTestGenerator.chooseName(this.myOccupiedNames, "Test" + (String)receiverTypeName + "_" + name, new String[0]);
            }
            throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.method.receiver.type", (Object[])new Object[]{function.getName()}));
        }
        @NonNls String testName = function.isPublic() ? "Test" + name : "Test_" + name;
        return GoTestGenerator.chooseName(this.myOccupiedNames, testName, new String[0]);
    }

    private static boolean isBasicType(@NotNull GoType type2, @NotNull GoFunctionOrMethodDeclaration context) {
        GoType underlyingType;
        if (type2 == null) {
            GoTestGenerator.$$$reportNull$$$0(61);
        }
        if (context == null) {
            GoTestGenerator.$$$reportNull$$$0(62);
        }
        return GoTypeUtil.isString(underlyingType = type2.getUnderlyingType(context), context) || GoTypeUtil.isBoolean(underlyingType, context) || GoTypeUtil.isNumericType(underlyingType, context);
    }

    @NotNull
    private static String chooseName(@NotNull Set<String> usedNames, @NotNull @NonNls String preferredName, String ... otherPreferredNames) {
        if (usedNames == null) {
            GoTestGenerator.$$$reportNull$$$0(63);
        }
        if (preferredName == null) {
            GoTestGenerator.$$$reportNull$$$0(64);
        }
        if (usedNames.add(preferredName)) {
            String string = preferredName;
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(65);
            }
            return string;
        }
        for (String name : otherPreferredNames) {
            if (!usedNames.add(name)) continue;
            String string = name;
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(66);
            }
            return string;
        }
        String string = GoTestGenerator.chooseNameWithSuffix(usedNames, preferredName, 1);
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(67);
        }
        return string;
    }

    private static String chooseNameWithSuffix(@NotNull Set<String> usedNames, @NotNull String prefix, int suffix) {
        if (usedNames == null) {
            GoTestGenerator.$$$reportNull$$$0(68);
        }
        if (prefix == null) {
            GoTestGenerator.$$$reportNull$$$0(69);
        }
        String name;
        while (!usedNames.add(name = prefix + suffix)) {
            ++suffix;
        }
        return name;
    }

    @NotNull
    private static List<Arg> getArgs(@NotNull GoParameters parameters) {
        if (parameters == null) {
            GoTestGenerator.$$$reportNull$$$0(70);
        }
        ArrayList<Arg> result = new ArrayList<Arg>();
        for (GoParameterDeclaration declaration : parameters.getParameterDeclarationList()) {
            GoType paramType = declaration.getType();
            if (paramType == null) continue;
            List<GoParamDefinition> definitions = declaration.getParamDefinitionList();
            if (definitions.isEmpty()) {
                result.add(new Arg(null, paramType, declaration.isVariadic()));
                continue;
            }
            for (GoParamDefinition definition : definitions) {
                result.add(new Arg(definition.isBlank() ? null : definition.getName(), paramType, declaration.isVariadic()));
            }
        }
        ArrayList<Arg> arrayList = result;
        if (arrayList == null) {
            GoTestGenerator.$$$reportNull$$$0(71);
        }
        return arrayList;
    }

    @NotNull
    private static List<Return> getReturns(@NotNull GoFunctionOrMethodDeclaration function) {
        if (function == null) {
            GoTestGenerator.$$$reportNull$$$0(72);
        }
        ArrayList<Return> result = new ArrayList<Return>();
        GoResult functionResult = function.getResult();
        if (functionResult != null) {
            List<Object> resultDecl;
            GoParameters resultParams = functionResult.getParameters();
            List<Object> list = resultDecl = resultParams != null ? resultParams.getParameterDeclarationList() : Collections.emptyList();
            if (resultDecl.isEmpty()) {
                GoType type2 = functionResult.getType();
                if (type2 != null) {
                    result.add(new Return(null, type2));
                }
            } else {
                for (GoParameterDeclaration goParameterDeclaration : resultDecl) {
                    GoType type3 = goParameterDeclaration.getType();
                    if (type3 == null) continue;
                    List<GoParamDefinition> definitions = goParameterDeclaration.getParamDefinitionList();
                    if (definitions.isEmpty()) {
                        result.add(new Return(null, type3));
                        continue;
                    }
                    for (GoParamDefinition definition : definitions) {
                        result.add(new Return(definition.isBlank() ? null : definition.getName(), type3));
                    }
                }
            }
        }
        ArrayList<Return> arrayList = result;
        if (arrayList == null) {
            GoTestGenerator.$$$reportNull$$$0(73);
        }
        return arrayList;
    }

    @NotNull
    private String importPackage(@NotNull @NonNls String importPath) {
        if (importPath == null) {
            GoTestGenerator.$$$reportNull$$$0(74);
        }
        return this.importPackage(importPath, importPath);
    }

    @NotNull
    private String importPackage(@Nullable String importPath, @Nullable String packageName) {
        if (this.myTestImportPath.equals(importPath) && this.myTestPackageName.equals(packageName) || importPath == null || packageName == null) {
            return "";
        }
        Pair localNameAndAlias = this.myPackageNames.get(importPath);
        if (localNameAndAlias == null) {
            ResolveState state;
            GoImportSpec spec = GoElementFactory.createImportSpec((PsiFile)this.myTargetTestFile, importPath, null);
            Collection<GoPackage> packages2 = spec.resolve(state = GoPsiImplUtil.createContextOnElement((PsiElement)this.myTargetTestFile));
            if (packages2.isEmpty()) {
                String localName = GoPsiImplUtil.sanitizePackageName(importPath);
                localNameAndAlias = Pair.create((Object)localName, null);
            } else {
                String alias = GoImportPackageQuickFix.getImportAlias(importPath, packageName);
                localNameAndAlias = alias != null ? Pair.create((Object)alias, (Object)alias) : Pair.create((Object)packageName, null);
            }
            this.myPackageNames.put(importPath, (Pair<String, String>)localNameAndAlias);
        }
        Object object = ".".equals(localNameAndAlias.first) ? "" : (String)localNameAndAlias.first + ".";
        if (object == null) {
            GoTestGenerator.$$$reportNull$$$0(75);
        }
        return object;
    }

    @NotNull
    private String getTypeText(@NotNull GoType type2) {
        GoTypeReferenceExpression expression;
        if (type2 == null) {
            GoTestGenerator.$$$reportNull$$$0(76);
        }
        if ((expression = type2.getTypeReferenceExpression()) == null) {
            String string = type2.getText();
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(77);
            }
            return string;
        }
        PsiElement resolved = type2.resolve((ResolveState)null);
        GoFile typeFile = (GoFile)((Object)ObjectUtils.tryCast((Object)(resolved != null ? resolved.getContainingFile() : null), GoFile.class));
        if (GoPsiImplUtil.isBuiltinFile((PsiFile)typeFile)) {
            String string = type2.getText();
            if (string == null) {
                GoTestGenerator.$$$reportNull$$$0(78);
            }
            return string;
        }
        String importPath = this.importPath(typeFile);
        String packageName = typeFile != null ? typeFile.getPackageName() : null;
        String string = this.importPackage(importPath, packageName) + expression.getIdentifier().getText();
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(79);
        }
        return string;
    }

    @Nullable
    private String importPath(@Nullable GoFile file) {
        String importPath;
        GoPackage pkg = file != null ? GoPackage.of(file) : null;
        String string = importPath = pkg != null ? pkg.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)this.myTargetTestFile)) : null;
        if (importPath != null) {
            return importPath;
        }
        return pkg != null ? pkg.getName() : null;
    }

    @NotNull
    private String getImportsSection() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> importPaths = new ArrayList<String>(this.myPackageNames.keySet());
        Collections.sort(importPaths);
        for (String importPath : importPaths) {
            result.append("import ");
            String alias = (String)this.myPackageNames.get((Object)importPath).second;
            if (alias != null) {
                result.append(alias).append(" ");
            }
            result.append("\"").append(importPath).append("\"\n");
        }
        String string = result.toString();
        if (string == null) {
            GoTestGenerator.$$$reportNull$$$0(80);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 28, 29, 44, 50, 51, 53, 54, 55, 56, 57, 58, 65, 66, 67, 71, 73, 75, 77, 78, 79, 80 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTestFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 28: 
            case 29: 
            case 44: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/creator/GoTestGenerator";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 25: 
            case 30: 
            case 32: 
            case 33: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testingDot";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 31: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testResult";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParams";
                break;
            }
            case 37: 
            case 59: 
            case 60: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageQualifier";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "want";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "got";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotErr";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolName";
                break;
            }
            case 49: 
            case 61: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 52: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedNames";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredName";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/creator/GoTestGenerator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTests";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestCaseTypeDeclaration";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "testifyAssertEqualf";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeExpression";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputName";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultName";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getWantName";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseName";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturns";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "importPackage";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportsSection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateTests";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 28: 
            case 29: 
            case 44: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 65: 
            case 66: 
            case 67: 
            case 71: 
            case 73: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateTestFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runTests";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkWriter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initReceiver";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initWriters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "declareFieldsType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "declareArgsType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParametersDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParametersInstantiation";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "declareTestCaseType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTestCaseTypeDeclaration";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "declareTestCases";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "declareTodoComment";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "declareTestCaseTypeFields";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "call";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "callNoAssign";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTestProperties";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "generateTestifyAsserts";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "testifyAssertEqualf";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "testifyCheckError";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "testifyAssertQName";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTypeExpression";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getInputName";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getPackageQualifier";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getTestName";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isBasicType";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "chooseName";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "chooseNameWithSuffix";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getArgs";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getReturns";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "importPackage";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 28, 29, 44, 50, 51, 53, 54, 55, 56, 57, 58, 65, 66, 67, 71, 73, 75, 77, 78, 79, 80 -> new IllegalStateException(string);
        };
    }

    static class TestGenerationException
    extends RuntimeException {
        TestGenerationException(@NotNull String message) {
            if (message == null) {
                TestGenerationException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/goide/execution/testing/creator/GoTestGenerator$TestGenerationException", "<init>"));
        }
    }

    private final class TestProperties {
        private final String functionName;
        private final String packageQualifier;
        private final String testName;
        private final String errorName;
        private final String wantErrorName;
        private final String tVarName;
        private final String fieldsTypeName;
        private final String argsTypeName;
        private final String testCasesName;
        private final String testCaseName;
        private final List<String> argExpressions;
        private final List<TestIn> inputs;
        private final List<TestInOut> writers;
        private final List<TestWant> wants;
        private final List<FunctionResult> results;
        private final Receiver receiver;
        private final List<TypeParam> argTypeParams;
        private final List<TypeParam> returnTypeParams;

        private TestProperties(@NotNull GoFunctionOrMethodDeclaration function, String packageQualifier) {
            HashSet<String> usedNames;
            if (function == null) {
                TestProperties.$$$reportNull$$$0(0);
            }
            if (packageQualifier == null) {
                TestProperties.$$$reportNull$$$0(1);
            }
            this.argExpressions = new ArrayList<String>();
            this.inputs = new ArrayList<TestIn>();
            this.writers = new ArrayList<TestInOut>();
            this.wants = new ArrayList<TestWant>();
            this.results = new ArrayList<FunctionResult>();
            this.functionName = function.getName();
            this.packageQualifier = packageQualifier;
            this.testName = GoTestGenerator.this.getTestName(function);
            int inputIndex = 0;
            int outputIndex = 0;
            GoSignature signature = Objects.requireNonNull(function.getSignature());
            List<Arg> args = GoTestGenerator.getArgs(signature.getParameters());
            HashSet<String> usedInputNames = new HashSet<String>(ContainerUtil.filter((Collection)ContainerUtil.map(args, it -> it.name), Objects::nonNull));
            for (Arg arg : args) {
                boolean isWriter;
                String inputName = GoTestGenerator.getInputName(usedInputNames, arg.name, inputIndex++);
                boolean bl = isWriter = !arg.variadic && GoStdlibUtil.isStdLibType(arg.type, function, "io", "Writer", false);
                if (isWriter) {
                    this.argExpressions.add(inputName);
                    String wantName = GoTestGenerator.getWantName(arg.name, outputIndex);
                    if (arg.name == null) {
                        ++outputIndex;
                    }
                    this.writers.add(new TestInOut(inputName, wantName));
                    this.wants.add(new TestWant(wantName, "string"));
                    continue;
                }
                String typeExpression = GoTestGenerator.this.getTypeExpression(arg.type, arg.variadic);
                this.argExpressions.add("args." + inputName + (arg.variadic ? "..." : ""));
                this.inputs.add(new TestIn(inputName, typeExpression));
            }
            String errName = null;
            String wantErrName = null;
            boolean errFound = false;
            List<Return> returns = GoTestGenerator.getReturns(function);
            for (int i = 0; i < returns.size() - 1; ++i) {
                Return functionReturn = returns.get(i);
                String typeExpression = GoTestGenerator.this.getTypeExpression(functionReturn.type, false);
                String wantName = GoTestGenerator.getWantName(functionReturn.name, outputIndex);
                this.wants.add(new TestWant(wantName, typeExpression));
                String resultName = GoTestGenerator.getResultName(functionReturn.name, outputIndex);
                this.results.add(new FunctionResult(resultName, wantName, GoTestGenerator.isBasicType(functionReturn.type, function)));
                errFound |= GoTypeUtil.isError(functionReturn.type, function);
                ++outputIndex;
            }
            Return lastReturn = (Return)ContainerUtil.getLastItem(returns);
            if (lastReturn != null) {
                if (!errFound && GoTypeUtil.isError(lastReturn.type, function)) {
                    usedNames = new HashSet<String>(ContainerUtil.map(this.writers, it -> it.inputName));
                    for (int i = 0; i < returns.size() - 1; ++i) {
                        ContainerUtil.addIfNotNull(usedNames, (Object)returns.get((int)i).name);
                    }
                    errName = GoTestGenerator.chooseName(usedNames, "err", new String[0]);
                    wantErrName = "want" + StringUtil.capitalize((String)errName);
                    if (GoTestGenerator.this.myUseTestifyAssert) {
                        this.wants.add(new TestWant(wantErrName, GoTestGenerator.this.testifyAssertQName("ErrorAssertionFunc")));
                        this.results.add(new FunctionResult(errName, wantErrName, false));
                    } else {
                        this.wants.add(new TestWant(wantErrName, "bool"));
                        this.results.add(new FunctionResult(errName, wantErrName, true));
                    }
                } else {
                    String typeExpression = GoTestGenerator.this.getTypeExpression(lastReturn.type, false);
                    String wantName = GoTestGenerator.getWantName(lastReturn.name, outputIndex);
                    this.wants.add(new TestWant(wantName, typeExpression));
                    this.results.add(new FunctionResult(GoTestGenerator.getResultName(lastReturn.name, outputIndex), wantName, GoTestGenerator.isBasicType(lastReturn.type, function)));
                }
            }
            this.errorName = errName;
            this.wantErrorName = wantErrName;
            this.receiver = this.getReceiver(function);
            usedNames = new HashSet(ContainerUtil.map(this.writers, it -> it.inputName));
            if (this.receiver != null && this.receiver.isStruct) {
                usedNames.add(this.receiver.name);
            }
            this.tVarName = GoTestGenerator.chooseName(usedNames, "t", new String[0]);
            this.testCaseName = GoTestGenerator.chooseName(usedNames, "tt", "tc", "test", "testCase");
            this.fieldsTypeName = GoTestGenerator.chooseName(usedNames, "fields", new String[0]);
            this.argsTypeName = GoTestGenerator.chooseName(usedNames, "args", "arguments");
            this.testCasesName = GoTestGenerator.chooseName(usedNames, "tests", "testCases");
            this.argTypeParams = TestProperties.collectUsedTypeParameters(signature.getParameters());
            this.returnTypeParams = TestProperties.collectUsedTypeParameters(signature.getResult());
        }

        @NotNull
        private static List<TypeParam> collectUsedTypeParameters(@Nullable PsiElement element) {
            if (element == null) {
                List<TypeParam> list = Collections.emptyList();
                if (list == null) {
                    TestProperties.$$$reportNull$$$0(2);
                }
                return list;
            }
            SmartList typeParams = new SmartList();
            HashSet seen = new HashSet();
            ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)element).filter(e -> e instanceof GoTypeReferenceExpression)).forEach(arg_0 -> TestProperties.lambda$collectUsedTypeParameters$4(seen, (List)typeParams, arg_0));
            SmartList smartList = typeParams;
            if (smartList == null) {
                TestProperties.$$$reportNull$$$0(3);
            }
            return smartList;
        }

        @Nullable
        private Receiver getReceiver(@NotNull GoFunctionOrMethodDeclaration function) {
            String receiverName;
            GoStructType struct;
            GoMethodDeclaration method;
            if (function == null) {
                TestProperties.$$$reportNull$$$0(4);
            }
            if ((method = (GoMethodDeclaration)ObjectUtils.tryCast((Object)function, GoMethodDeclaration.class)) == null) {
                return null;
            }
            GoReceiver goReceiver = method.getReceiver();
            if (goReceiver == null) {
                throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.method.receiver", (Object[])new Object[]{function.getName()}));
            }
            boolean isPointer = goReceiver.getType() instanceof GoPointerType;
            GoType unwrappedType = GoTypeUtil.unwrapPointerAndParTypes(goReceiver.getType());
            if (unwrappedType == null) {
                throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.method.receiver.type", (Object[])new Object[]{function.getName()}));
            }
            PsiElement resolvedType = unwrappedType.resolve((ResolveState)null);
            String receiverType = GoTestGenerator.this.getTypeExpression(unwrappedType, false);
            String preferredReceiverName = goReceiver.getName();
            if (preferredReceiverName == null || "_".equals(preferredReceiverName)) {
                String typeName;
                GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)resolvedType, GoTypeSpec.class);
                preferredReceiverName = typeSpec != null ? (!StringUtil.isEmpty((String)(typeName = typeSpec.getName())) ? StringUtil.toLowerCase((String)typeName.substring(0, Math.min(typeName.length(), 2))) : "x") : "x";
            }
            ArrayList<ReceiverField> receiverFields = new ArrayList<ReceiverField>();
            boolean isStruct = false;
            GoTypeSpec typeSpec = (GoTypeSpec)ObjectUtils.tryCast((Object)resolvedType, GoTypeSpec.class);
            GoStructType goStructType = struct = typeSpec != null ? (GoStructType)ObjectUtils.tryCast((Object)typeSpec.getSpecType().getType(), GoStructType.class) : null;
            if (struct != null) {
                isStruct = true;
                for (GoNamedElement field : struct.getFieldDefinitions()) {
                    GoType type2 = field.getGoType(GoPsiImplUtil.createContextOnElement(function));
                    String fieldName = field.getName();
                    if (type2 != null && fieldName != null) {
                        receiverFields.add(new ReceiverField(fieldName, GoTestGenerator.this.getTypeExpression(type2, false)));
                        continue;
                    }
                    throw new TestGenerationException(GoBundle.message((String)"go.test.creator.cannot.find.field.type", (Object[])new Object[]{field.getName()}));
                }
            }
            List<TypeParam> receiverTypeParams = TestProperties.getReceiverTypeParams(typeSpec);
            if (isStruct) {
                names = new HashSet<String>();
                names.addAll(ContainerUtil.map(this.writers, it -> it.inputName));
                names.addAll(ContainerUtil.map(this.results, it -> it.gotName));
                receiverName = GoTestGenerator.chooseName(names, preferredReceiverName, new String[0]);
            } else {
                names = new HashSet();
                names.add("name");
                names.add("args");
                names.addAll(ContainerUtil.map(this.wants, it -> it.name));
                receiverName = GoTestGenerator.chooseName(names, preferredReceiverName, new String[0]);
            }
            return new Receiver(receiverName, receiverType, isStruct, isPointer, receiverFields, receiverTypeParams);
        }

        private static List<TypeParam> getReceiverTypeParams(@Nullable GoTypeSpec spec) {
            if (spec == null) {
                return Collections.emptyList();
            }
            GoTypeParameters typeParameters = spec.getSpecType().getTypeParameters();
            if (typeParameters == null) {
                return Collections.emptyList();
            }
            ArrayList<TypeParam> typeParams = new ArrayList<TypeParam>();
            for (GoTypeParameterDeclaration typeParamDeclaration : typeParameters.getTypeParameterDeclarationList()) {
                for (GoTypeParamDefinition typeParamDefinition : typeParamDeclaration.getTypeParamDefinitionList()) {
                    String name;
                    GoType constraintType;
                    if (typeParamDefinition == null || (constraintType = typeParamDefinition.getTypeParameter().getConstraintType()) == null || (name = typeParamDefinition.getName()) == null) continue;
                    typeParams.add(new TypeParam(name, constraintType.getText()));
                }
            }
            return typeParams;
        }

        boolean isReturnsError() {
            return this.errorName != null;
        }

        boolean isErrorResult(@NotNull FunctionResult result) {
            if (result == null) {
                TestProperties.$$$reportNull$$$0(5);
            }
            return this.errorName != null && result == ContainerUtil.getLastItem(this.results);
        }

        boolean isCallInline() {
            return this.writers.isEmpty() && this.results.size() == 1;
        }

        boolean hasSeveralChecks() {
            return this.writers.size() + this.results.size() > 1;
        }

        @NotNull
        public List<String> getArgExpressions() {
            ArrayList<String> result = new ArrayList<String>();
            for (String expression : this.argExpressions) {
                if (expression.startsWith("args.")) {
                    result.add(this.getTestCaseField(expression));
                    continue;
                }
                result.add(expression);
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                TestProperties.$$$reportNull$$$0(6);
            }
            return arrayList;
        }

        @NotNull
        public String getTestCaseField(@NotNull @NonNls String fieldName) {
            if (fieldName == null) {
                TestProperties.$$$reportNull$$$0(7);
            }
            String string = this.testCaseName + "." + fieldName;
            if (string == null) {
                TestProperties.$$$reportNull$$$0(8);
            }
            return string;
        }

        public boolean hasTypeParams() {
            return !this.argTypeParams.isEmpty() || !this.returnTypeParams.isEmpty() || this.receiver != null && !this.receiver.typeParams.isEmpty();
        }

        private static /* synthetic */ void lambda$collectUsedTypeParameters$4(Set seen, List typeParams, PsiElement e) {
            GoTypeReferenceExpression typeRef = (GoTypeReferenceExpression)e;
            PsiElement resolve2 = typeRef.resolve();
            if (resolve2 instanceof GoTypeParamDefinition) {
                GoTypeParamDefinition typeParamDefinition = (GoTypeParamDefinition)resolve2;
                if (!seen.add(typeParamDefinition)) {
                    return;
                }
                GoType constraintType = typeParamDefinition.getTypeParameter().getConstraintType();
                if (constraintType == null) {
                    return;
                }
                typeParams.add(new TypeParam(typeRef.getText(), constraintType.getText()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 6, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageQualifier";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/testing/creator/GoTestGenerator$TestProperties";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/testing/creator/GoTestGenerator$TestProperties";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectUsedTypeParameters";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgExpressions";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestCaseField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getReceiver";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isErrorResult";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getTestCaseField";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 6, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FunctionResult {
        final String gotName;
        final String wantName;
        final boolean isBasicType;

        private FunctionResult(@NotNull String gotName, @NotNull String wantName, boolean isBasicType) {
            if (gotName == null) {
                FunctionResult.$$$reportNull$$$0(0);
            }
            if (wantName == null) {
                FunctionResult.$$$reportNull$$$0(1);
            }
            this.gotName = gotName;
            this.wantName = wantName;
            this.isBasicType = isBasicType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "gotName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wantName";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$FunctionResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TestInOut {
        final String inputName;
        final String wantName;

        private TestInOut(@NotNull String inputName, @NotNull String wantName) {
            if (inputName == null) {
                TestInOut.$$$reportNull$$$0(0);
            }
            if (wantName == null) {
                TestInOut.$$$reportNull$$$0(1);
            }
            this.inputName = inputName;
            this.wantName = wantName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inputName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wantName";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$TestInOut";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Receiver {
        final String name;
        final String type;
        final boolean isStruct;
        final boolean isPointer;
        final List<ReceiverField> fields;
        final List<TypeParam> typeParams;

        private Receiver(@NotNull String name, @NotNull String type2, boolean isStruct, boolean isPointer, @NotNull List<ReceiverField> fields, @NotNull List<TypeParam> typeParams) {
            if (name == null) {
                Receiver.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                Receiver.$$$reportNull$$$0(1);
            }
            if (fields == null) {
                Receiver.$$$reportNull$$$0(2);
            }
            if (typeParams == null) {
                Receiver.$$$reportNull$$$0(3);
            }
            this.name = name;
            this.type = type2;
            this.isStruct = isStruct;
            this.isPointer = isPointer;
            this.fields = fields;
            this.typeParams = typeParams;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fields";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeParams";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$Receiver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TestWant {
        final String name;
        final String type;

        private TestWant(@NotNull @NonNls String wantName, @NotNull @NonNls String wantType) {
            if (wantName == null) {
                TestWant.$$$reportNull$$$0(0);
            }
            if (wantType == null) {
                TestWant.$$$reportNull$$$0(1);
            }
            this.name = wantName;
            this.type = wantType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wantName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "wantType";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$TestWant";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Arg {
        @Nullable
        final String name;
        final GoType type;
        final boolean variadic;

        private Arg(@Nullable String name, @NotNull GoType type2, boolean variadic) {
            if (type2 == null) {
                Arg.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type2;
            this.variadic = variadic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/goide/execution/testing/creator/GoTestGenerator$Arg", "<init>"));
        }
    }

    private static final class Return {
        @Nullable
        final String name;
        final GoType type;

        private Return(@Nullable String name, @NotNull GoType type2) {
            if (type2 == null) {
                Return.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/goide/execution/testing/creator/GoTestGenerator$Return", "<init>"));
        }
    }

    private static final class TypeParam {
        final String name;
        final String constraint;

        private TypeParam(@NotNull String name, @NotNull String constraint) {
            if (name == null) {
                TypeParam.$$$reportNull$$$0(0);
            }
            if (constraint == null) {
                TypeParam.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.constraint = constraint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "constraint";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$TypeParam";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TestIn {
        final String name;
        final String type;

        private TestIn(@NotNull String name, @NotNull String type2) {
            if (name == null) {
                TestIn.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                TestIn.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.type = type2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$TestIn";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ReceiverField {
        final String name;
        final String type;

        private ReceiverField(@NotNull String name, @NotNull String type2) {
            if (name == null) {
                ReceiverField.$$$reportNull$$$0(0);
            }
            if (type2 == null) {
                ReceiverField.$$$reportNull$$$0(1);
            }
            this.name = name;
            this.type = type2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/goide/execution/testing/creator/GoTestGenerator$ReceiverField";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

