/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.testing.coverage;

import com.goide.execution.testing.coverage.GoCoverageEngine;
import com.goide.execution.testing.coverage.GoCoverageProjectData;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoPackageUtil;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.Processor;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(GoCoverageRunner.class);
    @NonNls
    private static final String ID = "GoCoverage";
    @NonNls
    private static final String DATA_FILE_EXTENSION = "out";

    public ProjectData loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite) {
        Module module;
        if (sessionDataFile == null) {
            GoCoverageRunner.$$$reportNull$$$0(0);
        }
        if (!(baseCoverageSuite instanceof BaseCoverageSuite)) {
            return null;
        }
        Project project = baseCoverageSuite.getProject();
        if (project == null) {
            return null;
        }
        RunConfigurationBase configuration = ((BaseCoverageSuite)baseCoverageSuite).getConfiguration();
        Module module2 = module = configuration instanceof ModuleBasedConfiguration ? ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule() : null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Ref projectDataRef = new Ref();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> projectDataRef.set((Object)GoCoverageRunner.doLoadCoverageData(sessionDataFile, project, module)), GoBundle.message((String)"go.execution.coverage.loading.coverage.data", (Object[])new Object[0]), true, baseCoverageSuite.getProject());
            return (ProjectData)projectDataRef.get();
        }
        return GoCoverageRunner.doLoadCoverageData(sessionDataFile, project, module);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static ProjectData doLoadCoverageData(@NotNull File sessionDataFile, Project project, Module module) {
        if (sessionDataFile == null) {
            GoCoverageRunner.$$$reportNull$$$0(1);
        }
        try (FileInputStream inputStream = new FileInputStream(sessionDataFile.getAbsolutePath());){
            GoCoverageProjectData goCoverageProjectData;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));){
                goCoverageProjectData = GoCoverageRunner.parseCoverage(reader, project, module);
            }
            return goCoverageProjectData;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static GoCoverageProjectData parseCoverage(@NotNull BufferedReader dataReader, @NotNull Project project, @Nullable Module module) throws IOException {
        String line;
        if (dataReader == null) {
            GoCoverageRunner.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GoCoverageRunner.$$$reportNull$$$0(3);
        }
        GoCoverageProjectData result = new GoCoverageProjectData();
        while ((line = dataReader.readLine()) != null) {
            Pair<VirtualFile, String> fileNameTail;
            ProgressManager.checkCanceled();
            if (line.isEmpty() || (fileNameTail = GoCoverageRunner.extractFileName(line, project, module)) == null) continue;
            String filePath = ((VirtualFile)fileNameTail.first).getPath();
            List tailParts = StringUtil.split((String)((String)fileNameTail.second), (String)" ");
            if (tailParts.size() != 3) continue;
            int statements = Integer.parseInt((String)tailParts.get(1));
            long hit = Long.parseLong((String)tailParts.get(2));
            String offsets = (String)tailParts.get(0);
            int firstDot = offsets.indexOf(46);
            int comma = offsets.indexOf(44, firstDot);
            int secondDot = offsets.indexOf(46, comma);
            if (firstDot == -1 || comma == -1 || secondDot == -1) continue;
            int lineStart = Integer.parseInt(offsets.substring(0, firstDot));
            int columnStart = Integer.parseInt(offsets.substring(firstDot + 1, comma));
            int lineEnd = Integer.parseInt(offsets.substring(comma + 1, secondDot));
            int columnEnd = Integer.parseInt(offsets.substring(secondDot + 1));
            result.addData(filePath, lineStart, columnStart, lineEnd, columnEnd, statements, hit);
        }
        result.processFiles((Processor<? super GoCoverageProjectData.FileData>)((Processor)fileData -> {
            ClassData classData = result.getOrCreateClassData(fileData.myFilePath);
            int max = -1;
            Int2ObjectOpenHashMap linesMap = new Int2ObjectOpenHashMap();
            for (GoCoverageProjectData.RangeData rangeData : fileData.myRangesData.values()) {
                for (int i = rangeData.startLine; i <= rangeData.endLine; ++i) {
                    int hits;
                    LineData data = (LineData)linesMap.get(i);
                    int n = hits = rangeData.hits > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)rangeData.hits;
                    if (data == null) {
                        data = new LineData(i, null);
                        linesMap.put(i, (Object)data);
                    }
                    data.setHits(Math.max(data.getHits(), hits));
                    if (hits != 0) continue;
                    data.setFalseHits(0, 0);
                    data.setTrueHits(0, 0);
                }
                max = Math.max(max, rangeData.endLine);
            }
            LineData[] linesArray = new LineData[max + 1];
            for (LineData data : linesMap.values()) {
                data.fillArrays();
                linesArray[data.getLineNumber()] = data;
            }
            classData.setLines(linesArray);
            return true;
        }));
        GoCoverageProjectData goCoverageProjectData = result;
        if (goCoverageProjectData == null) {
            GoCoverageRunner.$$$reportNull$$$0(4);
        }
        return goCoverageProjectData;
    }

    @Nullable
    private static Pair<VirtualFile, String> extractFileName(@NotNull String line, @NotNull Project project, @Nullable Module module) {
        int pos;
        if (line == null) {
            GoCoverageRunner.$$$reportNull$$$0(5);
        }
        if (project == null) {
            GoCoverageRunner.$$$reportNull$$$0(6);
        }
        if ((pos = line.lastIndexOf(58)) == -1) {
            return null;
        }
        String fileName = line.substring(0, pos);
        VirtualFile file = (VirtualFile)ReadAction.compute(() -> FileUtil.isAbsolute((String)fileName) ? LocalFileSystem.getInstance().findFileByPath(fileName) : GoPackageUtil.findFileByImportPath(fileName, project, module));
        if (file == null) {
            return null;
        }
        return Pair.create((Object)file, (Object)line.substring(pos + 1));
    }

    @NotNull
    public String getPresentableName() {
        String string = GoBundle.message((String)"go.execution.coverage.runner.name", (Object[])new Object[0]);
        if (string == null) {
            GoCoverageRunner.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDataFileExtension() {
        return DATA_FILE_EXTENSION;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine) {
        if (engine == null) {
            GoCoverageRunner.$$$reportNull$$$0(8);
        }
        return engine instanceof GoCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataReader";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/testing/coverage/GoCoverageRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/testing/coverage/GoCoverageRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseCoverage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doLoadCoverageData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseCoverage";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7 -> new IllegalStateException(string);
        };
    }
}

