/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.before;

import com.goide.GoIcons;
import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.before.GoCommandBeforeRunTask;
import com.goide.execution.before.GoCommandConfigureDialog;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoExecutor;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class GoBeforeRunTaskProvider
extends BeforeRunTaskProvider<GoCommandBeforeRunTask>
implements DumbAware {
    public static final Key<GoCommandBeforeRunTask> ID = Key.create((String)"GoBeforeRunTask");

    public Key<GoCommandBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return GoBundle.message((String)"go.execution.before.run.task.name", (Object[])new Object[0]);
    }

    public String getDescription(GoCommandBeforeRunTask task2) {
        return GoBundle.message((String)"go.execution.before.run.task.description", (Object[])new Object[]{task2});
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = GoIcons.APPLICATION_RUN;
        if (icon == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public Icon getTaskIcon(GoCommandBeforeRunTask task2) {
        Icon icon = this.getIcon();
        if (icon == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nullable
    public GoCommandBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        return runConfiguration instanceof GoRunConfigurationBase ? new GoCommandBeforeRunTask() : null;
    }

    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull GoCommandBeforeRunTask task2) {
        if (context == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (configuration == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        if (task2 == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        Project project = configuration.getProject();
        if (!(configuration instanceof GoRunConfigurationBase)) {
            GoBeforeRunTaskProvider.showAddingTaskErrorMessage(project, GoBundle.message((String)"go.execution.before.run.task.supports.only.go.run.configurations.error", (Object[])new Object[0]));
            return Promises.resolvedPromise((Object)false);
        }
        Module module = ((GoModuleBasedConfiguration)((GoRunConfigurationBase)configuration).getConfigurationModule()).getModule();
        if (!GoSdkService.getInstance(project).isGoModule(module)) {
            GoBeforeRunTaskProvider.showAddingTaskErrorMessage(project, GoBundle.message((String)"go.execution.before.run.task.supports.only.go.modules.error", (Object[])new Object[0]));
            return Promises.resolvedPromise((Object)false);
        }
        GoCommandConfigureDialog dialog = new GoCommandConfigureDialog(project, StringUtil.notNullize((String)task2.getCommand()));
        if (dialog.showAndGet()) {
            task2.setCommand(dialog.getCommand());
            return Promises.resolvedPromise((Object)true);
        }
        return Promises.resolvedPromise((Object)false);
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull GoCommandBeforeRunTask task2) {
        if (configuration == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        if (task2 == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (configuration instanceof GoRunConfigurationBase) {
            Module module = ((GoModuleBasedConfiguration)((GoRunConfigurationBase)configuration).getConfigurationModule()).getModule();
            GoSdkService sdkService = GoSdkService.getInstance(configuration.getProject());
            return sdkService.isGoModule(module) && StringUtil.isNotEmpty((String)task2.getCommand());
        }
        return false;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull GoCommandBeforeRunTask task2) {
        if (context == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (configuration == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if (env == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        if (task2 == null) {
            GoBeforeRunTaskProvider.$$$reportNull$$$0(11);
        }
        final Semaphore done = new Semaphore();
        final Ref result = Ref.create((Object)false);
        if (configuration instanceof WrappingRunConfiguration) {
            configuration = ((WrappingRunConfiguration)configuration).getPeer();
        }
        GoRunConfigurationBase goRunConfiguration = (GoRunConfigurationBase)configuration;
        Module module = ((GoModuleBasedConfiguration)goRunConfiguration.getConfigurationModule()).getModule();
        Project project = goRunConfiguration.getProject();
        String workingDirectory = goRunConfiguration.getWorkingDirectory();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (StringUtil.isEmpty((String)task2.getCommand())) {
                return;
            }
            if (project.isDisposed()) {
                return;
            }
            GoSdkService sdkService = GoSdkService.getInstance(project);
            if (!sdkService.isGoModule(module)) {
                return;
            }
            done.down();
            GoExecutor.in(module).withParameterString(task2.getCommand()).withWorkDirectory(workingDirectory).showNotifications(false, true).withPresentableName(GoBundle.message((String)"go.execution.before.run.task.executing.presentable.name", (Object[])new Object[]{task2})).withProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    result.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                    done.up();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/execution/before/GoBeforeRunTaskProvider$1", "processTerminated"));
                }
            }).executeWithProgress(true, true, (Consumer<? super GoExecutor.ExecutionResult>)((Consumer)it -> VirtualFileManager.getInstance().asyncRefresh()));
        });
        done.waitFor();
        return (Boolean)result.get();
    }

    private static void showAddingTaskErrorMessage(Project project, @NlsContexts.DialogMessage String message) {
        Messages.showErrorDialog((Project)project, (String)message, (String)GoBundle.message((String)"go.execution.before.run.task.error.dialog.title", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/before/GoBeforeRunTaskProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/before/GoBeforeRunTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureTask";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canExecuteTask";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

