/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution.application;

import com.goide.GoOsManager;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoBuildingRunningState;
import com.goide.execution.GoConsoleFilter;
import com.goide.execution.application.GoApplicationConfiguration;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoExecutor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoApplicationRunningState
extends GoBuildingRunningState<GoApplicationConfiguration> {
    private String myCoverageDirectoryLocation;

    public GoApplicationRunningState(@NotNull ExecutionEnvironment env, @NotNull Module module, @NotNull GoApplicationConfiguration configuration) {
        if (env == null) {
            GoApplicationRunningState.$$$reportNull$$$0(0);
        }
        if (module == null) {
            GoApplicationRunningState.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            GoApplicationRunningState.$$$reportNull$$$0(2);
        }
        super(env, module, configuration);
    }

    @Override
    @Nullable
    public List<GoCommandLineParameter> getBuildingTarget() {
        return switch (((GoApplicationConfiguration)this.myConfiguration).getKind()) {
            default -> throw new IncompatibleClassChangeError();
            case GoBuildingRunConfiguration.Kind.DIRECTORY -> Collections.singletonList(GoCommandLineParameter.string("."));
            case GoBuildingRunConfiguration.Kind.PACKAGE -> Collections.singletonList(GoCommandLineParameter.string(((GoApplicationConfiguration)this.myConfiguration).getPackage()));
            case GoBuildingRunConfiguration.Kind.FILE -> ContainerUtil.map(((GoApplicationConfiguration)this.myConfiguration).getFilePaths(), GoCommandLineParameter::path);
        };
    }

    @Override
    protected GoExecutor createBuildExecutorInner() throws ExecutionException {
        GoExecutor executor = this.createCommonExecutor().withParameters("build");
        if (this.myCoverageLocation != null) {
            executor.withParameters("-cover");
            this.addCommonCoverageFlags(executor);
        }
        return executor;
    }

    @Override
    protected GoExecutor createRunExecutor() throws ExecutionException {
        GoExecutor executor = super.createRunExecutor();
        if (this.myCoverageDirectoryLocation != null) {
            executor.withExtraEnvironment(Map.of("GOCOVERDIR", this.myCoverageDirectoryLocation));
        }
        return executor;
    }

    @Override
    @Nullable
    protected ConsoleView createConsoleInner(@NotNull Executor executor, @NotNull ProcessHandler processHandler) throws ExecutionException {
        ConsoleView console;
        if (executor == null) {
            GoApplicationRunningState.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            GoApplicationRunningState.$$$reportNull$$$0(4);
        }
        if ((console = super.createConsoleInner(executor, processHandler)) != null && ((GoApplicationConfiguration)this.myConfiguration).getKind() == GoBuildingRunConfiguration.Kind.DIRECTORY && !FileUtil.pathsEqual((String)((GoApplicationConfiguration)this.myConfiguration).getDirectoryPath(), (String)((GoApplicationConfiguration)this.myConfiguration).getWorkingDirectory())) {
            String directoryPathUrl = VfsUtilCore.pathToUrl((String)((GoApplicationConfiguration)this.myConfiguration).getDirectoryPath());
            console.addMessageFilter((Filter)new GoConsoleFilter(((GoApplicationConfiguration)this.myConfiguration).getProject(), this.myModule, directoryPathUrl));
        }
        return console;
    }

    @Override
    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner, @NotNull ProcessHandler processHandler) throws ExecutionException {
        if (executor == null) {
            GoApplicationRunningState.$$$reportNull$$$0(5);
        }
        if (runner == null) {
            GoApplicationRunningState.$$$reportNull$$$0(6);
        }
        if (processHandler == null) {
            GoApplicationRunningState.$$$reportNull$$$0(7);
        }
        ExecutionResult result = super.execute(executor, runner, processHandler);
        String inputFile = ((GoApplicationConfiguration)this.myConfiguration).getRedirectInputPath();
        if (((GoApplicationConfiguration)this.myConfiguration).isRedirectInput() && inputFile != null) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try (FileInputStream is = new FileInputStream(inputFile);){
                    OutputStream os = processHandler.getProcessInput();
                    if (os != null) {
                        is.transferTo(os);
                        if (processHandler instanceof OSProcessHandler && ((OSProcessHandler)processHandler).hasPty()) {
                            GoApplicationRunningState.sendEof(os);
                        } else {
                            os.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        ExecutionResult executionResult = result;
        if (executionResult == null) {
            GoApplicationRunningState.$$$reportNull$$$0(8);
        }
        return executionResult;
    }

    private static void sendEof(@NotNull OutputStream os) throws IOException {
        if (os == null) {
            GoApplicationRunningState.$$$reportNull$$$0(9);
        }
        if (GoOsManager.isWindows()) {
            os.write(26);
        } else {
            os.write(4);
        }
    }

    @Override
    public void processReport(@NotNull Runnable afterConversion) {
        if (afterConversion == null) {
            GoApplicationRunningState.$$$reportNull$$$0(10);
        }
        super.processReport(() -> this.convertReport(afterConversion));
    }

    private void convertReport(Runnable afterConversion) {
        if (this.myCoverageLocation == null || this.myModule == null) {
            afterConversion.run();
            return;
        }
        GoExecutor.in(this.myModule).disablePty().withParameters("tool", "covdata", "textfmt", "-i=" + this.myCoverageDirectoryLocation, "-o=" + this.myCoverageLocation).showNotifications(true, false).executeWithProgress((Consumer<? super GoExecutor.ExecutionResult>)((Consumer)result -> afterConversion.run()));
    }

    public void setCoverageDirectoryLocation(String coverageDirectoryLocation) {
        this.myCoverageDirectoryLocation = coverageDirectoryLocation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/application/GoApplicationRunningState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterConversion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/application/GoApplicationRunningState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleInner";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sendEof";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processReport";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

