/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.execution.GoModuleBasedConfiguration;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.extension.GoRunConfigurationExtensionsManager;
import com.goide.psi.GoFile;
import com.goide.psi.GoPackageClause;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoRunConfigurationProducerBase<T extends GoRunConfigurationBase<?>>
extends LazyRunConfigurationProducer<T> {
    protected void prepareConfigurationFromContext(@NotNull T configuration, @Nullable Module module) {
        GoSdk sdk;
        if (configuration == null) {
            GoRunConfigurationProducerBase.$$$reportNull$$$0(0);
        }
        if ((sdk = GoSdkService.getInstance(configuration.getProject()).getSdk(module)).supportsCompilerCache()) {
            ((GoRunConfigurationBase)((Object)configuration)).setGoToolParams(GoRunUtil.filterOutInstallParameter(((GoRunConfigurationBase)((Object)configuration)).getGoToolParams()));
        }
        configuration.setModule(module);
    }

    @Contract(value="_, null -> false")
    protected boolean isConfigurationFromTheSameModule(@NotNull T configuration, @Nullable PsiElement contextElement) {
        if (configuration == null) {
            GoRunConfigurationProducerBase.$$$reportNull$$$0(1);
        }
        if (contextElement == null) {
            return false;
        }
        return Comparing.equal((Object)GoUtil.module(contextElement), (Object)((GoModuleBasedConfiguration)configuration.getConfigurationModule()).getModule());
    }

    @Contract(value="!null, _ -> !null; null, _ -> null")
    private static ConfigurationFromContext applyRunConfigurationExtensions(@Nullable ConfigurationFromContext config, @NotNull ConfigurationContext context) {
        if (context == null) {
            GoRunConfigurationProducerBase.$$$reportNull$$$0(2);
        }
        if (config != null) {
            RunConfiguration configuration = config.getConfiguration();
            Location location = context.getLocation();
            if (configuration instanceof GoRunConfigurationBase && location != null) {
                GoRunConfigurationExtensionsManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)((GoRunConfigurationBase)configuration), location);
            }
        }
        return config;
    }

    @Contract(value="null -> false")
    public static boolean isPackageContext(@Nullable PsiElement contextElement) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)contextElement, (Class[])new Class[]{GoPackageClause.class}) != null;
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        if (context == null) {
            GoRunConfigurationProducerBase.$$$reportNull$$$0(3);
        }
        return GoRunConfigurationProducerBase.applyRunConfigurationExtensions(super.createConfigurationFromContext(context), context);
    }

    @NotNull
    protected List<VirtualFile> getFilesFromContext(@Nullable ConfigurationContext context, @Nullable PsiFile contextFile) {
        Project project;
        Object[] files = context != null ? (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context.getDataContext()) : null;
        Project project2 = project = context != null ? context.getProject() : null;
        if (files != null && files.length > 0) {
            List list = ContainerUtil.filter((Object[])files, file -> {
                if (!GoUtil.isInProject(project, file)) {
                    return false;
                }
                return this.isAvailableOnFile(PsiManager.getInstance((Project)project).findFile(file));
            });
            if (list == null) {
                GoRunConfigurationProducerBase.$$$reportNull$$$0(4);
            }
            return list;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)(this.isAvailableOnFile(contextFile) ? contextFile.getVirtualFile() : null));
        if (list == null) {
            GoRunConfigurationProducerBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Contract(value="null -> false")
    protected boolean isAvailableOnFile(@Nullable PsiFile file) {
        return file instanceof GoFile;
    }

    @Nullable
    protected Module findModule(@Nullable PsiFile file, @NotNull ConfigurationContext context) {
        if (context == null) {
            GoRunConfigurationProducerBase.$$$reportNull$$$0(6);
        }
        if (file != null && ScratchUtil.isScratch((VirtualFile)file.getVirtualFile())) {
            return (Module)ContainerUtil.getFirstItem(GoSdkUtil.getGoModules(context.getProject()));
        }
        Module module = context.getModule();
        return module != null && GoSdkService.getInstance(module.getProject()).isGoModule(module) ? module : null;
    }

    @Nullable
    protected PsiElement getContextElement(@Nullable ConfigurationContext context) {
        if (context == null) {
            return null;
        }
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        PsiFileSystemItem psiFile = psiElement instanceof PsiFileSystemItem ? (PsiFileSystemItem)psiElement : psiElement.getContainingFile();
        if (!GoUtil.isInProject(psiElement.getProject(), psiFile != null ? psiFile.getVirtualFile() : null)) {
            return null;
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoRunConfigurationProducerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoRunConfigurationProducerBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesFromContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareConfigurationFromContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromTheSameModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyRunConfigurationExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

