/*
 * Decompiled with CFR 0.152.
 */
package com.goide.execution;

import com.goide.GoEnvironmentUtil;
import com.goide.GoNotifications;
import com.goide.codeInsight.imports.GoManualImportDetector;
import com.goide.configuration.GoSdkConfigurable;
import com.goide.dlv.DlvDisconnectOption;
import com.goide.execution.GoBuildResultCache;
import com.goide.execution.GoBuildResultKey;
import com.goide.execution.GoBuildingRunConfiguration;
import com.goide.execution.GoBuildingRunningState;
import com.goide.execution.GoRunConfigurationBase;
import com.goide.execution.GoRunUtil;
import com.goide.execution.GoRunningState;
import com.goide.execution.GoVersions;
import com.goide.execution.GoWslUtil;
import com.goide.execution.extension.GoRunConfigurationExtensionsManager;
import com.goide.execution.target.GoCommandLineSetup;
import com.goide.execution.target.GoLanguageRuntimeType;
import com.goide.execution.testing.GoTestRunConfiguration;
import com.goide.execution.testing.GoTestRunningState;
import com.goide.execution.testing.frameworks.gofuzz.GoFuzzFramework;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.statistics.GoDebuggerUsageCollector;
import com.goide.statistics.errors.GoProgrammingErrorsStatisticsCollector;
import com.goide.util.GoCommandLineParameter;
import com.goide.util.GoElfUtil;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoLocalEnvironmentRequest;
import com.goide.util.GoUtil;
import com.google.common.base.Suppliers;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Platform;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.system.CpuArch;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebuggerManager;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class GoBuildingRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NonNls
    private static final String ID = "GoBuildingRunner";
    private static final Key<String> OLD_SDK_FOR_DEBUG_SHOWN_FOR_SDK = Key.create((String)"go.old.sdk.for.debug.shown.for.sdk");
    @NonNls
    private static final String DO_NOT_SHOW_OLD_SDK_FOR_DEBUG_WARNING = "go.do.not.show.old.sdk.for.debug.warning";
    private static final Logger LOG = Logger.getInstance(GoBuildingRunner.class);

    @NotNull
    public String getRunnerId() {
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            GoBuildingRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            GoBuildingRunner.$$$reportNull$$$0(1);
        }
        if (profile instanceof WrappingRunConfiguration) {
            profile = ((WrappingRunConfiguration)profile).getPeer();
        }
        if (profile instanceof GoTestRunConfiguration && ((GoTestRunConfiguration)profile).getTestFramework() == GoFuzzFramework.INSTANCE && "Debug".equals(executorId)) {
            return false;
        }
        return profile instanceof GoRunConfigurationBase && ("Run".equals(executorId) || ((GoRunConfigurationBase)profile).supportsDelve() && "Debug".equals(executorId));
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(final @NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) throws ExecutionException {
        GoBuildingRunningState buildingState;
        GoHistoryProcessListener historyProcessListener;
        AsyncPromise buildingPromise;
        boolean debug;
        block11: {
            block10: {
                if (environment == null) {
                    GoBuildingRunner.$$$reportNull$$$0(2);
                }
                if (state == null) {
                    GoBuildingRunner.$$$reportNull$$$0(3);
                }
                if (!(state instanceof GoRunningState)) {
                    ExecutionResult result2 = state.execute(environment.getExecutor(), (ProgramRunner)this);
                    RunContentDescriptor contentToReuse = environment.getContentToReuse();
                    Promise promise = Promises.resolvedPromise(result2 != null ? new RunContentBuilder(result2, environment).showRunContent(contentToReuse) : null);
                    if (promise == null) {
                        GoBuildingRunner.$$$reportNull$$$0(4);
                    }
                    return promise;
                }
                debug = ((GoRunningState)state).isDebug();
                GoManualImportDetector.optimizeUnusedManualImports(environment.getProject());
                FileDocumentManager.getInstance().saveAllDocuments();
                buildingPromise = new AsyncPromise();
                historyProcessListener = this.createProcessListener();
                if (!(state instanceof GoBuildingRunningState)) break block10;
                buildingState = (GoBuildingRunningState)state;
                if (debug || ((GoBuildingRunningState)state).isBuildable()) break block11;
            }
            this.startProcessInBackground((GoRunningState)state, historyProcessListener, (Supplier<String>)Suppliers.ofInstance(null), environment, (AsyncPromise<RunContentDescriptor>)buildingPromise, 0, null);
            AsyncPromise asyncPromise = buildingPromise;
            if (asyncPromise == null) {
                GoBuildingRunner.$$$reportNull$$$0(5);
            }
            return asyncPromise;
        }
        GoBuildingRunner.checkSdkCompatibleWithSources(buildingState.getModule());
        List<GoCommandLineParameter> target = buildingState.getBuildingTarget();
        if (target == null) {
            throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.find.target.to.compile.error", (Object[])new Object[0]));
        }
        GoExecutor executor = buildingState.createBuildExecutor();
        final ThrowableRunnable checkBeforeRun = debug ? () -> GoBuildingRunner.checkDebugIsAllowed(environment.getProject(), buildingState, executor.getTargetEnvironmentRequest()) : null;
        GoBuildingRunConfiguration runConfiguration = (GoBuildingRunConfiguration)((Object)buildingState.getConfiguration());
        TargetEnvironmentRequest runningTargetEnvironment = buildingState.getTargetEnvironmentRequest();
        GoBuildResultKey buildResultKey = buildingState.getBuildResultKey();
        final GoCommandLineParameter remoteOutput = GoBuildingRunner.createBuildOutput(environment, runConfiguration, executor, buildResultKey, runningTargetEnvironment, buildingState instanceof GoTestRunningState);
        GoBuildingRunner.removeOverridenOutputParameter(executor);
        executor.withParameters(GoCommandLineParameter.string("-o"), remoteOutput);
        final ClientId clientId = ClientId.getCurrentOrNull();
        final long start = System.currentTimeMillis();
        HashMap<String, String> extraEnvironment = new HashMap<String, String>();
        extraEnvironment.put("GOOS", GoBuildingRunner.getRunningTargetPlatform(runConfiguration, runningTargetEnvironment));
        executor.withParameters(buildingState.getAdditionalBuildParams()).withParameters(target.toArray(GoCommandLineParameter.EMPTY_ARRAY)).disablePty().withPresentableName(GoBundle.message((String)"go.background.task.compiling.title", (Object[])new Object[0])).withPrintingOutputAsStatus().withExtraEnvironment(extraEnvironment).withProcessHandlerPatcher((Consumer<? super ProcessHandler>)((Consumer)handler -> GoRunConfigurationExtensionsManager.getInstance().attachExtensionsToProcess((RunConfigurationBase)runConfiguration, (ProcessHandler)handler, environment.getRunnerSettings()))).withProcessListener((ProcessListener)historyProcessListener).withProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                try (AccessToken ignored = ClientId.withClientId((ClientId)clientId);){
                    LOG.debug("Compilation finished in " + (System.currentTimeMillis() - start) + "ms");
                    super.processTerminated(event);
                    if (event.getExitCode() != 0) {
                        GoProgrammingErrorsStatisticsCollector.reportCompilationErrors(environment.getProject(), historyProcessListener.getOutput());
                    }
                    Supplier<String> localBuildOutput = () -> this.getLocalBuildOutput();
                    GoBuildingRunner.this.startProcessInBackground(buildingState, historyProcessListener, localBuildOutput, environment, (AsyncPromise<RunContentDescriptor>)buildingPromise, event.getExitCode(), (ThrowableRunnable<ExecutionException>)checkBeforeRun);
                }
            }

            @Nullable
            private String getLocalBuildOutput() {
                TargetValue<String> buildOutput = remoteOutput.toValue();
                if (buildOutput == null) {
                    LOG.error("Parameter had not been passed to target: " + remoteOutput.toPresentableString());
                    return null;
                }
                try {
                    return (String)buildOutput.getLocalValue().blockingGet(0);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    LOG.debug("Build result had not been downloaded from target: " + remoteOutput.toPresentableString(), (Throwable)e);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/goide/execution/GoBuildingRunner$1", "processTerminated"));
            }
        }).executeWithProgress((Consumer<? super GoExecutor.ExecutionResult>)((Consumer)result -> {
            if (result.status == GoExecutor.ExecutionResult.Status.CANCELLED) {
                buildingPromise.setError((String)ObjectUtils.notNull((Object)result.message, (Object)GoBundle.message((String)"go.execution.process.cancelled", (Object[])new Object[0])));
            }
        }));
        AsyncPromise asyncPromise = buildingPromise;
        if (asyncPromise == null) {
            GoBuildingRunner.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    private static void checkSdkCompatibleWithSources(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            GoBuildingRunner.$$$reportNull$$$0(7);
        }
        boolean wslSources = GoWslUtil.hasSourcesInWsl(module);
        GoSdk sdk = GoSdkService.getInstance(module.getProject()).getSdk(module);
        boolean wslSdk = GoWslUtil.isInWsl(sdk);
        if (wslSources && !wslSdk) {
            throw new ExecutionException(GoBundle.message((String)"go.error.wsl.project.windows.sdk", (Object[])new Object[0]));
        }
        if (wslSdk && !wslSources) {
            throw new ExecutionException(GoBundle.message((String)"go.error.windows.project.wsl.sdk", (Object[])new Object[0]));
        }
    }

    private static void removeOverridenOutputParameter(@NotNull GoExecutor executor) {
        if (executor == null) {
            GoBuildingRunner.$$$reportNull$$$0(8);
        }
        List<GoCommandLineParameter> parameters = executor.getParameters();
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            GoCommandLineParameter parameter = parameters.get(i);
            if (!(parameter instanceof GoCommandLineParameter.StringParameter) || !"-o".equals(parameter.toPresentableString())) continue;
            if (parameters.size() > i + 1) {
                executor.withoutParameter(i + 1);
            }
            executor.withoutParameter(i);
            break;
        }
    }

    @Nullable
    private static String getRunningTargetPlatform(@NotNull GoRunConfigurationBase<?> runConfiguration, @Nullable TargetEnvironmentRequest targetEnvironmentRequest) {
        if (runConfiguration == null) {
            GoBuildingRunner.$$$reportNull$$$0(9);
        }
        String environmentPlatform = GoRunUtil.getTargetPlatform(targetEnvironmentRequest);
        return (String)ObjectUtils.chooseNotNull((Object)GoRunUtil.getRunConfigurationGOOS(runConfiguration), (Object)environmentPlatform);
    }

    @NotNull
    private static GoCommandLineParameter createBuildOutput(@NotNull ExecutionEnvironment environment, @NotNull GoBuildingRunConfiguration<?> runConfiguration, @NotNull GoExecutor buildExecutor, @Nullable GoBuildResultKey buildResultKey, @Nullable TargetEnvironmentRequest runningTargetEnvironment, boolean test) throws ExecutionException {
        GoCommandLineParameter overriddenOutput;
        if (environment == null) {
            GoBuildingRunner.$$$reportNull$$$0(10);
        }
        if (runConfiguration == null) {
            GoBuildingRunner.$$$reportNull$$$0(11);
        }
        if (buildExecutor == null) {
            GoBuildingRunner.$$$reportNull$$$0(12);
        }
        if ((overriddenOutput = GoBuildingRunner.getOverriddenOutput(runConfiguration, buildExecutor)) != null) {
            GoCommandLineParameter goCommandLineParameter = overriddenOutput;
            if (goCommandLineParameter == null) {
                GoBuildingRunner.$$$reportNull$$$0(13);
            }
            return goCommandLineParameter;
        }
        String targetPlatform = GoBuildingRunner.getRunningTargetPlatform(runConfiguration, runningTargetEnvironment);
        String binaryName = GoBuildingRunner.getOutputBinaryName(environment, targetPlatform, test);
        File outputFile = GoBuildingRunner.createLocalOutputFile(runConfiguration, binaryName, buildResultKey);
        if (GoBuildingRunner.isLocalExecutor(buildExecutor) || GoBuildingRunner.isPathInTargetWsl(buildExecutor, runConfiguration.getOutputDirectory())) {
            DownloadFromTargetParameter downloadFromTargetParameter = DownloadFromTargetParameter.forFullPath(outputFile.toPath());
            if (downloadFromTargetParameter == null) {
                GoBuildingRunner.$$$reportNull$$$0(14);
            }
            return downloadFromTargetParameter;
        }
        Path outputDir = outputFile.getParentFile().toPath();
        DownloadFromTargetParameter downloadFromTargetParameter = DownloadFromTargetParameter.forLanguageRuntime(outputFile.getName(), GoLanguageRuntimeType.COMPILED_EXECUTABLES_VOLUME, outputDir);
        if (downloadFromTargetParameter == null) {
            GoBuildingRunner.$$$reportNull$$$0(15);
        }
        return downloadFromTargetParameter;
    }

    private void startProcessInBackground(final @NotNull GoRunningState<?> state, final @NotNull GoHistoryProcessListener historyProcessListener, final @NotNull Supplier<@Nullable String> outputFilePath, final @NotNull ExecutionEnvironment environment, final @NotNull AsyncPromise<RunContentDescriptor> buildingPromise, final int exitCode, final @Nullable ThrowableRunnable<ExecutionException> checkBeforeRun) {
        Project project;
        if (state == null) {
            GoBuildingRunner.$$$reportNull$$$0(16);
        }
        if (historyProcessListener == null) {
            GoBuildingRunner.$$$reportNull$$$0(17);
        }
        if (outputFilePath == null) {
            GoBuildingRunner.$$$reportNull$$$0(18);
        }
        if (environment == null) {
            GoBuildingRunner.$$$reportNull$$$0(19);
        }
        if (buildingPromise == null) {
            GoBuildingRunner.$$$reportNull$$$0(20);
        }
        if ((project = environment.getProject()).isDisposed()) {
            buildingPromise.setResult(null);
            return;
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project, GoBundle.message((String)"go.background.task.running.title", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (checkBeforeRun != null) {
                    try {
                        checkBeforeRun.run();
                    }
                    catch (ExecutionException e) {
                        ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)e);
                        buildingPromise.setError((Throwable)e);
                        return;
                    }
                }
                indicator.setText2(state.getConfiguration().getName());
                try {
                    GoBuildingRunner.this.createStarter(state, historyProcessListener, outputFilePath, exitCode).execute(state, environment).processed((Promise)buildingPromise);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    buildingPromise.setError(e);
                    LOG.warn("Cannot run program", e);
                }
            }

            public void onCancel() {
                buildingPromise.setError(GoBundle.message((String)"go.execution.process.cancelled", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/execution/GoBuildingRunner$2", "run"));
            }
        };
        this.runOnEdt(() -> {
            if (project.isDisposed()) {
                task2.onCancel();
                return;
            }
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        }, ModalityState.defaultModalityState());
    }

    private static void checkDebugIsAllowed(@NotNull Project project, @NotNull GoRunningState<?> state, @NotNull TargetEnvironmentRequest execTarget) throws ExecutionException {
        WSLDistribution wsl;
        if (project == null) {
            GoBuildingRunner.$$$reportNull$$$0(21);
        }
        if (state == null) {
            GoBuildingRunner.$$$reportNull$$$0(22);
        }
        if (execTarget == null) {
            GoBuildingRunner.$$$reportNull$$$0(23);
        }
        Module module = state.getModule();
        if (CpuArch.is32Bit() && execTarget.getTargetPlatform().getPlatform() != Platform.UNIX) {
            throw new ExecutionException(GoBundle.message((String)"go.debugger.unsupported.architecture.error", (Object[])new Object[0]));
        }
        TargetEnvironmentRequest request = state.getTargetEnvironmentRequest();
        if (request instanceof WslTargetEnvironmentRequest && (wsl = ((WslTargetEnvironmentRequest)request).getConfiguration().getDistribution()) != null && wsl.getVersion() == 1) {
            throw new ExecutionException(GoBundle.message((String)"go.debugger.unsupported.wsl1", (Object[])new Object[0]));
        }
        if (execTarget instanceof GoLocalEnvironmentRequest && "darwin".equals(GoRunUtil.getLocalTargetPlatform()) && CpuArch.isArm64()) {
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
            if (!sdk.supportsDarwinArm64()) {
                throw new ExecutionException(GoBundle.message((String)"go.debugger.unsupported.go.version.on.darwin.arm64.error", (Object[])new Object[0]));
            }
            Map<String, String> envVars = ((GoRunConfigurationBase)((Object)state.getConfiguration())).getCustomEnvironment();
            if (!"arm64".equals(envVars.get("GOARCH"))) {
                String goVersion = GoVersions.getGoVersionOutput(project, state.getModule());
                if (goVersion == null) {
                    LOG.warn("Failed to check whether go sdk is compatible with darwin/arm64");
                } else if (!goVersion.endsWith("darwin/arm64")) {
                    throw new ExecutionException(GoBundle.message((String)"go.debugger.unsupported.go.arch.on.darwin.arm64.error", (Object[])new Object[]{goVersion}));
                }
            }
        }
    }

    @NotNull
    protected GoHistoryProcessListener createProcessListener() {
        return new GoHistoryProcessListener();
    }

    @NotNull
    protected Promise<RunContentDescriptor> executeProcess(@NotNull GoRunningState<?> state, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler process) {
        if (state == null) {
            GoBuildingRunner.$$$reportNull$$$0(24);
        }
        if (env == null) {
            GoBuildingRunner.$$$reportNull$$$0(25);
        }
        if (process == null) {
            GoBuildingRunner.$$$reportNull$$$0(26);
        }
        Promise promise = ReadAction.nonBlocking(() -> {
            state.prepareStateInBGT();
            return null;
        }).expireWhen(() -> env.getProject().isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService()).thenAsync(__ -> {
            AsyncPromise result = new AsyncPromise();
            this.runOnEdt(() -> Promises.compute((AsyncPromise)result, () -> {
                try {
                    ExecutionResult executionResult = state.execute(env.getExecutor(), (ProgramRunner<?>)this, process);
                    RunContentBuilder contentDescriptor = new RunContentBuilder(executionResult, env);
                    return contentDescriptor.showRunContent(env.getContentToReuse());
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }), ModalityState.nonModal());
            return result;
        });
        if (promise == null) {
            GoBuildingRunner.$$$reportNull$$$0(27);
        }
        return promise;
    }

    protected void runOnEdt(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            GoBuildingRunner.$$$reportNull$$$0(28);
        }
        if (modalityState == null) {
            GoBuildingRunner.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().invokeLater(runnable2, modalityState);
    }

    @NotNull
    protected GoStarter createStarter(@NotNull GoRunningState<?> state, @NotNull GoHistoryProcessListener historyProcessListener, @NotNull Supplier<@Nullable String> outputFilePath, int compilationExitCode) {
        if (state == null) {
            GoBuildingRunner.$$$reportNull$$$0(30);
        }
        if (historyProcessListener == null) {
            GoBuildingRunner.$$$reportNull$$$0(31);
        }
        if (outputFilePath == null) {
            GoBuildingRunner.$$$reportNull$$$0(32);
        }
        return state.isDebug() ? new GoDebugStarter(outputFilePath, historyProcessListener, compilationExitCode) : new GoStarter(outputFilePath, historyProcessListener, compilationExitCode);
    }

    @Nullable
    private static GoCommandLineParameter getOverriddenOutput(@NotNull GoRunConfigurationBase<?> runConfiguration, @NotNull GoExecutor executor) {
        String overriddenOutputFileParameter;
        if (runConfiguration == null) {
            GoBuildingRunner.$$$reportNull$$$0(33);
        }
        if (executor == null) {
            GoBuildingRunner.$$$reportNull$$$0(34);
        }
        if (StringUtil.isEmpty((String)(overriddenOutputFileParameter = runConfiguration.getOverriddenOutputFileParameter()))) {
            return null;
        }
        if (FileUtil.isAbsolute((String)overriddenOutputFileParameter)) {
            return DownloadFromTargetParameter.forFullPath(Path.of(overriddenOutputFileParameter, new String[0]).normalize());
        }
        WSLDistribution wsl = executor.getTargetWsl();
        if (wsl != null && GoWslUtil.isAbsoluteWslPath(overriddenOutputFileParameter)) {
            return GoCommandLineParameter.wslPath(wsl.getWindowsPath(overriddenOutputFileParameter), overriddenOutputFileParameter);
        }
        if (GoBuildingRunner.isLocalExecutor(executor)) {
            String workingDirectory = GoBuildingRunner.getLocalCompilationWorkingDirectory(runConfiguration, executor);
            return DownloadFromTargetParameter.forFullPath(Path.of(workingDirectory, overriddenOutputFileParameter).normalize());
        }
        return DownloadFromTargetParameter.forLanguageRuntime(overriddenOutputFileParameter, GoLanguageRuntimeType.COMPILED_EXECUTABLES_VOLUME);
    }

    @NotNull
    private static String getLocalCompilationWorkingDirectory(@NotNull GoRunConfigurationBase<?> runConfiguration, @NotNull GoExecutor executor) {
        if (runConfiguration == null) {
            GoBuildingRunner.$$$reportNull$$$0(35);
        }
        if (executor == null) {
            GoBuildingRunner.$$$reportNull$$$0(36);
        }
        String string = (String)ObjectUtils.notNull((Object)executor.getWorkDirectory(), (Object)runConfiguration.getWorkingDirectory());
        if (string == null) {
            GoBuildingRunner.$$$reportNull$$$0(37);
        }
        return string;
    }

    private static boolean isPathInTargetWsl(@NotNull GoExecutor executor, @Nullable String path) {
        if (executor == null) {
            GoBuildingRunner.$$$reportNull$$$0(38);
        }
        if (StringUtil.isEmpty((String)path)) {
            return false;
        }
        WSLDistribution targetWsl = executor.getTargetWsl();
        WslPath wslPath = WslPath.parseWindowsUncPath((String)path);
        return wslPath != null && Objects.equals(wslPath.getDistribution(), targetWsl);
    }

    public static boolean isLocalExecutor(@NotNull GoExecutor executor) {
        if (executor == null) {
            GoBuildingRunner.$$$reportNull$$$0(39);
        }
        return executor.getTargetEnvironmentRequest() instanceof LocalTargetEnvironmentRequest;
    }

    @NotNull
    private static File createLocalOutputFile(@NotNull GoBuildingRunConfiguration<?> configuration, @NotNull String binaryName, @Nullable GoBuildResultKey buildResultKey) throws ExecutionException {
        File outputFile;
        block14: {
            String outputDirectoryPath;
            if (configuration == null) {
                GoBuildingRunner.$$$reportNull$$$0(40);
            }
            if (binaryName == null) {
                GoBuildingRunner.$$$reportNull$$$0(41);
            }
            if (StringUtil.isEmpty((String)(outputDirectoryPath = configuration.getOutputDirectory()))) {
                Project project = configuration.getProject();
                Module module = configuration.getDefaultModule();
                String cachedOutputPath = GoBuildResultCache.getInstance().getCachedOutputPath(buildResultKey, project, module);
                if (cachedOutputPath != null) {
                    LOG.debug("Found cached output file path: " + cachedOutputPath);
                    File cachedOutputFile = new File(cachedOutputPath);
                    if (!GoBuildingRunner.isFileLocked(cachedOutputFile)) {
                        File file = cachedOutputFile;
                        if (file == null) {
                            GoBuildingRunner.$$$reportNull$$$0(42);
                        }
                        return file;
                    }
                    LOG.debug("Cached output file is locked. Creating the new one.");
                }
                try {
                    File dir = GoUtil.getGoLandTempDirectory().toFile();
                    outputFile = FileUtil.createTempFile((File)dir, (String)"", (String)binaryName, (boolean)true);
                    GoBuildResultCache.getInstance().cacheOutputPath(buildResultKey, outputFile.getAbsolutePath(), project, module);
                }
                catch (IOException e) {
                    throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.create.temp.output.file.error", (Object[])new Object[0]), (Throwable)e);
                }
            }
            File outputDirectory = new File(outputDirectoryPath);
            if (outputDirectory.isDirectory() || !outputDirectory.exists() && outputDirectory.mkdirs()) {
                outputFile = new File(outputDirectoryPath, binaryName);
                try {
                    if (!outputFile.exists() && !outputFile.createNewFile()) {
                        throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.create.output.file.error", (Object[])new Object[]{outputFile.getAbsolutePath()}));
                    }
                    break block14;
                }
                catch (IOException e) {
                    throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.create.output.file.error", (Object[])new Object[]{outputFile.getAbsolutePath()}));
                }
            }
            throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.create.output.file.in.error", (Object[])new Object[]{outputDirectory.getAbsolutePath()}));
        }
        if (outputFile.length() == 0L && !GoElfUtil.makeExecutableElfFile(outputFile)) {
            throw new ExecutionException(GoBundle.message((String)"go.execution.cannot.make.temporary.file.executable.error", (Object[])new Object[]{outputFile.getAbsolutePath()}));
        }
        File file = outputFile;
        if (file == null) {
            GoBuildingRunner.$$$reportNull$$$0(43);
        }
        return file;
    }

    private static boolean isFileLocked(@NotNull File file) {
        if (file == null) {
            GoBuildingRunner.$$$reportNull$$$0(44);
        }
        return !file.renameTo(file);
    }

    @NotNull
    private static String getOutputBinaryName(@NotNull ExecutionEnvironment environment, @Nullable String targetPlatform, boolean test) {
        RunnerAndConfigurationSettings settings;
        if (environment == null) {
            GoBuildingRunner.$$$reportNull$$$0(45);
        }
        Object configurationName = (settings = environment.getRunnerAndConfigurationSettings()) != null ? StringUtil.first((String)settings.getName(), (int)240, (boolean)false) : "application";
        boolean isWindows = "windows".equals(targetPlatform);
        if (!isWindows && !Objects.equals(GoRunUtil.getLocalTargetPlatform(), targetPlatform)) {
            configurationName = (String)configurationName + "_" + targetPlatform;
        }
        String string = GoEnvironmentUtil.getBinaryFileNameForPath(FileUtil.sanitizeFileName((String)configurationName), test ? ".test" : "", isWindows);
        if (string == null) {
            GoBuildingRunner.$$$reportNull$$$0(46);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 13, 14, 15, 27, 37, 42, 43, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 10: 
            case 19: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 16: 
            case 22: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 42: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/execution/GoBuildingRunner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 34: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: 
            case 11: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildExecutor";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProcessListener";
                break;
            }
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFilePath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildingPromise";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execTarget";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/execution/GoBuildingRunner";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildOutput";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "executeProcess";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCompilationWorkingDirectory";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocalOutputFile";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputBinaryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 27: 
            case 37: 
            case 42: 
            case 43: 
            case 46: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkSdkCompatibleWithSources";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeOverridenOutputParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRunningTargetPlatform";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createBuildOutput";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "startProcessInBackground";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkDebugIsAllowed";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "executeProcess";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runOnEdt";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createStarter";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenOutput";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCompilationWorkingDirectory";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isPathInTargetWsl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isLocalExecutor";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createLocalOutputFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isFileLocked";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getOutputBinaryName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 13, 14, 15, 27, 37, 42, 43, 46 -> new IllegalStateException(string);
        };
    }

    public static final class DownloadFromTargetParameter
    implements GoCommandLineParameter {
        private final String myPathInVolume;
        private final String myVolumeRoot;
        private final LanguageRuntimeType.VolumeDescriptor myVolume;
        private final Path myLocalPath;
        private volatile TargetValue<String> myTargetValue;

        @NotNull
        public static DownloadFromTargetParameter forFullPath(@NotNull Path path) {
            if (path == null) {
                DownloadFromTargetParameter.$$$reportNull$$$0(0);
            }
            return new DownloadFromTargetParameter(path.getFileName().toString(), null, path.getParent().toString(), path.getParent());
        }

        @NotNull
        public static DownloadFromTargetParameter forLanguageRuntime(@NotNull String outputFileName, @Nullable LanguageRuntimeType.VolumeDescriptor volume) {
            if (outputFileName == null) {
                DownloadFromTargetParameter.$$$reportNull$$$0(1);
            }
            return DownloadFromTargetParameter.forLanguageRuntime(outputFileName, volume, null);
        }

        @NotNull
        public static DownloadFromTargetParameter forLanguageRuntime(@NotNull String outputFileName, @Nullable LanguageRuntimeType.VolumeDescriptor volume, @Nullable Path localPath) {
            if (outputFileName == null) {
                DownloadFromTargetParameter.$$$reportNull$$$0(2);
            }
            return new DownloadFromTargetParameter(outputFileName, volume, null, localPath);
        }

        private DownloadFromTargetParameter(@NotNull String outputFileName, @Nullable LanguageRuntimeType.VolumeDescriptor volume, @Nullable String volumeRoot, @Nullable Path localPath) {
            if (outputFileName == null) {
                DownloadFromTargetParameter.$$$reportNull$$$0(3);
            }
            this.myPathInVolume = outputFileName;
            this.myVolume = volume;
            this.myVolumeRoot = StringUtil.nullize((String)volumeRoot);
            this.myLocalPath = localPath;
        }

        @Override
        @NotNull
        public String toPresentableString() {
            String string = this.myPathInVolume;
            if (string == null) {
                DownloadFromTargetParameter.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public void prepare(@NotNull GoCommandLineSetup setup) {
            if (setup == null) {
                DownloadFromTargetParameter.$$$reportNull$$$0(5);
            }
            this.myTargetValue = setup.requestDownloadFromTarget(this.myVolume, this.myVolumeRoot, this.myPathInVolume, this.myLocalPath);
        }

        @Override
        public TargetValue<String> toValue() {
            return this.myTargetValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputFileName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoBuildingRunner$DownloadFromTargetParameter";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "setup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoBuildingRunner$DownloadFromTargetParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toPresentableString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forFullPath";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "forLanguageRuntime";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "prepare";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public class GoDebugStarter
    extends GoStarter {
        public GoDebugStarter(@NotNull Supplier<String> outputFilePath, GoHistoryProcessListener historyListener, int compilationExitCode) {
            if (outputFilePath == null) {
                GoDebugStarter.$$$reportNull$$$0(0);
            }
            if (historyListener == null) {
                GoDebugStarter.$$$reportNull$$$0(1);
            }
            super(outputFilePath, historyListener, compilationExitCode);
        }

        @Override
        @NotNull
        public Promise<RunContentDescriptor> execute(@NotNull GoRunningState<?> state, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (state == null) {
                GoDebugStarter.$$$reportNull$$$0(2);
            }
            if (env == null) {
                GoDebugStarter.$$$reportNull$$$0(3);
            }
            this.patchBuildingState(state);
            GoDebuggerUsageCollector.triggerUsualRun(env.getProject());
            ProcessHandler process = state.startProcess();
            if (this.myCompilationExitCode != 0) {
                Promise<RunContentDescriptor> promise = GoBuildingRunner.this.executeProcess(state, env, process);
                if (promise == null) {
                    GoDebugStarter.$$$reportNull$$$0(4);
                }
                return promise;
            }
            Project project = env.getProject();
            GoDebugStarter.showOldGoVersionWarningIfNeeded(project);
            Promise promise = state.getDebugClientAddress().thenAsync(address -> {
                if (address == null) {
                    return Promises.rejectedPromise((Throwable)new ExecutionException(GoBundle.message((String)"go.execution.could.not.bind.remote.debugging.port.error", (Object[])new Object[0])));
                }
                if (state.isRemoteDebug()) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        return Promises.resolvedPromise();
                    }
                }
                return ReadAction.nonBlocking(() -> {
                    state.prepareStateInBGT();
                    return null;
                }).expireWhen(() -> env.getProject().isDisposed()).submit((Executor)AppExecutorUtil.getAppExecutorService()).thenAsync(__ -> {
                    AsyncPromise result = new AsyncPromise();
                    GoBuildingRunner.this.runOnEdt(() -> Promises.compute((AsyncPromise)result, () -> {
                        try {
                            ExecutionResult executionResult = state.execute(env.getExecutor(), (ProgramRunner<?>)GoBuildingRunner.this, process);
                            XDebugProcessStarter starter = this.createDebugProcessStarter(executionResult, state.isRemoteDebug(), (InetSocketAddress)address);
                            return XDebuggerManager.getInstance((Project)project).startSession(env, starter).getRunContentDescriptor();
                        }
                        catch (ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }), ModalityState.nonModal());
                    return result;
                });
            });
            if (promise == null) {
                GoDebugStarter.$$$reportNull$$$0(5);
            }
            return promise;
        }

        @NotNull
        protected XDebugProcessStarter createDebugProcessStarter(@Nullable ExecutionResult executionResult, boolean remote, @Nullable InetSocketAddress socket) {
            XDebugProcessStarter xDebugProcessStarter = GoRunUtil.createDelveXDebugStarter(socket, executionResult, DlvDisconnectOption.KILL, remote);
            if (xDebugProcessStarter == null) {
                GoDebugStarter.$$$reportNull$$$0(6);
            }
            return xDebugProcessStarter;
        }

        private static void showOldGoVersionWarningIfNeeded(final @NotNull Project project) {
            if (project == null) {
                GoDebugStarter.$$$reportNull$$$0(7);
            }
            if (PropertiesComponent.getInstance((Project)project).getBoolean(GoBuildingRunner.DO_NOT_SHOW_OLD_SDK_FOR_DEBUG_WARNING)) {
                return;
            }
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(null);
            if (sdk.getMajorVersion().isAtLeast(GoSdkVersion.GO_1_7)) {
                return;
            }
            String alreadyShowSdk = (String)project.getUserData(OLD_SDK_FOR_DEBUG_SHOWN_FOR_SDK);
            if (Objects.equals(sdk.getHomeUrl(), alreadyShowSdk)) {
                return;
            }
            project.putUserData(OLD_SDK_FOR_DEBUG_SHOWN_FOR_SDK, (Object)sdk.getHomeUrl());
            GoNotifications.getGeneralGroup().createNotification(GoBundle.message((String)"go.execution.outdated.go.notification.title", (Object[])new Object[0]), GoBundle.message((String)"go.execution.outdated.go.notification.text", (Object[])new Object[0]), NotificationType.WARNING).addAction((AnAction)new NotificationAction(GoBundle.message((String)"go.execution.change.goroot.action.name", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notification == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (project.isDisposed()) {
                        return;
                    }
                    notification.expire();
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new GoSdkConfigurable(project, true));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                    }
                    objectArray[1] = "com/goide/execution/GoBuildingRunner$GoDebugStarter$1";
                    objectArray[2] = "actionPerformed";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }).addAction((AnAction)new GoDoNotShowNotificationAction(project, GoBuildingRunner.DO_NOT_SHOW_OLD_SDK_FOR_DEBUG_WARNING)).notify(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "historyListener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoBuildingRunner$GoDebugStarter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoBuildingRunner$GoDebugStarter";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDebugProcessStarter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "showOldGoVersionWarningIfNeeded";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    protected class GoStarter {
        protected final int myCompilationExitCode;
        private final Supplier<@Nullable String> myOutputFilePath;
        private final GoHistoryProcessListener myHistoryProcessListener;

        public GoStarter(@NotNull Supplier<String> outputFilePath, GoHistoryProcessListener historyListener, int compilationExitCode) {
            if (outputFilePath == null) {
                GoStarter.$$$reportNull$$$0(0);
            }
            if (historyListener == null) {
                GoStarter.$$$reportNull$$$0(1);
            }
            this.myOutputFilePath = outputFilePath;
            this.myHistoryProcessListener = historyListener;
            this.myCompilationExitCode = compilationExitCode;
        }

        @NotNull
        public Promise<RunContentDescriptor> execute(@NotNull GoRunningState<?> state, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (state == null) {
                GoStarter.$$$reportNull$$$0(2);
            }
            if (env == null) {
                GoStarter.$$$reportNull$$$0(3);
            }
            this.patchBuildingState(state);
            Promise<RunContentDescriptor> promise = GoBuildingRunner.this.executeProcess(state, env, state.startProcess());
            if (promise == null) {
                GoStarter.$$$reportNull$$$0(4);
            }
            return promise;
        }

        protected void patchBuildingState(@NotNull GoRunningState<?> state) {
            if (state == null) {
                GoStarter.$$$reportNull$$$0(5);
            }
            if (state instanceof GoBuildingRunningState) {
                ((GoBuildingRunningState)state).setHistoryProcessHandler(this.myHistoryProcessListener);
                ((GoBuildingRunningState)state).setOutputFilePath(this.myOutputFilePath);
                ((GoBuildingRunningState)state).setCompilationExitCode(this.myCompilationExitCode);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "historyListener";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/execution/GoBuildingRunner$GoStarter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/execution/GoBuildingRunner$GoStarter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "patchBuildingState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class GoDoNotShowNotificationAction
    extends NotificationAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final String myKey;

        public GoDoNotShowNotificationAction(@NotNull Project project, @NotNull String key) {
            if (project == null) {
                GoDoNotShowNotificationAction.$$$reportNull$$$0(0);
            }
            if (key == null) {
                GoDoNotShowNotificationAction.$$$reportNull$$$0(1);
            }
            super(GoBundle.message((String)"go.notification.do.not.show.action.text", (Object[])new Object[0]));
            this.myProject = project;
            this.myKey = key;
        }

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            if (e == null) {
                GoDoNotShowNotificationAction.$$$reportNull$$$0(2);
            }
            if (notification == null) {
                GoDoNotShowNotificationAction.$$$reportNull$$$0(3);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            notification.expire();
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            propertiesComponent.setValue(this.myKey, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notification";
                    break;
                }
            }
            objectArray2[1] = "com/goide/execution/GoBuildingRunner$GoDoNotShowNotificationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

