/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor.template;

import com.goide.GoLanguage;
import com.goide.GoTypes;
import com.goide.highlighting.GoSyntaxHighlighter;
import com.goide.i18n.GoBundle;
import com.goide.inspections.tag.GoTagAddKeyIntention;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoEmptyStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportList;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoTag;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoLiveTemplateContextType
extends TemplateContextType {
    protected GoLiveTemplateContextType(@NotNull @NlsContexts.Label String presentableName) {
        if (presentableName == null) {
            GoLiveTemplateContextType.$$$reportNull$$$0(0);
        }
        super(presentableName);
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        int offset;
        PsiFile file;
        if (templateActionContext == null) {
            GoLiveTemplateContextType.$$$reportNull$$$0(1);
        }
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)(file = templateActionContext.getFile()), (int)(offset = templateActionContext.getStartOffset())).isKindOf(GoLanguage.INSTANCE)) {
            PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(offset), (Object)file);
            if (!this.acceptLeaf()) {
                psiElement = GoLiveTemplateContextType.getFirstCompositeElement(psiElement);
            }
            return psiElement != null && !(psiElement.getContainingFile() instanceof GoCodeFragment) && this.isInContext(psiElement);
        }
        return false;
    }

    protected boolean acceptLeaf() {
        return false;
    }

    @Nullable
    public static PsiElement nextVisibleLeafOrNewLine(PsiElement element) {
        PsiElement nextLeaf = element;
        while ((nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf)) != null) {
            if (nextLeaf instanceof PsiComment || nextLeaf instanceof PsiErrorElement) continue;
            if (!(nextLeaf instanceof PsiWhiteSpace)) break;
            if (!nextLeaf.textContains('\n')) continue;
            return nextLeaf;
        }
        return nextLeaf;
    }

    @Nullable
    public static PsiElement prevVisibleLeafOrNewLine(PsiElement element) {
        PsiElement prevLeaf = element;
        while ((prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf)) != null) {
            if (prevLeaf instanceof PsiComment || prevLeaf instanceof PsiErrorElement) continue;
            if (!(prevLeaf instanceof PsiWhiteSpace)) break;
            if (!prevLeaf.textContains('\n')) continue;
            return prevLeaf;
        }
        return prevLeaf;
    }

    @Nullable
    private static PsiElement getFirstCompositeElement(@Nullable PsiElement at) {
        PsiElement result;
        if (at instanceof PsiComment || at instanceof LeafPsiElement && ((LeafPsiElement)at).getElementType() == GoTypes.STRING) {
            return at;
        }
        for (result = at; result != null && (result instanceof PsiWhiteSpace || result.getNode().getChildren(null).length == 0); result = result.getParent()) {
        }
        return result;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    public SyntaxHighlighter createHighlighter() {
        return new GoSyntaxHighlighter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateActionContext";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/template/GoLiveTemplateContextType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Statement
    extends GoLiveTemplateContextType {
        public Statement() {
            super(GoBundle.message((String)"go.live.template.context.type.statement.presentable.name", (Object[])new Object[0]));
        }

        public static boolean onStatementBeginning(@NotNull PsiElement psiElement) {
            PsiElement prevLeaf;
            if (psiElement == null) {
                Statement.$$$reportNull$$$0(0);
            }
            if ((prevLeaf = Statement.prevVisibleLeafOrNewLine(psiElement)) == null) {
                return false;
            }
            if (prevLeaf instanceof PsiWhiteSpace || prevLeaf instanceof GoImportList || prevLeaf instanceof GoEmptyStatement) {
                return true;
            }
            IElementType type2 = prevLeaf.getNode().getElementType();
            return type2 == GoTypes.SEMICOLON || type2 == GoTypes.LBRACE || type2 == GoTypes.RBRACE || type2 == GoTypes.COLON;
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Statement.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiComment) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof GoExpression) {
                if (parent.getFirstChild() != element) {
                    return false;
                }
                parent = parent.getParent();
            }
            if (parent instanceof PsiErrorElement) {
                parent = parent.getParent();
            }
            return (parent instanceof GoStatement || parent instanceof GoLeftHandExprList || parent instanceof GoStatementsHolder) && Statement.onStatementBeginning(element);
        }

        @Override
        protected boolean acceptLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/goide/editor/template/GoLiveTemplateContextType$Statement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onStatementBeginning";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isInContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class TagLiteral
    extends GoLiveTemplateContextType {
        public TagLiteral() {
            super(GoBundle.message((String)"go.live.template.context.type.tag.literal.presentable.name", (Object[])new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                TagLiteral.$$$reportNull$$$0(0);
            }
            return element instanceof GoStringLiteral && element.getParent() instanceof GoTag;
        }

        @Override
        public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
            if (templateActionContext == null) {
                TagLiteral.$$$reportNull$$$0(1);
            }
            return super.isInContext(templateActionContext) && !GoTagAddKeyIntention.isInProgress(templateActionContext.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "templateActionContext";
                    break;
                }
            }
            objectArray[1] = "com/goide/editor/template/GoLiveTemplateContextType$TagLiteral";
            objectArray[2] = "isInContext";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Tag
    extends GoLiveTemplateContextType {
        private Tag() {
            super(GoBundle.message((String)"go.live.template.context.type.tag.presentable.name", (Object[])new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Tag.$$$reportNull$$$0(0);
            }
            if (element.getNode().getElementType() == GoTypes.IDENTIFIER) {
                if (Tag.isInsideFieldTypeDeclaration(element)) {
                    return true;
                }
                return Tag.isInsideFieldTypeDeclaration(Tag.prevVisibleLeafOrNewLine(element));
            }
            return false;
        }

        private static boolean isInsideFieldTypeDeclaration(@Nullable PsiElement element) {
            PsiElement parent;
            if (element != null && ((parent = element.getParent()) instanceof GoTypeReferenceExpression || parent instanceof GoType)) {
                return PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{GoType.class}) instanceof GoFieldDeclaration;
            }
            return false;
        }

        @Override
        protected boolean acceptLeaf() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/editor/template/GoLiveTemplateContextType$Tag", "isInContext"));
        }
    }

    public static final class Expression
    extends GoLiveTemplateContextType {
        private Expression() {
            super(GoBundle.message((String)"go.live.template.context.type.expression.presentable.name", (Object[])new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Expression.$$$reportNull$$$0(0);
            }
            return element instanceof GoExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/editor/template/GoLiveTemplateContextType$Expression", "isInContext"));
        }
    }

    public static final class Block
    extends GoLiveTemplateContextType {
        private Block() {
            super(GoBundle.message((String)"go.live.template.context.type.block.presentable.name", (Object[])new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Block.$$$reportNull$$$0(0);
            }
            return (element instanceof GoLeftHandExprList || element instanceof GoSimpleStatement) && PsiTreeUtil.getParentOfType((PsiElement)element, GoBlock.class) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/editor/template/GoLiveTemplateContextType$Block", "isInContext"));
        }
    }

    public static final class Type
    extends GoLiveTemplateContextType {
        private Type() {
            super(GoBundle.message((String)"go.live.template.context.type.type.presentable.name", (Object[])new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                Type.$$$reportNull$$$0(0);
            }
            return element instanceof GoType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/editor/template/GoLiveTemplateContextType$Type", "isInContext"));
        }
    }

    public static final class File
    extends GoLiveTemplateContextType {
        private File() {
            super(GoBundle.message((String)"go.live.template.context.type.file.presentable.name", (Object[])new Object[0]));
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (element == null) {
                File.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiComment || element instanceof GoPackageClause) {
                return false;
            }
            return element instanceof GoFile || element.getParent() instanceof GoFile && !(element instanceof GoTopLevelDeclaration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/goide/editor/template/GoLiveTemplateContextType$File", "isInContext"));
        }
    }
}

