/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoTypes;
import com.goide.documentation.GoDocUtil;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.highlighting.errors.GoStringLiteralLexerAdapter;
import com.goide.highlighting.errors.GoStringLiteralToken;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoElement;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoPackageClause;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoParameters;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoValue;
import com.goide.psi.GoVarSpec;
import com.goide.psi.impl.GoPsiUtil;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoWordSelectioner
extends AbstractWordSelectioner {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            GoWordSelectioner.$$$reportNull$$$0(0);
        }
        return e.getContainingFile() instanceof GoFile;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        GoSignature signature;
        if (e == null) {
            GoWordSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            GoWordSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GoWordSelectioner.$$$reportNull$$$0(3);
        }
        PsiElement parent = e.getParent();
        List result = super.select(e, editorText, cursorOffset, editor);
        assert (result != null);
        if (parent instanceof GoStringLiteral) {
            result.add(ElementManipulators.getValueTextRange((PsiElement)parent).shiftRight(parent.getTextRange().getStartOffset()));
            result.addAll(GoWordSelectioner.findEscapeSequenceRanges((GoStringLiteral)parent, cursorOffset));
            return result;
        }
        if (parent instanceof GoImportDeclaration) {
            result.addAll(GoWordSelectioner.extend(editorText, ((GoImportDeclaration)parent).getImportSpecList(), false));
        } else if (parent instanceof GoTopLevelDeclaration || parent instanceof GoFieldDeclaration || parent instanceof GoVarSpec) {
            result.addAll(GoWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)parent.getTextRange()));
        } else if (parent instanceof GoCaseClause) {
            PsiElement colon = ((GoCaseClause)parent).getColon();
            if (colon != null) {
                result.add(TextRange.create((int)parent.getTextRange().getStartOffset(), (int)colon.getTextRange().getStartOffset()));
                result.add(TextRange.create((int)parent.getTextRange().getStartOffset(), (int)colon.getTextRange().getEndOffset()));
            }
        } else if (parent instanceof GoIfStatement) {
            GoIfStatement ifStatement = (GoIfStatement)parent;
            result.addAll(GoWordSelectioner.extend(editorText, ifStatement.getInitStatement(), ifStatement.getCondition(), false));
        } else if (parent instanceof GoExprSwitchStatement) {
            switchStatement = (GoExprSwitchStatement)parent;
            result.addAll(GoWordSelectioner.extend(editorText, switchStatement.getInitStatement(), switchStatement.getCondition(), false));
        } else if (parent instanceof GoTypeSwitchStatement) {
            switchStatement = (GoTypeSwitchStatement)parent;
            result.addAll(GoWordSelectioner.extend(editorText, switchStatement.getStatement(), switchStatement.getTypeSwitchGuard(), false));
        } else if (parent instanceof GoValue) {
            result.add(parent.getTextRange());
        } else if (parent instanceof GoStatementsHolder) {
            result.addAll(GoWordSelectioner.extendCodeBlock(editorText, e));
        }
        if (e instanceof GoSimpleStatement) {
            PsiElement semicolon = GoPsiUtil.findTrailingSemicolon(e);
            if (semicolon != null) {
                result.addAll(GoWordSelectioner.extend(editorText, e, semicolon, true));
            } else {
                result.addAll(GoWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)e.getTextRange()));
            }
        } else if (e instanceof GoStructType) {
            result.addAll(GoWordSelectioner.extend(editorText, ((GoStructType)e).getFieldDeclarationList(), true));
        } else if (e instanceof GoLiteralValue) {
            PsiElement lbrace = ((GoLiteralValue)e).getLbrace();
            PsiElement rbrace = ((GoLiteralValue)e).getRbrace();
            TextRange range = TextRange.create((int)(lbrace != null ? lbrace.getTextRange().getEndOffset() : e.getTextRange().getStartOffset()), (int)(rbrace != null ? rbrace.getTextRange().getStartOffset() : e.getTextRange().getEndOffset()));
            result.add(range);
            result.addAll(GoWordSelectioner.extend(editorText, ((GoLiteralValue)e).getElementList(), true));
        } else if (e instanceof GoArgumentList || e instanceof GoParameters) {
            if (e.getTextLength() > 2) {
                result.add(TextRange.create((int)(e.getTextRange().getStartOffset() + 1), (int)(e.getTextRange().getEndOffset() - 1)));
            }
            if (e instanceof GoArgumentList) {
                GoExpression lastExpression = (GoExpression)ContainerUtil.getLastItem(((GoArgumentList)e).getExpressionList());
                result.addAll(GoWordSelectioner.extend(editorText, lastExpression, ((GoArgumentList)e).getTripleDot(), false));
            }
        } else if (e instanceof GoParameterDeclaration) {
            result.addAll(GoWordSelectioner.extend(editorText, ((GoParameterDeclaration)e).getTripleDot(), ((GoParameterDeclaration)e).getType(), false));
        } else if (e instanceof GoStatementsHolder) {
            result.addAll(GoWordSelectioner.extend(editorText, ((GoStatementsHolder)e).getStatementList(), true));
        } else if (e instanceof GoNamedElement || e instanceof GoPackageClause || e instanceof GoElement || e instanceof GoTopLevelDeclaration || e instanceof GoFieldDeclaration) {
            GoWordSelectioner.addCommentsRange(e, editorText, result);
        } else if (e instanceof PsiComment) {
            GoWordSelectioner.addCommentsRange(GoDocUtil.findCommentedElement((PsiComment)e), editorText, result);
        } else if (parent instanceof GoNamedSignatureOwner && (signature = ((GoNamedSignatureOwner)parent).getSignature()) != null) {
            int nameStartOffset = parent.getTextOffset();
            result.add(TextRange.create((int)nameStartOffset, (int)signature.getParameters().getTextRange().getEndOffset()));
            result.add(TextRange.create((int)nameStartOffset, (int)signature.getTextRange().getEndOffset()));
        }
        return result;
    }

    @NotNull
    private static List<TextRange> findEscapeSequenceRanges(@NotNull GoStringLiteral literal, int cursorOffset) {
        if (literal == null) {
            GoWordSelectioner.$$$reportNull$$$0(4);
        }
        if (literal.getRawString() != null || !literal.textContains('\\')) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                GoWordSelectioner.$$$reportNull$$$0(5);
            }
            return list;
        }
        for (GoStringLiteralToken token : new GoStringLiteralLexerAdapter(literal)) {
            TextRange tokenRange;
            if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(token.getType()) || !(tokenRange = token.getAbsoluteRange()).contains(cursorOffset)) continue;
            if (token.getType() == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && tokenRange.getLength() > 2) {
                TextRange escapedTextRange = TextRange.create((int)(tokenRange.getStartOffset() + 2), (int)tokenRange.getEndOffset());
                List<TextRange> list = List.of(escapedTextRange, tokenRange);
                if (list == null) {
                    GoWordSelectioner.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<TextRange> list = Collections.singletonList(tokenRange);
            if (list == null) {
                GoWordSelectioner.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<TextRange> list = Collections.emptyList();
        if (list == null) {
            GoWordSelectioner.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void addCommentsRange(@Nullable PsiElement commentedElement, @NotNull CharSequence editorText, List<TextRange> result) {
        if (editorText == null) {
            GoWordSelectioner.$$$reportNull$$$0(9);
        }
        if (commentedElement == null) {
            return;
        }
        List<PsiComment> comments = GoDocumentationProvider.getCommentsForElement(commentedElement);
        PsiComment lastComment = (PsiComment)ContainerUtil.getLastItem(comments);
        result.addAll(GoWordSelectioner.extend(editorText, commentedElement, (PsiElement)lastComment, false));
        PsiComment firstComment = (PsiComment)ContainerUtil.getFirstItem(comments);
        result.addAll(GoWordSelectioner.extend(editorText, (PsiElement)firstComment, commentedElement, false));
        result.addAll(GoWordSelectioner.extend(editorText, (PsiElement)firstComment, (PsiElement)lastComment, false));
        result.addAll(GoWordSelectioner.extend(editorText, (PsiElement)firstComment, commentedElement, true));
        result.addAll(GoWordSelectioner.extend(editorText, commentedElement, (PsiElement)lastComment, true));
        result.addAll(GoWordSelectioner.extend(editorText, (PsiElement)firstComment, (PsiElement)lastComment, true));
    }

    @NotNull
    private static List<TextRange> extendCodeBlock(@NotNull CharSequence editorText, @NotNull PsiElement e) {
        if (editorText == null) {
            GoWordSelectioner.$$$reportNull$$$0(10);
        }
        if (e == null) {
            GoWordSelectioner.$$$reportNull$$$0(11);
        }
        PsiElement start = e;
        PsiElement stop = e;
        PsiElement sibling = e;
        while (!((sibling = sibling.getPrevSibling()) == null || sibling instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)sibling.getText()) > 1 || sibling.getNode().getElementType() == GoTypes.LBRACE)) {
            start = sibling;
        }
        while (start instanceof PsiWhiteSpace) {
            start = start.getNextSibling();
        }
        sibling = e;
        while (!((sibling = sibling.getNextSibling()) == null || sibling instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)sibling.getText()) > 1 || sibling.getNode().getElementType() == GoTypes.RBRACE)) {
            stop = sibling;
        }
        while (stop instanceof PsiWhiteSpace) {
            stop = stop.getPrevSibling();
        }
        return GoWordSelectioner.extend(editorText, start, stop, true);
    }

    @NotNull
    private static List<TextRange> extend(@NotNull CharSequence editorText, @NotNull List<? extends PsiElement> list, boolean expand) {
        if (editorText == null) {
            GoWordSelectioner.$$$reportNull$$$0(12);
        }
        if (list == null) {
            GoWordSelectioner.$$$reportNull$$$0(13);
        }
        return GoWordSelectioner.extend(editorText, (PsiElement)ContainerUtil.getFirstItem(list), (PsiElement)ContainerUtil.getLastItem(list), expand);
    }

    @NotNull
    private static List<TextRange> extend(@NotNull CharSequence editorText, @Nullable PsiElement first, @Nullable PsiElement last, boolean expand) {
        if (editorText == null) {
            GoWordSelectioner.$$$reportNull$$$0(14);
        }
        if (first != null && last != null && last.getTextRange().getStartOffset() >= first.getTextRange().getEndOffset()) {
            TextRange range = TextRange.create((int)first.getTextRange().getStartOffset(), (int)last.getTextRange().getEndOffset());
            if (!expand) {
                return new SmartList((Object)range);
            }
            List list = GoWordSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)range);
            if (list == null) {
                GoWordSelectioner.$$$reportNull$$$0(15);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            GoWordSelectioner.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoWordSelectioner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoWordSelectioner";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findEscapeSequenceRanges";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "extend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findEscapeSequenceRanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCommentsRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extendCodeBlock";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extend";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 15, 16 -> new IllegalStateException(string);
        };
    }
}

