/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoTypes;
import com.goide.editor.GoParameterInfoUtil;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFieldDefinition;
import com.goide.psi.GoKey;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoValue;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStructLiteralParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GoLiteralValue, Object, GoElement>,
DumbAware {
    public GoElement @NotNull [] getActualParameters(@NotNull GoLiteralValue o) {
        if (o == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(0);
        }
        GoElement[] goElementArray = o.getElementList().toArray(new GoElement[0]);
        if (goElementArray == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return goElementArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GoTypes.COMMA;
        if (iElementType == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GoTypes.RBRACE;
        if (iElementType == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = Set.of(GoCompositeLit.class, GoKey.class, GoValue.class);
        if (set == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set set = Collections.emptySet();
        if (set == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Class<GoLiteralValue> getArgumentListClass() {
        return GoLiteralValue.class;
    }

    @Nullable
    public GoLiteralValue findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        GoLiteralValue literal;
        GoStructType type2;
        if (context == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if ((type2 = GoInspectionUtil.findStructTypeForLiteralValue(literal = GoParameterInfoUtil.findGoLiteralValueForParameterInfo((ParameterInfoContext)context))) != null) {
            context.setItemsToShow(new Object[]{type2});
        }
        return literal;
    }

    public void showParameterInfo(@NotNull GoLiteralValue element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (!ArrayUtil.isEmpty((Object[])context.getItemsToShow())) {
            context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
    }

    @Nullable
    public GoLiteralValue findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return GoParameterInfoUtil.findGoLiteralValueForParameterInfo((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull GoLiteralValue list, @NotNull UpdateParameterInfoContext context) {
        if (list == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(11);
        }
        context.setCurrentParameter(ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)context.getOffset(), (IElementType)GoTypes.COMMA));
    }

    public void updateUI(Object p, @NotNull ParameterInfoUIContext context) {
        GoStructType type2;
        if (context == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if ((type2 = (GoStructType)ObjectUtils.tryCast((Object)p, GoStructType.class)) == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        List<String> presentations = GoStructLiteralParameterInfoHandler.getParameterPresentations(type2);
        if (presentations.isEmpty()) {
            context.setupRawUIComponentPresentation(XmlStringUtil.escapeString((String)CodeInsightBundle.message((String)"parameter.info.no.fields", (Object[])new Object[0])));
        } else {
            int selected = context.getCurrentParameterIndex();
            int highlightStart = 0;
            int highlightEnd = 0;
            @NlsContexts.Label StringBuilder builder = new StringBuilder();
            for (int i = 0; i < presentations.size(); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                String parameter = XmlStringUtil.escapeString((String)presentations.get(i));
                if (i == selected) {
                    highlightStart = builder.length();
                    highlightEnd = highlightStart + parameter.length();
                }
                builder.append(parameter);
            }
            String text = builder.toString();
            context.setupUIComponentPresentation(text, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
        }
    }

    @NotNull
    public static List<String> getParameterPresentations(@NotNull GoStructType type2) {
        if (type2 == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(13);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (GoFieldDeclaration declaration : type2.getFieldDeclarationList()) {
            GoAnonymousFieldDefinition anonymousField = declaration.getAnonymousFieldDefinition();
            if (anonymousField != null) {
                GoTypeReferenceExpression typeReference = anonymousField.getTypeReferenceExpression();
                if (typeReference == null) continue;
                String fieldName = anonymousField.getName();
                GoType fieldType = anonymousField.getGoType(ResolveState.initial());
                String fieldTypeText = fieldType != null ? fieldType.getText() : "";
                result.add((String)(StringUtil.isEmpty((String)fieldName) ? fieldTypeText : fieldName + " " + fieldTypeText));
                continue;
            }
            for (GoFieldDefinition field : declaration.getFieldDefinitionList()) {
                String fieldName = StringUtil.notNullize((String)field.getName());
                GoType fieldType = field.getGoType(ResolveState.initial());
                String fieldTypeText = fieldType != null ? fieldType.getText() : "";
                result.add((String)(fieldName.isEmpty() ? fieldTypeText : fieldName + " " + fieldTypeText));
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            GoStructLiteralParameterInfoHandler.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoStructLiteralParameterInfoHandler";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoStructLiteralParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterPresentations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterPresentations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 14 -> new IllegalStateException(string);
        };
    }
}

