/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoLanguage;
import com.goide.editor.GoFoldingBuilderUtil;
import com.goide.editor.GoFoldingSettings;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStructType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J>\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J6\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J6\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0013\u001a\u00020'2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010(\u001a\u00020)2\u0006\u0010!\u001a\u00020\"H\u0007JF\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020\"H\u0007JF\u00100\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00101\u001a\u0002022\u0006\u0010-\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020/2\u0006\u0010!\u001a\u00020\"H\u0007J\u001e\u00103\u001a\u00020\u00042\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J&\u00104\u001a\u00020\"2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0007J\u001a\u00106\u001a\u0004\u0018\u00010\u00162\u0006\u00107\u001a\u0002082\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020'H\u0007J\u0018\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001a\u0010>\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020)2\u0006\u0010?\u001a\u00020@H\u0007J\u0012\u0010>\u001a\u0004\u0018\u00010 2\u0006\u0010?\u001a\u00020@H\u0007J\u0010\u0010A\u001a\u00020\"2\u0006\u0010B\u001a\u00020'H\u0007J\u0012\u0010C\u001a\u0004\u0018\u00010,2\u0006\u0010B\u001a\u00020'H\u0007J>\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u0002082\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010F\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010G\u001a\u00020\"2\u0006\u0010?\u001a\u00020@H\u0007J\u0018\u0010H\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020I2\u0006\u0010J\u001a\u00020\u0004H\u0002J(\u0010K\u001a\u00020\u00122\u0006\u00107\u001a\u00020'2\u0006\u0010L\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J(\u0010M\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010N\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010O\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J \u0010P\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020\"2\u0006\u0010R\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0007J\u0018\u0010S\u001a\u00020\u00122\u0006\u0010B\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007J \u0010S\u001a\u00020\u00122\u0006\u0010T\u001a\u00020'2\u0006\u0010U\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\r\u00a8\u0006V"}, d2={"Lcom/goide/editor/GoFoldingBuilderUtil;", "", "()V", "BLOCK", "", "CLOSED_BRACE", "COLON", "OPEN_BRACE", "SPACE", "TRIPLE_DOT", "arrowSymbol", "getArrowSymbol$annotations", "getArrowSymbol", "()Ljava/lang/String;", "bombSymbol", "getBombSymbol$annotations", "getBombSymbol", "canBeErrorHandlingIfBlock", "", "block", "Lcom/goide/psi/GoBlock;", "soleElement", "Lcom/goide/psi/GoCompositeElement;", "createFoldingDescriptorForBlock", "Lcom/intellij/lang/folding/FoldingDescriptor;", "expressions", "", "Lcom/goide/psi/GoExpression;", "symbol", "textRange", "Lcom/intellij/openapi/util/TextRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rightMargin", "", "createFoldingDescriptorForBlockNew", "blockTextRange", "soleStatementTextRange", "createFoldingDescriptorForEmptyBlock", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "createFoldingDescriptorForPanicInBlock", "callExpr", "Lcom/goide/psi/GoCallExpr;", "soleElementTextRange", "goFoldingSettings", "Lcom/goide/editor/GoFoldingSettings;", "createFoldingDescriptorForReturnInBlock", "returnStatement", "Lcom/goide/psi/GoReturnStatement;", "doCalcPlaceholderText", "doCalcPlaceholderTextLength", "calculatedPlaceholderText", "findSoleElementToCollapse", "holder", "Lcom/goide/psi/GoStatementsHolder;", "getBlockTextRange", "leftBrace", "rightBrace", "getColumn", "offset", "getEditor", "file", "Lcom/intellij/psi/PsiFile;", "getFoldingStartOffset", "element", "getPanicCallExpr", "getPlaceHolderForSymbol", "statementsHolder", "defaultPlaceholder", "getRightMargin", "getSpecialSymbol", "", "plainText", "isBeforeRightMargin", "placeholderTextLength", "isBeforeRightMarginBlockNew", "statement", "isIfStatementBlockWithoutElse", "isInSameLine", "startOffset", "endOffset", "isInTheSameLine", "firstChild", "lastChild", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoFoldingBuilderUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoFoldingBuilderUtil.kt\ncom/goide/editor/GoFoldingBuilderUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1#2:296\n*E\n"})
public final class GoFoldingBuilderUtil {
    @NotNull
    public static final GoFoldingBuilderUtil INSTANCE = new GoFoldingBuilderUtil();
    @NotNull
    public static final String TRIPLE_DOT = "...";
    @NotNull
    public static final String BLOCK = "{...}";
    @NotNull
    public static final String COLON = ": ";
    @NotNull
    public static final String SPACE = " ";
    @NotNull
    private static final String OPEN_BRACE = "{";
    @NotNull
    private static final String CLOSED_BRACE = "}";
    @NotNull
    private static final String arrowSymbol = INSTANCE.getSpecialSymbol('\u2934', "-^");
    @NotNull
    private static final String bombSymbol = INSTANCE.getSpecialSymbol('\u2737', "*");

    private GoFoldingBuilderUtil() {
    }

    @NotNull
    public static final String getArrowSymbol() {
        return arrowSymbol;
    }

    @JvmStatic
    public static /* synthetic */ void getArrowSymbol$annotations() {
    }

    @NotNull
    public static final String getBombSymbol() {
        return bombSymbol;
    }

    @JvmStatic
    public static /* synthetic */ void getBombSymbol$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final TextRange getBlockTextRange(@NotNull PsiElement leftBrace, @NotNull PsiElement rightBrace) {
        Intrinsics.checkNotNullParameter((Object)leftBrace, (String)"leftBrace");
        Intrinsics.checkNotNullParameter((Object)rightBrace, (String)"rightBrace");
        int startOffset = leftBrace.getTextOffset();
        int endOffset = rightBrace.getTextOffset() + 1;
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    private final String getSpecialSymbol(char symbol, String plainText) {
        String string;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            String string2 = EditorUtil.displayCharInEditor((char)symbol, (TextAttributesKey)EditorColors.FOLDED_TEXT_ATTRIBUTES, (String)plainText);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = plainText;
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final GoCompositeElement findSoleElementToCollapse(@NotNull GoStatementsHolder holder, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List<GoStatement> list = holder.getStatementList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getStatementList(...)");
        GoStatement soleElement = (GoStatement)CollectionsKt.singleOrNull(list);
        if (soleElement == null) return null;
        if (!GoFoldingBuilderUtil.isInTheSameLine(soleElement, document)) return null;
        GoCompositeElement goCompositeElement = soleElement;
        return goCompositeElement;
    }

    @JvmStatic
    public static final boolean isInTheSameLine(@NotNull PsiElement element, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange range = element.getTextRange();
        return GoFoldingBuilderUtil.isInSameLine(range.getStartOffset(), range.getEndOffset(), document);
    }

    @JvmStatic
    public static final boolean isInTheSameLine(@NotNull PsiElement firstChild, @NotNull PsiElement lastChild, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)firstChild, (String)"firstChild");
        Intrinsics.checkNotNullParameter((Object)lastChild, (String)"lastChild");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return GoFoldingBuilderUtil.isInSameLine(firstChild.getTextOffset(), lastChild.getTextOffset() + 1, document);
    }

    @JvmStatic
    public static final boolean isInSameLine(int startOffset, int endOffset, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return document.getLineNumber(startOffset) == document.getLineNumber(endOffset);
    }

    @JvmStatic
    public static final boolean isBeforeRightMarginBlockNew(@NotNull GoBlock block, @NotNull PsiElement statement, @NotNull Editor editor, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int length = 2 + statement.getTextLength() + 1 + 1;
        return GoFoldingBuilderUtil.isBeforeRightMargin(block, length, editor, rightMargin);
    }

    @JvmStatic
    public static final boolean isBeforeRightMargin(@NotNull PsiElement holder, int placeholderTextLength, @NotNull Editor editor, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int column = GoFoldingBuilderUtil.getColumn(GoFoldingBuilderUtil.getFoldingStartOffset(holder), editor);
        return column + placeholderTextLength <= rightMargin;
    }

    @JvmStatic
    public static final int getColumn(int offset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return editor.offsetToLogicalPosition((int)offset).column;
    }

    @JvmStatic
    public static final int getFoldingStartOffset(@NotNull PsiElement element) {
        PsiElement anchor;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element;
        PsiElement psiElement2 = anchor = psiElement instanceof GoBlock ? ((GoBlock)element).getLbrace() : (psiElement instanceof GoCaseClause ? ((GoCaseClause)element).getColon() : (psiElement instanceof GoStructType ? ((GoStructType)element).getLbrace() : (psiElement instanceof GoInterfaceType ? ((GoInterfaceType)element).getLbrace() : element)));
        return psiElement2 != null ? psiElement2.getTextOffset() : element.getTextOffset();
    }

    @JvmStatic
    @Nullable
    public static final Editor getEditor(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return GoFoldingBuilderUtil.getEditor(document2, file);
    }

    @JvmStatic
    @Nullable
    public static final Editor getEditor(@NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Editor[] editorArray = EditorFactory.getInstance().getEditors(document, file.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getEditors(...)");
        return (Editor)ArraysKt.firstOrNull((Object[])editorArray);
    }

    @JvmStatic
    @NotNull
    public static final List<FoldingDescriptor> createFoldingDescriptorForReturnInBlock(@NotNull GoBlock block, @NotNull TextRange textRange, @NotNull GoReturnStatement returnStatement, @NotNull TextRange soleElementTextRange, @NotNull Editor editor, @NotNull GoFoldingSettings goFoldingSettings, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)returnStatement, (String)"returnStatement");
        Intrinsics.checkNotNullParameter((Object)soleElementTextRange, (String)"soleElementTextRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)goFoldingSettings, (String)"goFoldingSettings");
        return switch (WhenMappings.$EnumSwitchMapping$0[goFoldingSettings.returnSyntax.ordinal()]) {
            case 1 -> GoFoldingBuilderUtil.createFoldingDescriptorForBlockNew(block, textRange, soleElementTextRange, editor, rightMargin);
            case 2 -> {
                List<GoExpression> v1 = returnStatement.getExpressionList();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"getExpressionList(...)");
                yield CollectionsKt.listOf((Object)GoFoldingBuilderUtil.createFoldingDescriptorForBlock(block, v1, arrowSymbol, textRange, editor, rightMargin));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    @NotNull
    public static final FoldingDescriptor createFoldingDescriptorForBlock(@NotNull GoBlock block, @NotNull List<? extends GoExpression> expressions, @NotNull String symbol, @NotNull TextRange textRange, @NotNull Editor editor, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String placeholder = GoFoldingBuilderUtil.getPlaceHolderForSymbol(block, expressions, symbol, BLOCK, editor, rightMargin);
        return new FoldingDescriptor(block.getNode(), textRange, null, placeholder);
    }

    @JvmStatic
    @NotNull
    public static final List<FoldingDescriptor> createFoldingDescriptorForEmptyBlock(@NotNull PsiElement block, @NotNull TextRange blockTextRange, @NotNull Editor editor, @NotNull Document document, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockTextRange, (String)"blockTextRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (GoFoldingBuilderUtil.isInSameLine(blockTextRange.getStartOffset(), blockTextRange.getEndOffset(), document)) {
            return CollectionsKt.emptyList();
        }
        int length = 2;
        if (!GoFoldingBuilderUtil.isBeforeRightMargin(block, length, editor, rightMargin)) {
            return CollectionsKt.listOf((Object)new FoldingDescriptor(block.getNode(), blockTextRange, null, BLOCK));
        }
        int firstStart = blockTextRange.getStartOffset();
        int firstEnd = firstStart + 1;
        FoldingGroup group = FoldingGroup.newGroup((String)"block");
        String firstPlaceHolder = OPEN_BRACE;
        FoldingDescriptor firstFoldingDescriptor = new FoldingDescriptor(block, firstStart, firstEnd, group, firstPlaceHolder);
        int secondStart = firstStart + 1;
        int secondEnd = blockTextRange.getEndOffset();
        String secondPlaceHolder = CLOSED_BRACE;
        FoldingDescriptor secondFoldingDescriptor = new FoldingDescriptor(block, secondStart, secondEnd, group, secondPlaceHolder);
        Object[] objectArray = new FoldingDescriptor[]{firstFoldingDescriptor, secondFoldingDescriptor};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @JvmStatic
    @NotNull
    public static final List<FoldingDescriptor> createFoldingDescriptorForBlockNew(@NotNull GoBlock block, @NotNull TextRange blockTextRange, @NotNull TextRange soleStatementTextRange, @NotNull Editor editor, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)blockTextRange, (String)"blockTextRange");
        Intrinsics.checkNotNullParameter((Object)soleStatementTextRange, (String)"soleStatementTextRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        int length = 2 + soleStatementTextRange.getLength() + 1 + 1;
        if (!GoFoldingBuilderUtil.isBeforeRightMargin(block, length, editor, rightMargin)) {
            return CollectionsKt.listOf((Object)new FoldingDescriptor(block.getNode(), blockTextRange, null, BLOCK));
        }
        int firstStart = blockTextRange.getStartOffset();
        int firstEnd = soleStatementTextRange.getStartOffset();
        FoldingGroup group = FoldingGroup.newGroup((String)"block");
        String firstPlaceHolder = "{ ";
        FoldingDescriptor firstFoldingDescriptor = new FoldingDescriptor((PsiElement)block, firstStart, firstEnd, group, firstPlaceHolder);
        int secondStart = soleStatementTextRange.getEndOffset();
        int secondEnd = blockTextRange.getEndOffset();
        String secondPlaceHolder = " }";
        FoldingDescriptor secondFoldingDescriptor = new FoldingDescriptor((PsiElement)block, secondStart, secondEnd, group, secondPlaceHolder);
        Object[] objectArray = new FoldingDescriptor[]{firstFoldingDescriptor, secondFoldingDescriptor};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @JvmStatic
    @NotNull
    public static final String getPlaceHolderForSymbol(@NotNull GoStatementsHolder statementsHolder, @NotNull List<? extends GoExpression> expressions, @NotNull String symbol, @NotNull String defaultPlaceholder, @NotNull Editor editor, int rightMargin) {
        boolean isBeforeRightMargin;
        Intrinsics.checkNotNullParameter((Object)statementsHolder, (String)"statementsHolder");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)defaultPlaceholder, (String)"defaultPlaceholder");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        String placeholderText = GoFoldingBuilderUtil.doCalcPlaceholderText(expressions, symbol);
        int placeholderLength = GoFoldingBuilderUtil.doCalcPlaceholderTextLength(expressions, symbol, placeholderText);
        if (statementsHolder instanceof GoCaseClause) {
            ++placeholderLength;
        }
        return (isBeforeRightMargin = GoFoldingBuilderUtil.isBeforeRightMargin(statementsHolder, placeholderLength, editor, rightMargin)) ? placeholderText : defaultPlaceholder;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int doCalcPlaceholderTextLength(@NotNull List<? extends GoExpression> expressions, @NotNull String symbol, @NotNull String calculatedPlaceholderText) {
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)calculatedPlaceholderText, (String)"calculatedPlaceholderText");
        Iterable iterable = expressions;
        int n = 0;
        for (Object t : iterable) {
            void it;
            GoExpression goExpression = (GoExpression)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getTextLength();
            n = n2 + n3;
        }
        int getExpressionsLength = n + 2 * (expressions.size() - 1);
        int length = !expressions.isEmpty() ? 2 + getExpressionsLength + 1 + symbol.length() : 2 + symbol.length();
        int n4 = n = length == calculatedPlaceholderText.length() ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return length;
    }

    @JvmStatic
    @NotNull
    public static final String doCalcPlaceholderText(@NotNull List<? extends GoExpression> expressions, @NotNull String symbol) {
        String string;
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!expressions.isEmpty()) {
            String expressionsText2 = CollectionsKt.joinToString$default((Iterable)expressions, (CharSequence)", ", null, null, (int)0, null, (Function1)doCalcPlaceholderText.expressionsText.1.INSTANCE, (int)30, null);
            string = COLON + expressionsText2 + SPACE + symbol;
        } else {
            string = COLON + symbol;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final GoCallExpr getPanicCallExpr(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        GoSimpleStatement goSimpleStatement = element instanceof GoSimpleStatement ? (GoSimpleStatement)element : null;
        if (goSimpleStatement == null) {
            return null;
        }
        GoSimpleStatement simpleStatement = goSimpleStatement;
        GoLeftHandExprList goLeftHandExprList = simpleStatement.getLeftHandExprList();
        if (goLeftHandExprList == null) {
            return null;
        }
        GoLeftHandExprList lhs = goLeftHandExprList;
        List<GoExpression> list = lhs.getExpressionList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressionList(...)");
        GoExpression expr = (GoExpression)CollectionsKt.singleOrNull(list);
        return expr instanceof GoCallExpr && GoPsiImplUtil.isPanic((GoCallExpr)expr) ? (GoCallExpr)expr : null;
    }

    @JvmStatic
    @NotNull
    public static final List<FoldingDescriptor> createFoldingDescriptorForPanicInBlock(@NotNull GoBlock block, @NotNull TextRange textRange, @NotNull GoCallExpr callExpr, @NotNull TextRange soleElementTextRange, @NotNull Editor editor, @NotNull GoFoldingSettings goFoldingSettings, int rightMargin) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        Intrinsics.checkNotNullParameter((Object)soleElementTextRange, (String)"soleElementTextRange");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)goFoldingSettings, (String)"goFoldingSettings");
        return switch (WhenMappings.$EnumSwitchMapping$1[goFoldingSettings.panicSyntax.ordinal()]) {
            case 1 -> GoFoldingBuilderUtil.createFoldingDescriptorForBlockNew(block, textRange, soleElementTextRange, editor, rightMargin);
            case 2 -> {
                List<GoExpression> v1 = callExpr.getArgumentList().getExpressionList();
                Intrinsics.checkNotNullExpressionValue(v1, (String)"getExpressionList(...)");
                yield CollectionsKt.listOf((Object)GoFoldingBuilderUtil.createFoldingDescriptorForBlock(block, v1, bombSymbol, textRange, editor, rightMargin));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @JvmStatic
    public static final int getRightMargin(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CodeStyle.getSettings((PsiFile)file).getRightMargin(GoLanguage.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean canBeErrorHandlingIfBlock(@NotNull GoBlock block, @NotNull GoCompositeElement soleElement) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)soleElement, (String)"soleElement");
        if (soleElement instanceof GoReturnStatement) return false;
        if (GoFoldingBuilderUtil.getPanicCallExpr(soleElement) != null) return false;
        if (!GoFoldingBuilderUtil.isIfStatementBlockWithoutElse(block)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isIfStatementBlockWithoutElse(@NotNull GoBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        PsiElement psiElement = block.getParent();
        GoIfStatement goIfStatement = psiElement instanceof GoIfStatement ? (GoIfStatement)psiElement : null;
        if (goIfStatement == null) {
            return false;
        }
        GoIfStatement ifStatement = goIfStatement;
        return ifStatement.getBlock() != null && ifStatement.getElseStatement() == null;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GoFoldingSettings.FoldedReturnSyntax.values().length];
            try {
                nArray[GoFoldingSettings.FoldedReturnSyntax.RETURN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoFoldingSettings.FoldedReturnSyntax.ARROW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GoFoldingSettings.FoldedPanicSyntax.values().length];
            try {
                nArray[GoFoldingSettings.FoldedPanicSyntax.PANIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GoFoldingSettings.FoldedPanicSyntax.BOMB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

