/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoTypes;
import com.goide.editor.GoFoldingBuilderUtil;
import com.goide.editor.GoFoldingSettings;
import com.goide.inspections.GoDecodedStringLiteralRangeConverter;
import com.goide.inspections.GoErrorHandlingUtil;
import com.goide.inspections.fmtstring.GoFmtStringUtil;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringBadPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringEscapedPercent;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringPlaceholder;
import com.goide.inspections.fmtstring.parser.tokens.GoFmtStringToken;
import com.goide.psi.GoArgumentList;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoTypeAssertionExpr;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVarSpec;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoFoldingBuilder
extends CustomFoldingBuilder {
    private static void fold(@NotNull PsiElement e, @Nullable PsiElement l, @Nullable PsiElement r, @NotNull String placeholderText, @NotNull List<FoldingDescriptor> result) {
        if (e == null) {
            GoFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (placeholderText == null) {
            GoFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (result == null) {
            GoFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (l != null && r != null) {
            result.add(new FoldingDescriptor(e, l.getTextRange().getStartOffset(), r.getTextRange().getEndOffset(), null, placeholderText));
        }
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> result, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        GoFile file;
        block8: {
            block7: {
                if (result == null) {
                    GoFoldingBuilder.$$$reportNull$$$0(3);
                }
                if (root == null) {
                    GoFoldingBuilder.$$$reportNull$$$0(4);
                }
                if (document == null) {
                    GoFoldingBuilder.$$$reportNull$$$0(5);
                }
                if (!(root instanceof GoFile)) break block7;
                file = (GoFile)root;
                if (!(root instanceof GoCodeFragment)) break block8;
            }
            return;
        }
        if (!file.isContentsLoaded()) {
            return;
        }
        Editor editor = GoFoldingBuilderUtil.getEditor((PsiFile)file);
        int rightMargin = GoFoldingBuilderUtil.getRightMargin((PsiFile)file);
        GoFoldingSettings goFoldingSettings = GoFoldingSettings.getInstance();
        PsiTreeUtil.processElements((PsiElement)file, element -> {
            if (quick) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) return true;
            }
            if (element instanceof GoStringLiteral) {
                GoStringLiteral stringLiteral = (GoStringLiteral)element;
                if (goFoldingSettings.isFmtStrings) {
                    GoFoldingBuilder.foldFmtString(stringLiteral, result);
                    return true;
                }
            }
            if (!(element instanceof GoBlock)) return true;
            GoBlock block = (GoBlock)element;
            if (editor == null) return true;
            PsiElement leftBrace = block.getLbrace();
            PsiElement rightBrace = block.getRbrace();
            if (rightBrace == null) return true;
            TextRange blockTextRange = GoFoldingBuilderUtil.getBlockTextRange(leftBrace, rightBrace);
            GoCompositeElement soleElement = GoFoldingBuilderUtil.findSoleElementToCollapse(block, document);
            if (soleElement == null) return true;
            if (!GoFoldingBuilderUtil.canBeErrorHandlingIfBlock(block, soleElement)) return true;
            GoIfStatement ifStatement = (GoIfStatement)block.getParent();
            if (goFoldingSettings.isOneLineErrorHandlingBlocks && GoFoldingBuilder.isOneLineErrorHandlingIfBlock(ifStatement)) {
                result.addAll(GoFoldingBuilderUtil.createFoldingDescriptorForBlockNew(block, blockTextRange, soleElement.getTextRange(), editor, rightMargin));
                return true;
            }
            result.add(new FoldingDescriptor(block.getNode(), blockTextRange, null, "{...}"));
            return true;
        });
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            GoFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (range == null) {
            GoFoldingBuilder.$$$reportNull$$$0(7);
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            GoFoldingBuilder.$$$reportNull$$$0(8);
        }
        GoFoldingSettings goFoldingSettings = GoFoldingSettings.getInstance();
        IElementType type2 = node.getElementType();
        PsiElement psi = node.getPsi();
        PsiFile file = psi.getContainingFile();
        int rightMargin = GoFoldingBuilderUtil.getRightMargin(file);
        Editor editor = GoFoldingBuilderUtil.getEditor(file);
        if (editor == null) {
            return false;
        }
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return false;
        }
        if (type2 == GoTypes.BLOCK && psi instanceof GoBlock) {
            GoIfStatement ifStatement;
            GoBlock block = (GoBlock)psi;
            GoCompositeElement soleElement = GoFoldingBuilderUtil.findSoleElementToCollapse(block, document);
            if (soleElement == null) {
                return false;
            }
            if (goFoldingSettings.isOneLineErrorHandlingBlocks && GoFoldingBuilderUtil.canBeErrorHandlingIfBlock(block, soleElement) && GoFoldingBuilder.isOneLineErrorHandlingIfBlock(ifStatement = (GoIfStatement)block.getParent())) {
                return GoFoldingBuilderUtil.isBeforeRightMarginBlockNew(block, soleElement, editor, rightMargin);
            }
        }
        return type2 == GoTypes.ARGUMENT_LIST && goFoldingSettings.isFmtStrings && GoFmtStringUtil.findFormattingFunction(psi) != null;
    }

    private static void foldFmtString(@NotNull GoStringLiteral literal, @NotNull List<FoldingDescriptor> result) {
        if (literal == null) {
            GoFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (result == null) {
            GoFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (!(literal.getParent() instanceof GoArgumentList)) {
            return;
        }
        GoFmtStringUtil.FmtFunctionInfo fmtFunctionInfo = GoFmtStringUtil.findFormattingFunction(literal);
        if (fmtFunctionInfo == null || fmtFunctionInfo.isScanFunction()) {
            return;
        }
        GoArgumentList argumentList = fmtFunctionInfo.getCallExpression().getArgumentList();
        if (argumentList.isVariadic()) {
            return;
        }
        GoFmtStringUtil.FmtCallArguments args = fmtFunctionInfo.getFmtStringAndRestArguments();
        if (args == null || args.getFmtString() != literal || args.getRestArguments().isEmpty()) {
            return;
        }
        List<GoFmtStringPlaceholder> placeholders = GoFoldingBuilder.getPlaceholders(literal);
        if (placeholders == null) {
            return;
        }
        List<GoFmtStringUtil.Indices> indicesList = GoFoldingBuilder.getIndicesIfAllOperandsPresent(placeholders, args.getRestArguments().size());
        if (indicesList == null) {
            return;
        }
        SmartList verbOperands = new SmartList();
        for (int i = 0; i < placeholders.size(); ++i) {
            verbOperands.add(Pair.create((Object)placeholders.get(i), (Object)args.getRestArguments().get(indicesList.get(i).getVerbIndex())));
        }
        String foldingText = GoFoldingBuilder.getFoldedFmtString(literal, (List<Pair<GoFmtStringPlaceholder, GoExpression>>)verbOperands);
        if (foldingText == null) {
            return;
        }
        GoFoldingBuilder.fold(argumentList, literal, (PsiElement)ContainerUtil.getLastItem(args.getRestArguments()), foldingText, result);
    }

    @Nullable
    private static List<GoFmtStringPlaceholder> getPlaceholders(@NotNull GoStringLiteral literal) {
        List<GoFmtStringToken> tokens;
        if (literal == null) {
            GoFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (ContainerUtil.or(tokens = GoFmtStringUtil.parse(literal), t -> t instanceof GoFmtStringBadPlaceholder || t instanceof GoFmtStringEscapedPercent && !"%%".equals(t.getText()))) {
            return null;
        }
        return GoFmtStringUtil.filterPlaceholders(tokens);
    }

    @Nullable
    private static List<GoFmtStringUtil.Indices> getIndicesIfAllOperandsPresent(@NotNull List<GoFmtStringPlaceholder> placeholders, int operandsNumber) {
        if (placeholders == null) {
            GoFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (ContainerUtil.exists(placeholders, GoFmtStringUtil::hasZeroIndices)) {
            return null;
        }
        List<GoFmtStringUtil.Indices> indicesList = GoFmtStringUtil.operandsIndices(placeholders);
        int requiredOperandsCount = GoFmtStringUtil.maxIndex(indicesList) + 1;
        if (operandsNumber != requiredOperandsCount) {
            return null;
        }
        return indicesList;
    }

    @Nullable
    private static String getFoldedFmtString(@NotNull GoStringLiteral literal, @NotNull List<Pair<GoFmtStringPlaceholder, GoExpression>> verbOperands) {
        if (literal == null) {
            GoFoldingBuilder.$$$reportNull$$$0(13);
        }
        if (verbOperands == null) {
            GoFoldingBuilder.$$$reportNull$$$0(14);
        }
        GoDecodedStringLiteralRangeConverter converter = new GoDecodedStringLiteralRangeConverter(literal);
        StringBuilder sb = new StringBuilder(literal.getText());
        for (int i = verbOperands.size() - 1; i >= 0; --i) {
            Pair<GoFmtStringPlaceholder, GoExpression> pair = verbOperands.get(i);
            TextRange range = converter.computeRange(((GoFmtStringPlaceholder)pair.first).getStart(), ((GoFmtStringPlaceholder)pair.first).getEnd());
            if (range == null) {
                return null;
            }
            sb.replace(range.getStartOffset(), range.getEndOffset(), "#{" + ((GoExpression)pair.second).getText() + "}");
        }
        return sb.toString();
    }

    public boolean isDumbAware() {
        return false;
    }

    private static boolean isOneLineErrorHandlingIfBlock(@NotNull GoIfStatement ifStatement) {
        GoExpression condition;
        if (ifStatement == null) {
            GoFoldingBuilder.$$$reportNull$$$0(15);
        }
        if ((condition = ifStatement.getCondition()) == null) {
            return false;
        }
        return GoFoldingBuilder.isTypeAssertionOnError(condition) || GoErrorHandlingUtil.isEqualityComparisonWithErrors(condition) || GoErrorHandlingUtil.isErrorsIsCall(condition) || GoErrorHandlingUtil.isErrorsAsCall(condition);
    }

    private static boolean isTypeAssertionOnError(@NotNull GoExpression condition) {
        GoReferenceExpression referenceExpression;
        PsiElement resolved;
        if (condition == null) {
            GoFoldingBuilder.$$$reportNull$$$0(16);
        }
        boolean isTypeAssertionOnError = false;
        if (condition instanceof GoReferenceExpression && (resolved = (referenceExpression = (GoReferenceExpression)condition).resolve()) != null) {
            GoVarDeclaration varDeclaration;
            List<GoVarSpec> specList;
            PsiElement rhs;
            PsiElement parent = resolved.getParent();
            if (parent instanceof GoShortVarDeclaration) {
                GoShortVarDeclaration shortVarDeclaration = (GoShortVarDeclaration)parent;
                rhs = shortVarDeclaration.getRightExpressionsList().size() == 1 ? shortVarDeclaration.getRightExpressionsList().get(0) : null;
                isTypeAssertionOnError = GoFoldingBuilder.isTypeAssertionOrErrorsIsCall((GoExpression)rhs);
            }
            if (parent instanceof GoVarSpec && (rhs = parent.getParent()) instanceof GoVarDeclaration && (specList = (varDeclaration = (GoVarDeclaration)rhs).getSpecList()).size() == 1) {
                GoVarSpec spec = specList.get(0);
                GoExpression rhs2 = spec.getExpressionList().size() == 1 ? spec.getExpressionList().get(0) : null;
                isTypeAssertionOnError = GoFoldingBuilder.isTypeAssertionOrErrorsIsCall(rhs2);
            }
        }
        return isTypeAssertionOnError;
    }

    private static boolean isTypeAssertionOrErrorsIsCall(@Nullable GoExpression expr) {
        return expr instanceof GoTypeAssertionExpr || GoErrorHandlingUtil.isErrorsAsCall(expr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "verbOperands";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "com/goide/editor/GoFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fold";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "foldFmtString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getPlaceholders";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndicesIfAllOperandsPresent";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getFoldedFmtString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isOneLineErrorHandlingIfBlock";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isTypeAssertionOnError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

