/*
 * Decompiled with CFR 0.152.
 */
package com.goide.editor;

import com.goide.GoLanguage;
import com.goide.GoParserDefinition;
import com.goide.GoTypes;
import com.goide.editor.GoFoldingBuilderUtil;
import com.goide.editor.GoFoldingSettings;
import com.goide.psi.GoBlock;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCaseClause;
import com.goide.psi.GoCodeFragment;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoFunctionOrMethodDeclaration;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoImportDeclaration;
import com.goide.psi.GoImportList;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoStatementsHolder;
import com.goide.psi.GoStringLiteral;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoVarDeclaration;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoDumbAwareFoldingBuilder
extends CustomFoldingBuilder {
    private static final String PARENTHESES = "(...)";
    private static final String SINGLE_LINE_COMMENT = "/.../";
    private static final String MULTI_LINE_COMMENT = "/*...*/";

    private static void foldTypes(@Nullable PsiElement e, @NotNull List<FoldingDescriptor> result, @NotNull Editor editor, @NotNull Document document, @NotNull GoFoldingSettings settings, int rightMargin) {
        if (result == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (e instanceof GoStructType) {
            GoStructType structType = (GoStructType)e;
            GoDumbAwareFoldingBuilder.foldTypeDefBlock(structType, structType.getFieldDeclarationList(), structType.getLbrace(), structType.getRbrace(), settings, editor, document, rightMargin, result);
        } else if (e instanceof GoInterfaceType) {
            GoInterfaceType interfaceType = (GoInterfaceType)e;
            GoDumbAwareFoldingBuilder.foldTypeDefBlock(interfaceType, interfaceType.getMethods(), interfaceType.getLbrace(), interfaceType.getRbrace(), settings, editor, document, rightMargin, result);
        }
    }

    private static void foldTypeDefBlock(@NotNull PsiElement element, @NotNull List<? extends PsiElement> children, @Nullable PsiElement lbrace, @Nullable PsiElement rbrace, @NotNull GoFoldingSettings settings, @NotNull Editor editor, @NotNull Document document, int rightMargin, @NotNull List<FoldingDescriptor> result) {
        if (element == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (children == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (document == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(8);
        }
        if (result == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (lbrace == null || rbrace == null) {
            return;
        }
        if (children.isEmpty() && settings.isEmptyStructOrInterfaceTypeDefs) {
            TextRange textRange = TextRange.create((int)lbrace.getTextOffset(), (int)(rbrace.getTextOffset() + 1));
            result.addAll(GoFoldingBuilderUtil.createFoldingDescriptorForEmptyBlock(element, textRange, editor, document, rightMargin));
        } else {
            GoDumbAwareFoldingBuilder.fold(element, lbrace, rbrace, "{...}", result);
        }
    }

    private static void fold(@NotNull PsiElement e, @Nullable PsiElement l, @Nullable PsiElement r, @NotNull String placeholderText, @NotNull List<FoldingDescriptor> result) {
        if (e == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(10);
        }
        if (placeholderText == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (result == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(12);
        }
        if (l != null && r != null) {
            result.add(new FoldingDescriptor(e, l.getTextRange().getStartOffset(), r.getTextRange().getEndOffset(), null, placeholderText));
        }
    }

    private static void addCommentFolds(@NotNull PsiElement comment, @NotNull Set<PsiElement> processedComments, @NotNull List<FoldingDescriptor> result) {
        ASTNode node;
        if (comment == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(13);
        }
        if (processedComments == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(14);
        }
        if (result == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(15);
        }
        if (processedComments.contains(comment)) {
            return;
        }
        PsiElement end = null;
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == GoParserDefinition.Lazy.LINE_COMMENT) {
                end = current;
                processedComments.add(current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE || StringUtil.countChars((CharSequence)node.getText(), (char)'\n') > 1) break;
        }
        if (end != null) {
            int startOffset = comment.getTextRange().getStartOffset();
            int endOffset = end.getTextRange().getEndOffset();
            result.add(new FoldingDescriptor(comment, startOffset, endOffset, null, SINGLE_LINE_COMMENT));
        }
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> result, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        List<GoImportDeclaration> importDeclarationList;
        GoImportDeclaration firstImport;
        GoFile file;
        block12: {
            block11: {
                if (result == null) {
                    GoDumbAwareFoldingBuilder.$$$reportNull$$$0(16);
                }
                if (root == null) {
                    GoDumbAwareFoldingBuilder.$$$reportNull$$$0(17);
                }
                if (document == null) {
                    GoDumbAwareFoldingBuilder.$$$reportNull$$$0(18);
                }
                if (!(root instanceof GoFile)) break block11;
                file = (GoFile)root;
                if (!(root instanceof GoCodeFragment)) break block12;
            }
            return;
        }
        if (!file.isContentsLoaded()) {
            return;
        }
        GoImportList importList = file.getImportList();
        if (!(importList == null || (firstImport = (GoImportDeclaration)ContainerUtil.getFirstItem(importDeclarationList = importList.getImportDeclarationList())) == null || importDeclarationList.size() <= 1 && GoFoldingBuilderUtil.isInTheSameLine(firstImport, document))) {
            PsiElement importKeyword = firstImport.getImport();
            int offset = importKeyword.getTextRange().getEndOffset();
            int startOffset = importKeyword.getNextSibling() instanceof PsiWhiteSpace ? offset + 1 : offset;
            int n = importList.getTextRange().getEndOffset();
            if (n - startOffset > 3) {
                result.add(new FoldingDescriptor((PsiElement)importList, startOffset, n, null, "..."));
            }
        }
        int rightMargin = CodeStyle.getSettings((PsiFile)file).getRightMargin(GoLanguage.INSTANCE);
        GoFoldingSettings goFoldingSettings = GoFoldingSettings.getInstance();
        Editor editor = GoFoldingBuilderUtil.getEditor(document, (PsiFile)file);
        if (editor == null) {
            return;
        }
        HashSet processedComments = new HashSet();
        PsiTreeUtil.processElements((PsiElement)file, element -> {
            GoCaseClause caseClause;
            FoldingDescriptor foldingDescriptor;
            if (element instanceof GoBlock) {
                GoBlock block = (GoBlock)element;
                PsiElement leftBrace = block.getLbrace();
                PsiElement rightBrace = block.getRbrace();
                if (rightBrace != null) {
                    List<FoldingDescriptor> list;
                    TextRange range = GoFoldingBuilderUtil.getBlockTextRange(leftBrace, rightBrace);
                    if (!GoFoldingBuilderUtil.isInTheSameLine(leftBrace, rightBrace, document) && (list = GoDumbAwareFoldingBuilder.createFoldingDescriptorForBlock(block, range, editor, document, goFoldingSettings, rightMargin)) != null) {
                        result.addAll(list);
                    }
                }
            } else if (element instanceof GoExprSwitchStatement) {
                GoExprSwitchStatement switchStatement = (GoExprSwitchStatement)element;
                GoDumbAwareFoldingBuilder.fold(switchStatement, switchStatement.getLbrace(), switchStatement.getRbrace(), "{...}", result);
            } else if (element instanceof GoTypeSwitchStatement) {
                GoTypeSwitchStatement switchStatement = (GoTypeSwitchStatement)element;
                GoDumbAwareFoldingBuilder.fold(switchStatement, switchStatement.getLbrace(), switchStatement.getRbrace(), "{...}", result);
            } else if (element instanceof GoSelectStatement) {
                GoSelectStatement selectStatement = (GoSelectStatement)element;
                GoDumbAwareFoldingBuilder.fold(selectStatement, selectStatement.getLbrace(), selectStatement.getRbrace(), "{...}", result);
            } else if (element instanceof GoVarDeclaration) {
                GoVarDeclaration varDeclaration = (GoVarDeclaration)element;
                if (varDeclaration.getVarSpecList().size() > 1) {
                    GoDumbAwareFoldingBuilder.fold(varDeclaration, varDeclaration.getLparen(), varDeclaration.getRparen(), PARENTHESES, result);
                }
            } else if (element instanceof GoConstDeclaration) {
                GoConstDeclaration constDeclaration = (GoConstDeclaration)element;
                if (constDeclaration.getConstSpecList().size() > 1) {
                    GoDumbAwareFoldingBuilder.fold(constDeclaration, constDeclaration.getLparen(), constDeclaration.getRparen(), PARENTHESES, result);
                }
            } else if (element instanceof GoTypeDeclaration) {
                GoTypeDeclaration typeDeclaration = (GoTypeDeclaration)element;
                if (typeDeclaration.getTypeSpecList().size() > 1) {
                    GoDumbAwareFoldingBuilder.fold(typeDeclaration, typeDeclaration.getLparen(), typeDeclaration.getRparen(), PARENTHESES, result);
                }
            } else if (element instanceof GoLiteralValue) {
                GoLiteralValue literalValue = (GoLiteralValue)element;
                if (literalValue.getLbrace() != null && literalValue.getRbrace() != null && !literalValue.getElementList().isEmpty() && !GoFoldingBuilderUtil.isInTheSameLine(literalValue.getLbrace(), literalValue.getRbrace(), document)) {
                    GoDumbAwareFoldingBuilder.fold(element, literalValue.getLbrace(), literalValue.getRbrace(), "{...}", result);
                }
            } else if (element instanceof GoCaseClause && (foldingDescriptor = GoDumbAwareFoldingBuilder.createFoldingDescriptorsForCaseClause(caseClause = (GoCaseClause)element, editor, document, goFoldingSettings, rightMargin)) != null) {
                result.add(foldingDescriptor);
            }
            if (!quick || ApplicationManager.getApplication().isUnitTestMode()) {
                GoStringLiteral stringLiteral;
                PsiElement string;
                ASTNode node = element.getNode();
                IElementType type2 = node.getElementType();
                TextRange range = element.getTextRange();
                if (type2 == GoParserDefinition.Lazy.MULTILINE_COMMENT && range.getLength() > 2) {
                    result.add(new FoldingDescriptor(node, range, null, MULTI_LINE_COMMENT));
                } else if (type2 == GoParserDefinition.Lazy.LINE_COMMENT) {
                    GoDumbAwareFoldingBuilder.addCommentFolds(element, processedComments, result);
                } else if (element instanceof GoStringLiteral && (string = (stringLiteral = (GoStringLiteral)element).getRawString()) != null && !GoFoldingBuilderUtil.isInTheSameLine(string, document)) {
                    String placeholderText = StringUtil.substringBefore((String)string.getText(), (String)"\n");
                    result.add(new FoldingDescriptor(string.getNode(), string.getTextRange(), null, (String)(StringUtil.isNotEmpty((String)placeholderText) ? placeholderText + "...`" : "`...`")));
                }
                GoDumbAwareFoldingBuilder.foldTypes(element, result, editor, document, goFoldingSettings, rightMargin);
            }
            return true;
        });
        for (GoTypeSpec goTypeSpec : file.getTypes()) {
            GoDumbAwareFoldingBuilder.foldTypes(goTypeSpec.getSpecType().getType(), result, editor, document, goFoldingSettings, rightMargin);
        }
    }

    @Nullable
    private static List<FoldingDescriptor> createFoldingDescriptorForBlock(@NotNull GoBlock block, @NotNull TextRange blockTextRange, @NotNull Editor editor, @NotNull Document document, @NotNull GoFoldingSettings goFoldingSettings, int rightMargin) {
        GoCallExpr callExpr;
        PsiElement parent;
        if (block == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(19);
        }
        if (blockTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(20);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(21);
        }
        if (document == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(22);
        }
        if (goFoldingSettings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(23);
        }
        if ((parent = block.getParent()) instanceof GoFunctionOrMethodDeclaration && block.getStatementList().isEmpty() && goFoldingSettings.isEmptyFunctions) {
            return GoFoldingBuilderUtil.createFoldingDescriptorForEmptyBlock(block, blockTextRange, editor, document, rightMargin);
        }
        GoCompositeElement soleElement = GoFoldingBuilderUtil.findSoleElementToCollapse(block, document);
        if (soleElement == null) {
            return GoDumbAwareFoldingBuilder.defaultBlockFoldingDescriptor(block, blockTextRange);
        }
        if (GoFoldingBuilderUtil.canBeErrorHandlingIfBlock(block, soleElement)) {
            return null;
        }
        TextRange soleElementTextRange = soleElement.getTextRange();
        if (soleElement instanceof GoReturnStatement) {
            boolean isFunction;
            GoIfStatement ifStatement;
            GoReturnStatement returnStatement = (GoReturnStatement)soleElement;
            boolean isIfStatement = goFoldingSettings.isOneLineReturns && parent instanceof GoIfStatement && (ifStatement = (GoIfStatement)parent).getElseStatement() == null;
            boolean bl = isFunction = goFoldingSettings.isOneLineReturnFunctions && (parent instanceof GoFunctionOrMethodDeclaration || parent instanceof GoFunctionLit);
            if (isIfStatement || isFunction) {
                return GoFoldingBuilderUtil.createFoldingDescriptorForReturnInBlock(block, blockTextRange, returnStatement, soleElementTextRange, editor, goFoldingSettings, rightMargin);
            }
        }
        if (goFoldingSettings.isOneLinePanics && (callExpr = GoFoldingBuilderUtil.getPanicCallExpr(soleElement)) != null) {
            return GoFoldingBuilderUtil.createFoldingDescriptorForPanicInBlock(block, blockTextRange, callExpr, soleElementTextRange, editor, goFoldingSettings, rightMargin);
        }
        return GoDumbAwareFoldingBuilder.defaultBlockFoldingDescriptor(block, blockTextRange);
    }

    @NotNull
    private static List<FoldingDescriptor> defaultBlockFoldingDescriptor(@NotNull GoBlock block, @NotNull TextRange blockTextRange) {
        if (block == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(24);
        }
        if (blockTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(25);
        }
        List<FoldingDescriptor> list = List.of(new FoldingDescriptor(block.getNode(), blockTextRange, null, "{...}"));
        if (list == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(26);
        }
        return list;
    }

    private static boolean isBeforeRightMarginBlock(@NotNull GoBlock block, @NotNull List<GoExpression> expressions, @NotNull String symbol, @NotNull Editor editor, int rightMargin) {
        if (block == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(27);
        }
        if (expressions == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(28);
        }
        if (symbol == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(29);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(30);
        }
        int length = GoFoldingBuilderUtil.doCalcPlaceholderTextLength(expressions, symbol, GoFoldingBuilderUtil.doCalcPlaceholderText(expressions, symbol));
        return GoFoldingBuilderUtil.isBeforeRightMargin(block, length, editor, rightMargin);
    }

    @Nullable
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(31);
        }
        if (range == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(32);
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        GoStructType structType;
        GoInterfaceType interfaceType;
        if (node == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(33);
        }
        CodeFoldingSettings codeFoldingSettings = CodeFoldingSettings.getInstance();
        GoFoldingSettings goFoldingSettings = GoFoldingSettings.getInstance();
        IElementType type2 = node.getElementType();
        PsiElement psi = node.getPsi();
        PsiFile file = psi.getContainingFile();
        int rightMargin = GoFoldingBuilderUtil.getRightMargin(file);
        Document document = file.getViewProvider().getDocument();
        if (document == null) {
            return false;
        }
        Editor editor = GoFoldingBuilderUtil.getEditor(file);
        if (editor == null) {
            return false;
        }
        if (type2 == GoParserDefinition.Lazy.LINE_COMMENT || type2 == GoParserDefinition.Lazy.MULTILINE_COMMENT) {
            return codeFoldingSettings.COLLAPSE_DOC_COMMENTS;
        }
        if (type2 == GoTypes.INTERFACE_TYPE && goFoldingSettings.isEmptyStructOrInterfaceTypeDefs && psi instanceof GoInterfaceType && (interfaceType = (GoInterfaceType)psi).getAllMethods().isEmpty()) {
            return true;
        }
        if (type2 == GoTypes.STRUCT_TYPE && goFoldingSettings.isEmptyStructOrInterfaceTypeDefs && psi instanceof GoStructType && (structType = (GoStructType)psi).getFieldDeclarationList().isEmpty()) {
            return true;
        }
        if (type2 == GoTypes.BLOCK) {
            GoBlock block;
            if (codeFoldingSettings.COLLAPSE_METHODS) {
                ASTNode parent = node.getTreeParent();
                return parent != null && parent.getPsi() instanceof GoFunctionOrMethodDeclaration;
            }
            return psi instanceof GoBlock && GoDumbAwareFoldingBuilder.isBlockCollapsedByDefault(block = (GoBlock)psi, document, goFoldingSettings, rightMargin);
        }
        if (goFoldingSettings.isOneLineCaseClauses && (type2 == GoTypes.EXPR_CASE_CLAUSE || type2 == GoTypes.TYPE_CASE_CLAUSE || type2 == GoTypes.COMM_CLAUSE)) {
            List<? extends GoCaseClause> caseClauses = GoDumbAwareFoldingBuilder.getCaseClauses(psi.getParent());
            return !caseClauses.isEmpty() && ContainerUtil.and(caseClauses, clause -> clause.getStatementList().isEmpty() || GoDumbAwareFoldingBuilder.hasSingleCollapsibleElement(clause, document, editor, rightMargin));
        }
        return codeFoldingSettings.COLLAPSE_IMPORTS && node.getElementType() == GoTypes.IMPORT_LIST;
    }

    private static List<? extends GoCaseClause> getCaseClauses(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return Collections.emptyList();
        }
        if (psiElement instanceof GoExprSwitchStatement) {
            GoExprSwitchStatement exprSwitchStatement = (GoExprSwitchStatement)psiElement;
            return exprSwitchStatement.getExprCaseClauseList();
        }
        if (psiElement instanceof GoTypeSwitchStatement) {
            GoTypeSwitchStatement typeSwitchStatement = (GoTypeSwitchStatement)psiElement;
            return typeSwitchStatement.getTypeCaseClauseList();
        }
        if (psiElement instanceof GoSelectStatement) {
            GoSelectStatement selectStatement = (GoSelectStatement)psiElement;
            return selectStatement.getCommClauseList();
        }
        return Collections.emptyList();
    }

    private static boolean hasSingleCollapsibleElement(@NotNull GoCaseClause caseClause, @NotNull Document document, @NotNull Editor editor, int rightMargin) {
        GoCompositeElement soleElement;
        if (caseClause == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(34);
        }
        if (document == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(35);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(36);
        }
        if ((soleElement = GoFoldingBuilderUtil.findSoleElementToCollapse(caseClause, document)) == null) {
            return false;
        }
        return GoDumbAwareFoldingBuilder.isBeforeRightMarginCaseClause(caseClause, soleElement, editor, rightMargin);
    }

    private static boolean isBlockCollapsedByDefault(@NotNull GoBlock block, @NotNull Document document, @NotNull GoFoldingSettings settings, int rightMargin) {
        GoCallExpr callExpr;
        Editor editor;
        if (block == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(37);
        }
        if (document == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(38);
        }
        if (settings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(39);
        }
        if ((editor = GoFoldingBuilderUtil.getEditor(block.getContainingFile())) == null) {
            return false;
        }
        PsiElement parent = block.getParent();
        if (parent instanceof GoFunctionOrMethodDeclaration && block.getStatementList().isEmpty() && settings.isEmptyFunctions) {
            return true;
        }
        GoCompositeElement soleElement = GoFoldingBuilderUtil.findSoleElementToCollapse(block, document);
        if (soleElement == null) {
            return false;
        }
        if (soleElement instanceof GoReturnStatement) {
            GoIfStatement ifStatement;
            GoReturnStatement returnStatement = (GoReturnStatement)soleElement;
            if (settings.isOneLineReturns && parent instanceof GoIfStatement && (ifStatement = (GoIfStatement)parent).getElseStatement() == null) {
                return switch (settings.returnSyntax) {
                    default -> throw new IncompatibleClassChangeError();
                    case GoFoldingSettings.FoldedReturnSyntax.RETURN -> GoFoldingBuilderUtil.isBeforeRightMarginBlockNew(block, returnStatement, editor, rightMargin);
                    case GoFoldingSettings.FoldedReturnSyntax.ARROW -> GoDumbAwareFoldingBuilder.isBeforeRightMarginBlock(block, returnStatement.getExpressionList(), GoFoldingBuilderUtil.getArrowSymbol(), editor, rightMargin);
                };
            }
            if (settings.isOneLineReturnFunctions && (parent instanceof GoFunctionOrMethodDeclaration || parent instanceof GoFunctionLit)) {
                return GoFoldingBuilderUtil.isBeforeRightMarginBlockNew(block, returnStatement, editor, rightMargin);
            }
        }
        if (settings.isOneLinePanics && (callExpr = GoFoldingBuilderUtil.getPanicCallExpr(soleElement)) != null) {
            return switch (settings.panicSyntax) {
                default -> throw new IncompatibleClassChangeError();
                case GoFoldingSettings.FoldedPanicSyntax.PANIC -> GoFoldingBuilderUtil.isBeforeRightMarginBlockNew(block, callExpr, editor, rightMargin);
                case GoFoldingSettings.FoldedPanicSyntax.BOMB -> GoDumbAwareFoldingBuilder.isBeforeRightMarginBlock(block, callExpr.getArgumentList().getExpressionList(), GoFoldingBuilderUtil.getBombSymbol(), editor, rightMargin);
            };
        }
        return false;
    }

    @Nullable
    private static FoldingDescriptor createFoldingDescriptorsForCaseClause(@NotNull GoCaseClause caseClause, @NotNull Editor editor, @NotNull Document document, @NotNull GoFoldingSettings goFoldingSettings, int rightMargin) {
        GoCallExpr callExpr;
        PsiElement colon;
        if (caseClause == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(40);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(41);
        }
        if (document == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(42);
        }
        if (goFoldingSettings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(43);
        }
        if ((colon = caseClause.getColon()) == null || caseClause.getStatementList().isEmpty()) {
            return null;
        }
        TextRange caseClauseTextRange = caseClause.getTextRange();
        GoCompositeElement soleElement = GoFoldingBuilderUtil.findSoleElementToCollapse(caseClause, document);
        int startOffset = colon.getNextSibling().getTextRange().getStartOffset();
        int endOffset = caseClauseTextRange.getEndOffset();
        TextRange defaultFoldingRange = TextRange.create((int)startOffset, (int)endOffset);
        FoldingDescriptor defaultFoldingDescriptor = new FoldingDescriptor(caseClause.getNode(), defaultFoldingRange, null, "...");
        if (soleElement == null) {
            return defaultFoldingDescriptor;
        }
        TextRange soleElementTextRange = soleElement.getTextRange();
        if (goFoldingSettings.isOneLineReturns && soleElement instanceof GoReturnStatement) {
            GoReturnStatement returnStatement = (GoReturnStatement)soleElement;
            return GoDumbAwareFoldingBuilder.createFoldingDescriptorForReturnInCaseClause(caseClause, returnStatement, caseClauseTextRange, colon, soleElementTextRange, defaultFoldingRange, editor, goFoldingSettings, rightMargin);
        }
        if (goFoldingSettings.isOneLinePanics && (callExpr = GoFoldingBuilderUtil.getPanicCallExpr(soleElement)) != null) {
            return GoDumbAwareFoldingBuilder.createFoldingDescriptorForPanicInCaseClause(caseClause, caseClauseTextRange, colon, callExpr, soleElementTextRange, defaultFoldingRange, editor, goFoldingSettings, rightMargin);
        }
        if (goFoldingSettings.isOneLineCaseClauses) {
            return GoDumbAwareFoldingBuilder.createFoldingDescriptorForCaseClauseNew(caseClause, caseClauseTextRange, colon, soleElement, soleElementTextRange, editor, rightMargin);
        }
        return defaultFoldingDescriptor;
    }

    @NotNull
    private static FoldingDescriptor createFoldingDescriptorForReturnInCaseClause(@NotNull GoCaseClause caseClause, @NotNull GoReturnStatement returnStatement, @NotNull TextRange caseClauseTextRange, @NotNull PsiElement colon, @NotNull TextRange soleElementTextRange, @NotNull TextRange defaultFoldingRange, @NotNull Editor editor, @NotNull GoFoldingSettings settings, int rightMargin) {
        if (caseClause == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(44);
        }
        if (returnStatement == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(45);
        }
        if (caseClauseTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(46);
        }
        if (colon == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(47);
        }
        if (soleElementTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(48);
        }
        if (defaultFoldingRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(49);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(50);
        }
        if (settings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(51);
        }
        return switch (settings.returnSyntax) {
            default -> throw new IncompatibleClassChangeError();
            case GoFoldingSettings.FoldedReturnSyntax.RETURN -> GoDumbAwareFoldingBuilder.createFoldingDescriptorForCaseClauseNew(caseClause, caseClauseTextRange, colon, returnStatement, soleElementTextRange, editor, rightMargin);
            case GoFoldingSettings.FoldedReturnSyntax.ARROW -> GoDumbAwareFoldingBuilder.createFoldingDescriptorForCaseClause(caseClause, returnStatement.getExpressionList(), GoFoldingBuilderUtil.getArrowSymbol(), defaultFoldingRange, editor, rightMargin);
        };
    }

    @NotNull
    private static FoldingDescriptor createFoldingDescriptorForPanicInCaseClause(@NotNull GoCaseClause caseClause, @NotNull TextRange caseClauseTextRange, @NotNull PsiElement colon, @NotNull GoCallExpr callExpr, @NotNull TextRange soleElementTextRange, @NotNull TextRange defaultFoldingRange, @NotNull Editor editor, @NotNull GoFoldingSettings settings, int rightMargin) {
        if (caseClause == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(52);
        }
        if (caseClauseTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(53);
        }
        if (colon == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(54);
        }
        if (callExpr == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(55);
        }
        if (soleElementTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(56);
        }
        if (defaultFoldingRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(57);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(58);
        }
        if (settings == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(59);
        }
        return switch (settings.panicSyntax) {
            default -> throw new IncompatibleClassChangeError();
            case GoFoldingSettings.FoldedPanicSyntax.PANIC -> GoDumbAwareFoldingBuilder.createFoldingDescriptorForCaseClauseNew(caseClause, caseClauseTextRange, colon, callExpr, soleElementTextRange, editor, rightMargin);
            case GoFoldingSettings.FoldedPanicSyntax.BOMB -> GoDumbAwareFoldingBuilder.createFoldingDescriptorForCaseClause(caseClause, callExpr.getArgumentList().getExpressionList(), GoFoldingBuilderUtil.getBombSymbol(), defaultFoldingRange, editor, rightMargin);
        };
    }

    @NotNull
    private static FoldingDescriptor createFoldingDescriptorForCaseClause(@NotNull GoStatementsHolder statementsHolder, @NotNull List<GoExpression> expressions, @NotNull String symbol, @NotNull TextRange textRange, @NotNull Editor editor, int rightMargin) {
        if (statementsHolder == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(60);
        }
        if (expressions == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(61);
        }
        if (symbol == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(62);
        }
        if (textRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(63);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(64);
        }
        String placeholder = GoFoldingBuilderUtil.getPlaceHolderForSymbol(statementsHolder, expressions, symbol, "...", editor, rightMargin);
        return new FoldingDescriptor(statementsHolder.getNode(), textRange, null, placeholder);
    }

    @NotNull
    private static FoldingDescriptor createFoldingDescriptorForCaseClauseNew(@NotNull GoCaseClause caseClause, @NotNull TextRange caseClauseTextRange, @NotNull PsiElement colon, @NotNull PsiElement soleElement, @NotNull TextRange soleElementTextRange, @NotNull Editor editor, int rightMargin) {
        if (caseClause == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(65);
        }
        if (caseClauseTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(66);
        }
        if (colon == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(67);
        }
        if (soleElement == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(68);
        }
        if (soleElementTextRange == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(69);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(70);
        }
        if (GoDumbAwareFoldingBuilder.isBeforeRightMarginCaseClause(caseClause, soleElement, editor, rightMargin)) {
            int colonOffset = colon.getTextOffset();
            int soleElementOffset = soleElementTextRange.getStartOffset();
            return new FoldingDescriptor((PsiElement)caseClause, colonOffset, soleElementOffset, null, ": ");
        }
        int nextSiblingOffset = colon.getNextSibling().getTextRange().getStartOffset();
        int endOffset = caseClauseTextRange.getEndOffset();
        return new FoldingDescriptor((PsiElement)caseClause, nextSiblingOffset, endOffset, null, "...");
    }

    private static boolean isBeforeRightMarginCaseClause(@NotNull GoStatementsHolder holder, @NotNull PsiElement statement, @NotNull Editor editor, int rightMargin) {
        if (holder == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(71);
        }
        if (statement == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(72);
        }
        if (editor == null) {
            GoDumbAwareFoldingBuilder.$$$reportNull$$$0(73);
        }
        return GoFoldingBuilderUtil.isBeforeRightMargin(holder, ": ".length() + statement.getTextLength(), editor, rightMargin);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 7: 
            case 21: 
            case 30: 
            case 36: 
            case 41: 
            case 50: 
            case 58: 
            case 64: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 18: 
            case 22: 
            case 35: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 6: 
            case 39: 
            case 51: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholderText";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedComments";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: 
            case 24: 
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockTextRange";
                break;
            }
            case 23: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goFoldingSettings";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/editor/GoDumbAwareFoldingBuilder";
                break;
            }
            case 28: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 29: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 34: 
            case 40: 
            case 44: 
            case 52: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseClause";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 46: 
            case 53: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseClauseTextRange";
                break;
            }
            case 47: 
            case 54: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colon";
                break;
            }
            case 48: 
            case 56: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "soleElementTextRange";
                break;
            }
            case 49: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFoldingRange";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsHolder";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "soleElement";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/editor/GoDumbAwareFoldingBuilder";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultBlockFoldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foldTypes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "foldTypeDefBlock";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fold";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addCommentFolds";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptorForBlock";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "defaultBlockFoldingDescriptor";
                break;
            }
            case 26: {
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeRightMarginBlock";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleCollapsibleElement";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isBlockCollapsedByDefault";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptorsForCaseClause";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptorForReturnInCaseClause";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptorForPanicInCaseClause";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptorForCaseClause";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "createFoldingDescriptorForCaseClauseNew";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isBeforeRightMarginCaseClause";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 26 -> new IllegalStateException(string);
        };
    }
}

