/*
 * Decompiled with CFR 0.152.
 */
package com.goide.documentation.langspecparser;

import com.goide.documentation.GoKeywordDescription;
import com.goide.documentation.langspecparser.LangSpecParserKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/goide/documentation/langspecparser/KeywordDescriptionGenerator;", "", "languageSpecification", "Lorg/jsoup/nodes/Document;", "specURL", "", "(Lorg/jsoup/nodes/Document;Ljava/lang/String;)V", "addTextToKeywordDescription", "", "goKeywordDescription", "Lcom/goide/documentation/GoKeywordDescription;", "copyKeywordDescriptionAndAddText", "goKeyword", "makeSpecificationLinkAbsolute", "rewriteRelativeLinks", "Lorg/jsoup/nodes/Element;", "e", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nLangSpecParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangSpecParser.kt\ncom/goide/documentation/langspecparser/KeywordDescriptionGenerator\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n429#2:169\n502#2,5:170\n1855#3,2:175\n*S KotlinDebug\n*F\n+ 1 LangSpecParser.kt\ncom/goide/documentation/langspecparser/KeywordDescriptionGenerator\n*L\n126#1:169\n126#1:170,5\n141#1:175,2\n*E\n"})
public final class KeywordDescriptionGenerator {
    @NotNull
    private final Document languageSpecification;
    @NotNull
    private final String specURL;

    public KeywordDescriptionGenerator(@NotNull Document languageSpecification, @NotNull String specURL) {
        Intrinsics.checkNotNullParameter((Object)languageSpecification, (String)"languageSpecification");
        Intrinsics.checkNotNullParameter((Object)specURL, (String)"specURL");
        this.languageSpecification = languageSpecification;
        this.specURL = specURL;
    }

    @NotNull
    public final GoKeywordDescription copyKeywordDescriptionAndAddText(@NotNull GoKeywordDescription goKeyword) {
        Intrinsics.checkNotNullParameter((Object)goKeyword, (String)"goKeyword");
        Object object = goKeyword.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.goide.documentation.GoKeywordDescription");
        GoKeywordDescription completeGoKeywordDescription = (GoKeywordDescription)object;
        this.addTextToKeywordDescription(completeGoKeywordDescription);
        this.makeSpecificationLinkAbsolute(completeGoKeywordDescription);
        return completeGoKeywordDescription;
    }

    /*
     * WARNING - void declaration
     */
    private final void addTextToKeywordDescription(GoKeywordDescription goKeywordDescription) {
        void $this$filterTo$iv$iv;
        String string = goKeywordDescription.getSpecificationLink();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSpecificationLink(...)");
        char[] cArray = new char[]{'#'};
        String specFileSection = (String)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(1);
        Element element = this.languageSpecification.getElementById(specFileSection);
        if (element == null) {
            return;
        }
        Element specFileBody = element;
        Element element2 = specFileBody.nextElementSiblings().select("p").first();
        if (element2 == null) {
            return;
        }
        Element specFileBodyNextParagraphRelative = element2;
        String string2 = this.rewriteRelativeLinks(specFileBodyNextParagraphRelative).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String specFileBodyNextParagraphAbsolute = string2;
        int lengthBeforeFilter = specFileBodyNextParagraphAbsolute.length();
        String $this$filter$iv = specFileBodyNextParagraphAbsolute;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!LangSpecParserKt.isPrintableASCIIOrSectionSign(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string3 = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String keywordDescription = string3;
        int lengthAfterFilter = keywordDescription.length();
        if (lengthBeforeFilter != lengthAfterFilter) {
            String string4 = "WARN: truncated " + (lengthBeforeFilter - lengthAfterFilter) + "characters whileprocessing description text for keyword " + goKeywordDescription.getKeyword();
            System.out.println((Object)string4);
        }
        goKeywordDescription.setDescriptionText(keywordDescription);
    }

    private final Element rewriteRelativeLinks(Element e) {
        Elements links = e.select("a");
        Intrinsics.checkNotNull((Object)links);
        Iterable $this$forEach$iv = (Iterable)links;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element it = (Element)element$iv;
            boolean bl = false;
            String curHref = it.attr("href");
            Intrinsics.checkNotNull((Object)curHref);
            if (StringsKt.first((CharSequence)curHref) != '#') continue;
            String prefixedHref = this.specURL + curHref;
            it.attr("href", prefixedHref);
        }
        return e;
    }

    private final void makeSpecificationLinkAbsolute(GoKeywordDescription goKeywordDescription) {
        goKeywordDescription.setSpecificationLink(this.specURL + goKeywordDescription.getSpecificationLink());
    }
}

