/*
 * Decompiled with CFR 0.152.
 */
package com.goide.documentation.additional;

import com.goide.documentation.GoAdditionalDocumentationProvider;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0003J\u001a\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/goide/documentation/additional/GoTypeSpecDocumentationProvider;", "Lcom/goide/documentation/GoAdditionalDocumentationProvider;", "()V", "hyperlink", "", "Lcom/intellij/openapi/util/NlsSafe;", "tutorialLink", "calculateMessage", "typeSpec", "Lcom/goide/psi/GoTypeSpec;", "provideAdditionalDocumentation", "element", "Lcom/intellij/psi/PsiElement;", "originalElement", "intellij.go.impl"})
public final class GoTypeSpecDocumentationProvider
implements GoAdditionalDocumentationProvider {
    @NotNull
    private final String tutorialLink;
    @NotNull
    private final String hyperlink;

    public GoTypeSpecDocumentationProvider() {
        this.tutorialLink = "https://go.dev/ref/spec#Type_identity";
        String string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.link((String)this.tutorialLink, (String)GoBundle.message((String)"go.quick.doc.type.alias.and.definition.hint.link.text", (Object[])new Object[0]))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.hyperlink = string;
    }

    @Override
    @NotNull
    public String provideAdditionalDocumentation(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof GoTypeSpec)) {
            return "";
        }
        String message = this.calculateMessage((GoTypeSpec)element);
        if (Intrinsics.areEqual((Object)message, (Object)"")) {
            return message;
        }
        HtmlBuilder documentationMarkup = new HtmlBuilder();
        documentationMarkup.append((HtmlChunk)DocumentationMarkup.CONTENT_ELEMENT.addRaw(message));
        String string = documentationMarkup.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nls
    private final String calculateMessage(GoTypeSpec typeSpec) {
        String name = typeSpec.getName();
        GoType goType = typeSpec.getSpecType().getType();
        if (goType == null) {
            return "";
        }
        GoType type2 = goType;
        String referencedName = type2.getText();
        if (typeSpec.isTypeAlias()) {
            Object[] objectArray = new Object[]{name, referencedName, this.hyperlink};
            String string = GoBundle.message((String)"go.quick.doc.type.alias.hint", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (type2.getChildren().length == 1 && type2.getFirstChild() instanceof GoTypeReferenceExpression) {
            Object[] objectArray = new Object[]{name, referencedName, this.hyperlink};
            String string = GoBundle.message((String)"go.quick.doc.type.definition.hint", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        return "";
    }
}

