/*
 * Decompiled with CFR 0.152.
 */
package com.goide.dlv;

import com.goide.dlv.DlvDebugProcess;
import com.goide.dlv.DlvUtil;
import com.goide.dlv.DlvXValue;
import com.goide.dlv.protocol.DlvApi;
import com.goide.dlv.protocol.DlvRequest;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoBuiltinCallExpr;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoConstDefinition;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoStatement;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoElementFactory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class DlvExpressionEvaluator
extends XDebuggerEvaluator {
    private final DlvDebugProcess myProcess;
    private final DlvApi.Location myLocation;
    private final int myFrameId;
    private final long myGoroutineId;

    DlvExpressionEvaluator(@NotNull DlvDebugProcess process, @NotNull DlvApi.Location location, int frameId, long goroutineId) {
        if (process == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(0);
        }
        if (location == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(1);
        }
        this.myProcess = process;
        this.myLocation = location;
        this.myFrameId = frameId;
        this.myGoroutineId = goroutineId;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(3);
        }
        if (this.hasCalls(expression)) {
            if (this.myFrameId != 0) {
                callback.errorOccurred(GoBundle.message((String)"go.debugger.cannot.evaluate.call", (Object[])new Object[]{GoBundle.message((String)"go.debugger.non.top.frame.selected", (Object[])new Object[0])}));
            } else if (this.myLocation.function == null) {
                callback.errorOccurred(GoBundle.message((String)"go.debugger.cannot.evaluate.call", (Object[])new Object[]{GoBundle.message((String)"go.debugger.missing.current.function", (Object[])new Object[0])}));
            } else {
                this.myProcess.getStacktrace(this.myGoroutineId).thenAsync(stack -> this.myProcess.send(new DlvRequest.Call(expression)).thenAsync(state -> this.handleCallResult((List<XStackFrame>)stack, expression, callback, (DlvApi.DebuggerState)state)).onError(throwable -> {
                    Object message = throwable.getMessage();
                    if (((String)message).contains("could not find symbol value for")) {
                        message = (String)message + GoBundle.message((String)"go.debugger.unused.functions.are.not.included.message", (Object[])new Object[0]);
                    } else if (((String)message).contains(" has no member ")) {
                        message = (String)message + GoBundle.message((String)"go.debugger.unused.methods.are.not.included.message", (Object[])new Object[0]);
                    }
                    callback.errorOccurred((String)message);
                }));
            }
        } else {
            this.myProcess.send(new DlvRequest.Eval(expression, this.myFrameId, this.myGoroutineId)).onSuccess(variable -> callback.evaluated((XValue)DlvXValue.create(expression, this.myProcess, null, variable, this.myFrameId, this.myGoroutineId, AllIcons.Debugger.Watch))).onError(throwable -> callback.errorOccurred(throwable.getMessage()));
        }
    }

    private boolean hasCalls(@NotNull String expression) {
        if (expression == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(4);
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            GoFile file = GoElementFactory.createFileFromText(this.myProcess.getSession().getProject(), "package a; func a() { " + expression + "}");
            GoStatement statement = (GoStatement)PsiTreeUtil.findChildOfType((PsiElement)file, GoStatement.class);
            return statement != null && PsiTreeUtil.findChildOfType((PsiElement)statement, GoCallExpr.class) != null;
        });
    }

    @Nullable
    private static PsiElement findElementAt(@Nullable PsiFile file, int offset) {
        return file != null ? file.findElementAt(offset) : null;
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(5);
        }
        if (document == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(6);
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> {
            GoTypeOwner e = null;
            try {
                PsiElement elementAtCursor = DlvExpressionEvaluator.findElementAt(PsiDocumentManager.getInstance((Project)project).getPsiFile(document), offset);
                e = (GoTypeOwner)PsiTreeUtil.getParentOfType((PsiElement)elementAtCursor, (Class[])new Class[]{GoExpression.class, GoVarDefinition.class, GoConstDefinition.class, GoParamDefinition.class});
                if (!sideEffectsAllowed && DlvExpressionEvaluator.containsCalls(e)) {
                    e = null;
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            return e != null ? new ExpressionInfo(e.getTextRange()) : null;
        }).withDocumentsCommitted(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (cancellablePromise == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(7);
        }
        return cancellablePromise;
    }

    private static boolean containsCalls(@Nullable PsiElement element) {
        return PsiTreeUtil.findChildOfType((PsiElement)element, GoCallExpr.class, (boolean)false) != null || PsiTreeUtil.findChildOfType((PsiElement)element, GoBuiltinCallExpr.class, (boolean)false) != null;
    }

    @NotNull
    private Promise<Void> handleCallResult(@NotNull List<XStackFrame> initialStack, @NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @NotNull DlvApi.DebuggerState state) {
        DlvApi.Location currentLocation;
        boolean inInitialLocation;
        if (initialStack == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(10);
        }
        if (state == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(11);
        }
        boolean bl = inInitialLocation = (currentLocation = DlvUtil.getCurrentLocation(state)) != null && Objects.equals(DlvExpressionEvaluator.getFunctionName(this.myLocation), DlvExpressionEvaluator.getFunctionName(currentLocation)) && this.myLocation.line == currentLocation.line;
        if (inInitialLocation) {
            Promise promise = this.myProcess.getStacktrace(this.myGoroutineId).thenAsync(stack -> {
                List<DlvApi.Variable> returnValues;
                if (stack.size() > initialStack.size()) {
                    return this.myProcess.send(new DlvRequest.ContinueCall()).thenAsync(s -> this.handleCallResult(initialStack, expression, callback, (DlvApi.DebuggerState)s));
                }
                DlvApi.Thread thread = state.currentThread;
                List<DlvApi.Variable> list = returnValues = thread != null ? thread.returnValues : null;
                if (returnValues == null) {
                    returnValues = Collections.emptyList();
                }
                callback.evaluated(DlvXValue.createCallResult(expression, returnValues, this.myProcess, this.myFrameId, this.myGoroutineId));
                return Promises.resolvedPromise(null);
            });
            if (promise == null) {
                DlvExpressionEvaluator.$$$reportNull$$$0(12);
            }
            return promise;
        }
        Promise promise = this.myProcess.send(new DlvRequest.ContinueCall()).thenAsync(s -> this.handleCallResult(initialStack, expression, callback, (DlvApi.DebuggerState)s));
        if (promise == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @Nullable
    private static String getFunctionName(@NotNull DlvApi.Location loc) {
        DlvApi.Function function;
        if (loc == null) {
            DlvExpressionEvaluator.$$$reportNull$$$0(14);
        }
        return (function = loc.function) != null ? function.name : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/dlv/DlvExpressionEvaluator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialStack";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/dlv/DlvExpressionEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCallResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasCalls";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleCallResult";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12, 13 -> new IllegalStateException(string);
        };
    }
}

