/*
 * Decompiled with CFR 0.152.
 */
package com.goide.diagram.vgo;

import com.goide.util.GoExecutor;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoModule;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramEdgeBase;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeBase;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationships;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Consumer;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoDependencyDataModel
extends DiagramDataModel<VgoDependency> {
    private final Collection<VgoDependencyEdge> myEdges;
    private final VgoModule myVgoModule;
    private final Map<String, VgoDependencyNode> myNodes;

    public VgoDependencyDataModel(@NotNull Project project, @Nullable VgoModule vgoModule, @NotNull DiagramProvider<VgoDependency> provider) {
        if (project == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(1);
        }
        super(project, provider);
        this.myEdges = new HashSet<VgoDependencyEdge>();
        this.myVgoModule = vgoModule;
        this.myNodes = FactoryMap.create(key -> vgoModule != null && key.equals(vgoModule.getImportPath()) ? new VgoDependencyNode(vgoModule) : new VgoDependencyNode(VgoDependencyDataModel.dependency(key)));
    }

    @Nullable
    public VgoModule getVgoModule() {
        return this.myVgoModule;
    }

    @NotNull
    public Collection<? extends DiagramNode<VgoDependency>> getNodes() {
        Collection<VgoDependencyNode> collection = this.myNodes.values();
        if (collection == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends DiagramEdge<VgoDependency>> getEdges() {
        Collection<VgoDependencyEdge> collection = this.myEdges;
        if (collection == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<VgoDependency> node) {
        if (node == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(4);
        }
        String string = StringUtil.notNullize((String)node.getTooltip());
        if (string == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void refreshDataModel() {
        if (this.myVgoModule == null) {
            return;
        }
        this.cleanUp();
        Project project = this.getProject();
        @NlsSafe String presentableName = "go mod graph (" + this.myVgoModule.getImportPath() + ")";
        GoExecutor.in(project, null).disablePty().withPresentableName(presentableName).withParameters("mod", "graph").withWorkDirectory(this.myVgoModule.getRoot().getPath()).withProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                List split;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT && (split = StringUtil.split((String)event.getText().trim(), (String)" ")).size() == 2) {
                    VgoDependencyDataModel.this.myEdges.add(new VgoDependencyEdge(VgoDependencyDataModel.this.myNodes.get(split.get(0)), VgoDependencyDataModel.this.myNodes.get(split.get(1))));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/goide/diagram/vgo/VgoDependencyDataModel$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).showNotifications(false, false).executeWithProgress(true, true, (Consumer<? super GoExecutor.ExecutionResult>)((Consumer)result -> {
            DiagramBuilder builder;
            if (result.status == GoExecutor.ExecutionResult.Status.SUCCEEDED && !project.isDisposed() && !Disposer.isDisposed((Disposable)(builder = this.getBuilder()))) {
                builder.queryUpdate().withDataReload().withPresentationUpdate().run();
            }
        }));
    }

    public void rebuild(VgoDependency element) {
        this.cleanUp();
        super.rebuild((Object)element);
    }

    @Nullable
    public DiagramNode<VgoDependency> addElement(VgoDependency element) {
        return null;
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        PsiModificationTracker psiModificationTracker = PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
        if (psiModificationTracker == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(6);
        }
        return psiModificationTracker;
    }

    public void dispose() {
        this.cleanUp();
    }

    private void cleanUp() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    private static VgoDependency dependency(@NotNull String s) {
        if (s == null) {
            VgoDependencyDataModel.$$$reportNull$$$0(7);
        }
        return new VgoDependencyImpl(StringUtil.substringBeforeLast((String)s, (String)"@"), StringUtil.notNullize((String)StringUtil.substringAfterLast((String)s, (String)"@")), null, null, null, null, null, null, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/diagram/vgo/VgoDependencyDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/diagram/vgo/VgoDependencyDataModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }

    private final class VgoDependencyNode
    extends DiagramNodeBase<VgoDependency> {
        private final VgoDependency myDependency;

        private VgoDependencyNode(VgoDependency dependency) {
            if (dependency == null) {
                VgoDependencyNode.$$$reportNull$$$0(0);
            }
            super(VgoDependencyDataModel.this.getProvider());
            this.myDependency = dependency;
        }

        @NotNull
        public String getTooltip() {
            String string = this.myDependency.getImportPath();
            if (string == null) {
                VgoDependencyNode.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = IconManager.getInstance().getPlatformIcon(PlatformIcons.Package);
            if (icon == null) {
                VgoDependencyNode.$$$reportNull$$$0(2);
            }
            return icon;
        }

        @NotNull
        public VgoDependency getIdentifyingElement() {
            VgoDependency vgoDependency = this.myDependency;
            if (vgoDependency == null) {
                VgoDependencyNode.$$$reportNull$$$0(3);
            }
            return vgoDependency;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/diagram/vgo/VgoDependencyDataModel$VgoDependencyNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/diagram/vgo/VgoDependencyDataModel$VgoDependencyNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIdentifyingElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class VgoDependencyEdge
    extends DiagramEdgeBase<VgoDependency> {
        private VgoDependencyEdge(@NotNull VgoDependencyNode source, @NotNull VgoDependencyNode target) {
            if (source == null) {
                VgoDependencyEdge.$$$reportNull$$$0(0);
            }
            if (target == null) {
                VgoDependencyEdge.$$$reportNull$$$0(1);
            }
            super((DiagramNode)source, (DiagramNode)target, DiagramRelationships.DEPENDENCY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "source";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/goide/diagram/vgo/VgoDependencyDataModel$VgoDependencyEdge";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

