/*
 * Decompiled with CFR 0.152.
 */
package com.goide.controlflow;

import com.goide.controlflow.instructions.GoAssignmentStatementInstruction;
import com.goide.controlflow.instructions.GoBranchInstruction;
import com.goide.controlflow.instructions.GoBreakStatementInstruction;
import com.goide.controlflow.instructions.GoCaseBranchInstruction;
import com.goide.controlflow.instructions.GoConstDeclarationInstruction;
import com.goide.controlflow.instructions.GoContinueStatementInstruction;
import com.goide.controlflow.instructions.GoDeferStatementInstruction;
import com.goide.controlflow.instructions.GoExpressionInstruction;
import com.goide.controlflow.instructions.GoExpressionStatementInstruction;
import com.goide.controlflow.instructions.GoFallthroughStatementInstruction;
import com.goide.controlflow.instructions.GoForLoopBranchInstruction;
import com.goide.controlflow.instructions.GoForLoopEndInstruction;
import com.goide.controlflow.instructions.GoForLoopStartInstruction;
import com.goide.controlflow.instructions.GoGoStatementInstruction;
import com.goide.controlflow.instructions.GoGotoStatementInstruction;
import com.goide.controlflow.instructions.GoIncDecStatementInstruction;
import com.goide.controlflow.instructions.GoInstruction;
import com.goide.controlflow.instructions.GoParameterDeclarationInstruction;
import com.goide.controlflow.instructions.GoRangeClauseInstruction;
import com.goide.controlflow.instructions.GoRecvStatementInstruction;
import com.goide.controlflow.instructions.GoReturnStatementInstruction;
import com.goide.controlflow.instructions.GoSendStatementInstruction;
import com.goide.controlflow.instructions.GoShortVarDeclarationInstruction;
import com.goide.controlflow.instructions.GoTypeDeclarationInstruction;
import com.goide.controlflow.instructions.GoTypeInSwitchCaseInstruction;
import com.goide.controlflow.instructions.GoTypeSwitchGuardInstruction;
import com.goide.controlflow.instructions.GoVarDeclarationInstruction;
import com.goide.intentions.negate.GoBooleanExpressionUtil;
import com.goide.psi.GoAssignmentStatement;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoBlock;
import com.goide.psi.GoBreakStatement;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoCommCase;
import com.goide.psi.GoCommClause;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoConstDeclaration;
import com.goide.psi.GoContinueStatement;
import com.goide.psi.GoDeferStatement;
import com.goide.psi.GoElseStatement;
import com.goide.psi.GoExprCaseClause;
import com.goide.psi.GoExprSwitchStatement;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFallthroughStatement;
import com.goide.psi.GoForClause;
import com.goide.psi.GoForStatement;
import com.goide.psi.GoFunctionLit;
import com.goide.psi.GoGoStatement;
import com.goide.psi.GoGotoStatement;
import com.goide.psi.GoIfStatement;
import com.goide.psi.GoIncDecStatement;
import com.goide.psi.GoLabelDefinition;
import com.goide.psi.GoLabelRef;
import com.goide.psi.GoLabeledStatement;
import com.goide.psi.GoLeftHandExprList;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoRangeClause;
import com.goide.psi.GoRecvStatement;
import com.goide.psi.GoReturnStatement;
import com.goide.psi.GoSelectStatement;
import com.goide.psi.GoSendStatement;
import com.goide.psi.GoShortVarDeclaration;
import com.goide.psi.GoSimpleStatement;
import com.goide.psi.GoStatement;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSwitchGuard;
import com.goide.psi.GoTypeSwitchStatement;
import com.goide.psi.GoUnaryExpr;
import com.goide.psi.GoVarDeclaration;
import com.goide.psi.GoVisitor;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.util.GoStdlibUtil;
import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowBuilder;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.TransparentInstruction;
import com.intellij.codeInsight.controlflow.impl.TransparentInstructionImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoControlFlowBuilder
extends GoVisitor
implements PsiRecursiveVisitor {
    private static final Logger LOG = Logger.getInstance(GoControlFlowBuilder.class);
    private static final int DEPTH_LIMIT = 1000;
    private static final ControlFlow TRIVIAL;
    static boolean ourExpandExpressionsInTests;
    protected final ControlFlowBuilder myBuilder = new ControlFlowBuilder();
    private final Map<GoLabelDefinition, TransparentInstruction> myGotoTargets = new IdentityHashMap<GoLabelDefinition, TransparentInstruction>();
    private final Map<GoLabelDefinition, TransparentInstruction> myLabeledBreakTargets = new IdentityHashMap<GoLabelDefinition, TransparentInstruction>();
    private final Map<GoLabelDefinition, TransparentInstruction> myLabeledContinueTargets = new IdentityHashMap<GoLabelDefinition, TransparentInstruction>();
    private final Stack<Instruction> myFallthroughTargets = new Stack();

    @NotNull
    public ControlFlow getControlFlow(@NotNull PsiElement element) {
        if (element == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(0);
        }
        ControlFlow controlFlow = GoPsiTreeUtil.getMaxDepth(element) < 1000 ? this.myBuilder.build((PsiElementVisitor)this, element) : TRIVIAL;
        if (controlFlow == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return controlFlow;
    }

    @Override
    public void visitCompositeElement(@NotNull GoCompositeElement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(2);
        }
        super.visitCompositeElement(o);
        for (PsiElement psiElement : o.getChildren()) {
            psiElement.accept((PsiElementVisitor)this);
            ProgressIndicatorProvider.checkCanceled();
        }
    }

    @Override
    public void visitParameterDeclaration(@NotNull GoParameterDeclaration o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(3);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.addNode(new GoParameterDeclarationInstruction(this.myBuilder, o));
    }

    @Override
    public void visitAssignmentStatement(@NotNull GoAssignmentStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(4);
        }
        ProgressIndicatorProvider.checkCanceled();
        o.acceptChildren(this);
        this.addNode(new GoAssignmentStatementInstruction(this.myBuilder, o));
    }

    @Override
    public void visitDeferStatement(@NotNull GoDeferStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(5);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoExpression expression = o.getExpression();
        if (expression != null) {
            expression.acceptChildren(this);
        }
        this.addNode(new GoDeferStatementInstruction(this.myBuilder, o));
    }

    @Override
    public void visitGoStatement(@NotNull GoGoStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(6);
        }
        ProgressIndicatorProvider.checkCanceled();
        o.acceptChildren(this);
        this.addNode(new GoGoStatementInstruction(this.myBuilder, o));
    }

    @Override
    public void visitIncDecStatement(@NotNull GoIncDecStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(7);
        }
        ProgressIndicatorProvider.checkCanceled();
        o.acceptChildren(this);
        this.addNode(new GoIncDecStatementInstruction(this.myBuilder, o));
    }

    @Override
    public void visitSendStatement(@NotNull GoSendStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(8);
        }
        ProgressIndicatorProvider.checkCanceled();
        o.acceptChildren(this);
        this.addNode(new GoSendStatementInstruction(this.myBuilder, o));
    }

    @Override
    public void visitSimpleStatement(@NotNull GoSimpleStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(9);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoLeftHandExprList expressionList = o.getLeftHandExprList();
        if (expressionList != null) {
            GoExpression expression = (GoExpression)ContainerUtil.getFirstItem(expressionList.getExpressionList());
            if (expression == null) {
                return;
            }
            expression.acceptChildren(this);
            GoExpressionStatementInstruction expressionStmt = this.addNode(new GoExpressionStatementInstruction(this.myBuilder, expression));
            if (GoControlFlowBuilder.isTerminatingCall(expression)) {
                this.addFlowBreakingEdge((Instruction)expressionStmt);
            }
            return;
        }
        GoShortVarDeclaration declaration = o.getShortVarDeclaration();
        if (declaration != null) {
            this.processShortVarDeclaration(declaration);
        }
    }

    public void processShortVarDeclaration(@NotNull GoShortVarDeclaration o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(10);
        }
        o.acceptChildren(this);
        this.addNode(new GoShortVarDeclarationInstruction(this.myBuilder, o));
    }

    @Override
    public void visitStatement(@NotNull GoStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(11);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoConstDeclaration constDeclaration = o.getConstDeclaration();
        if (constDeclaration != null) {
            constDeclaration.acceptChildren(this);
            this.addNode(new GoConstDeclarationInstruction(this.myBuilder, constDeclaration));
            return;
        }
        GoVarDeclaration varDeclaration = o.getVarDeclaration();
        if (varDeclaration != null) {
            this.processVarDeclaration(varDeclaration);
            return;
        }
        GoTypeDeclaration typeDeclaration = o.getTypeDeclaration();
        if (typeDeclaration != null) {
            this.addNode(new GoTypeDeclarationInstruction(this.myBuilder, typeDeclaration));
            return;
        }
        GoBlock blockStmt = o.getBlock();
        if (blockStmt != null) {
            blockStmt.getStatementList().forEach(s -> s.accept(this));
        }
    }

    public void processVarDeclaration(GoVarDeclaration o) {
        o.acceptChildren(this);
        this.addNode(new GoVarDeclarationInstruction(this.myBuilder, o));
    }

    @Override
    public void visitReturnStatement(@NotNull GoReturnStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(12);
        }
        ProgressIndicatorProvider.checkCanceled();
        o.acceptChildren(this);
        this.addFlowBreakingNode(new GoReturnStatementInstruction(this.myBuilder, o), null);
    }

    @Override
    public void visitIfStatement(@NotNull GoIfStatement o) {
        GoExpression condition;
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(13);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoStatement initStatement = o.getInitStatement();
        if (initStatement != null) {
            initStatement.accept(this);
        }
        if ((condition = o.getCondition()) != null) {
            this.processTerminalCondition(condition);
        }
        TransparentInstruction branchingStart = this.addTransparentNode("if.branching.start");
        this.addNode(new GoBranchInstruction(this.myBuilder, true, condition));
        GoBlock thenBranch = o.getBlock();
        if (thenBranch != null) {
            thenBranch.getStatementList().forEach(s -> s.accept(this));
        }
        TransparentInstruction ifStmtEnd = this.addTransparentNode("if.statement.end");
        this.myBuilder.prevInstruction = branchingStart;
        this.addNode(new GoBranchInstruction(this.myBuilder, false, condition));
        GoElseStatement elseBranch = o.getElseStatement();
        if (elseBranch != null) {
            GoIfStatement elseIf = elseBranch.getIfStatement();
            GoBlock elseBlock = elseBranch.getBlock();
            if (elseIf != null) {
                elseIf.accept(this);
            } else if (elseBlock != null) {
                elseBlock.getStatementList().forEach(s -> s.accept(this));
            }
        }
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)ifStmtEnd);
        this.myBuilder.prevInstruction = ifStmtEnd;
    }

    public void processTerminalCondition(@NotNull GoExpression condition) {
        if (condition == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(14);
        }
        this.acceptExpression(condition);
    }

    @Override
    public void visitForStatement(@NotNull GoForStatement forStatement) {
        if (forStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(15);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoForClause forClause = forStatement.getForClause();
        if (forClause != null) {
            this.processNonRangeFor(forStatement, forClause.getInitStatement(), forClause.getExpression(), forClause.getPostStatement());
            return;
        }
        GoRangeClause rangeClause = forStatement.getRangeClause();
        if (rangeClause != null) {
            rangeClause.acceptChildren(this);
            GoForLoopStartInstruction loopStart = this.addNode(new GoForLoopStartInstruction(this.myBuilder, forStatement));
            this.addNode(new GoRangeClauseInstruction(this.myBuilder, rangeClause));
            this.processBody(forStatement, rangeClause, loopStart, null);
            return;
        }
        if (GoControlFlowBuilder.isEmptyForLoop(forStatement)) {
            forStatement.acceptChildren(this);
            GoInstruction instruction = this.addNode(forStatement);
            this.myBuilder.addEdge((Instruction)instruction, (Instruction)instruction);
            this.myBuilder.flowAbrupted();
            return;
        }
        this.processNonRangeFor(forStatement, null, forStatement.getExpression(), null);
    }

    private void processNonRangeFor(@NotNull GoForStatement forStatement, @Nullable GoStatement initStatement, @Nullable GoExpression condition, @Nullable GoStatement postStatement) {
        if (forStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(16);
        }
        if (initStatement != null) {
            initStatement.accept(this);
        }
        GoForLoopStartInstruction loopStart = this.addNode(new GoForLoopStartInstruction(this.myBuilder, forStatement));
        if (condition != null) {
            this.processTerminalCondition(condition);
        }
        this.processBody(forStatement, condition, loopStart, postStatement);
    }

    private void processBody(@NotNull GoForStatement forStatement, @Nullable PsiElement condition, @NotNull GoForLoopStartInstruction loopStart, @Nullable GoStatement postStatement) {
        GoBlock forBlock;
        if (forStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(17);
        }
        if (loopStart == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(18);
        }
        Instruction beforeLoopEnd = null;
        if (condition != null) {
            beforeLoopEnd = this.myBuilder.prevInstruction;
            this.addNode(new GoForLoopBranchInstruction(this.myBuilder, true, condition, loopStart));
        }
        if ((forBlock = forStatement.getBlock()) != null) {
            forBlock.getStatementList().forEach(s -> s.accept(this));
        }
        TransparentInstruction postStatementStart = null;
        if (postStatement != null) {
            postStatementStart = this.addTransparentNode("post.statement.start");
            postStatement.accept(this);
        }
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)loopStart);
        this.myBuilder.prevInstruction = beforeLoopEnd;
        if (condition != null) {
            this.addNode(new GoForLoopBranchInstruction(this.myBuilder, false, condition, loopStart));
        }
        GoForLoopEndInstruction loopEnd = this.addNode(new GoForLoopEndInstruction(this.myBuilder, loopStart));
        Instruction continueTarget = (Instruction)ObjectUtils.chooseNotNull((Object)postStatementStart, (Object)((Object)loopStart));
        this.processBreakContinue(forStatement, continueTarget, (Instruction)loopEnd);
        this.processLabeledContinue(forStatement, continueTarget);
        this.myBuilder.prevInstruction = loopEnd;
    }

    private void processBreakContinue(@NotNull GoStatement scopeStatement, @Nullable Instruction continueTarget, @NotNull Instruction breakTarget) {
        if (scopeStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(19);
        }
        if (breakTarget == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(20);
        }
        this.myBuilder.processPending((pendingScope, instruction) -> {
            if (pendingScope == null || !PsiTreeUtil.isAncestor((PsiElement)scopeStatement, (PsiElement)pendingScope, (boolean)true)) {
                this.myBuilder.addPendingEdge(pendingScope, instruction);
                return;
            }
            PsiElement element = instruction.getElement();
            if (element instanceof GoBreakStatement && ((GoBreakStatement)element).getLabelRef() == null) {
                this.myBuilder.addEdge(instruction, breakTarget);
            } else if (element instanceof GoContinueStatement && ((GoContinueStatement)element).getLabelRef() == null) {
                if (continueTarget != null) {
                    this.myBuilder.addEdge(instruction, continueTarget);
                } else {
                    this.myBuilder.addPendingEdge(pendingScope, instruction);
                }
            } else {
                String error = "Unexpected pending edge while processing break/continue: %s, scope: %s, 'for': %s";
                LOG.error(String.format(error, element != null ? element.getText() : "null", pendingScope.getText(), scopeStatement.getText()));
                this.myBuilder.addPendingEdge(pendingScope, instruction);
            }
        });
    }

    private void processLabeledContinue(@NotNull GoForStatement forStatement, @NotNull Instruction continueTarget) {
        PsiElement psiElement;
        if (forStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(21);
        }
        if (continueTarget == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(22);
        }
        if (!((psiElement = forStatement.getParent()) instanceof GoLabeledStatement)) {
            return;
        }
        GoLabeledStatement labeled = (GoLabeledStatement)psiElement;
        GoLabelDefinition labelDefinition = labeled.getLabelDefinition();
        Instruction labeledContinueTarget = (Instruction)this.myLabeledContinueTargets.get(labelDefinition);
        if (labeledContinueTarget != null) {
            this.myBuilder.addEdge(labeledContinueTarget, continueTarget);
        }
    }

    @Override
    public void visitBreakStatement(@NotNull GoBreakStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(23);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoLabelRef labelRef = o.getLabelRef();
        GoBreakStatementInstruction instruction = new GoBreakStatementInstruction(this.myBuilder, o);
        if (labelRef != null) {
            this.processGotoLikeStatement(instruction, labelRef, this.myLabeledBreakTargets);
            return;
        }
        this.addFlowBreakingNode(instruction, o);
    }

    @Override
    public void visitContinueStatement(@NotNull GoContinueStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(24);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoLabelRef labelRef = o.getLabelRef();
        GoContinueStatementInstruction instruction = new GoContinueStatementInstruction(this.myBuilder, o);
        if (labelRef != null) {
            this.processGotoLikeStatement(instruction, labelRef, this.myLabeledContinueTargets);
            return;
        }
        this.addFlowBreakingNode(instruction, o);
    }

    @Override
    public void visitGotoStatement(@NotNull GoGotoStatement gotoStatement) {
        if (gotoStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(25);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoLabelRef labelRef = gotoStatement.getLabelRef();
        if (labelRef != null) {
            this.processGotoLikeStatement(new GoGotoStatementInstruction(this.myBuilder, gotoStatement), labelRef, this.myGotoTargets);
        }
    }

    @Override
    public void visitLabeledStatement(@NotNull GoLabeledStatement o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(26);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoStatement statement = o.getStatement();
        if (statement == null) {
            return;
        }
        GoLabelDefinition labelDefinition = o.getLabelDefinition();
        Instruction beforeLabeledStatement = (Instruction)this.myGotoTargets.computeIfAbsent(labelDefinition, label -> this.addDetachedTransparentNode(String.format("goto.label.%s", label.getIdentifier())));
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, beforeLabeledStatement);
        this.myBuilder.prevInstruction = beforeLabeledStatement;
        statement.accept(this);
        Instruction afterLabeledStatement = (Instruction)this.myLabeledBreakTargets.computeIfAbsent(labelDefinition, label -> this.addDetachedTransparentNode(String.format("break.label.%s", label.getIdentifier())));
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, afterLabeledStatement);
        this.myBuilder.prevInstruction = afterLabeledStatement;
    }

    private <I extends GoInstruction> void processGotoLikeStatement(@NotNull I gotoInstruction, @NotNull GoLabelRef labelRef, @NotNull Map<GoLabelDefinition, TransparentInstruction> targets) {
        if (gotoInstruction == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(27);
        }
        if (labelRef == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(28);
        }
        if (targets == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(29);
        }
        GoLabelDefinition labelDefinition = (GoLabelDefinition)ObjectUtils.tryCast((Object)labelRef.getReference().resolve(), GoLabelDefinition.class);
        this.addNode(gotoInstruction);
        if (labelDefinition == null) {
            return;
        }
        Instruction labelInstruction = (Instruction)targets.computeIfAbsent(labelDefinition, label -> this.addDetachedTransparentNode(String.format("label.%s", label.getIdentifier())));
        this.myBuilder.addEdge(gotoInstruction, labelInstruction);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitTypeSwitchStatement(@NotNull GoTypeSwitchStatement typeSwitchStatement) {
        if (typeSwitchStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(30);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoStatement initStmt = typeSwitchStatement.getStatement();
        if (initStmt != null) {
            initStmt.accept(this);
        }
        GoTypeSwitchGuard typeSwitchGuard = typeSwitchStatement.getTypeSwitchGuard();
        typeSwitchGuard.accept(this);
        TransparentInstruction switchEnd = this.addDetachedTransparentNode("type.switch.end");
        GoTypeCaseClause defaultClause = null;
        for (GoTypeCaseClause caseClause : typeSwitchStatement.getTypeCaseClauseList()) {
            if (caseClause.getDefault() != null) {
                defaultClause = caseClause;
                continue;
            }
            List<GoType> types = GoTypeUtil.getListOfTypesFromTypeList(caseClause.getType());
            if (types.isEmpty()) continue;
            TransparentInstruction caseBodyStart = this.addDetachedTransparentNode("case.body.start");
            for (GoType type2 : types) {
                GoTypeInSwitchCaseInstruction typeInstruction = this.addNode(new GoTypeInSwitchCaseInstruction(this.myBuilder, typeSwitchGuard, type2));
                this.myBuilder.addEdge((Instruction)typeInstruction, (Instruction)caseBodyStart);
            }
            this.withTemporaryPrevInstruction((Instruction)caseBodyStart, () -> {
                caseClause.getStatementList().forEach(s -> s.accept(this));
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)switchEnd);
            });
        }
        if (defaultClause != null) {
            defaultClause.getStatementList().forEach(s -> s.accept(this));
        }
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)switchEnd);
        this.myBuilder.prevInstruction = switchEnd;
        this.processBreakContinue(typeSwitchStatement, null, (Instruction)switchEnd);
        this.myBuilder.prevInstruction = switchEnd;
    }

    @Override
    public void visitExprSwitchStatement(@NotNull GoExprSwitchStatement switchStatement) {
        GoExpression condition;
        if (switchStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(31);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoStatement initStmt = switchStatement.getInitStatement();
        if (initStmt != null) {
            initStmt.accept(this);
        }
        if ((condition = switchStatement.getCondition()) != null) {
            this.processTerminalCondition(condition);
        }
        TransparentInstruction switchEnd = this.addDetachedTransparentNode("expr.switch.end");
        List<GoExprCaseClause> cases = switchStatement.getExprCaseClauseList();
        SmartList caseBodyStartPoints = new SmartList();
        for (int i = 0; i < cases.size(); ++i) {
            caseBodyStartPoints.add(this.addDetachedTransparentNode(String.format("case.%d.body.start", i)));
        }
        int defaultCaseIndex = -1;
        for (int i = 0; i < cases.size(); ++i) {
            GoExprCaseClause caseClause = cases.get(i);
            if (caseClause.getDefault() != null) {
                defaultCaseIndex = i;
                continue;
            }
            List<GoExpression> expressions = caseClause.getExpressionList();
            if (expressions.isEmpty()) continue;
            TransparentInstruction beforeTrueBranch = this.addDetachedTransparentNode("expr.switch.before.true.branch");
            for (int j = 0; j < expressions.size(); ++j) {
                GoExpression expression = expressions.get(j);
                this.processTerminalCondition(expression);
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)beforeTrueBranch);
                if (!this.isAddedFalseBranchInstructionInSwitchCases() || j == expressions.size() - 1) continue;
                this.addNode(new GoBranchInstruction(this.myBuilder, false, expression));
            }
            TransparentInstruction caseBodyStart = (TransparentInstruction)caseBodyStartPoints.get(i);
            this.withTemporaryPrevInstruction((Instruction)beforeTrueBranch, () -> {
                GoCaseBranchInstruction instruction = this.addNode(new GoCaseBranchInstruction(this.myBuilder, true, condition, expressions));
                this.myBuilder.addEdge((Instruction)instruction, (Instruction)caseBodyStart);
            });
            this.myFallthroughTargets.push((Object)((Instruction)ContainerUtil.getOrElse((List)caseBodyStartPoints, (int)(i + 1), null)));
            this.withTemporaryPrevInstruction((Instruction)caseBodyStart, () -> {
                caseClause.getStatementList().forEach(s -> s.accept(this));
                this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)switchEnd);
            });
            this.myFallthroughTargets.pop();
            this.addNode(new GoCaseBranchInstruction(this.myBuilder, false, condition, expressions));
        }
        if (defaultCaseIndex >= 0) {
            TransparentInstruction defaultBodyStart = (TransparentInstruction)caseBodyStartPoints.get(defaultCaseIndex);
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)defaultBodyStart);
            this.myBuilder.prevInstruction = defaultBodyStart;
            this.myFallthroughTargets.push((Object)((Instruction)ContainerUtil.getOrElse((List)caseBodyStartPoints, (int)(defaultCaseIndex + 1), null)));
            cases.get(defaultCaseIndex).getStatementList().forEach(s -> s.accept(this));
            this.myFallthroughTargets.pop();
        }
        this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)switchEnd);
        this.myBuilder.prevInstruction = switchEnd;
        this.processBreakContinue(switchStatement, null, (Instruction)switchEnd);
        this.myBuilder.prevInstruction = switchEnd;
    }

    public boolean isAddedFalseBranchInstructionInSwitchCases() {
        return false;
    }

    @Override
    public void visitFallthroughStatement(@NotNull GoFallthroughStatement o) {
        Instruction fallthroughTarget;
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(32);
        }
        ProgressIndicatorProvider.checkCanceled();
        Instruction instruction = fallthroughTarget = this.myFallthroughTargets.isEmpty() ? null : (Instruction)this.myFallthroughTargets.peek();
        if (fallthroughTarget == null) {
            this.addFlowBreakingNode(new GoFallthroughStatementInstruction(this.myBuilder, o), null);
            return;
        }
        GoFallthroughStatementInstruction fallthrough = this.addNode(new GoFallthroughStatementInstruction(this.myBuilder, o));
        this.myBuilder.addEdge((Instruction)fallthrough, fallthroughTarget);
        this.myBuilder.flowAbrupted();
    }

    @Override
    public void visitSelectStatement(@NotNull GoSelectStatement selectStatement) {
        if (selectStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(33);
        }
        ProgressIndicatorProvider.checkCanceled();
        List<GoCommClause> cases = selectStatement.getCommClauseList();
        if (cases.isEmpty()) {
            this.addFlowBreakingEdge((Instruction)this.addNode(selectStatement));
            return;
        }
        for (GoCommClause caseClause : cases) {
            GoCommCase commCase;
            GoCommCase goCommCase = commCase = caseClause.getDefault() == null ? caseClause.getCommCase() : null;
            if (commCase == null) continue;
            this.addReceiveOrSendStatementOperands(commCase);
        }
        TransparentInstruction selectStart = this.addTransparentNode("select.branching.start");
        TransparentInstruction selectEnd = this.addDetachedTransparentNode("select.end");
        boolean hasDefault = false;
        for (GoCommClause caseClause : cases) {
            GoCommCase commCase;
            hasDefault = caseClause.getDefault() != null;
            GoCommCase goCommCase = commCase = caseClause.getDefault() == null ? caseClause.getCommCase() : null;
            if (commCase != null) {
                this.addReceiveOrSendStatement(commCase);
            }
            caseClause.getStatementList().forEach(s -> s.accept(this));
            this.myBuilder.addEdge(this.myBuilder.prevInstruction, (Instruction)selectEnd);
            this.myBuilder.prevInstruction = selectStart;
        }
        if (!hasDefault) {
            this.addFlowBreakingEdge((Instruction)selectStart);
        }
        this.myBuilder.prevInstruction = selectEnd;
        this.processBreakContinue(selectStatement, null, (Instruction)selectEnd);
        this.myBuilder.prevInstruction = selectEnd;
    }

    private void addReceiveOrSendStatementOperands(@NotNull GoCommCase commCase) {
        GoRecvStatement recvStatement;
        if (commCase == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(34);
        }
        if ((recvStatement = commCase.getRecvStatement()) != null) {
            GoExpression receiveOperand;
            GoExpression unwrapped;
            GoExpression recvExpression = recvStatement.getRecvExpression();
            GoExpression goExpression = unwrapped = recvExpression != null ? recvExpression.unwrapParentheses() : null;
            if (unwrapped instanceof GoUnaryExpr) {
                GoUnaryExpr unary = (GoUnaryExpr)unwrapped;
                v1 = unary.getExpression();
            } else {
                v1 = receiveOperand = null;
            }
            if (receiveOperand != null) {
                this.acceptExpression(receiveOperand);
            }
            return;
        }
        GoSendStatement sendStatement = commCase.getSendStatement();
        if (sendStatement != null) {
            GoExpression channel = sendStatement.getChannelExpression();
            this.acceptExpression(channel);
            GoExpression sendExpression = sendStatement.getSendExpression();
            if (sendExpression != null) {
                this.acceptExpression(sendExpression);
            }
        }
    }

    private void addReceiveOrSendStatement(@NotNull GoCommCase commCase) {
        GoRecvStatement recvStatement;
        if (commCase == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(35);
        }
        if ((recvStatement = commCase.getRecvStatement()) != null) {
            GoExpression recvExpression;
            if (recvStatement.getAssign() != null) {
                recvStatement.getLeftExpressionsList().forEach(this::acceptExpression);
            }
            if ((recvExpression = recvStatement.getRecvExpression()) != null) {
                this.addNode(new GoExpressionInstruction(this.myBuilder, recvExpression));
            }
            this.addNode(new GoRecvStatementInstruction(this.myBuilder, recvStatement));
            return;
        }
        GoSendStatement sendStatement = commCase.getSendStatement();
        if (sendStatement != null) {
            this.addNode(new GoSendStatementInstruction(this.myBuilder, sendStatement));
        }
    }

    @Override
    public void visitExpression(@NotNull GoExpression o) {
        GoExpression rightOperand;
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(36);
        }
        ProgressIndicatorProvider.checkCanceled();
        GoBinaryExpr binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)o, GoBinaryExpr.class);
        GoExpression goExpression = rightOperand = binaryExpr != null ? binaryExpr.getRight() : null;
        if (binaryExpr != null && rightOperand != null && GoBooleanExpressionUtil.isLogicalAndExpression(o)) {
            GoExpression leftOperand = binaryExpr.getLeft();
            this.acceptExpression(leftOperand);
            Instruction leftOperandInstruction = this.myBuilder.prevInstruction;
            GoBranchInstruction falseBranch = this.addNode(new GoBranchInstruction(this.myBuilder, false, leftOperand));
            this.myBuilder.prevInstruction = leftOperandInstruction;
            this.addNode(new GoBranchInstruction(this.myBuilder, true, leftOperand));
            this.acceptExpression(rightOperand);
            GoExpressionInstruction binaryExprInstruction = this.addNode(new GoExpressionInstruction(this.myBuilder, o));
            this.myBuilder.addEdge((Instruction)falseBranch, (Instruction)binaryExprInstruction);
        } else if (binaryExpr != null && rightOperand != null && GoBooleanExpressionUtil.isLogicalOrExpression(o)) {
            GoExpression leftOperand = binaryExpr.getLeft();
            this.acceptExpression(leftOperand);
            Instruction leftOperandInstruction = this.myBuilder.prevInstruction;
            GoBranchInstruction trueBranch = this.addNode(new GoBranchInstruction(this.myBuilder, true, leftOperand));
            this.myBuilder.prevInstruction = leftOperandInstruction;
            this.addNode(new GoBranchInstruction(this.myBuilder, false, leftOperand));
            this.acceptExpression(rightOperand);
            GoExpressionInstruction binaryExprInstruction = this.addNode(new GoExpressionInstruction(this.myBuilder, o));
            this.myBuilder.addEdge((Instruction)trueBranch, (Instruction)binaryExprInstruction);
        } else if (!ApplicationManager.getApplication().isUnitTestMode() || ourExpandExpressionsInTests) {
            o.acceptChildren(this);
            this.addNode(new GoExpressionInstruction(this.myBuilder, o));
        }
    }

    @Override
    public void visitFunctionLit(@NotNull GoFunctionLit o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(37);
        }
        ProgressIndicatorProvider.checkCanceled();
        this.addNode(new GoExpressionInstruction(this.myBuilder, o));
    }

    @Override
    public void visitTypeSwitchGuard(@NotNull GoTypeSwitchGuard o) {
        if (o == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(38);
        }
        ProgressIndicatorProvider.checkCanceled();
        o.acceptChildren(this);
        this.addNode(new GoTypeSwitchGuardInstruction(this.myBuilder, o));
    }

    public static boolean isTerminatingCall(@NotNull GoExpression expression) {
        GoCallExpr callExpr;
        if (expression == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(39);
        }
        return (callExpr = (GoCallExpr)ObjectUtils.tryCast((Object)expression, GoCallExpr.class)) != null && (GoPsiImplUtil.isPanic(callExpr) || GoStdlibUtil.isOsExit(callExpr) || GoStdlibUtil.isTestingTerminatingCall(callExpr) || GoStdlibUtil.isLogTerminatingCall(callExpr));
    }

    private static boolean isEmptyForLoop(@NotNull GoForStatement forStatement) {
        GoBlock block;
        if (forStatement == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(40);
        }
        return ((block = forStatement.getBlock()) == null || block.getStatementList().isEmpty()) && forStatement.getExpression() == null && forStatement.getForClause() == null && forStatement.getRangeClause() == null;
    }

    @NotNull
    private GoInstruction addNode(@NotNull PsiElement element) {
        if (element == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(41);
        }
        GoInstruction instruction = new GoInstruction(this.myBuilder, element);
        this.myBuilder.addNode((Instruction)instruction);
        GoInstruction goInstruction = instruction;
        if (goInstruction == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(42);
        }
        return goInstruction;
    }

    @NotNull
    protected <I extends GoInstruction> I addNode(@NotNull I instruction) {
        if (instruction == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(43);
        }
        this.myBuilder.addNode(instruction);
        I i = instruction;
        if (i == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(44);
        }
        return i;
    }

    @NotNull
    protected TransparentInstruction addTransparentNode(@NotNull String debugName) {
        if (debugName == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(45);
        }
        TransparentInstructionImpl instruction = new TransparentInstructionImpl(this.myBuilder, null, debugName);
        this.myBuilder.addNode((Instruction)instruction);
        TransparentInstructionImpl transparentInstructionImpl = instruction;
        if (transparentInstructionImpl == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(46);
        }
        return transparentInstructionImpl;
    }

    protected <I extends GoInstruction> void addFlowBreakingNode(@NotNull I instruction, @Nullable PsiElement scope) {
        if (instruction == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(47);
        }
        this.addNode(instruction);
        this.myBuilder.addPendingEdge(scope, instruction);
        this.myBuilder.flowAbrupted();
    }

    private void addFlowBreakingEdge(@NotNull Instruction instruction) {
        if (instruction == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(48);
        }
        this.myBuilder.addPendingEdge(null, instruction);
        this.myBuilder.flowAbrupted();
    }

    @NotNull
    private TransparentInstruction addDetachedTransparentNode(@NotNull String debugName) {
        if (debugName == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(49);
        }
        Instruction current = this.myBuilder.prevInstruction;
        this.myBuilder.prevInstruction = null;
        TransparentInstruction instruction = this.addTransparentNode(debugName);
        this.myBuilder.prevInstruction = current;
        TransparentInstruction transparentInstruction = instruction;
        if (transparentInstruction == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(50);
        }
        return transparentInstruction;
    }

    private void withTemporaryPrevInstruction(@Nullable Instruction tempararyPrevInstruction, @NotNull Runnable action) {
        if (action == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(51);
        }
        Instruction current = this.myBuilder.prevInstruction;
        this.myBuilder.prevInstruction = tempararyPrevInstruction;
        action.run();
        this.myBuilder.prevInstruction = current;
    }

    private void acceptExpression(@NotNull GoExpression expression) {
        if (expression == null) {
            GoControlFlowBuilder.$$$reportNull$$$0(52);
        }
        if (GoBooleanExpressionUtil.isLogicalBinaryExpr(expression)) {
            expression.accept(this);
        } else {
            expression.acceptChildren(this);
            this.addNode(new GoExpressionInstruction(this.myBuilder, expression));
        }
    }

    static {
        ControlFlowBuilder builder = new ControlFlowBuilder();
        builder.startNode(null);
        TRIVIAL = builder.getControlFlow();
        ourExpandExpressionsInTests = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 42, 44, 46, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 42: 
            case 44: 
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/controlflow/GoControlFlowBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 26: 
            case 32: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopStart";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeStatement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakTarget";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "continueTarget";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoStatement";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gotoInstruction";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelRef";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSwitchStatement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchStatement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectStatement";
                break;
            }
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commCase";
                break;
            }
            case 39: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 43: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/controlflow/GoControlFlowBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 42: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addNode";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "addTransparentNode";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "addDetachedTransparentNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 1: 
            case 42: 
            case 44: 
            case 46: 
            case 50: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitCompositeElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitParameterDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitAssignmentStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitDeferStatement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitGoStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitIncDecStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitSendStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitSimpleStatement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processShortVarDeclaration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitReturnStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitIfStatement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processTerminalCondition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitForStatement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processNonRangeFor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processBody";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processBreakContinue";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processLabeledContinue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitBreakStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitContinueStatement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitGotoStatement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitLabeledStatement";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processGotoLikeStatement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeSwitchStatement";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitExprSwitchStatement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitFallthroughStatement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitSelectStatement";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addReceiveOrSendStatementOperands";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addReceiveOrSendStatement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitExpression";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitFunctionLit";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeSwitchGuard";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isTerminatingCall";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyForLoop";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addTransparentNode";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addFlowBreakingNode";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addFlowBreakingEdge";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addDetachedTransparentNode";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "withTemporaryPrevInstruction";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "acceptExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 42, 44, 46, 50 -> new IllegalStateException(string);
        };
    }
}

