/*
 * Decompiled with CFR 0.152.
 */
package com.goide.configuration;

import com.goide.configuration.GoCommonSettings;
import com.goide.i18n.GoBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GoCommonSettingsUI
implements ConfigurableUi<GoCommonSettings> {
    private final JPanel myPanel;
    private final JBCheckBox myIndentOnEnterInRawStringCheckBox;
    private final JBCheckBox mySuggestParameterNamesCheckBox = new JBCheckBox(GoBundle.message((String)"go.settings.common.suggest.parameter.names.checkbox", (Object[])new Object[0]));
    private final JBCheckBox myShowAutoImportInAutoPopupCheckBox = new JBCheckBox(GoBundle.message((String)"go.settings.common.show.auto.import.in.completion.popup.checkbox", (Object[])new Object[0]));
    private final JBCheckBox myShowDocumentationInParameterInfoCheckBox;
    private final JBCheckBox myGoPackageFromClipboardCheckBox;
    private final JBCheckBox myAskConfirmationForShareInPlaygroundCheckBox;
    private final JRadioButton[] myOnDirectoryRenameRadioButtonGroup;
    private final JRadioButton[] myOnPackageRenameRadioButtonGroup;
    private final JRadioButton[] myOnFileRenameRadioButtonGroup;
    private final JRadioButton[] myOnJsonPasteRadioButtonGroup;

    GoCommonSettingsUI() {
        this.myIndentOnEnterInRawStringCheckBox = new JBCheckBox(GoBundle.message((String)"go.settings.common.indent.on.enter.in.raw.strings.checkbox", (Object[])new Object[0]));
        this.myShowDocumentationInParameterInfoCheckBox = new JBCheckBox(GoBundle.message((String)"go.settings.common.show.documentation.in.parameter.info.checkbox", (Object[])new Object[0]));
        this.myGoPackageFromClipboardCheckBox = new JBCheckBox(GoBundle.message((String)"go.settings.common.detect.go.packages.from.clipboard.checkbox", (Object[])new Object[0]));
        this.myAskConfirmationForShareInPlaygroundCheckBox = new JBCheckBox(GoBundle.message((String)"go.settings.common.ask.for.confirmation.in.playground.checkbox", (Object[])new Object[0]));
        this.myOnDirectoryRenameRadioButtonGroup = new JRadioButton[]{new JBRadioButton(GoBundle.message((String)"go.settings.common.confirmation.show.options.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.directory.rename.rename.package.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.directory.rename.do.not.rename.package.option", (Object[])new Object[0]))};
        this.myOnPackageRenameRadioButtonGroup = new JRadioButton[]{new JBRadioButton(GoBundle.message((String)"go.settings.common.confirmation.show.options.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.package.rename.rename.directory.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.package.rename.do.not.rename.directory.option", (Object[])new Object[0]))};
        this.myOnFileRenameRadioButtonGroup = new JRadioButton[]{new JBRadioButton(GoBundle.message((String)"go.settings.common.confirmation.show.options.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.test.rename.corresponding.file.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.test.do.not.rename.corresponding.file.option", (Object[])new Object[0]))};
        this.myOnJsonPasteRadioButtonGroup = new JRadioButton[]{new JBRadioButton(GoBundle.message((String)"go.settings.common.confirmation.show.options.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.convert.json.on.paste.convert.option", (Object[])new Object[0])), new JBRadioButton(GoBundle.message((String)"go.settings.common.convert.json.on.paste.insert.as.is.option", (Object[])new Object[0]))};
        this.myPanel = new JPanel(new BorderLayout());
        FormBuilder builder = FormBuilder.createFormBuilder().addComponent((JComponent)this.mySuggestParameterNamesCheckBox).addComponent((JComponent)this.myShowAutoImportInAutoPopupCheckBox).addComponent((JComponent)this.myIndentOnEnterInRawStringCheckBox).addComponent((JComponent)this.myShowDocumentationInParameterInfoCheckBox).addComponent((JComponent)this.myGoPackageFromClipboardCheckBox).addComponent((JComponent)this.myAskConfirmationForShareInPlaygroundCheckBox);
        GoCommonSettingsUI.addRadioButtonGroup(builder, GoBundle.message((String)"go.settings.common.directory.rename.option", (Object[])new Object[0]), this.myOnDirectoryRenameRadioButtonGroup);
        GoCommonSettingsUI.addRadioButtonGroup(builder, GoBundle.message((String)"go.settings.common.package.rename.option", (Object[])new Object[0]), this.myOnPackageRenameRadioButtonGroup);
        GoCommonSettingsUI.addRadioButtonGroup(builder, GoBundle.message((String)"go.settings.common.test.rename.option", (Object[])new Object[0]), this.myOnFileRenameRadioButtonGroup);
        GoCommonSettingsUI.addRadioButtonGroup(builder, GoBundle.message((String)"go.settings.common.convert.json.on.paste.option", (Object[])new Object[0]), this.myOnJsonPasteRadioButtonGroup);
        this.myPanel.add((Component)builder.getPanel(), "North");
    }

    private static void addRadioButtonGroup(@NotNull FormBuilder builder, @NotNull @Nls String title, JRadioButton @NotNull [] group) {
        if (builder == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(1);
        }
        if (group == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(2);
        }
        builder.setVerticalGap(12).addComponent((JComponent)new JBLabel(title)).setVerticalGap(4).setFormLeftIndent(10);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (JRadioButton radioButton : group) {
            radioButton.getModel().setGroup(buttonGroup);
            builder.addComponent((JComponent)radioButton);
        }
        builder.setFormLeftIndent(0);
    }

    public void reset(@NotNull GoCommonSettings settings) {
        if (settings == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(3);
        }
        this.mySuggestParameterNamesCheckBox.setSelected(settings.codeInsightSettings().isSuggestParametersNames());
        this.myShowAutoImportInAutoPopupCheckBox.setSelected(settings.codeInsightSettings().isShowAutoImportVariantsInAutoPopup());
        this.myIndentOnEnterInRawStringCheckBox.setSelected(settings.codeInsightSettings().isIndentOnEnterInRawStrings());
        this.myShowDocumentationInParameterInfoCheckBox.setSelected(settings.codeInsightSettings().isShowDocumentationInParameterPopup());
        this.myGoPackageFromClipboardCheckBox.setSelected(settings.codeInsightSettings().isDetectGoPackageFromClipboard());
        this.myAskConfirmationForShareInPlaygroundCheckBox.setSelected(settings.codeInsightSettings().isAskConfirmationForShareInPlayground());
        GoCommonSettingsUI.setRadioButtonGroupValue(this.myOnDirectoryRenameRadioButtonGroup, settings.codeInsightSettings().getRenamePackageOnDirectoryRenaming());
        GoCommonSettingsUI.setRadioButtonGroupValue(this.myOnPackageRenameRadioButtonGroup, settings.codeInsightSettings().getRenameDirectoryOnPackageRenaming());
        GoCommonSettingsUI.setRadioButtonGroupValue(this.myOnFileRenameRadioButtonGroup, settings.codeInsightSettings().getRenameCorrespondingTestOrProductionFile());
        GoCommonSettingsUI.setRadioButtonGroupValue(this.myOnJsonPasteRadioButtonGroup, settings.codeInsightSettings().getConvertJsonOnPaste());
    }

    public boolean isModified(@NotNull GoCommonSettings settings) {
        if (settings == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(4);
        }
        return this.mySuggestParameterNamesCheckBox.isSelected() != settings.codeInsightSettings().isSuggestParametersNames() || this.myShowAutoImportInAutoPopupCheckBox.isSelected() != settings.codeInsightSettings().isShowAutoImportVariantsInAutoPopup() || this.myIndentOnEnterInRawStringCheckBox.isSelected() != settings.codeInsightSettings().isIndentOnEnterInRawStrings() || this.myShowDocumentationInParameterInfoCheckBox.isSelected() != settings.codeInsightSettings().isShowDocumentationInParameterPopup() || this.myGoPackageFromClipboardCheckBox.isSelected() != settings.codeInsightSettings().isDetectGoPackageFromClipboard() || this.myAskConfirmationForShareInPlaygroundCheckBox.isSelected() != settings.codeInsightSettings().isAskConfirmationForShareInPlayground() || GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnDirectoryRenameRadioButtonGroup) != settings.codeInsightSettings().getRenamePackageOnDirectoryRenaming() || GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnPackageRenameRadioButtonGroup) != settings.codeInsightSettings().getRenameDirectoryOnPackageRenaming() || GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnFileRenameRadioButtonGroup) != settings.codeInsightSettings().getRenameCorrespondingTestOrProductionFile() || GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnJsonPasteRadioButtonGroup) != settings.codeInsightSettings().getConvertJsonOnPaste();
    }

    public void apply(@NotNull GoCommonSettings settings) {
        if (settings == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(5);
        }
        settings.codeInsightSettings().setSuggestParametersNames(this.mySuggestParameterNamesCheckBox.isSelected());
        settings.codeInsightSettings().setShowAutoImportVariantsInAutoPopup(this.myShowAutoImportInAutoPopupCheckBox.isSelected());
        settings.codeInsightSettings().setIndentOnEnterInRawStringsAndSyncWithFrontback(this.myIndentOnEnterInRawStringCheckBox.isSelected());
        settings.codeInsightSettings().setShowDocumentationInParameterPopup(this.myShowDocumentationInParameterInfoCheckBox.isSelected());
        settings.codeInsightSettings().setDetectGoPackageFromClipboard(this.myGoPackageFromClipboardCheckBox.isSelected());
        settings.codeInsightSettings().setAskConfirmationForShareInPlayground(this.myAskConfirmationForShareInPlaygroundCheckBox.isSelected());
        settings.codeInsightSettings().setRenamePackageOnDirectoryRenaming(GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnDirectoryRenameRadioButtonGroup));
        settings.codeInsightSettings().setRenameDirectoryOnPackageRenaming(GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnPackageRenameRadioButtonGroup));
        settings.codeInsightSettings().setRenameCorrespondingTestOrProductionFile(GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnFileRenameRadioButtonGroup));
        settings.codeInsightSettings().setConvertJsonOnPaste(GoCommonSettingsUI.getRadioButtonGroupValue(this.myOnJsonPasteRadioButtonGroup));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static void setRadioButtonGroupValue(JRadioButton @NotNull [] group, ThreeState value) {
        if (group == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(7);
        }
        switch (value) {
            case YES: {
                group[1].setSelected(true);
                break;
            }
            case NO: {
                group[2].setSelected(true);
                break;
            }
            case UNSURE: {
                group[0].setSelected(true);
            }
        }
    }

    private static ThreeState getRadioButtonGroupValue(JRadioButton @NotNull [] group) {
        if (group == null) {
            GoCommonSettingsUI.$$$reportNull$$$0(8);
        }
        assert (group.length == 3);
        if (group[0].isSelected()) {
            return ThreeState.UNSURE;
        }
        if (group[1].isSelected()) {
            return ThreeState.YES;
        }
        if (group[2].isSelected()) {
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/configuration/GoCommonSettingsUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/configuration/GoCommonSettingsUI";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRadioButtonGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setRadioButtonGroupValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRadioButtonGroupValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

