/*
 * Decompiled with CFR 0.152.
 */
package com.goide.completion;

import com.goide.psi.GoElement;
import com.goide.psi.GoFieldName;
import com.goide.psi.GoKey;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoStructType;
import com.goide.psi.GoValue;
import com.goide.psi.impl.GoPsiImplUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GoStructLiteralCompletion {
    GoStructLiteralCompletion() {
    }

    @NotNull
    static Variants allowedVariants(@Nullable GoReferenceExpression structFieldReference) {
        GoValue value = GoStructLiteralCompletion.parent(structFieldReference, GoValue.class);
        GoElement element = GoStructLiteralCompletion.parent(value, GoElement.class);
        if (element != null && element.getKey() != null) {
            Variants variants = Variants.NONE;
            if (variants == null) {
                GoStructLiteralCompletion.$$$reportNull$$$0(0);
            }
            return variants;
        }
        if (!(GoPsiImplUtil.getUnwrappedTypeOfLiteralValue(element) instanceof GoStructType)) {
            Variants variants = Variants.NONE;
            if (variants == null) {
                GoStructLiteralCompletion.$$$reportNull$$$0(1);
            }
            return variants;
        }
        boolean hasValueInitializers = false;
        boolean hasFieldValueInitializers = false;
        GoLiteralValue literalValue = GoStructLiteralCompletion.parent(element, GoLiteralValue.class);
        List<Object> fieldInitializers = literalValue != null ? literalValue.getElementList() : Collections.emptyList();
        for (GoElement goElement : fieldInitializers) {
            if (goElement == element) continue;
            PsiElement colon = goElement.getColon();
            hasFieldValueInitializers |= colon != null;
            hasValueInitializers |= colon == null;
        }
        Variants variants = hasFieldValueInitializers && !hasValueInitializers ? Variants.FIELD_NAME_ONLY : (!hasFieldValueInitializers && hasValueInitializers ? Variants.VALUE_ONLY : Variants.BOTH);
        if (variants == null) {
            GoStructLiteralCompletion.$$$reportNull$$$0(2);
        }
        return variants;
    }

    @NotNull
    static Set<String> alreadyAssignedFields(@Nullable GoLiteralValue literal) {
        if (literal == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                GoStructLiteralCompletion.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set set = ContainerUtil.map2SetNotNull(literal.getElementList(), element -> {
            GoKey key = element.getKey();
            GoFieldName fieldName = key != null ? key.getFieldName() : null;
            PsiElement identifier = fieldName != null ? fieldName.getIdentifier() : null;
            return identifier != null ? identifier.getText() : null;
        });
        if (set == null) {
            GoStructLiteralCompletion.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Contract(value="null,_->null")
    private static <T> T parent(@Nullable PsiElement of, @NotNull Class<T> parentClass) {
        if (parentClass == null) {
            GoStructLiteralCompletion.$$$reportNull$$$0(5);
        }
        return (T)ObjectUtils.tryCast((Object)(of != null ? of.getParent() : null), parentClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/completion/GoStructLiteralCompletion";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allowedVariants";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "alreadyAssignedFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/completion/GoStructLiteralCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }

    static enum Variants {
        FIELD_NAME_ONLY,
        VALUE_ONLY,
        BOTH,
        NONE;

    }
}

